/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.Cam16;
import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.MathUtils;
import com.google.android.material.color.ViewingConditions;

final class Hct {
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float DE_MAX = 1.0f;
    private static final float DE_MAX_ERROR = 1.0E-9f;
    private static final float DL_MAX = 0.2f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;
    private float chroma;
    private float hue;
    private float tone;

    private Hct(float f, float f2, float f3) {
        this.setInternalState(Hct.gamutMap(f, f2, f3));
    }

    private static Cam16 findCamByJ(float f, float f2, float f3) {
        Cam16 cam16;
        float f4 = 1000.0f;
        Cam16 cam162 = null;
        float f5 = 1000.0f;
        float f6 = 100.0f;
        float f7 = 0.0f;
        while (true) {
            cam16 = cam162;
            if (!(Math.abs(f7 - f6) > 0.01f)) break;
            float f8 = (f6 - f7) / 2.0f + f7;
            int n = Cam16.fromJch(f8, f2, f).getInt();
            float f9 = ColorUtils.lstarFromInt(n);
            float f10 = Math.abs(f3 - f9);
            float f11 = f4;
            float f12 = f5;
            cam16 = cam162;
            if (f10 < 0.2f) {
                Cam16 cam163 = Cam16.fromInt(n);
                float f13 = cam163.distance(Cam16.fromJch(cam163.getJ(), cam163.getChroma(), f));
                f11 = f4;
                f12 = f5;
                cam16 = cam162;
                if (f13 <= 1.0f) {
                    f11 = f4;
                    f12 = f5;
                    cam16 = cam162;
                    if (f13 <= f4) {
                        cam16 = cam163;
                        f12 = f10;
                        f11 = f13;
                    }
                }
            }
            if (f12 == 0.0f && f11 < 1.0E-9f) break;
            if (f9 < f3) {
                f7 = f8;
                f4 = f11;
                f5 = f12;
                cam162 = cam16;
                continue;
            }
            f6 = f8;
            f4 = f11;
            f5 = f12;
            cam162 = cam16;
        }
        return cam16;
    }

    public static Hct from(float f, float f2, float f3) {
        return new Hct(f, f2, f3);
    }

    public static Hct fromInt(int n) {
        Cam16 cam16 = Cam16.fromInt(n);
        return new Hct(cam16.getHue(), cam16.getChroma(), ColorUtils.lstarFromInt(n));
    }

    private static int gamutMap(float f, float f2, float f3) {
        return Hct.gamutMapInViewingConditions(f, f2, f3, ViewingConditions.DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int gamutMapInViewingConditions(float f, float f2, float f3, ViewingConditions viewingConditions) {
        if ((double)f2 < 1.0) return ColorUtils.intFromLstar(f3);
        if ((double)Math.round(f3) <= 0.0) return ColorUtils.intFromLstar(f3);
        if ((double)Math.round(f3) >= 100.0) {
            return ColorUtils.intFromLstar(f3);
        }
        float f4 = MathUtils.sanitizeDegrees(f);
        f = f2;
        Cam16 cam16 = null;
        float f5 = 0.0f;
        boolean bl = true;
        while (true) {
            if (!(Math.abs(f5 - f2) >= 0.4f)) {
                if (cam16 != null) return cam16.viewed(viewingConditions);
                return ColorUtils.intFromLstar(f3);
            }
            Cam16 cam162 = Hct.findCamByJ(f4, f, f3);
            if (bl) {
                if (cam162 != null) {
                    return cam162.viewed(viewingConditions);
                }
                bl = false;
            } else if (cam162 == null) {
                f2 = f;
            } else {
                cam16 = cam162;
                f5 = f;
            }
            f = (f2 - f5) / 2.0f + f5;
        }
    }

    private void setInternalState(int n) {
        Cam16 cam16 = Cam16.fromInt(n);
        float f = ColorUtils.lstarFromInt(n);
        this.hue = cam16.getHue();
        this.chroma = cam16.getChroma();
        this.tone = f;
    }

    public float getChroma() {
        return this.chroma;
    }

    public float getHue() {
        return this.hue;
    }

    public float getTone() {
        return this.tone;
    }

    public void setChroma(float f) {
        this.setInternalState(Hct.gamutMap(this.hue, f, this.tone));
    }

    public void setHue(float f) {
        this.setInternalState(Hct.gamutMap(MathUtils.sanitizeDegrees(f), this.chroma, this.tone));
    }

    public void setTone(float f) {
        this.setInternalState(Hct.gamutMap(this.hue, this.chroma, f));
    }

    public int toInt() {
        return Hct.gamutMap(this.hue, this.chroma, this.tone);
    }
}

