/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.color.Blend;
import com.google.android.material.color.ColorRoles;
import com.google.android.material.color.Hct;
import com.google.android.material.resources.MaterialAttributes;

public class MaterialColors {
    public static final float ALPHA_DISABLED = 0.38f;
    public static final float ALPHA_DISABLED_LOW = 0.12f;
    public static final float ALPHA_FULL = 1.0f;
    public static final float ALPHA_LOW = 0.32f;
    public static final float ALPHA_MEDIUM = 0.54f;
    private static final int TONE_ACCENT_CONTAINER_DARK = 20;
    private static final int TONE_ACCENT_CONTAINER_LIGHT = 90;
    private static final int TONE_ACCENT_DARK = 70;
    private static final int TONE_ACCENT_LIGHT = 40;
    private static final int TONE_ON_ACCENT_CONTAINER_DARK = 80;
    private static final int TONE_ON_ACCENT_CONTAINER_LIGHT = 10;
    private static final int TONE_ON_ACCENT_DARK = 10;
    private static final int TONE_ON_ACCENT_LIGHT = 100;

    private MaterialColors() {
    }

    public static int compositeARGBWithAlpha(int n, int n2) {
        return ColorUtils.setAlphaComponent((int)n, (int)(Color.alpha((int)n) * n2 / 255));
    }

    public static int getColor(Context context, int n, int n2) {
        if ((context = MaterialAttributes.resolve(context, n)) != null) {
            return context.data;
        }
        return n2;
    }

    public static int getColor(Context context, int n, String string2) {
        return MaterialAttributes.resolveOrThrow(context, n, string2);
    }

    public static int getColor(View view, int n) {
        return MaterialAttributes.resolveOrThrow(view, n);
    }

    public static int getColor(View view, int n, int n2) {
        return MaterialColors.getColor(view.getContext(), n, n2);
    }

    private static int getColorRole(int n, int n2) {
        Hct hct = Hct.fromInt(n);
        hct.setTone(n2);
        return hct.toInt();
    }

    public static ColorRoles getColorRoles(int n, boolean bl) {
        ColorRoles colorRoles = bl ? new ColorRoles(MaterialColors.getColorRole(n, 40), MaterialColors.getColorRole(n, 100), MaterialColors.getColorRole(n, 90), MaterialColors.getColorRole(n, 10)) : new ColorRoles(MaterialColors.getColorRole(n, 70), MaterialColors.getColorRole(n, 10), MaterialColors.getColorRole(n, 20), MaterialColors.getColorRole(n, 80));
        return colorRoles;
    }

    public static ColorRoles getColorRoles(Context context, int n) {
        return MaterialColors.getColorRoles(n, MaterialAttributes.resolveBoolean(context, R.attr.isLightTheme, true));
    }

    public static int harmonize(int n, int n2) {
        return Blend.harmonize(n, n2);
    }

    public static int harmonizeWithPrimary(Context context, int n) {
        return MaterialColors.harmonize(n, MaterialColors.getColor(context, R.attr.colorPrimary, MaterialColors.class.getCanonicalName()));
    }

    public static boolean isColorLight(int n) {
        boolean bl = n != 0 && ColorUtils.calculateLuminance((int)n) > 0.5;
        return bl;
    }

    public static int layer(int n, int n2) {
        return ColorUtils.compositeColors((int)n2, (int)n);
    }

    public static int layer(int n, int n2, float f) {
        return MaterialColors.layer(n, ColorUtils.setAlphaComponent((int)n2, (int)Math.round((float)Color.alpha((int)n2) * f)));
    }

    public static int layer(View view, int n, int n2) {
        return MaterialColors.layer(view, n, n2, 1.0f);
    }

    public static int layer(View view, int n, int n2, float f) {
        return MaterialColors.layer(MaterialColors.getColor(view, n), MaterialColors.getColor(view, n2), f);
    }
}

