/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

final class MathUtils {
    private MathUtils() {
    }

    static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f3, f), f2);
    }

    public static float differenceDegrees(float f, float f2) {
        return 180.0f - Math.abs(Math.abs(f - f2) - 180.0f);
    }

    public static float lerp(float f, float f2, float f3) {
        return (1.0f - f3) * f + f3 * f2;
    }

    public static float sanitizeDegrees(float f) {
        if (f < 0.0f) {
            return f % 360.0f + 360.0f;
        }
        float f2 = f;
        if (f >= 360.0f) {
            f2 = f % 360.0f;
        }
        return f2;
    }

    public static int sanitizeDegrees(int n) {
        if (n < 0) {
            return n % 360 + 360;
        }
        int n2 = n;
        if (n >= 360) {
            n2 = n % 360;
        }
        return n2;
    }

    static float toDegrees(float f) {
        return f * 180.0f / (float)Math.PI;
    }

    static float toRadians(float f) {
        return f / 180.0f * (float)Math.PI;
    }
}

