/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.Cam16;
import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.MathUtils;

final class ViewingConditions {
    public static final ViewingConditions DEFAULT = ViewingConditions.make(ColorUtils.whitePointD65(), (float)((double)ColorUtils.yFromLstar(50.0f) * 63.66197723675813 / 100.0), 50.0f, 2.0f, false);
    private final float aw;
    private final float c;
    private final float fl;
    private final float flRoot;
    private final float n;
    private final float nbb;
    private final float nc;
    private final float ncb;
    private final float[] rgbD;
    private final float z;

    private ViewingConditions(float f, float f2, float f3, float f4, float f5, float f6, float[] fArray, float f7, float f8, float f9) {
        this.n = f;
        this.aw = f2;
        this.nbb = f3;
        this.ncb = f4;
        this.c = f5;
        this.nc = f6;
        this.rgbD = fArray;
        this.fl = f7;
        this.flRoot = f8;
        this.z = f9;
    }

    static ViewingConditions make(float[] fArray, float f, float f2, float f3, boolean bl) {
        Object object = Cam16.XYZ_TO_CAM16RGB;
        float f4 = fArray[0] * object[0][0] + fArray[1] * object[0][1] + fArray[2] * object[0][2];
        float f5 = fArray[0] * object[1][0] + fArray[1] * object[1][1] + fArray[2] * object[1][2];
        float f6 = fArray[0] * object[2][0] + fArray[1] * object[2][1] + fArray[2] * object[2][2];
        float f7 = f3 / 10.0f + 0.8f;
        float f8 = (double)f7 >= 0.9 ? MathUtils.lerp(0.59f, 0.69f, (f7 - 0.9f) * 10.0f) : MathUtils.lerp(0.525f, 0.59f, (f7 - 0.8f) * 10.0f);
        f3 = bl ? 1.0f : (1.0f - (float)Math.exp((-f - 42.0f) / 92.0f) * 0.2777778f) * f7;
        double d = f3;
        if (d > 1.0) {
            f3 = 1.0f;
        } else if (d < 0.0) {
            f3 = 0.0f;
        }
        object = new float[3];
        object[0] = (float[])(100.0f / f4 * f3 + 1.0f - f3);
        object[1] = (float[])(100.0f / f5 * f3 + 1.0f - f3);
        object[2] = (float[])(100.0f / f6 * f3 + 1.0f - f3);
        f3 = 1.0f / (5.0f * f + 1.0f);
        f3 = f3 * f3 * f3 * f3;
        float f9 = 1.0f - f3;
        f = f3 * f + 0.1f * f9 * f9 * (float)Math.cbrt((double)f * 5.0);
        f3 = ColorUtils.yFromLstar(f2) / fArray[1];
        d = f3;
        f9 = (float)Math.sqrt(d);
        f2 = 0.725f / (float)Math.pow(d, 0.2);
        fArray = new float[]{(float)Math.pow((double)(object[0] * f * f4) / 100.0, 0.42), (float)Math.pow((double)(object[1] * f * f5) / 100.0, 0.42), (float)Math.pow((double)(object[2] * f * f6) / 100.0, 0.42)};
        float[] fArray2 = new float[]{fArray[0] * 400.0f / (fArray[0] + 27.13f), fArray[1] * 400.0f / (fArray[1] + 27.13f), fArray[2] * 400.0f / (fArray[2] + 27.13f)};
        return new ViewingConditions(f3, (fArray2[0] * 2.0f + fArray2[1] + fArray2[2] * 0.05f) * f2, f2, f2, f8, f7, (float[])object, f, (float)Math.pow(f, 0.25), f9 + 1.48f);
    }

    public float getAw() {
        return this.aw;
    }

    float getC() {
        return this.c;
    }

    float getFl() {
        return this.fl;
    }

    public float getFlRoot() {
        return this.flRoot;
    }

    public float getN() {
        return this.n;
    }

    public float getNbb() {
        return this.nbb;
    }

    float getNc() {
        return this.nc;
    }

    float getNcb() {
        return this.ncb;
    }

    public float[] getRgbD() {
        return this.rgbD;
    }

    float getZ() {
        return this.z;
    }
}

