/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.material.R;
import com.google.android.material.datepicker.UtcDates;
import java.util.Calendar;
import java.util.Locale;

class DaysOfWeekAdapter
extends BaseAdapter {
    private static final int CALENDAR_DAY_STYLE;
    private static final int NARROW_FORMAT = 4;
    private final Calendar calendar;
    private final int daysInWeek;
    private final int firstDayOfWeek;

    static {
        int n = Build.VERSION.SDK_INT >= 26 ? 4 : 1;
        CALENDAR_DAY_STYLE = n;
    }

    public DaysOfWeekAdapter() {
        Calendar calendar;
        this.calendar = calendar = UtcDates.getUtcCalendar();
        this.daysInWeek = calendar.getMaximum(7);
        this.firstDayOfWeek = calendar.getFirstDayOfWeek();
    }

    private int positionToDayOfWeek(int n) {
        int n2 = n + this.firstDayOfWeek;
        int n3 = this.daysInWeek;
        n = n2;
        if (n2 > n3) {
            n = n2 - n3;
        }
        return n;
    }

    public int getCount() {
        return this.daysInWeek;
    }

    public Integer getItem(int n) {
        if (n >= this.daysInWeek) {
            return null;
        }
        return this.positionToDayOfWeek(n);
    }

    public long getItemId(int n) {
        return 0L;
    }

    public View getView(int n, View object, ViewGroup viewGroup) {
        TextView textView = (TextView)object;
        if (object == null) {
            textView = (TextView)LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.mtrl_calendar_day_of_week, viewGroup, false);
        }
        this.calendar.set(7, this.positionToDayOfWeek(n));
        object = textView.getResources().getConfiguration().locale;
        textView.setText((CharSequence)this.calendar.getDisplayName(7, CALENDAR_DAY_STYLE, (Locale)object));
        textView.setContentDescription((CharSequence)String.format(viewGroup.getContext().getString(R.string.mtrl_picker_day_of_week_column_header), this.calendar.getDisplayName(7, 2, Locale.getDefault())));
        return textView;
    }
}

