/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.core.util.Pair;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MonthAdapter;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.ViewUtils;
import java.util.Calendar;

final class MaterialCalendarGridView
extends GridView {
    private final Calendar dayCompute = UtcDates.getUtcCalendar();
    private final boolean nestedScrollable;

    public MaterialCalendarGridView(Context context) {
        this(context, null);
    }

    public MaterialCalendarGridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MaterialCalendarGridView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        if (MaterialDatePicker.isFullscreen(this.getContext())) {
            this.setNextFocusLeftId(R.id.cancel_button);
            this.setNextFocusRightId(R.id.confirm_button);
        }
        this.nestedScrollable = MaterialDatePicker.isNestedScrollable(this.getContext());
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setCollectionInfo(null);
            }
        });
    }

    private void gainFocus(int n, Rect rect) {
        if (n == 33) {
            this.setSelection(this.getAdapter().lastPositionInMonth());
        } else if (n == 130) {
            this.setSelection(this.getAdapter().firstPositionInMonth());
        } else {
            super.onFocusChanged(true, n, rect);
        }
    }

    private View getChildAtPosition(int n) {
        return this.getChildAt(n - this.getFirstVisiblePosition());
    }

    private static int horizontalMidPoint(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    private static boolean skipMonth(Long l, Long l2, Long l3, Long l4) {
        boolean bl;
        boolean bl2 = bl = true;
        if (l != null) {
            bl2 = bl;
            if (l2 != null) {
                bl2 = bl;
                if (l3 != null) {
                    if (l4 == null) {
                        bl2 = bl;
                    } else {
                        bl2 = bl;
                        if (l3 <= l2) {
                            bl2 = l4 < l ? bl : false;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public MonthAdapter getAdapter() {
        return (MonthAdapter)super.getAdapter();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getAdapter().notifyDataSetChanged();
    }

    /*
     * Unable to fully structure code
     */
    protected final void onDraw(Canvas var1_1) {
        super.onDraw(var1_1);
        var2_2 = this.getAdapter();
        var3_3 = var2_2.dateSelector;
        var4_4 = var2_2.calendarStyle;
        var5_5 = Math.max(var2_2.firstPositionInMonth(), this.getFirstVisiblePosition());
        var6_6 = Math.min(var2_2.lastPositionInMonth(), this.getLastVisiblePosition());
        var7_7 = var2_2.getItem(var5_5);
        var8_8 = var2_2.getItem(var6_6);
        var3_3 = var3_3.getSelectedRanges().iterator();
        block0: while (true) {
            var9_9 = this;
            if (!var3_3.hasNext()) break;
            var10_10 = (Pair)var3_3.next();
            if (var10_10.first == null || var10_10.second == null) continue;
            var11_11 = (Long)var10_10.first;
            var13_12 = (Long)var10_10.second;
            if (MaterialCalendarGridView.skipMonth(var7_7, var8_8, var11_11, var13_12)) continue;
            var15_13 = ViewUtils.isLayoutRtl((View)this);
            if (var11_11 < var7_7) {
                var16_14 = var2_2.isFirstInRow(var5_5) != false ? 0 : (var15_13 == false ? var9_9.getChildAtPosition(var5_5 - 1).getRight() : var9_9.getChildAtPosition(var5_5 - 1).getLeft());
                var17_15 = var5_5;
            } else {
                var9_9.dayCompute.setTimeInMillis(var11_11);
                var17_15 = var2_2.dayToPosition(var9_9.dayCompute.get(5));
                var16_14 = MaterialCalendarGridView.horizontalMidPoint(var9_9.getChildAtPosition(var17_15));
            }
            if (var13_12 > var8_8) {
                var18_16 = var2_2.isLastInRow(var6_6) != false ? this.getWidth() : (var15_13 == false ? var9_9.getChildAtPosition(var6_6).getRight() : var9_9.getChildAtPosition(var6_6).getLeft());
                var19_17 = var6_6;
            } else {
                var9_9.dayCompute.setTimeInMillis(var13_12);
                var19_17 = var2_2.dayToPosition(var9_9.dayCompute.get(5));
                var18_16 = MaterialCalendarGridView.horizontalMidPoint(var9_9.getChildAtPosition(var19_17));
            }
            var20_18 = (int)var2_2.getItemId(var17_15);
            var21_19 = (int)var2_2.getItemId(var19_17);
            while (true) {
                if (var20_18 <= var21_19) ** break;
                continue block0;
                var22_20 = this.getNumColumns() * var20_18;
                var23_21 = var22_20 + this.getNumColumns() - 1;
                var9_9 = this.getChildAtPosition(var22_20);
                var24_22 = var9_9.getTop();
                var25_23 = var4_4.day.getTopInset();
                var26_24 = var9_9.getBottom();
                var27_25 = var4_4.day.getBottomInset();
                if (!var15_13) {
                    var28_26 = var22_20 > var17_15 ? 0 : var16_14;
                    var22_20 = var19_17 > var23_21 ? this.getWidth() : var18_16;
                } else {
                    var28_26 = var19_17 > var23_21 ? 0 : var18_16;
                    var22_20 = var22_20 > var17_15 ? this.getWidth() : var16_14;
                }
                var1_1.drawRect((float)var28_26, (float)(var24_22 + var25_23), (float)var22_20, (float)(var26_24 - var27_25), var4_4.rangeFill);
                ++var20_18;
            }
            break;
        }
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        if (bl) {
            this.gainFocus(n, rect);
        } else {
            super.onFocusChanged(false, n, rect);
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!super.onKeyDown(n, keyEvent)) {
            return false;
        }
        if (this.getSelectedItemPosition() != -1 && this.getSelectedItemPosition() < this.getAdapter().firstPositionInMonth()) {
            if (19 == n) {
                this.setSelection(this.getAdapter().firstPositionInMonth());
                return true;
            }
            return false;
        }
        return true;
    }

    public void onMeasure(int n, int n2) {
        if (this.nestedScrollable) {
            super.onMeasure(n, View.MeasureSpec.makeMeasureSpec((int)0xFFFFFF, (int)Integer.MIN_VALUE));
            this.getLayoutParams().height = this.getMeasuredHeight();
        } else {
            super.onMeasure(n, n2);
        }
    }

    public final void setAdapter(ListAdapter listAdapter) {
        if (listAdapter instanceof MonthAdapter) {
            super.setAdapter(listAdapter);
            return;
        }
        throw new IllegalArgumentException(String.format("%1$s must have its Adapter set to a %2$s", MaterialCalendarGridView.class.getCanonicalName(), MonthAdapter.class.getCanonicalName()));
    }

    public void setSelection(int n) {
        if (n < this.getAdapter().firstPositionInMonth()) {
            super.setSelection(this.getAdapter().firstPositionInMonth());
        } else {
            super.setSelection(n);
        }
    }
}

