/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class Month
implements Comparable<Month>,
Parcelable {
    public static final Parcelable.Creator<Month> CREATOR = new Parcelable.Creator<Month>(){

        public Month createFromParcel(Parcel parcel) {
            return Month.create(parcel.readInt(), parcel.readInt());
        }

        public Month[] newArray(int n) {
            return new Month[n];
        }
    };
    final int daysInMonth;
    final int daysInWeek;
    private final Calendar firstOfMonth;
    private String longName;
    final int month;
    final long timeInMillis;
    final int year;

    private Month(Calendar calendar) {
        calendar.set(5, 1);
        this.firstOfMonth = calendar = UtcDates.getDayCopy(calendar);
        this.month = calendar.get(2);
        this.year = calendar.get(1);
        this.daysInWeek = calendar.getMaximum(7);
        this.daysInMonth = calendar.getActualMaximum(5);
        this.timeInMillis = calendar.getTimeInMillis();
    }

    static Month create(int n, int n2) {
        Calendar calendar = UtcDates.getUtcCalendar();
        calendar.set(1, n);
        calendar.set(2, n2);
        return new Month(calendar);
    }

    static Month create(long l) {
        Calendar calendar = UtcDates.getUtcCalendar();
        calendar.setTimeInMillis(l);
        return new Month(calendar);
    }

    static Month current() {
        return new Month(UtcDates.getTodayCalendar());
    }

    @Override
    public int compareTo(Month month) {
        return this.firstOfMonth.compareTo(month.firstOfMonth);
    }

    int daysFromStartOfWeekToFirstOfMonth() {
        int n;
        int n2 = n = this.firstOfMonth.get(7) - this.firstOfMonth.getFirstDayOfWeek();
        if (n < 0) {
            n2 = n + this.daysInWeek;
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Month)) {
            return false;
        }
        object = (Month)object;
        if (this.month != ((Month)object).month || this.year != ((Month)object).year) {
            bl = false;
        }
        return bl;
    }

    long getDay(int n) {
        Calendar calendar = UtcDates.getDayCopy(this.firstOfMonth);
        calendar.set(5, n);
        return calendar.getTimeInMillis();
    }

    int getDayOfMonth(long l) {
        Calendar calendar = UtcDates.getDayCopy(this.firstOfMonth);
        calendar.setTimeInMillis(l);
        return calendar.get(5);
    }

    String getLongName(Context context) {
        if (this.longName == null) {
            this.longName = DateStrings.getYearMonth(context, this.firstOfMonth.getTimeInMillis());
        }
        return this.longName;
    }

    long getStableId() {
        return this.firstOfMonth.getTimeInMillis();
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.month, this.year});
    }

    Month monthsLater(int n) {
        Calendar calendar = UtcDates.getDayCopy(this.firstOfMonth);
        calendar.add(2, n);
        return new Month(calendar);
    }

    int monthsUntil(Month month) {
        if (this.firstOfMonth instanceof GregorianCalendar) {
            return (month.year - this.year) * 12 + (month.month - this.month);
        }
        throw new IllegalArgumentException("Only Gregorian calendars are supported.");
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.year);
        parcel.writeInt(this.month);
    }
}

