/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarItemStyle;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialCalendarGridView;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import java.util.Collection;

class MonthAdapter
extends BaseAdapter {
    static final int MAXIMUM_WEEKS = UtcDates.getUtcCalendar().getMaximum(4);
    final CalendarConstraints calendarConstraints;
    CalendarStyle calendarStyle;
    final DateSelector<?> dateSelector;
    final Month month;
    private Collection<Long> previouslySelectedDates;

    MonthAdapter(Month month, DateSelector<?> dateSelector, CalendarConstraints calendarConstraints) {
        this.month = month;
        this.dateSelector = dateSelector;
        this.calendarConstraints = calendarConstraints;
        this.previouslySelectedDates = dateSelector.getSelectedDays();
    }

    private void initializeStyles(Context context) {
        if (this.calendarStyle == null) {
            this.calendarStyle = new CalendarStyle(context);
        }
    }

    private boolean isSelected(long l) {
        for (long l2 : this.dateSelector.getSelectedDays()) {
            if (UtcDates.canonicalYearMonthDay(l) != UtcDates.canonicalYearMonthDay(l2)) continue;
            return true;
        }
        return false;
    }

    private void updateSelectedState(TextView textView, long l) {
        CalendarItemStyle calendarItemStyle;
        if (textView == null) {
            return;
        }
        if (this.calendarConstraints.getDateValidator().isValid(l)) {
            textView.setEnabled(true);
            calendarItemStyle = this.isSelected(l) ? this.calendarStyle.selectedDay : (UtcDates.getTodayCalendar().getTimeInMillis() == l ? this.calendarStyle.todayDay : this.calendarStyle.day);
        } else {
            textView.setEnabled(false);
            calendarItemStyle = this.calendarStyle.invalidDay;
        }
        calendarItemStyle.styleItem(textView);
    }

    private void updateSelectedStateForDate(MaterialCalendarGridView materialCalendarGridView, long l) {
        if (Month.create(l).equals(this.month)) {
            int n = this.month.getDayOfMonth(l);
            this.updateSelectedState((TextView)materialCalendarGridView.getChildAt(materialCalendarGridView.getAdapter().dayToPosition(n) - materialCalendarGridView.getFirstVisiblePosition()), l);
        }
    }

    int dayToPosition(int n) {
        return this.firstPositionInMonth() + (n - 1);
    }

    int firstPositionInMonth() {
        return this.month.daysFromStartOfWeekToFirstOfMonth();
    }

    public int getCount() {
        return this.month.daysInMonth + this.firstPositionInMonth();
    }

    public Long getItem(int n) {
        if (n >= this.month.daysFromStartOfWeekToFirstOfMonth() && n <= this.lastPositionInMonth()) {
            return this.month.getDay(this.positionToDay(n));
        }
        return null;
    }

    public long getItemId(int n) {
        return n / this.month.daysInWeek;
    }

    public TextView getView(int n, View object, ViewGroup viewGroup) {
        int n2;
        this.initializeStyles(viewGroup.getContext());
        TextView textView = (TextView)object;
        if (object == null) {
            textView = (TextView)LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.mtrl_calendar_day, viewGroup, false);
        }
        if ((n2 = n - this.firstPositionInMonth()) >= 0 && n2 < this.month.daysInMonth) {
            textView.setTag((Object)this.month);
            textView.setText((CharSequence)String.format(textView.getResources().getConfiguration().locale, "%d", ++n2));
            long l = this.month.getDay(n2);
            if (this.month.year == Month.current().year) {
                textView.setContentDescription((CharSequence)DateStrings.getMonthDayOfWeekDay(l));
            } else {
                textView.setContentDescription((CharSequence)DateStrings.getYearMonthDayOfWeekDay(l));
            }
            textView.setVisibility(0);
            textView.setEnabled(true);
        } else {
            textView.setVisibility(8);
            textView.setEnabled(false);
        }
        object = this.getItem(n);
        if (object == null) {
            return textView;
        }
        this.updateSelectedState(textView, (Long)object);
        return textView;
    }

    public boolean hasStableIds() {
        return true;
    }

    boolean isFirstInRow(int n) {
        boolean bl = n % this.month.daysInWeek == 0;
        return bl;
    }

    boolean isLastInRow(int n) {
        boolean bl = true;
        if ((n + 1) % this.month.daysInWeek != 0) {
            bl = false;
        }
        return bl;
    }

    int lastPositionInMonth() {
        return this.month.daysFromStartOfWeekToFirstOfMonth() + this.month.daysInMonth - 1;
    }

    int positionToDay(int n) {
        return n - this.month.daysFromStartOfWeekToFirstOfMonth() + 1;
    }

    public void updateSelectedStates(MaterialCalendarGridView materialCalendarGridView) {
        Object object = this.previouslySelectedDates.iterator();
        while (object.hasNext()) {
            this.updateSelectedStateForDate(materialCalendarGridView, object.next());
        }
        object = this.dateSelector;
        if (object != null) {
            object = object.getSelectedDays().iterator();
            while (object.hasNext()) {
                this.updateSelectedStateForDate(materialCalendarGridView, object.next());
            }
            this.previouslySelectedDates = this.dateSelector.getSelectedDays();
        }
    }

    boolean withinMonth(int n) {
        boolean bl = n >= this.firstPositionInMonth() && n <= this.lastPositionInMonth();
        return bl;
    }
}

