/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.MaterialCalendar;
import com.google.android.material.datepicker.MaterialCalendarGridView;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.MonthAdapter;

class MonthsPagerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final CalendarConstraints calendarConstraints;
    private final Context context;
    private final DateSelector<?> dateSelector;
    private final int itemHeight;
    private final MaterialCalendar.OnDayClickListener onDayClickListener;

    MonthsPagerAdapter(Context context, DateSelector<?> dateSelector, CalendarConstraints calendarConstraints, MaterialCalendar.OnDayClickListener onDayClickListener) {
        Month month = calendarConstraints.getStart();
        Month month2 = calendarConstraints.getEnd();
        Month month3 = calendarConstraints.getOpenAt();
        if (month.compareTo(month3) <= 0) {
            if (month3.compareTo(month2) <= 0) {
                int n = MonthAdapter.MAXIMUM_WEEKS;
                int n2 = MaterialCalendar.getDayHeight(context);
                int n3 = MaterialDatePicker.isFullscreen(context) ? MaterialCalendar.getDayHeight(context) : 0;
                this.context = context;
                this.itemHeight = n * n2 + n3;
                this.calendarConstraints = calendarConstraints;
                this.dateSelector = dateSelector;
                this.onDayClickListener = onDayClickListener;
                this.setHasStableIds(true);
                return;
            }
            throw new IllegalArgumentException("currentPage cannot be after lastPage");
        }
        throw new IllegalArgumentException("firstPage cannot be after currentPage");
    }

    public int getItemCount() {
        return this.calendarConstraints.getMonthSpan();
    }

    public long getItemId(int n) {
        return this.calendarConstraints.getStart().monthsLater(n).getStableId();
    }

    Month getPageMonth(int n) {
        return this.calendarConstraints.getStart().monthsLater(n);
    }

    CharSequence getPageTitle(int n) {
        return this.getPageMonth(n).getLongName(this.context);
    }

    int getPosition(Month month) {
        return this.calendarConstraints.getStart().monthsUntil(month);
    }

    public void onBindViewHolder(ViewHolder object, int n) {
        Month month = this.calendarConstraints.getStart().monthsLater(n);
        ((ViewHolder)((Object)object)).monthTitle.setText((CharSequence)month.getLongName(((ViewHolder)((Object)object)).itemView.getContext()));
        object = (MaterialCalendarGridView)((ViewHolder)((Object)object)).monthGrid.findViewById(R.id.month_grid);
        if (((MaterialCalendarGridView)((Object)object)).getAdapter() != null && month.equals(((MaterialCalendarGridView)((Object)object)).getAdapter().month)) {
            object.invalidate();
            ((MaterialCalendarGridView)((Object)object)).getAdapter().updateSelectedStates((MaterialCalendarGridView)((Object)object));
        } else {
            MonthAdapter monthAdapter = new MonthAdapter(month, this.dateSelector, this.calendarConstraints);
            object.setNumColumns(month.daysInWeek);
            ((MaterialCalendarGridView)((Object)object)).setAdapter((ListAdapter)monthAdapter);
        }
        object.setOnItemClickListener(new AdapterView.OnItemClickListener((MaterialCalendarGridView)((Object)object)){
            final /* synthetic */ MaterialCalendarGridView val$monthGrid;
            {
                this.val$monthGrid = materialCalendarGridView;
            }

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (this.val$monthGrid.getAdapter().withinMonth(n)) {
                    MonthsPagerAdapter.this.onDayClickListener.onDayClick(this.val$monthGrid.getAdapter().getItem(n));
                }
            }
        });
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.mtrl_calendar_month_labeled, viewGroup, false);
        if (MaterialDatePicker.isFullscreen(viewGroup.getContext())) {
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, this.itemHeight));
            return new ViewHolder(linearLayout, true);
        }
        return new ViewHolder(linearLayout, false);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        final MaterialCalendarGridView monthGrid;
        final TextView monthTitle;

        ViewHolder(LinearLayout linearLayout, boolean bl) {
            super((View)linearLayout);
            TextView textView;
            this.monthTitle = textView = (TextView)linearLayout.findViewById(R.id.month_title);
            ViewCompat.setAccessibilityHeading((View)textView, (boolean)true);
            this.monthGrid = (MaterialCalendarGridView)linearLayout.findViewById(R.id.month_grid);
            if (!bl) {
                textView.setVisibility(8);
            }
        }
    }
}

