/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.dialog.InsetDialogOnTouchListener;
import com.google.android.material.dialog.MaterialDialogs;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialAlertDialogBuilder
extends AlertDialog.Builder {
    private static final int DEF_STYLE_ATTR = R.attr.alertDialogStyle;
    private static final int DEF_STYLE_RES = R.style.MaterialAlertDialog_MaterialComponents;
    private static final int MATERIAL_ALERT_DIALOG_THEME_OVERLAY = R.attr.materialAlertDialogTheme;
    private Drawable background;
    private final Rect backgroundInsets;

    public MaterialAlertDialogBuilder(Context context) {
        this(context, 0);
    }

    public MaterialAlertDialogBuilder(Context object, int n) {
        super(MaterialAlertDialogBuilder.createMaterialAlertDialogThemedContext((Context)object), MaterialAlertDialogBuilder.getOverridingThemeResId((Context)object, n));
        Context context = this.getContext();
        Resources.Theme theme = context.getTheme();
        int n2 = DEF_STYLE_ATTR;
        int n3 = DEF_STYLE_RES;
        this.backgroundInsets = MaterialDialogs.getDialogBackgroundInsets(context, n2, n3);
        n = MaterialColors.getColor(context, R.attr.colorSurface, ((Object)((Object)this)).getClass().getCanonicalName());
        object = new MaterialShapeDrawable(context, null, n2, n3);
        ((MaterialShapeDrawable)object).initializeElevationOverlay(context);
        ((MaterialShapeDrawable)object).setFillColor(ColorStateList.valueOf((int)n));
        if (Build.VERSION.SDK_INT >= 28) {
            context = new TypedValue();
            theme.resolveAttribute(16844145, (TypedValue)context, true);
            float f = context.getDimension(this.getContext().getResources().getDisplayMetrics());
            if (context.type == 5 && f >= 0.0f) {
                ((MaterialShapeDrawable)object).setCornerSize(f);
            }
        }
        this.background = object;
    }

    private static Context createMaterialAlertDialogThemedContext(Context context) {
        int n = MaterialAlertDialogBuilder.getMaterialAlertDialogThemeOverlay(context);
        context = MaterialThemeOverlay.wrap(context, null, DEF_STYLE_ATTR, DEF_STYLE_RES);
        if (n == 0) {
            return context;
        }
        return new ContextThemeWrapper(context, n);
    }

    private static int getMaterialAlertDialogThemeOverlay(Context context) {
        if ((context = MaterialAttributes.resolve(context, MATERIAL_ALERT_DIALOG_THEME_OVERLAY)) == null) {
            return 0;
        }
        return context.data;
    }

    private static int getOverridingThemeResId(Context context, int n) {
        int n2 = n;
        if (n == 0) {
            n2 = MaterialAlertDialogBuilder.getMaterialAlertDialogThemeOverlay(context);
        }
        return n2;
    }

    public AlertDialog create() {
        AlertDialog alertDialog = super.create();
        Window window = alertDialog.getWindow();
        View view = window.getDecorView();
        Drawable drawable2 = this.background;
        if (drawable2 instanceof MaterialShapeDrawable) {
            ((MaterialShapeDrawable)drawable2).setElevation(ViewCompat.getElevation((View)view));
        }
        window.setBackgroundDrawable((Drawable)MaterialDialogs.insetDrawable(this.background, this.backgroundInsets));
        view.setOnTouchListener((View.OnTouchListener)new InsetDialogOnTouchListener((Dialog)alertDialog, this.backgroundInsets));
        return alertDialog;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public MaterialAlertDialogBuilder setAdapter(ListAdapter listAdapter, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setAdapter(listAdapter, onClickListener);
    }

    public MaterialAlertDialogBuilder setBackground(Drawable drawable2) {
        this.background = drawable2;
        return this;
    }

    public MaterialAlertDialogBuilder setBackgroundInsetBottom(int n) {
        this.backgroundInsets.bottom = n;
        return this;
    }

    public MaterialAlertDialogBuilder setBackgroundInsetEnd(int n) {
        if (Build.VERSION.SDK_INT >= 17 && this.getContext().getResources().getConfiguration().getLayoutDirection() == 1) {
            this.backgroundInsets.left = n;
        } else {
            this.backgroundInsets.right = n;
        }
        return this;
    }

    public MaterialAlertDialogBuilder setBackgroundInsetStart(int n) {
        if (Build.VERSION.SDK_INT >= 17 && this.getContext().getResources().getConfiguration().getLayoutDirection() == 1) {
            this.backgroundInsets.right = n;
        } else {
            this.backgroundInsets.left = n;
        }
        return this;
    }

    public MaterialAlertDialogBuilder setBackgroundInsetTop(int n) {
        this.backgroundInsets.top = n;
        return this;
    }

    public MaterialAlertDialogBuilder setCancelable(boolean bl) {
        return (MaterialAlertDialogBuilder)super.setCancelable(bl);
    }

    public MaterialAlertDialogBuilder setCursor(Cursor cursor, DialogInterface.OnClickListener onClickListener, String string2) {
        return (MaterialAlertDialogBuilder)super.setCursor(cursor, onClickListener, string2);
    }

    public MaterialAlertDialogBuilder setCustomTitle(View view) {
        return (MaterialAlertDialogBuilder)super.setCustomTitle(view);
    }

    public MaterialAlertDialogBuilder setIcon(int n) {
        return (MaterialAlertDialogBuilder)super.setIcon(n);
    }

    public MaterialAlertDialogBuilder setIcon(Drawable drawable2) {
        return (MaterialAlertDialogBuilder)super.setIcon(drawable2);
    }

    public MaterialAlertDialogBuilder setIconAttribute(int n) {
        return (MaterialAlertDialogBuilder)super.setIconAttribute(n);
    }

    public MaterialAlertDialogBuilder setItems(int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setItems(n, onClickListener);
    }

    public MaterialAlertDialogBuilder setItems(CharSequence[] charSequenceArray, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setItems(charSequenceArray, onClickListener);
    }

    public MaterialAlertDialogBuilder setMessage(int n) {
        return (MaterialAlertDialogBuilder)super.setMessage(n);
    }

    public MaterialAlertDialogBuilder setMessage(CharSequence charSequence) {
        return (MaterialAlertDialogBuilder)super.setMessage(charSequence);
    }

    public MaterialAlertDialogBuilder setMultiChoiceItems(int n, boolean[] blArray, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
        return (MaterialAlertDialogBuilder)super.setMultiChoiceItems(n, blArray, onMultiChoiceClickListener);
    }

    public MaterialAlertDialogBuilder setMultiChoiceItems(Cursor cursor, String string2, String string3, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
        return (MaterialAlertDialogBuilder)super.setMultiChoiceItems(cursor, string2, string3, onMultiChoiceClickListener);
    }

    public MaterialAlertDialogBuilder setMultiChoiceItems(CharSequence[] charSequenceArray, boolean[] blArray, DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener) {
        return (MaterialAlertDialogBuilder)super.setMultiChoiceItems(charSequenceArray, blArray, onMultiChoiceClickListener);
    }

    public MaterialAlertDialogBuilder setNegativeButton(int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setNegativeButton(n, onClickListener);
    }

    public MaterialAlertDialogBuilder setNegativeButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setNegativeButton(charSequence, onClickListener);
    }

    public MaterialAlertDialogBuilder setNegativeButtonIcon(Drawable drawable2) {
        return (MaterialAlertDialogBuilder)super.setNegativeButtonIcon(drawable2);
    }

    public MaterialAlertDialogBuilder setNeutralButton(int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setNeutralButton(n, onClickListener);
    }

    public MaterialAlertDialogBuilder setNeutralButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setNeutralButton(charSequence, onClickListener);
    }

    public MaterialAlertDialogBuilder setNeutralButtonIcon(Drawable drawable2) {
        return (MaterialAlertDialogBuilder)super.setNeutralButtonIcon(drawable2);
    }

    public MaterialAlertDialogBuilder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        return (MaterialAlertDialogBuilder)super.setOnCancelListener(onCancelListener);
    }

    public MaterialAlertDialogBuilder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        return (MaterialAlertDialogBuilder)super.setOnDismissListener(onDismissListener);
    }

    public MaterialAlertDialogBuilder setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        return (MaterialAlertDialogBuilder)super.setOnItemSelectedListener(onItemSelectedListener);
    }

    public MaterialAlertDialogBuilder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
        return (MaterialAlertDialogBuilder)super.setOnKeyListener(onKeyListener);
    }

    public MaterialAlertDialogBuilder setPositiveButton(int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setPositiveButton(n, onClickListener);
    }

    public MaterialAlertDialogBuilder setPositiveButton(CharSequence charSequence, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setPositiveButton(charSequence, onClickListener);
    }

    public MaterialAlertDialogBuilder setPositiveButtonIcon(Drawable drawable2) {
        return (MaterialAlertDialogBuilder)super.setPositiveButtonIcon(drawable2);
    }

    public MaterialAlertDialogBuilder setSingleChoiceItems(int n, int n2, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setSingleChoiceItems(n, n2, onClickListener);
    }

    public MaterialAlertDialogBuilder setSingleChoiceItems(Cursor cursor, int n, String string2, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setSingleChoiceItems(cursor, n, string2, onClickListener);
    }

    public MaterialAlertDialogBuilder setSingleChoiceItems(ListAdapter listAdapter, int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setSingleChoiceItems(listAdapter, n, onClickListener);
    }

    public MaterialAlertDialogBuilder setSingleChoiceItems(CharSequence[] charSequenceArray, int n, DialogInterface.OnClickListener onClickListener) {
        return (MaterialAlertDialogBuilder)super.setSingleChoiceItems(charSequenceArray, n, onClickListener);
    }

    public MaterialAlertDialogBuilder setTitle(int n) {
        return (MaterialAlertDialogBuilder)super.setTitle(n);
    }

    public MaterialAlertDialogBuilder setTitle(CharSequence charSequence) {
        return (MaterialAlertDialogBuilder)super.setTitle(charSequence);
    }

    public MaterialAlertDialogBuilder setView(int n) {
        return (MaterialAlertDialogBuilder)super.setView(n);
    }

    public MaterialAlertDialogBuilder setView(View view) {
        return (MaterialAlertDialogBuilder)super.setView(view);
    }
}

