/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.util.Property;
import android.view.View;
import androidx.core.util.Preconditions;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.floatingactionbutton.AnimatorTracker;
import com.google.android.material.floatingactionbutton.ExtendedFloatingActionButton;
import com.google.android.material.floatingactionbutton.MotionStrategy;
import java.util.ArrayList;
import java.util.List;

abstract class BaseMotionStrategy
implements MotionStrategy {
    private final Context context;
    private MotionSpec defaultMotionSpec;
    private final ExtendedFloatingActionButton fab;
    private final ArrayList<Animator.AnimatorListener> listeners = new ArrayList();
    private MotionSpec motionSpec;
    private final AnimatorTracker tracker;

    BaseMotionStrategy(ExtendedFloatingActionButton extendedFloatingActionButton, AnimatorTracker animatorTracker) {
        this.fab = extendedFloatingActionButton;
        this.context = extendedFloatingActionButton.getContext();
        this.tracker = animatorTracker;
    }

    @Override
    public final void addAnimationListener(Animator.AnimatorListener animatorListener) {
        this.listeners.add(animatorListener);
    }

    @Override
    public AnimatorSet createAnimator() {
        return this.createAnimator(this.getCurrentMotionSpec());
    }

    AnimatorSet createAnimator(MotionSpec motionSpec) {
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        if (motionSpec.hasPropertyValues("opacity")) {
            arrayList.add((Animator)motionSpec.getAnimator("opacity", this.fab, View.ALPHA));
        }
        if (motionSpec.hasPropertyValues("scale")) {
            arrayList.add((Animator)motionSpec.getAnimator("scale", this.fab, View.SCALE_Y));
            arrayList.add((Animator)motionSpec.getAnimator("scale", this.fab, View.SCALE_X));
        }
        if (motionSpec.hasPropertyValues("width")) {
            arrayList.add((Animator)motionSpec.getAnimator("width", this.fab, ExtendedFloatingActionButton.WIDTH));
        }
        if (motionSpec.hasPropertyValues("height")) {
            arrayList.add((Animator)motionSpec.getAnimator("height", this.fab, ExtendedFloatingActionButton.HEIGHT));
        }
        if (motionSpec.hasPropertyValues("paddingStart")) {
            arrayList.add((Animator)motionSpec.getAnimator("paddingStart", this.fab, ExtendedFloatingActionButton.PADDING_START));
        }
        if (motionSpec.hasPropertyValues("paddingEnd")) {
            arrayList.add((Animator)motionSpec.getAnimator("paddingEnd", this.fab, ExtendedFloatingActionButton.PADDING_END));
        }
        if (motionSpec.hasPropertyValues("labelOpacity")) {
            arrayList.add((Animator)motionSpec.getAnimator("labelOpacity", this.fab, new Property<ExtendedFloatingActionButton, Float>(Float.class, "LABEL_OPACITY_PROPERTY"){

                public Float get(ExtendedFloatingActionButton extendedFloatingActionButton) {
                    int n = Color.alpha((int)extendedFloatingActionButton.originalTextCsl.getColorForState(extendedFloatingActionButton.getDrawableState(), ((BaseMotionStrategy)BaseMotionStrategy.this).fab.originalTextCsl.getDefaultColor()));
                    return Float.valueOf(AnimationUtils.lerp(0.0f, 1.0f, (float)Color.alpha((int)extendedFloatingActionButton.getCurrentTextColor()) / 255.0f / (float)n));
                }

                public void set(ExtendedFloatingActionButton extendedFloatingActionButton, Float f) {
                    int n = extendedFloatingActionButton.originalTextCsl.getColorForState(extendedFloatingActionButton.getDrawableState(), ((BaseMotionStrategy)BaseMotionStrategy.this).fab.originalTextCsl.getDefaultColor());
                    ColorStateList colorStateList = ColorStateList.valueOf((int)Color.argb((int)((int)(AnimationUtils.lerp(0.0f, (float)Color.alpha((int)n) / 255.0f, f.floatValue()) * 255.0f)), (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n)));
                    if (f.floatValue() == 1.0f) {
                        extendedFloatingActionButton.silentlyUpdateTextColor(extendedFloatingActionButton.originalTextCsl);
                    } else {
                        extendedFloatingActionButton.silentlyUpdateTextColor(colorStateList);
                    }
                }
            }));
        }
        motionSpec = new AnimatorSet();
        AnimatorSetCompat.playTogether((AnimatorSet)motionSpec, arrayList);
        return motionSpec;
    }

    @Override
    public final MotionSpec getCurrentMotionSpec() {
        MotionSpec motionSpec = this.motionSpec;
        if (motionSpec != null) {
            return motionSpec;
        }
        if (this.defaultMotionSpec == null) {
            this.defaultMotionSpec = MotionSpec.createFromResource(this.context, this.getDefaultMotionSpecResource());
        }
        return (MotionSpec)Preconditions.checkNotNull((Object)this.defaultMotionSpec);
    }

    @Override
    public final List<Animator.AnimatorListener> getListeners() {
        return this.listeners;
    }

    @Override
    public MotionSpec getMotionSpec() {
        return this.motionSpec;
    }

    @Override
    public void onAnimationCancel() {
        this.tracker.clear();
    }

    @Override
    public void onAnimationEnd() {
        this.tracker.clear();
    }

    @Override
    public void onAnimationStart(Animator animator2) {
        this.tracker.onNextAnimationStart(animator2);
    }

    @Override
    public final void removeAnimationListener(Animator.AnimatorListener animatorListener) {
        this.listeners.remove(animatorListener);
    }

    @Override
    public final void setMotionSpec(MotionSpec motionSpec) {
        this.motionSpec = motionSpec;
    }
}

