/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.imageview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class ShapeableImageView
extends AppCompatImageView
implements Shapeable {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ShapeableImageView;
    private static final int UNDEFINED_PADDING = Integer.MIN_VALUE;
    private final Paint borderPaint;
    private int bottomContentPadding;
    private final Paint clearPaint;
    private final RectF destination;
    private int endContentPadding;
    private boolean hasAdjustedPaddingAfterLayoutDirectionResolved;
    private int leftContentPadding;
    private Path maskPath;
    private final RectF maskRect;
    private final Path path;
    private final ShapeAppearancePathProvider pathProvider;
    private int rightContentPadding;
    private MaterialShapeDrawable shadowDrawable;
    private ShapeAppearanceModel shapeAppearanceModel;
    private int startContentPadding;
    private ColorStateList strokeColor;
    private float strokeWidth;
    private int topContentPadding;

    public ShapeableImageView(Context context) {
        this(context, null, 0);
    }

    public ShapeableImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ShapeableImageView(Context context, AttributeSet attributeSet, int n) {
        int n2;
        Paint paint;
        int n3 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n3), attributeSet, n);
        this.pathProvider = ShapeAppearancePathProvider.getInstance();
        this.path = new Path();
        this.hasAdjustedPaddingAfterLayoutDirectionResolved = false;
        context = this.getContext();
        this.clearPaint = paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-1);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.destination = new RectF();
        this.maskRect = new RectF();
        this.maskPath = new Path();
        paint = context.obtainStyledAttributes(attributeSet, R.styleable.ShapeableImageView, n, n3);
        this.strokeColor = MaterialResources.getColorStateList(context, (TypedArray)paint, R.styleable.ShapeableImageView_strokeColor);
        this.strokeWidth = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_strokeWidth, 0);
        this.leftContentPadding = n2 = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPadding, 0);
        this.topContentPadding = n2;
        this.rightContentPadding = n2;
        this.bottomContentPadding = n2;
        this.leftContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingLeft, n2);
        this.topContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingTop, n2);
        this.rightContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingRight, n2);
        this.bottomContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingBottom, n2);
        this.startContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingStart, Integer.MIN_VALUE);
        this.endContentPadding = paint.getDimensionPixelSize(R.styleable.ShapeableImageView_contentPaddingEnd, Integer.MIN_VALUE);
        paint.recycle();
        this.borderPaint = paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setAntiAlias(true);
        this.shapeAppearanceModel = ShapeAppearanceModel.builder(context, attributeSet, n, n3).build();
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new OutlineProvider());
        }
    }

    static /* synthetic */ MaterialShapeDrawable access$102(ShapeableImageView shapeableImageView, MaterialShapeDrawable materialShapeDrawable) {
        shapeableImageView.shadowDrawable = materialShapeDrawable;
        return materialShapeDrawable;
    }

    private void drawStroke(Canvas canvas) {
        if (this.strokeColor == null) {
            return;
        }
        this.borderPaint.setStrokeWidth(this.strokeWidth);
        int n = this.strokeColor.getColorForState(this.getDrawableState(), this.strokeColor.getDefaultColor());
        if (this.strokeWidth > 0.0f && n != 0) {
            this.borderPaint.setColor(n);
            canvas.drawPath(this.path, this.borderPaint);
        }
    }

    private boolean isContentPaddingRelative() {
        boolean bl = this.startContentPadding != Integer.MIN_VALUE || this.endContentPadding != Integer.MIN_VALUE;
        return bl;
    }

    private boolean isRtl() {
        int n = Build.VERSION.SDK_INT;
        boolean bl = true;
        if (n < 17 || this.getLayoutDirection() != 1) {
            bl = false;
        }
        return bl;
    }

    private void updateShapeMask(int n, int n2) {
        this.destination.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(n - this.getPaddingRight()), (float)(n2 - this.getPaddingBottom()));
        this.pathProvider.calculatePath(this.shapeAppearanceModel, 1.0f, this.destination, this.path);
        this.maskPath.rewind();
        this.maskPath.addPath(this.path);
        this.maskRect.set(0.0f, 0.0f, (float)n, (float)n2);
        this.maskPath.addRect(this.maskRect, Path.Direction.CCW);
    }

    public int getContentPaddingBottom() {
        return this.bottomContentPadding;
    }

    public final int getContentPaddingEnd() {
        int n = this.endContentPadding;
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        n = this.isRtl() ? this.leftContentPadding : this.rightContentPadding;
        return n;
    }

    public int getContentPaddingLeft() {
        if (this.isContentPaddingRelative()) {
            int n;
            if (this.isRtl() && (n = this.endContentPadding) != Integer.MIN_VALUE) {
                return n;
            }
            if (!this.isRtl() && (n = this.startContentPadding) != Integer.MIN_VALUE) {
                return n;
            }
        }
        return this.leftContentPadding;
    }

    public int getContentPaddingRight() {
        if (this.isContentPaddingRelative()) {
            int n;
            if (this.isRtl() && (n = this.startContentPadding) != Integer.MIN_VALUE) {
                return n;
            }
            if (!this.isRtl() && (n = this.endContentPadding) != Integer.MIN_VALUE) {
                return n;
            }
        }
        return this.rightContentPadding;
    }

    public final int getContentPaddingStart() {
        int n = this.startContentPadding;
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        n = this.isRtl() ? this.rightContentPadding : this.leftContentPadding;
        return n;
    }

    public int getContentPaddingTop() {
        return this.topContentPadding;
    }

    public int getPaddingBottom() {
        return super.getPaddingBottom() - this.getContentPaddingBottom();
    }

    public int getPaddingEnd() {
        return super.getPaddingEnd() - this.getContentPaddingEnd();
    }

    public int getPaddingLeft() {
        return super.getPaddingLeft() - this.getContentPaddingLeft();
    }

    public int getPaddingRight() {
        return super.getPaddingRight() - this.getContentPaddingRight();
    }

    public int getPaddingStart() {
        return super.getPaddingStart() - this.getContentPaddingStart();
    }

    public int getPaddingTop() {
        return super.getPaddingTop() - this.getContentPaddingTop();
    }

    @Override
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.shapeAppearanceModel;
    }

    public ColorStateList getStrokeColor() {
        return this.strokeColor;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setLayerType(2, null);
    }

    protected void onDetachedFromWindow() {
        this.setLayerType(0, null);
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.maskPath, this.clearPaint);
        this.drawStroke(canvas);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.hasAdjustedPaddingAfterLayoutDirectionResolved) {
            return;
        }
        if (Build.VERSION.SDK_INT > 19 && !this.isLayoutDirectionResolved()) {
            return;
        }
        this.hasAdjustedPaddingAfterLayoutDirectionResolved = true;
        if (Build.VERSION.SDK_INT >= 21 && (this.isPaddingRelative() || this.isContentPaddingRelative())) {
            this.setPaddingRelative(super.getPaddingStart(), super.getPaddingTop(), super.getPaddingEnd(), super.getPaddingBottom());
            return;
        }
        this.setPadding(super.getPaddingLeft(), super.getPaddingTop(), super.getPaddingRight(), super.getPaddingBottom());
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.updateShapeMask(n, n2);
    }

    public void setContentPadding(int n, int n2, int n3, int n4) {
        this.startContentPadding = Integer.MIN_VALUE;
        this.endContentPadding = Integer.MIN_VALUE;
        super.setPadding(super.getPaddingLeft() - this.leftContentPadding + n, super.getPaddingTop() - this.topContentPadding + n2, super.getPaddingRight() - this.rightContentPadding + n3, super.getPaddingBottom() - this.bottomContentPadding + n4);
        this.leftContentPadding = n;
        this.topContentPadding = n2;
        this.rightContentPadding = n3;
        this.bottomContentPadding = n4;
    }

    public void setContentPaddingRelative(int n, int n2, int n3, int n4) {
        super.setPaddingRelative(super.getPaddingStart() - this.getContentPaddingStart() + n, super.getPaddingTop() - this.topContentPadding + n2, super.getPaddingEnd() - this.getContentPaddingEnd() + n3, super.getPaddingBottom() - this.bottomContentPadding + n4);
        int n5 = this.isRtl() ? n3 : n;
        this.leftContentPadding = n5;
        this.topContentPadding = n2;
        if (!this.isRtl()) {
            n = n3;
        }
        this.rightContentPadding = n;
        this.bottomContentPadding = n4;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        super.setPadding(n + this.getContentPaddingLeft(), n2 + this.getContentPaddingTop(), n3 + this.getContentPaddingRight(), n4 + this.getContentPaddingBottom());
    }

    public void setPaddingRelative(int n, int n2, int n3, int n4) {
        super.setPaddingRelative(n + this.getContentPaddingStart(), n2 + this.getContentPaddingTop(), n3 + this.getContentPaddingEnd(), n4 + this.getContentPaddingBottom());
    }

    @Override
    public void setShapeAppearanceModel(ShapeAppearanceModel shapeAppearanceModel) {
        this.shapeAppearanceModel = shapeAppearanceModel;
        MaterialShapeDrawable materialShapeDrawable = this.shadowDrawable;
        if (materialShapeDrawable != null) {
            materialShapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        }
        this.updateShapeMask(this.getWidth(), this.getHeight());
        this.invalidate();
        if (Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setStrokeColor(ColorStateList colorStateList) {
        this.strokeColor = colorStateList;
        this.invalidate();
    }

    public void setStrokeColorResource(int n) {
        this.setStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
    }

    public void setStrokeWidth(float f) {
        if (this.strokeWidth != f) {
            this.strokeWidth = f;
            this.invalidate();
        }
    }

    public void setStrokeWidthResource(int n) {
        this.setStrokeWidth(this.getResources().getDimensionPixelSize(n));
    }

    class OutlineProvider
    extends ViewOutlineProvider {
        private final Rect rect = new Rect();

        OutlineProvider() {
        }

        public void getOutline(View view, Outline outline) {
            if (ShapeableImageView.this.shapeAppearanceModel == null) {
                return;
            }
            if (ShapeableImageView.this.shadowDrawable == null) {
                ShapeableImageView.access$102(ShapeableImageView.this, new MaterialShapeDrawable(ShapeableImageView.this.shapeAppearanceModel));
            }
            ShapeableImageView.this.destination.round(this.rect);
            ShapeableImageView.this.shadowDrawable.setBounds(this.rect);
            ShapeableImageView.this.shadowDrawable.getOutline(outline);
        }
    }
}

