/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.animation.TimeInterpolator;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.core.math.MathUtils;
import androidx.core.text.TextDirectionHeuristicCompat;
import androidx.core.text.TextDirectionHeuristicsCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.StaticLayoutBuilderCompat;
import com.google.android.material.resources.CancelableFontCallback;
import com.google.android.material.resources.TextAppearance;

public final class CollapsingTextHelper {
    private static final boolean DEBUG_DRAW = false;
    private static final Paint DEBUG_DRAW_PAINT;
    private static final String ELLIPSIS_NORMAL = "\u2026";
    private static final float FADE_MODE_THRESHOLD_FRACTION_RELATIVE = 0.5f;
    private static final String TAG = "CollapsingTextHelper";
    private static final boolean USE_SCALING_TEXTURE;
    private boolean boundsChanged;
    private final Rect collapsedBounds;
    private float collapsedDrawX;
    private float collapsedDrawY;
    private CancelableFontCallback collapsedFontCallback;
    private float collapsedLetterSpacing;
    private ColorStateList collapsedShadowColor;
    private float collapsedShadowDx;
    private float collapsedShadowDy;
    private float collapsedShadowRadius;
    private float collapsedTextBlend;
    private ColorStateList collapsedTextColor;
    private int collapsedTextGravity = 16;
    private float collapsedTextSize = 15.0f;
    private float collapsedTextWidth;
    private Typeface collapsedTypeface;
    private final RectF currentBounds;
    private float currentDrawX;
    private float currentDrawY;
    private int currentOffsetY;
    private float currentTextSize;
    private Typeface currentTypeface;
    private boolean drawTitle;
    private final Rect expandedBounds;
    private float expandedDrawX;
    private float expandedDrawY;
    private float expandedFirstLineDrawX;
    private CancelableFontCallback expandedFontCallback;
    private float expandedFraction;
    private float expandedLetterSpacing;
    private int expandedLineCount;
    private ColorStateList expandedShadowColor;
    private float expandedShadowDx;
    private float expandedShadowDy;
    private float expandedShadowRadius;
    private float expandedTextBlend;
    private ColorStateList expandedTextColor;
    private int expandedTextGravity = 16;
    private float expandedTextSize = 15.0f;
    private Bitmap expandedTitleTexture;
    private Typeface expandedTypeface;
    private boolean fadeModeEnabled;
    private float fadeModeStartFraction;
    private float fadeModeThresholdFraction;
    private int hyphenationFrequency = StaticLayoutBuilderCompat.DEFAULT_HYPHENATION_FREQUENCY;
    private boolean isRtl;
    private boolean isRtlTextDirectionHeuristicsEnabled = true;
    private float lineSpacingAdd = 0.0f;
    private float lineSpacingMultiplier = 1.0f;
    private int maxLines = 1;
    private TimeInterpolator positionInterpolator;
    private float scale;
    private int[] state;
    private CharSequence text;
    private StaticLayout textLayout;
    private final TextPaint textPaint;
    private TimeInterpolator textSizeInterpolator;
    private CharSequence textToDraw;
    private CharSequence textToDrawCollapsed;
    private Paint texturePaint;
    private final TextPaint tmpPaint;
    private boolean useTexture;
    private final View view;

    static {
        boolean bl = Build.VERSION.SDK_INT < 18;
        USE_SCALING_TEXTURE = bl;
        DEBUG_DRAW_PAINT = null;
    }

    public CollapsingTextHelper(View view) {
        this.view = view;
        view = new TextPaint(129);
        this.textPaint = view;
        this.tmpPaint = new TextPaint((Paint)view);
        this.collapsedBounds = new Rect();
        this.expandedBounds = new Rect();
        this.currentBounds = new RectF();
        this.fadeModeThresholdFraction = this.calculateFadeModeThresholdFraction();
    }

    private static int blendColors(int n, int n2, float f) {
        float f2 = 1.0f - f;
        float f3 = Color.alpha((int)n);
        float f4 = Color.alpha((int)n2);
        float f5 = Color.red((int)n);
        float f6 = Color.red((int)n2);
        float f7 = Color.green((int)n);
        float f8 = Color.green((int)n2);
        float f9 = Color.blue((int)n);
        float f10 = Color.blue((int)n2);
        return Color.argb((int)((int)(f3 * f2 + f4 * f)), (int)((int)(f5 * f2 + f6 * f)), (int)((int)(f7 * f2 + f8 * f)), (int)((int)(f9 * f2 + f10 * f)));
    }

    private void calculateBaseOffsets(boolean bl) {
        float f;
        StaticLayout staticLayout;
        float f2 = this.currentTextSize;
        this.calculateUsingTextSize(this.collapsedTextSize, bl);
        CharSequence charSequence = this.textToDraw;
        if (charSequence != null && (staticLayout = this.textLayout) != null) {
            this.textToDrawCollapsed = TextUtils.ellipsize((CharSequence)charSequence, (TextPaint)this.textPaint, (float)staticLayout.getWidth(), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        }
        charSequence = this.textToDrawCollapsed;
        float f3 = 0.0f;
        if (charSequence != null) {
            staticLayout = new TextPaint((Paint)this.textPaint);
            if (Build.VERSION.SDK_INT >= 21) {
                staticLayout.setLetterSpacing(this.collapsedLetterSpacing);
            }
            charSequence = this.textToDrawCollapsed;
            this.collapsedTextWidth = staticLayout.measureText(charSequence, 0, charSequence.length());
        } else {
            this.collapsedTextWidth = 0.0f;
        }
        int n = GravityCompat.getAbsoluteGravity((int)this.collapsedTextGravity, (int)(this.isRtl ? 1 : 0));
        int n2 = n & 0x70;
        if (n2 != 48) {
            if (n2 != 80) {
                f = (this.textPaint.descent() - this.textPaint.ascent()) / 2.0f;
                this.collapsedDrawY = (float)this.collapsedBounds.centerY() - f;
            } else {
                this.collapsedDrawY = (float)this.collapsedBounds.bottom + this.textPaint.ascent();
            }
        } else {
            this.collapsedDrawY = this.collapsedBounds.top;
        }
        n2 = n & 0x800007;
        this.collapsedDrawX = n2 != 1 ? (n2 != 5 ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.collapsedTextWidth) : (float)this.collapsedBounds.centerX() - this.collapsedTextWidth / 2.0f;
        this.calculateUsingTextSize(this.expandedTextSize, bl);
        charSequence = this.textLayout;
        float f4 = charSequence != null ? (float)charSequence.getHeight() : 0.0f;
        charSequence = this.textLayout;
        n2 = charSequence != null ? charSequence.getLineCount() : 0;
        this.expandedLineCount = n2;
        charSequence = this.textToDraw;
        f = charSequence != null ? this.textPaint.measureText(charSequence, 0, charSequence.length()) : 0.0f;
        charSequence = this.textLayout;
        float f5 = f;
        if (charSequence != null) {
            f5 = f;
            if (this.maxLines > 1) {
                f5 = charSequence.getWidth();
            }
        }
        charSequence = this.textLayout;
        f = f3;
        if (charSequence != null) {
            f = this.maxLines > 1 ? (float)charSequence.getLineStart(0) : charSequence.getLineLeft(0);
        }
        this.expandedFirstLineDrawX = f;
        n2 = GravityCompat.getAbsoluteGravity((int)this.expandedTextGravity, (int)(this.isRtl ? 1 : 0));
        n = n2 & 0x70;
        if (n != 48) {
            if (n != 80) {
                f = f4 / 2.0f;
                this.expandedDrawY = (float)this.expandedBounds.centerY() - f;
            } else {
                this.expandedDrawY = (float)this.expandedBounds.bottom - f4 + this.textPaint.descent();
            }
        } else {
            this.expandedDrawY = this.expandedBounds.top;
        }
        this.expandedDrawX = (n2 &= 0x800007) != 1 ? (n2 != 5 ? (float)this.expandedBounds.left : (float)this.expandedBounds.right - f5) : (float)this.expandedBounds.centerX() - f5 / 2.0f;
        this.clearTexture();
        this.setInterpolatedTextSize(f2);
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.expandedFraction);
    }

    private float calculateFadeModeTextAlpha(float f) {
        float f2 = this.fadeModeThresholdFraction;
        if (f <= f2) {
            return AnimationUtils.lerp(1.0f, 0.0f, this.fadeModeStartFraction, f2, f);
        }
        return AnimationUtils.lerp(0.0f, 1.0f, f2, 1.0f, f);
    }

    private float calculateFadeModeThresholdFraction() {
        float f = this.fadeModeStartFraction;
        return f + (1.0f - f) * 0.5f;
    }

    private boolean calculateIsRtl(CharSequence charSequence) {
        boolean bl;
        boolean bl2 = bl = this.isDefaultIsRtl();
        if (this.isRtlTextDirectionHeuristicsEnabled) {
            bl2 = this.isTextDirectionHeuristicsIsRtl(charSequence, bl);
        }
        return bl2;
    }

    private void calculateOffsets(float f) {
        float f2;
        this.interpolateBounds(f);
        if (this.fadeModeEnabled) {
            if (f < this.fadeModeThresholdFraction) {
                this.currentDrawX = this.expandedDrawX;
                this.currentDrawY = this.expandedDrawY;
                this.setInterpolatedTextSize(this.expandedTextSize);
                f2 = 0.0f;
            } else {
                this.currentDrawX = this.collapsedDrawX;
                this.currentDrawY = this.collapsedDrawY - (float)Math.max(0, this.currentOffsetY);
                this.setInterpolatedTextSize(this.collapsedTextSize);
                f2 = 1.0f;
            }
        } else {
            this.currentDrawX = CollapsingTextHelper.lerp(this.expandedDrawX, this.collapsedDrawX, f, this.positionInterpolator);
            this.currentDrawY = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, f, this.positionInterpolator);
            this.setInterpolatedTextSize(CollapsingTextHelper.lerp(this.expandedTextSize, this.collapsedTextSize, f, this.textSizeInterpolator));
            f2 = f;
        }
        this.setCollapsedTextBlend(1.0f - CollapsingTextHelper.lerp(0.0f, 1.0f, 1.0f - f, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        this.setExpandedTextBlend(CollapsingTextHelper.lerp(1.0f, 0.0f, f, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        if (this.collapsedTextColor != this.expandedTextColor) {
            this.textPaint.setColor(CollapsingTextHelper.blendColors(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), f2));
        } else {
            this.textPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            f2 = this.collapsedLetterSpacing;
            float f3 = this.expandedLetterSpacing;
            if (f2 != f3) {
                this.textPaint.setLetterSpacing(CollapsingTextHelper.lerp(f3, f2, f, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
            } else {
                this.textPaint.setLetterSpacing(f2);
            }
        }
        this.textPaint.setShadowLayer(CollapsingTextHelper.lerp(this.expandedShadowRadius, this.collapsedShadowRadius, f, null), CollapsingTextHelper.lerp(this.expandedShadowDx, this.collapsedShadowDx, f, null), CollapsingTextHelper.lerp(this.expandedShadowDy, this.collapsedShadowDy, f, null), CollapsingTextHelper.blendColors(this.getCurrentColor(this.expandedShadowColor), this.getCurrentColor(this.collapsedShadowColor), f));
        if (this.fadeModeEnabled) {
            int n = this.textPaint.getAlpha();
            n = (int)(this.calculateFadeModeTextAlpha(f) * (float)n);
            this.textPaint.setAlpha(n);
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private void calculateUsingTextSize(float f) {
        this.calculateUsingTextSize(f, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateUsingTextSize(float f, boolean bl) {
        int n;
        Typeface typeface;
        float f2;
        if (this.text == null) {
            return;
        }
        float f3 = this.collapsedBounds.width();
        float f4 = this.expandedBounds.width();
        boolean bl2 = CollapsingTextHelper.isClose(f, this.collapsedTextSize);
        boolean bl3 = false;
        int n2 = 1;
        if (bl2) {
            f2 = this.collapsedTextSize;
            this.scale = 1.0f;
            Typeface typeface2 = this.currentTypeface;
            typeface = this.collapsedTypeface;
            if (typeface2 != typeface) {
                this.currentTypeface = typeface;
                n = 1;
                f = f3;
            } else {
                n = 0;
                f = f3;
            }
        } else {
            f2 = this.expandedTextSize;
            typeface = this.currentTypeface;
            Typeface typeface3 = this.expandedTypeface;
            if (typeface != typeface3) {
                this.currentTypeface = typeface3;
                n = 1;
            } else {
                n = 0;
            }
            this.scale = CollapsingTextHelper.isClose(f, f2) ? 1.0f : f / this.expandedTextSize;
            f = this.collapsedTextSize / this.expandedTextSize;
            f = !bl && f4 * f > f3 ? Math.min(f3 / f, f4) : f4;
        }
        int n3 = n;
        if (f > 0.0f) {
            n = this.currentTextSize == f2 && !this.boundsChanged && n == 0 ? 0 : 1;
            this.currentTextSize = f2;
            this.boundsChanged = false;
            n3 = n;
        }
        if (this.textToDraw == null || n3 != 0) {
            this.textPaint.setTextSize(this.currentTextSize);
            this.textPaint.setTypeface(this.currentTypeface);
            typeface = this.textPaint;
            bl = bl3;
            if (this.scale != 1.0f) {
                bl = true;
            }
            typeface.setLinearText(bl);
            this.isRtl = this.calculateIsRtl(this.text);
            n = n2;
            if (this.shouldDrawMultiline()) {
                n = this.maxLines;
            }
            typeface = this.createStaticLayout(n, f, this.isRtl);
            this.textLayout = typeface;
            this.textToDraw = typeface.getText();
        }
    }

    private void clearTexture() {
        Bitmap bitmap = this.expandedTitleTexture;
        if (bitmap != null) {
            bitmap.recycle();
            this.expandedTitleTexture = null;
        }
    }

    private StaticLayout createStaticLayout(int n, float f, boolean bl) {
        StaticLayout staticLayout;
        try {
            staticLayout = StaticLayoutBuilderCompat.obtain(this.text, this.textPaint, (int)f).setEllipsize(TextUtils.TruncateAt.END).setIsRtl(bl).setAlignment(Layout.Alignment.ALIGN_NORMAL).setIncludePad(false).setMaxLines(n).setLineSpacing(this.lineSpacingAdd, this.lineSpacingMultiplier).setHyphenationFrequency(this.hyphenationFrequency).build();
        }
        catch (StaticLayoutBuilderCompat.StaticLayoutBuilderCompatException staticLayoutBuilderCompatException) {
            Log.e((String)TAG, (String)staticLayoutBuilderCompatException.getCause().getMessage(), (Throwable)staticLayoutBuilderCompatException);
            staticLayout = null;
        }
        return (StaticLayout)Preconditions.checkNotNull(staticLayout);
    }

    private void drawMultilineTransition(Canvas canvas, float f, float f2) {
        int n = this.textPaint.getAlpha();
        canvas.translate(f, f2);
        Object object = this.textPaint;
        f = this.expandedTextBlend;
        f2 = n;
        object.setAlpha((int)(f * f2));
        this.textLayout.draw(canvas);
        this.textPaint.setAlpha((int)(this.collapsedTextBlend * f2));
        int n2 = this.textLayout.getLineBaseline(0);
        object = this.textToDrawCollapsed;
        int n3 = object.length();
        f = n2;
        canvas.drawText((CharSequence)object, 0, n3, 0.0f, f, (Paint)this.textPaint);
        if (!this.fadeModeEnabled) {
            String string2 = this.textToDrawCollapsed.toString().trim();
            object = string2;
            if (string2.endsWith(ELLIPSIS_NORMAL)) {
                object = string2.substring(0, string2.length() - 1);
            }
            this.textPaint.setAlpha(n);
            canvas.drawText((String)object, 0, Math.min(this.textLayout.getLineEnd(0), ((String)object).length()), 0.0f, f, (Paint)this.textPaint);
        }
    }

    private void ensureExpandedTexture() {
        if (this.expandedTitleTexture == null && !this.expandedBounds.isEmpty() && !TextUtils.isEmpty((CharSequence)this.textToDraw)) {
            this.calculateOffsets(0.0f);
            int n = this.textLayout.getWidth();
            int n2 = this.textLayout.getHeight();
            if (n > 0 && n2 > 0) {
                this.expandedTitleTexture = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(this.expandedTitleTexture);
                this.textLayout.draw(canvas);
                if (this.texturePaint == null) {
                    this.texturePaint = new Paint(3);
                }
            }
        }
    }

    private float getCollapsedTextLeftBound(int n, int n2) {
        if (n2 != 17 && (n2 & 7) != 1) {
            if ((n2 & 0x800005) != 0x800005 && (n2 & 5) != 5) {
                float f = this.isRtl ? (float)this.collapsedBounds.right - this.collapsedTextWidth : (float)this.collapsedBounds.left;
                return f;
            }
            float f = this.isRtl ? (float)this.collapsedBounds.left : (float)this.collapsedBounds.right - this.collapsedTextWidth;
            return f;
        }
        return (float)n / 2.0f - this.collapsedTextWidth / 2.0f;
    }

    private float getCollapsedTextRightBound(RectF rectF, int n, int n2) {
        if (n2 != 17 && (n2 & 7) != 1) {
            if ((n2 & 0x800005) != 0x800005 && (n2 & 5) != 5) {
                float f = this.isRtl ? (float)this.collapsedBounds.right : rectF.left + this.collapsedTextWidth;
                return f;
            }
            float f = this.isRtl ? rectF.left + this.collapsedTextWidth : (float)this.collapsedBounds.right;
            return f;
        }
        return (float)n / 2.0f + this.collapsedTextWidth / 2.0f;
    }

    private int getCurrentColor(ColorStateList colorStateList) {
        if (colorStateList == null) {
            return 0;
        }
        int[] nArray = this.state;
        if (nArray != null) {
            return colorStateList.getColorForState(nArray, 0);
        }
        return colorStateList.getDefaultColor();
    }

    private int getCurrentExpandedTextColor() {
        return this.getCurrentColor(this.expandedTextColor);
    }

    private void getTextPaintCollapsed(TextPaint textPaint) {
        textPaint.setTextSize(this.collapsedTextSize);
        textPaint.setTypeface(this.collapsedTypeface);
        if (Build.VERSION.SDK_INT >= 21) {
            textPaint.setLetterSpacing(this.collapsedLetterSpacing);
        }
    }

    private void getTextPaintExpanded(TextPaint textPaint) {
        textPaint.setTextSize(this.expandedTextSize);
        textPaint.setTypeface(this.expandedTypeface);
        if (Build.VERSION.SDK_INT >= 21) {
            textPaint.setLetterSpacing(this.expandedLetterSpacing);
        }
    }

    private void interpolateBounds(float f) {
        if (this.fadeModeEnabled) {
            RectF rectF = this.currentBounds;
            Rect rect = f < this.fadeModeThresholdFraction ? this.expandedBounds : this.collapsedBounds;
            rectF.set(rect);
        } else {
            this.currentBounds.left = CollapsingTextHelper.lerp(this.expandedBounds.left, this.collapsedBounds.left, f, this.positionInterpolator);
            this.currentBounds.top = CollapsingTextHelper.lerp(this.expandedDrawY, this.collapsedDrawY, f, this.positionInterpolator);
            this.currentBounds.right = CollapsingTextHelper.lerp(this.expandedBounds.right, this.collapsedBounds.right, f, this.positionInterpolator);
            this.currentBounds.bottom = CollapsingTextHelper.lerp(this.expandedBounds.bottom, this.collapsedBounds.bottom, f, this.positionInterpolator);
        }
    }

    private static boolean isClose(float f, float f2) {
        boolean bl = Math.abs(f - f2) < 0.001f;
        return bl;
    }

    private boolean isDefaultIsRtl() {
        int n = ViewCompat.getLayoutDirection((View)this.view);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    private boolean isTextDirectionHeuristicsIsRtl(CharSequence charSequence, boolean bl) {
        TextDirectionHeuristicCompat textDirectionHeuristicCompat = bl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        return textDirectionHeuristicCompat.isRtl(charSequence, 0, charSequence.length());
    }

    private static float lerp(float f, float f2, float f3, TimeInterpolator timeInterpolator) {
        float f4 = f3;
        if (timeInterpolator != null) {
            f4 = timeInterpolator.getInterpolation(f3);
        }
        return AnimationUtils.lerp(f, f2, f4);
    }

    private static boolean rectEquals(Rect rect, int n, int n2, int n3, int n4) {
        boolean bl = rect.left == n && rect.top == n2 && rect.right == n3 && rect.bottom == n4;
        return bl;
    }

    private void setCollapsedTextBlend(float f) {
        this.collapsedTextBlend = f;
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private boolean setCollapsedTypefaceInternal(Typeface typeface) {
        CancelableFontCallback cancelableFontCallback = this.collapsedFontCallback;
        if (cancelableFontCallback != null) {
            cancelableFontCallback.cancel();
        }
        if (this.collapsedTypeface != typeface) {
            this.collapsedTypeface = typeface;
            return true;
        }
        return false;
    }

    private void setExpandedTextBlend(float f) {
        this.expandedTextBlend = f;
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private boolean setExpandedTypefaceInternal(Typeface typeface) {
        CancelableFontCallback cancelableFontCallback = this.expandedFontCallback;
        if (cancelableFontCallback != null) {
            cancelableFontCallback.cancel();
        }
        if (this.expandedTypeface != typeface) {
            this.expandedTypeface = typeface;
            return true;
        }
        return false;
    }

    private void setInterpolatedTextSize(float f) {
        this.calculateUsingTextSize(f);
        boolean bl = USE_SCALING_TEXTURE && this.scale != 1.0f;
        this.useTexture = bl;
        if (bl) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.view);
    }

    private boolean shouldDrawMultiline() {
        int n = this.maxLines;
        boolean bl = true;
        if (n <= 1 || this.isRtl && !this.fadeModeEnabled || this.useTexture) {
            bl = false;
        }
        return bl;
    }

    public void draw(Canvas canvas) {
        int n = canvas.save();
        if (this.textToDraw != null && this.drawTitle) {
            int n2 = this.maxLines;
            boolean bl = true;
            float f = n2 > 1 ? (float)this.textLayout.getLineStart(0) : this.textLayout.getLineLeft(0);
            float f2 = this.currentDrawX;
            float f3 = this.expandedFirstLineDrawX;
            this.textPaint.setTextSize(this.currentTextSize);
            float f4 = this.currentDrawX;
            float f5 = this.currentDrawY;
            if (!this.useTexture || this.expandedTitleTexture == null) {
                bl = false;
            }
            float f6 = this.scale;
            if (f6 != 1.0f && !this.fadeModeEnabled) {
                canvas.scale(f6, f6, f4, f5);
            }
            if (bl) {
                canvas.drawBitmap(this.expandedTitleTexture, f4, f5, this.texturePaint);
                canvas.restoreToCount(n);
                return;
            }
            if (this.shouldDrawMultiline() && (!this.fadeModeEnabled || this.expandedFraction > this.fadeModeThresholdFraction)) {
                this.drawMultilineTransition(canvas, f2 + f - f3 * 2.0f, f5);
            } else {
                canvas.translate(f4, f5);
                this.textLayout.draw(canvas);
            }
            canvas.restoreToCount(n);
        }
    }

    public void getCollapsedTextActualBounds(RectF rectF, int n, int n2) {
        this.isRtl = this.calculateIsRtl(this.text);
        rectF.left = this.getCollapsedTextLeftBound(n, n2);
        rectF.top = this.collapsedBounds.top;
        rectF.right = this.getCollapsedTextRightBound(rectF, n, n2);
        rectF.bottom = (float)this.collapsedBounds.top + this.getCollapsedTextHeight();
    }

    public ColorStateList getCollapsedTextColor() {
        return this.collapsedTextColor;
    }

    public int getCollapsedTextGravity() {
        return this.collapsedTextGravity;
    }

    public float getCollapsedTextHeight() {
        this.getTextPaintCollapsed(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public float getCollapsedTextSize() {
        return this.collapsedTextSize;
    }

    public Typeface getCollapsedTypeface() {
        Typeface typeface = this.collapsedTypeface;
        if (typeface == null) {
            typeface = Typeface.DEFAULT;
        }
        return typeface;
    }

    public int getCurrentCollapsedTextColor() {
        return this.getCurrentColor(this.collapsedTextColor);
    }

    public int getExpandedLineCount() {
        return this.expandedLineCount;
    }

    public ColorStateList getExpandedTextColor() {
        return this.expandedTextColor;
    }

    public float getExpandedTextFullHeight() {
        this.getTextPaintExpanded(this.tmpPaint);
        return -this.tmpPaint.ascent() + this.tmpPaint.descent();
    }

    public int getExpandedTextGravity() {
        return this.expandedTextGravity;
    }

    public float getExpandedTextHeight() {
        this.getTextPaintExpanded(this.tmpPaint);
        return -this.tmpPaint.ascent();
    }

    public float getExpandedTextSize() {
        return this.expandedTextSize;
    }

    public Typeface getExpandedTypeface() {
        Typeface typeface = this.expandedTypeface;
        if (typeface == null) {
            typeface = Typeface.DEFAULT;
        }
        return typeface;
    }

    public float getExpansionFraction() {
        return this.expandedFraction;
    }

    public float getFadeModeThresholdFraction() {
        return this.fadeModeThresholdFraction;
    }

    public int getHyphenationFrequency() {
        return this.hyphenationFrequency;
    }

    public int getLineCount() {
        StaticLayout staticLayout = this.textLayout;
        int n = staticLayout != null ? staticLayout.getLineCount() : 0;
        return n;
    }

    public float getLineSpacingAdd() {
        return this.textLayout.getSpacingAdd();
    }

    public float getLineSpacingMultiplier() {
        return this.textLayout.getSpacingMultiplier();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public TimeInterpolator getPositionInterpolator() {
        return this.positionInterpolator;
    }

    public CharSequence getText() {
        return this.text;
    }

    public boolean isRtlTextDirectionHeuristicsEnabled() {
        return this.isRtlTextDirectionHeuristicsEnabled;
    }

    public final boolean isStateful() {
        ColorStateList colorStateList = this.collapsedTextColor;
        boolean bl = colorStateList != null && colorStateList.isStateful() || (colorStateList = this.expandedTextColor) != null && colorStateList.isStateful();
        return bl;
    }

    void onBoundsChanged() {
        boolean bl = this.collapsedBounds.width() > 0 && this.collapsedBounds.height() > 0 && this.expandedBounds.width() > 0 && this.expandedBounds.height() > 0;
        this.drawTitle = bl;
    }

    public void recalculate() {
        this.recalculate(false);
    }

    public void recalculate(boolean bl) {
        if (this.view.getHeight() > 0 && this.view.getWidth() > 0 || bl) {
            this.calculateBaseOffsets(bl);
            this.calculateCurrentOffsets();
        }
    }

    public void setCollapsedBounds(int n, int n2, int n3, int n4) {
        if (!CollapsingTextHelper.rectEquals(this.collapsedBounds, n, n2, n3, n4)) {
            this.collapsedBounds.set(n, n2, n3, n4);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setCollapsedBounds(Rect rect) {
        this.setCollapsedBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setCollapsedTextAppearance(int n) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), n);
        if (textAppearance.getTextColor() != null) {
            this.collapsedTextColor = textAppearance.getTextColor();
        }
        if (textAppearance.getTextSize() != 0.0f) {
            this.collapsedTextSize = textAppearance.getTextSize();
        }
        if (textAppearance.shadowColor != null) {
            this.collapsedShadowColor = textAppearance.shadowColor;
        }
        this.collapsedShadowDx = textAppearance.shadowDx;
        this.collapsedShadowDy = textAppearance.shadowDy;
        this.collapsedShadowRadius = textAppearance.shadowRadius;
        this.collapsedLetterSpacing = textAppearance.letterSpacing;
        CancelableFontCallback cancelableFontCallback = this.collapsedFontCallback;
        if (cancelableFontCallback != null) {
            cancelableFontCallback.cancel();
        }
        this.collapsedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            @Override
            public void apply(Typeface typeface) {
                CollapsingTextHelper.this.setCollapsedTypeface(typeface);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), this.collapsedFontCallback);
        this.recalculate();
    }

    public void setCollapsedTextColor(ColorStateList colorStateList) {
        if (this.collapsedTextColor != colorStateList) {
            this.collapsedTextColor = colorStateList;
            this.recalculate();
        }
    }

    public void setCollapsedTextGravity(int n) {
        if (this.collapsedTextGravity != n) {
            this.collapsedTextGravity = n;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize(float f) {
        if (this.collapsedTextSize != f) {
            this.collapsedTextSize = f;
            this.recalculate();
        }
    }

    public void setCollapsedTypeface(Typeface typeface) {
        if (this.setCollapsedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setCurrentOffsetY(int n) {
        this.currentOffsetY = n;
    }

    public void setExpandedBounds(int n, int n2, int n3, int n4) {
        if (!CollapsingTextHelper.rectEquals(this.expandedBounds, n, n2, n3, n4)) {
            this.expandedBounds.set(n, n2, n3, n4);
            this.boundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setExpandedBounds(Rect rect) {
        this.setExpandedBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setExpandedTextAppearance(int n) {
        TextAppearance textAppearance = new TextAppearance(this.view.getContext(), n);
        if (textAppearance.getTextColor() != null) {
            this.expandedTextColor = textAppearance.getTextColor();
        }
        if (textAppearance.getTextSize() != 0.0f) {
            this.expandedTextSize = textAppearance.getTextSize();
        }
        if (textAppearance.shadowColor != null) {
            this.expandedShadowColor = textAppearance.shadowColor;
        }
        this.expandedShadowDx = textAppearance.shadowDx;
        this.expandedShadowDy = textAppearance.shadowDy;
        this.expandedShadowRadius = textAppearance.shadowRadius;
        this.expandedLetterSpacing = textAppearance.letterSpacing;
        CancelableFontCallback cancelableFontCallback = this.expandedFontCallback;
        if (cancelableFontCallback != null) {
            cancelableFontCallback.cancel();
        }
        this.expandedFontCallback = new CancelableFontCallback(new CancelableFontCallback.ApplyFont(){

            @Override
            public void apply(Typeface typeface) {
                CollapsingTextHelper.this.setExpandedTypeface(typeface);
            }
        }, textAppearance.getFallbackFont());
        textAppearance.getFontAsync(this.view.getContext(), this.expandedFontCallback);
        this.recalculate();
    }

    public void setExpandedTextColor(ColorStateList colorStateList) {
        if (this.expandedTextColor != colorStateList) {
            this.expandedTextColor = colorStateList;
            this.recalculate();
        }
    }

    public void setExpandedTextGravity(int n) {
        if (this.expandedTextGravity != n) {
            this.expandedTextGravity = n;
            this.recalculate();
        }
    }

    public void setExpandedTextSize(float f) {
        if (this.expandedTextSize != f) {
            this.expandedTextSize = f;
            this.recalculate();
        }
    }

    public void setExpandedTypeface(Typeface typeface) {
        if (this.setExpandedTypefaceInternal(typeface)) {
            this.recalculate();
        }
    }

    public void setExpansionFraction(float f) {
        if ((f = MathUtils.clamp((float)f, (float)0.0f, (float)1.0f)) != this.expandedFraction) {
            this.expandedFraction = f;
            this.calculateCurrentOffsets();
        }
    }

    public void setFadeModeEnabled(boolean bl) {
        this.fadeModeEnabled = bl;
    }

    public void setFadeModeStartFraction(float f) {
        this.fadeModeStartFraction = f;
        this.fadeModeThresholdFraction = this.calculateFadeModeThresholdFraction();
    }

    public void setHyphenationFrequency(int n) {
        this.hyphenationFrequency = n;
    }

    public void setLineSpacingAdd(float f) {
        this.lineSpacingAdd = f;
    }

    public void setLineSpacingMultiplier(float f) {
        this.lineSpacingMultiplier = f;
    }

    public void setMaxLines(int n) {
        if (n != this.maxLines) {
            this.maxLines = n;
            this.clearTexture();
            this.recalculate();
        }
    }

    public void setPositionInterpolator(TimeInterpolator timeInterpolator) {
        this.positionInterpolator = timeInterpolator;
        this.recalculate();
    }

    public void setRtlTextDirectionHeuristicsEnabled(boolean bl) {
        this.isRtlTextDirectionHeuristicsEnabled = bl;
    }

    public final boolean setState(int[] nArray) {
        this.state = nArray;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    public void setText(CharSequence charSequence) {
        if (charSequence == null || !TextUtils.equals((CharSequence)this.text, (CharSequence)charSequence)) {
            this.text = charSequence;
            this.textToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    public void setTextSizeInterpolator(TimeInterpolator timeInterpolator) {
        this.textSizeInterpolator = timeInterpolator;
        this.recalculate();
    }

    public void setTypefaces(Typeface typeface) {
        boolean bl = this.setCollapsedTypefaceInternal(typeface);
        boolean bl2 = this.setExpandedTypefaceInternal(typeface);
        if (bl || bl2) {
            this.recalculate();
        }
    }
}

