/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.view.menu.SubMenuBuilder;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import com.google.android.material.R;
import com.google.android.material.internal.NavigationMenuItemView;
import com.google.android.material.internal.NavigationMenuView;
import com.google.android.material.internal.ParcelableSparseArray;
import java.util.ArrayList;

public class NavigationMenuPresenter
implements MenuPresenter {
    public static final int NO_TEXT_APPEARANCE_SET = 0;
    private static final String STATE_ADAPTER = "android:menu:adapter";
    private static final String STATE_HEADER = "android:menu:header";
    private static final String STATE_HIERARCHY = "android:menu:list";
    NavigationMenuAdapter adapter;
    private MenuPresenter.Callback callback;
    int dividerInsetEnd;
    int dividerInsetStart;
    boolean hasCustomItemIconSize;
    LinearLayout headerLayout;
    ColorStateList iconTintList;
    private int id;
    boolean isBehindStatusBar = true;
    Drawable itemBackground;
    int itemHorizontalPadding;
    int itemIconPadding;
    int itemIconSize;
    private int itemMaxLines;
    int itemVerticalPadding;
    LayoutInflater layoutInflater;
    MenuBuilder menu;
    private NavigationMenuView menuView;
    final View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View object) {
            NavigationMenuItemView navigationMenuItemView = (NavigationMenuItemView)((Object)object);
            object = NavigationMenuPresenter.this;
            boolean bl = true;
            ((NavigationMenuPresenter)object).setUpdateSuspended(true);
            object = navigationMenuItemView.getItemData();
            boolean bl2 = NavigationMenuPresenter.this.menu.performItemAction((MenuItem)object, (MenuPresenter)NavigationMenuPresenter.this, 0);
            if (object != null && object.isCheckable() && bl2) {
                NavigationMenuPresenter.this.adapter.setCheckedItem((MenuItemImpl)object);
            } else {
                bl = false;
            }
            NavigationMenuPresenter.this.setUpdateSuspended(false);
            if (bl) {
                NavigationMenuPresenter.this.updateMenuView(false);
            }
        }
    };
    private int overScrollMode = -1;
    int paddingSeparator;
    private int paddingTopDefault;
    ColorStateList subheaderColor;
    int subheaderInsetEnd;
    int subheaderInsetStart;
    int subheaderTextAppearance = 0;
    int textAppearance = 0;
    ColorStateList textColor;

    private void updateTopPadding() {
        int n = this.headerLayout.getChildCount() == 0 && this.isBehindStatusBar ? this.paddingTopDefault : 0;
        NavigationMenuView navigationMenuView = this.menuView;
        navigationMenuView.setPadding(0, n, 0, navigationMenuView.getPaddingBottom());
    }

    public void addHeaderView(View object) {
        this.headerLayout.addView(object);
        object = this.menuView;
        object.setPadding(0, 0, 0, object.getPaddingBottom());
    }

    public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return false;
    }

    public void dispatchApplyWindowInsets(WindowInsetsCompat windowInsetsCompat) {
        int n = windowInsetsCompat.getSystemWindowInsetTop();
        if (this.paddingTopDefault != n) {
            this.paddingTopDefault = n;
            this.updateTopPadding();
        }
        NavigationMenuView navigationMenuView = this.menuView;
        navigationMenuView.setPadding(0, navigationMenuView.getPaddingTop(), 0, windowInsetsCompat.getSystemWindowInsetBottom());
        ViewCompat.dispatchApplyWindowInsets((View)this.headerLayout, (WindowInsetsCompat)windowInsetsCompat);
    }

    public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
        return false;
    }

    public boolean flagActionItems() {
        return false;
    }

    public MenuItemImpl getCheckedItem() {
        return this.adapter.getCheckedItem();
    }

    public int getDividerInsetEnd() {
        return this.dividerInsetEnd;
    }

    public int getDividerInsetStart() {
        return this.dividerInsetStart;
    }

    public int getHeaderCount() {
        return this.headerLayout.getChildCount();
    }

    public View getHeaderView(int n) {
        return this.headerLayout.getChildAt(n);
    }

    public int getId() {
        return this.id;
    }

    public Drawable getItemBackground() {
        return this.itemBackground;
    }

    public int getItemHorizontalPadding() {
        return this.itemHorizontalPadding;
    }

    public int getItemIconPadding() {
        return this.itemIconPadding;
    }

    public int getItemMaxLines() {
        return this.itemMaxLines;
    }

    public ColorStateList getItemTextColor() {
        return this.textColor;
    }

    public ColorStateList getItemTintList() {
        return this.iconTintList;
    }

    public int getItemVerticalPadding() {
        return this.itemVerticalPadding;
    }

    public MenuView getMenuView(ViewGroup object) {
        if (this.menuView == null) {
            int n;
            object = (NavigationMenuView)this.layoutInflater.inflate(R.layout.design_navigation_menu, object, false);
            this.menuView = object;
            object.setAccessibilityDelegateCompat((RecyclerViewAccessibilityDelegate)new NavigationMenuViewAccessibilityDelegate(this.menuView));
            if (this.adapter == null) {
                this.adapter = new NavigationMenuAdapter();
            }
            if ((n = this.overScrollMode) != -1) {
                this.menuView.setOverScrollMode(n);
            }
            this.headerLayout = (LinearLayout)this.layoutInflater.inflate(R.layout.design_navigation_item_header, (ViewGroup)this.menuView, false);
            this.menuView.setAdapter(this.adapter);
        }
        return this.menuView;
    }

    public int getSubheaderInsetEnd() {
        return this.subheaderInsetEnd;
    }

    public int getSubheaderInsetStart() {
        return this.subheaderInsetStart;
    }

    public View inflateHeaderView(int n) {
        View view = this.layoutInflater.inflate(n, (ViewGroup)this.headerLayout, false);
        this.addHeaderView(view);
        return view;
    }

    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.menu = menuBuilder;
        this.paddingSeparator = context.getResources().getDimensionPixelOffset(R.dimen.design_navigation_separator_vertical_padding);
    }

    public boolean isBehindStatusBar() {
        return this.isBehindStatusBar;
    }

    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        MenuPresenter.Callback callback = this.callback;
        if (callback != null) {
            callback.onCloseMenu(menuBuilder, bl);
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            SparseArray sparseArray = (parcelable = (Bundle)parcelable).getSparseParcelableArray(STATE_HIERARCHY);
            if (sparseArray != null) {
                this.menuView.restoreHierarchyState(sparseArray);
            }
            if ((sparseArray = parcelable.getBundle(STATE_ADAPTER)) != null) {
                this.adapter.restoreInstanceState((Bundle)sparseArray);
            }
            if ((parcelable = parcelable.getSparseParcelableArray(STATE_HEADER)) != null) {
                this.headerLayout.restoreHierarchyState((SparseArray)parcelable);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        NavigationMenuAdapter navigationMenuAdapter;
        Bundle bundle = new Bundle();
        if (this.menuView != null) {
            navigationMenuAdapter = new SparseArray();
            this.menuView.saveHierarchyState((SparseArray)navigationMenuAdapter);
            bundle.putSparseParcelableArray(STATE_HIERARCHY, (SparseArray)navigationMenuAdapter);
        }
        if ((navigationMenuAdapter = this.adapter) != null) {
            bundle.putBundle(STATE_ADAPTER, navigationMenuAdapter.createInstanceState());
        }
        if (this.headerLayout != null) {
            navigationMenuAdapter = new SparseArray();
            this.headerLayout.saveHierarchyState((SparseArray)navigationMenuAdapter);
            bundle.putSparseParcelableArray(STATE_HEADER, (SparseArray)navigationMenuAdapter);
        }
        return bundle;
    }

    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        return false;
    }

    public void removeHeaderView(View object) {
        this.headerLayout.removeView(object);
        if (this.headerLayout.getChildCount() == 0) {
            object = this.menuView;
            object.setPadding(0, this.paddingTopDefault, 0, object.getPaddingBottom());
        }
    }

    public void setBehindStatusBar(boolean bl) {
        if (this.isBehindStatusBar != bl) {
            this.isBehindStatusBar = bl;
            this.updateTopPadding();
        }
    }

    public void setCallback(MenuPresenter.Callback callback) {
        this.callback = callback;
    }

    public void setCheckedItem(MenuItemImpl menuItemImpl) {
        this.adapter.setCheckedItem(menuItemImpl);
    }

    public void setDividerInsetEnd(int n) {
        this.dividerInsetEnd = n;
        this.updateMenuView(false);
    }

    public void setDividerInsetStart(int n) {
        this.dividerInsetStart = n;
        this.updateMenuView(false);
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setItemBackground(Drawable drawable2) {
        this.itemBackground = drawable2;
        this.updateMenuView(false);
    }

    public void setItemHorizontalPadding(int n) {
        this.itemHorizontalPadding = n;
        this.updateMenuView(false);
    }

    public void setItemIconPadding(int n) {
        this.itemIconPadding = n;
        this.updateMenuView(false);
    }

    public void setItemIconSize(int n) {
        if (this.itemIconSize != n) {
            this.itemIconSize = n;
            this.hasCustomItemIconSize = true;
            this.updateMenuView(false);
        }
    }

    public void setItemIconTintList(ColorStateList colorStateList) {
        this.iconTintList = colorStateList;
        this.updateMenuView(false);
    }

    public void setItemMaxLines(int n) {
        this.itemMaxLines = n;
        this.updateMenuView(false);
    }

    public void setItemTextAppearance(int n) {
        this.textAppearance = n;
        this.updateMenuView(false);
    }

    public void setItemTextColor(ColorStateList colorStateList) {
        this.textColor = colorStateList;
        this.updateMenuView(false);
    }

    public void setItemVerticalPadding(int n) {
        this.itemVerticalPadding = n;
        this.updateMenuView(false);
    }

    public void setOverScrollMode(int n) {
        this.overScrollMode = n;
        NavigationMenuView navigationMenuView = this.menuView;
        if (navigationMenuView != null) {
            navigationMenuView.setOverScrollMode(n);
        }
    }

    public void setSubheaderColor(ColorStateList colorStateList) {
        this.subheaderColor = colorStateList;
        this.updateMenuView(false);
    }

    public void setSubheaderInsetEnd(int n) {
        this.subheaderInsetEnd = n;
        this.updateMenuView(false);
    }

    public void setSubheaderInsetStart(int n) {
        this.subheaderInsetStart = n;
        this.updateMenuView(false);
    }

    public void setSubheaderTextAppearance(int n) {
        this.subheaderTextAppearance = n;
        this.updateMenuView(false);
    }

    public void setUpdateSuspended(boolean bl) {
        NavigationMenuAdapter navigationMenuAdapter = this.adapter;
        if (navigationMenuAdapter != null) {
            navigationMenuAdapter.setUpdateSuspended(bl);
        }
    }

    public void updateMenuView(boolean bl) {
        NavigationMenuAdapter navigationMenuAdapter = this.adapter;
        if (navigationMenuAdapter != null) {
            navigationMenuAdapter.update();
        }
    }

    private static class HeaderViewHolder
    extends ViewHolder {
        public HeaderViewHolder(View view) {
            super(view);
        }
    }

    private class NavigationMenuAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final String STATE_ACTION_VIEWS = "android:menu:action_views";
        private static final String STATE_CHECKED_ITEM = "android:menu:checked";
        private static final int VIEW_TYPE_HEADER = 3;
        private static final int VIEW_TYPE_NORMAL = 0;
        private static final int VIEW_TYPE_SEPARATOR = 2;
        private static final int VIEW_TYPE_SUBHEADER = 1;
        private MenuItemImpl checkedItem;
        private final ArrayList<NavigationMenuItem> items = new ArrayList();
        private boolean updateSuspended;

        NavigationMenuAdapter() {
            this.prepareMenuItems();
        }

        private void appendTransparentIconIfMissing(int n, int n2) {
            while (n < n2) {
                ((NavigationMenuTextItem)this.items.get((int)n)).needsEmptyIcon = true;
                ++n;
            }
        }

        private void prepareMenuItems() {
            if (this.updateSuspended) {
                return;
            }
            this.updateSuspended = true;
            this.items.clear();
            this.items.add(new NavigationMenuHeaderItem());
            int n = -1;
            int n2 = NavigationMenuPresenter.this.menu.getVisibleItems().size();
            boolean bl = false;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4;
                int n5;
                boolean bl2;
                int n6;
                Object object = (MenuItemImpl)NavigationMenuPresenter.this.menu.getVisibleItems().get(i);
                if (object.isChecked()) {
                    this.setCheckedItem((MenuItemImpl)object);
                }
                if (object.isCheckable()) {
                    object.setExclusiveCheckable(false);
                }
                if (object.hasSubMenu()) {
                    SubMenu subMenu = object.getSubMenu();
                    n6 = n;
                    bl2 = bl;
                    n5 = n3;
                    if (subMenu.hasVisibleItems()) {
                        if (i != 0) {
                            this.items.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.paddingSeparator, 0));
                        }
                        this.items.add(new NavigationMenuTextItem((MenuItemImpl)object));
                        int n7 = this.items.size();
                        int n8 = subMenu.size();
                        n4 = 0;
                        for (n6 = 0; n6 < n8; ++n6) {
                            MenuItemImpl menuItemImpl = (MenuItemImpl)subMenu.getItem(n6);
                            n5 = n4;
                            if (menuItemImpl.isVisible()) {
                                n5 = n4;
                                if (n4 == 0) {
                                    n5 = n4;
                                    if (menuItemImpl.getIcon() != null) {
                                        n5 = 1;
                                    }
                                }
                                if (menuItemImpl.isCheckable()) {
                                    menuItemImpl.setExclusiveCheckable(false);
                                }
                                if (object.isChecked()) {
                                    this.setCheckedItem((MenuItemImpl)object);
                                }
                                this.items.add(new NavigationMenuTextItem(menuItemImpl));
                            }
                            n4 = n5;
                        }
                        n6 = n;
                        bl2 = bl;
                        n5 = n3;
                        if (n4 != 0) {
                            this.appendTransparentIconIfMissing(n7, this.items.size());
                            n6 = n;
                            bl2 = bl;
                            n5 = n3;
                        }
                    }
                } else {
                    n6 = object.getGroupId();
                    if (n6 != n) {
                        n3 = this.items.size();
                        bl = object.getIcon() != null;
                        bl2 = bl;
                        n4 = n3;
                        if (i != 0) {
                            n4 = n3 + 1;
                            this.items.add(new NavigationMenuSeparatorItem(NavigationMenuPresenter.this.paddingSeparator, NavigationMenuPresenter.this.paddingSeparator));
                            bl2 = bl;
                        }
                    } else {
                        bl2 = bl;
                        n4 = n3;
                        if (!bl) {
                            bl2 = bl;
                            n4 = n3;
                            if (object.getIcon() != null) {
                                this.appendTransparentIconIfMissing(n3, this.items.size());
                                bl2 = true;
                                n4 = n3;
                            }
                        }
                    }
                    object = new NavigationMenuTextItem((MenuItemImpl)object);
                    object.needsEmptyIcon = bl2;
                    this.items.add((NavigationMenuItem)object);
                    n5 = n4;
                }
                n = n6;
                bl = bl2;
                n3 = n5;
            }
            this.updateSuspended = false;
        }

        public Bundle createInstanceState() {
            Bundle bundle = new Bundle();
            Object object = this.checkedItem;
            if (object != null) {
                bundle.putInt(STATE_CHECKED_ITEM, object.getItemId());
            }
            SparseArray sparseArray = new SparseArray();
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                MenuItemImpl menuItemImpl;
                object = this.items.get(i);
                if (!(object instanceof NavigationMenuTextItem) || (object = (menuItemImpl = ((NavigationMenuTextItem)object).getMenuItem()) != null ? menuItemImpl.getActionView() : null) == null) continue;
                ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
                object.saveHierarchyState((SparseArray)parcelableSparseArray);
                sparseArray.put(menuItemImpl.getItemId(), (Object)parcelableSparseArray);
            }
            bundle.putSparseParcelableArray(STATE_ACTION_VIEWS, sparseArray);
            return bundle;
        }

        public MenuItemImpl getCheckedItem() {
            return this.checkedItem;
        }

        public int getItemCount() {
            return this.items.size();
        }

        public long getItemId(int n) {
            return n;
        }

        public int getItemViewType(int n) {
            NavigationMenuItem navigationMenuItem = this.items.get(n);
            if (navigationMenuItem instanceof NavigationMenuSeparatorItem) {
                return 2;
            }
            if (navigationMenuItem instanceof NavigationMenuHeaderItem) {
                return 3;
            }
            if (navigationMenuItem instanceof NavigationMenuTextItem) {
                if (((NavigationMenuTextItem)navigationMenuItem).getMenuItem().hasSubMenu()) {
                    return 1;
                }
                return 0;
            }
            throw new RuntimeException("Unknown item type.");
        }

        int getRowCount() {
            int n = NavigationMenuPresenter.this.headerLayout.getChildCount();
            n = n == 0 ? 0 : 1;
            for (int i = 0; i < NavigationMenuPresenter.this.adapter.getItemCount(); ++i) {
                int n2 = n;
                if (NavigationMenuPresenter.this.adapter.getItemViewType(i) == 0) {
                    n2 = n + 1;
                }
                n = n2;
            }
            return n;
        }

        public void onBindViewHolder(ViewHolder object, int n) {
            int n2 = this.getItemViewType(n);
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        NavigationMenuSeparatorItem navigationMenuSeparatorItem = (NavigationMenuSeparatorItem)this.items.get(n);
                        ((ViewHolder)((Object)object)).itemView.setPadding(NavigationMenuPresenter.this.dividerInsetStart, navigationMenuSeparatorItem.getPaddingTop(), NavigationMenuPresenter.this.dividerInsetEnd, navigationMenuSeparatorItem.getPaddingBottom());
                    }
                } else {
                    object = (TextView)((ViewHolder)((Object)object)).itemView;
                    object.setText(((NavigationMenuTextItem)this.items.get(n)).getMenuItem().getTitle());
                    if (NavigationMenuPresenter.this.subheaderTextAppearance != 0) {
                        TextViewCompat.setTextAppearance((TextView)object, (int)NavigationMenuPresenter.this.subheaderTextAppearance);
                    }
                    object.setPadding(NavigationMenuPresenter.this.subheaderInsetStart, object.getPaddingTop(), NavigationMenuPresenter.this.subheaderInsetEnd, object.getPaddingBottom());
                    if (NavigationMenuPresenter.this.subheaderColor != null) {
                        object.setTextColor(NavigationMenuPresenter.this.subheaderColor);
                    }
                }
            } else {
                NavigationMenuItemView navigationMenuItemView = (NavigationMenuItemView)((ViewHolder)((Object)object)).itemView;
                navigationMenuItemView.setIconTintList(NavigationMenuPresenter.this.iconTintList);
                if (NavigationMenuPresenter.this.textAppearance != 0) {
                    navigationMenuItemView.setTextAppearance(NavigationMenuPresenter.this.textAppearance);
                }
                if (NavigationMenuPresenter.this.textColor != null) {
                    navigationMenuItemView.setTextColor(NavigationMenuPresenter.this.textColor);
                }
                object = NavigationMenuPresenter.this.itemBackground != null ? NavigationMenuPresenter.this.itemBackground.getConstantState().newDrawable() : null;
                ViewCompat.setBackground((View)navigationMenuItemView, (Drawable)object);
                object = (NavigationMenuTextItem)this.items.get(n);
                navigationMenuItemView.setNeedsEmptyIcon(((NavigationMenuTextItem)object).needsEmptyIcon);
                navigationMenuItemView.setPadding(NavigationMenuPresenter.this.itemHorizontalPadding, NavigationMenuPresenter.this.itemVerticalPadding, NavigationMenuPresenter.this.itemHorizontalPadding, NavigationMenuPresenter.this.itemVerticalPadding);
                navigationMenuItemView.setIconPadding(NavigationMenuPresenter.this.itemIconPadding);
                if (NavigationMenuPresenter.this.hasCustomItemIconSize) {
                    navigationMenuItemView.setIconSize(NavigationMenuPresenter.this.itemIconSize);
                }
                navigationMenuItemView.setMaxLines(NavigationMenuPresenter.this.itemMaxLines);
                navigationMenuItemView.initialize(((NavigationMenuTextItem)object).getMenuItem(), 0);
            }
        }

        public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) {
                            return null;
                        }
                        return new HeaderViewHolder((View)NavigationMenuPresenter.this.headerLayout);
                    }
                    return new SeparatorViewHolder(NavigationMenuPresenter.this.layoutInflater, viewGroup);
                }
                return new SubheaderViewHolder(NavigationMenuPresenter.this.layoutInflater, viewGroup);
            }
            return new NormalViewHolder(NavigationMenuPresenter.this.layoutInflater, viewGroup, NavigationMenuPresenter.this.onClickListener);
        }

        public void onViewRecycled(ViewHolder viewHolder) {
            if (viewHolder instanceof NormalViewHolder) {
                ((NavigationMenuItemView)viewHolder.itemView).recycle();
            }
        }

        public void restoreInstanceState(Bundle bundle) {
            NavigationMenuItem navigationMenuItem;
            int n;
            int n2;
            int n3 = 0;
            int n4 = bundle.getInt(STATE_CHECKED_ITEM, 0);
            if (n4 != 0) {
                this.updateSuspended = true;
                n2 = this.items.size();
                for (n = 0; n < n2; ++n) {
                    navigationMenuItem = this.items.get(n);
                    if (!(navigationMenuItem instanceof NavigationMenuTextItem) || (navigationMenuItem = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem()) == null || navigationMenuItem.getItemId() != n4) continue;
                    this.setCheckedItem((MenuItemImpl)navigationMenuItem);
                    break;
                }
                this.updateSuspended = false;
                this.prepareMenuItems();
            }
            if ((bundle = bundle.getSparseParcelableArray(STATE_ACTION_VIEWS)) != null) {
                n2 = this.items.size();
                for (n = n3; n < n2; ++n) {
                    Object object;
                    navigationMenuItem = this.items.get(n);
                    if (!(navigationMenuItem instanceof NavigationMenuTextItem) || (object = ((NavigationMenuTextItem)navigationMenuItem).getMenuItem()) == null || (navigationMenuItem = object.getActionView()) == null || (object = (ParcelableSparseArray)((Object)bundle.get(object.getItemId()))) == null) continue;
                    navigationMenuItem.restoreHierarchyState((SparseArray)object);
                }
            }
        }

        public void setCheckedItem(MenuItemImpl menuItemImpl) {
            if (this.checkedItem != menuItemImpl && menuItemImpl.isCheckable()) {
                MenuItemImpl menuItemImpl2 = this.checkedItem;
                if (menuItemImpl2 != null) {
                    menuItemImpl2.setChecked(false);
                }
                this.checkedItem = menuItemImpl;
                menuItemImpl.setChecked(true);
            }
        }

        public void setUpdateSuspended(boolean bl) {
            this.updateSuspended = bl;
        }

        public void update() {
            this.prepareMenuItems();
            this.notifyDataSetChanged();
        }
    }

    private static class NavigationMenuHeaderItem
    implements NavigationMenuItem {
        NavigationMenuHeaderItem() {
        }
    }

    private static interface NavigationMenuItem {
    }

    private static class NavigationMenuSeparatorItem
    implements NavigationMenuItem {
        private final int paddingBottom;
        private final int paddingTop;

        public NavigationMenuSeparatorItem(int n, int n2) {
            this.paddingTop = n;
            this.paddingBottom = n2;
        }

        public int getPaddingBottom() {
            return this.paddingBottom;
        }

        public int getPaddingTop() {
            return this.paddingTop;
        }
    }

    private static class NavigationMenuTextItem
    implements NavigationMenuItem {
        private final MenuItemImpl menuItem;
        boolean needsEmptyIcon;

        NavigationMenuTextItem(MenuItemImpl menuItemImpl) {
            this.menuItem = menuItemImpl;
        }

        public MenuItemImpl getMenuItem() {
            return this.menuItem;
        }
    }

    private class NavigationMenuViewAccessibilityDelegate
    extends RecyclerViewAccessibilityDelegate {
        NavigationMenuViewAccessibilityDelegate(RecyclerView recyclerView) {
            super(recyclerView);
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)NavigationMenuPresenter.this.adapter.getRowCount(), (int)0, (boolean)false));
        }
    }

    private static class NormalViewHolder
    extends ViewHolder {
        public NormalViewHolder(LayoutInflater layoutInflater, ViewGroup viewGroup, View.OnClickListener onClickListener) {
            super(layoutInflater.inflate(R.layout.design_navigation_item, viewGroup, false));
            this.itemView.setOnClickListener(onClickListener);
        }
    }

    private static class SeparatorViewHolder
    extends ViewHolder {
        public SeparatorViewHolder(LayoutInflater layoutInflater, ViewGroup viewGroup) {
            super(layoutInflater.inflate(R.layout.design_navigation_item_separator, viewGroup, false));
        }
    }

    private static class SubheaderViewHolder
    extends ViewHolder {
        public SubheaderViewHolder(LayoutInflater layoutInflater, ViewGroup viewGroup) {
            super(layoutInflater.inflate(R.layout.design_navigation_item_subheader, viewGroup, false));
        }
    }

    private static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View view) {
            super(view);
        }
    }
}

