/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.core.view.ViewCompat;
import com.google.android.material.internal.ViewGroupOverlayApi14;
import com.google.android.material.internal.ViewOverlayImpl;
import com.google.android.material.internal.ViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class ViewOverlayApi14
implements ViewOverlayImpl {
    protected OverlayViewGroup overlayViewGroup;

    ViewOverlayApi14(Context context, ViewGroup viewGroup, View view) {
        this.overlayViewGroup = new OverlayViewGroup(context, viewGroup, view, this);
    }

    static ViewOverlayApi14 createFrom(View view) {
        ViewGroup viewGroup = ViewUtils.getContentView(view);
        if (viewGroup != null) {
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = viewGroup.getChildAt(i);
                if (!(view2 instanceof OverlayViewGroup)) continue;
                return ((OverlayViewGroup)view2).viewOverlay;
            }
            return new ViewGroupOverlayApi14(viewGroup.getContext(), viewGroup, view);
        }
        return null;
    }

    @Override
    public void add(Drawable drawable2) {
        this.overlayViewGroup.add(drawable2);
    }

    @Override
    public void remove(Drawable drawable2) {
        this.overlayViewGroup.remove(drawable2);
    }

    static class OverlayViewGroup
    extends ViewGroup {
        static Method invalidateChildInParentFastMethod;
        private boolean disposed;
        ArrayList<Drawable> drawables = null;
        ViewGroup hostView;
        View requestingView;
        ViewOverlayApi14 viewOverlay;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static {
            try {
                invalidateChildInParentFastMethod = ViewGroup.class.getDeclaredMethod("invalidateChildInParentFast", Integer.TYPE, Integer.TYPE, Rect.class);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }

        OverlayViewGroup(Context context, ViewGroup viewGroup, View view, ViewOverlayApi14 viewOverlayApi14) {
            super(context);
            this.hostView = viewGroup;
            this.requestingView = view;
            this.setRight(viewGroup.getWidth());
            this.setBottom(viewGroup.getHeight());
            viewGroup.addView((View)this);
            this.viewOverlay = viewOverlayApi14;
        }

        private void assertNotDisposed() {
            if (!this.disposed) {
                return;
            }
            throw new IllegalStateException("This overlay was disposed already. Please use a new one via ViewGroupUtils.getOverlay()");
        }

        private void disposeIfEmpty() {
            ArrayList<Drawable> arrayList;
            if (this.getChildCount() == 0 && ((arrayList = this.drawables) == null || arrayList.size() == 0)) {
                this.disposed = true;
                this.hostView.removeView((View)this);
            }
        }

        private void getOffset(int[] nArray) {
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[2];
            this.hostView.getLocationOnScreen(nArray2);
            this.requestingView.getLocationOnScreen(nArray3);
            nArray[0] = nArray3[0] - nArray2[0];
            nArray[1] = nArray3[1] - nArray2[1];
        }

        public void add(Drawable drawable2) {
            this.assertNotDisposed();
            if (this.drawables == null) {
                this.drawables = new ArrayList();
            }
            if (!this.drawables.contains(drawable2)) {
                this.drawables.add(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback((Drawable.Callback)this);
            }
        }

        public void add(View view) {
            this.assertNotDisposed();
            if (view.getParent() instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view.getParent();
                if (viewGroup != this.hostView && viewGroup.getParent() != null && ViewCompat.isAttachedToWindow((View)viewGroup)) {
                    int[] nArray = new int[2];
                    int[] nArray2 = new int[2];
                    viewGroup.getLocationOnScreen(nArray);
                    this.hostView.getLocationOnScreen(nArray2);
                    ViewCompat.offsetLeftAndRight((View)view, (int)(nArray[0] - nArray2[0]));
                    ViewCompat.offsetTopAndBottom((View)view, (int)(nArray[1] - nArray2[1]));
                }
                viewGroup.removeView(view);
                if (view.getParent() != null) {
                    viewGroup.removeView(view);
                }
            }
            super.addView(view);
        }

        protected void dispatchDraw(Canvas canvas) {
            Object object = new int[2];
            int[] nArray = new int[2];
            this.hostView.getLocationOnScreen((int[])object);
            this.requestingView.getLocationOnScreen(nArray);
            canvas.translate((float)(nArray[0] - object[0]), (float)(nArray[1] - object[1]));
            canvas.clipRect(new Rect(0, 0, this.requestingView.getWidth(), this.requestingView.getHeight()));
            super.dispatchDraw(canvas);
            object = this.drawables;
            int n = object == null ? 0 : ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                this.drawables.get(i).draw(canvas);
            }
        }

        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            return false;
        }

        public ViewParent invalidateChildInParent(int[] nArray, Rect rect) {
            if (this.hostView != null) {
                rect.offset(nArray[0], nArray[1]);
                if (this.hostView != null) {
                    nArray[0] = 0;
                    nArray[1] = 0;
                    int[] nArray2 = new int[2];
                    this.getOffset(nArray2);
                    rect.offset(nArray2[0], nArray2[1]);
                    return super.invalidateChildInParent(nArray, rect);
                }
                this.invalidate(rect);
            }
            return null;
        }

        protected ViewParent invalidateChildInParentFast(int n, int n2, Rect rect) {
            if (this.hostView != null && invalidateChildInParentFastMethod != null) {
                try {
                    this.getOffset(new int[2]);
                    invalidateChildInParentFastMethod.invoke((Object)this.hostView, n, n2, rect);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            return null;
        }

        public void invalidateDrawable(Drawable drawable2) {
            this.invalidate(drawable2.getBounds());
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        }

        public void remove(Drawable drawable2) {
            ArrayList<Drawable> arrayList = this.drawables;
            if (arrayList != null) {
                arrayList.remove(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(null);
                this.disposeIfEmpty();
            }
        }

        public void remove(View view) {
            super.removeView(view);
            this.disposeIfEmpty();
        }

        protected boolean verifyDrawable(Drawable drawable2) {
            ArrayList<Drawable> arrayList;
            boolean bl = super.verifyDrawable(drawable2) || (arrayList = this.drawables) != null && arrayList.contains(drawable2);
            return bl;
        }
    }
}

