/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.view.MenuItem;
import android.view.SubMenu;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;

public final class NavigationBarMenu
extends MenuBuilder {
    private final int maxItemCount;
    private final Class<?> viewClass;

    public NavigationBarMenu(Context context, Class<?> clazz, int n) {
        super(context);
        this.viewClass = clazz;
        this.maxItemCount = n;
    }

    protected MenuItem addInternal(int n, int n2, int n3, CharSequence charSequence) {
        if (this.size() + 1 <= this.maxItemCount) {
            this.stopDispatchingItemsChanged();
            charSequence = super.addInternal(n, n2, n3, charSequence);
            if (charSequence instanceof MenuItemImpl) {
                ((MenuItemImpl)charSequence).setExclusiveCheckable(true);
            }
            this.startDispatchingItemsChanged();
            return charSequence;
        }
        charSequence = this.viewClass.getSimpleName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Maximum number of items supported by ");
        stringBuilder.append((String)charSequence);
        stringBuilder.append(" is ");
        stringBuilder.append(this.maxItemCount);
        stringBuilder.append(". Limit can be checked with ");
        stringBuilder.append((String)charSequence);
        stringBuilder.append("#getMaxItemCount()");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(this.viewClass.getSimpleName());
        ((StringBuilder)charSequence).append(" does not support submenus");
        throw new UnsupportedOperationException(((StringBuilder)charSequence).toString());
    }

    public int getMaxItemCount() {
        return this.maxItemCount;
    }
}

