/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.core.util.Pools;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.internal.TextScale;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarPresenter;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.util.HashSet;

public abstract class NavigationBarMenuView
extends ViewGroup
implements MenuView {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private static final int ITEM_POOL_SIZE = 5;
    private static final int NO_PADDING = -1;
    private SparseArray<BadgeDrawable> badgeDrawables;
    private NavigationBarItemView[] buttons;
    private ColorStateList itemActiveIndicatorColor;
    private boolean itemActiveIndicatorEnabled;
    private int itemActiveIndicatorHeight;
    private int itemActiveIndicatorMarginHorizontal;
    private boolean itemActiveIndicatorResizeable = false;
    private ShapeAppearanceModel itemActiveIndicatorShapeAppearance;
    private int itemActiveIndicatorWidth;
    private Drawable itemBackground;
    private int itemBackgroundRes;
    private int itemIconSize;
    private ColorStateList itemIconTint;
    private int itemPaddingBottom = -1;
    private int itemPaddingTop = -1;
    private final Pools.Pool<NavigationBarItemView> itemPool = new Pools.SynchronizedPool(5);
    private int itemTextAppearanceActive;
    private int itemTextAppearanceInactive;
    private final ColorStateList itemTextColorDefault;
    private ColorStateList itemTextColorFromUser;
    private int labelVisibilityMode;
    private MenuBuilder menu;
    private final View.OnClickListener onClickListener;
    private final SparseArray<View.OnTouchListener> onTouchListeners = new SparseArray(5);
    private NavigationBarPresenter presenter;
    private int selectedItemId = 0;
    private int selectedItemPosition = 0;
    private final TransitionSet set;

    public NavigationBarMenuView(Context context) {
        super(context);
        this.badgeDrawables = new SparseArray(5);
        this.itemTextColorDefault = this.createDefaultColorStateList(16842808);
        context = new AutoTransition();
        this.set = context;
        context.setOrdering(0);
        context.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationLong1, this.getResources().getInteger(R.integer.material_motion_duration_long_1)));
        context.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingStandard, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        context.addTransition((Transition)new TextScale());
        this.onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                view = ((NavigationBarItemView)view).getItemData();
                if (!NavigationBarMenuView.this.menu.performItemAction((MenuItem)view, (MenuPresenter)NavigationBarMenuView.this.presenter, 0)) {
                    view.setChecked(true);
                }
            }
        };
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
    }

    private Drawable createItemActiveIndicatorDrawable() {
        if (this.itemActiveIndicatorShapeAppearance != null && this.itemActiveIndicatorColor != null) {
            MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(this.itemActiveIndicatorShapeAppearance);
            materialShapeDrawable.setFillColor(this.itemActiveIndicatorColor);
            return materialShapeDrawable;
        }
        return null;
    }

    private NavigationBarItemView getNewItem() {
        NavigationBarItemView navigationBarItemView;
        NavigationBarItemView navigationBarItemView2 = navigationBarItemView = (NavigationBarItemView)((Object)this.itemPool.acquire());
        if (navigationBarItemView == null) {
            navigationBarItemView2 = this.createNavigationBarItemView(this.getContext());
        }
        return navigationBarItemView2;
    }

    private boolean isValidId(int n) {
        boolean bl = n != -1;
        return bl;
    }

    private void removeUnusedBadges() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 >= this.menu.size()) break;
            hashSet.add(this.menu.getItem(n2).getItemId());
            ++n2;
        }
        for (int i = n; i < this.badgeDrawables.size(); ++i) {
            n2 = this.badgeDrawables.keyAt(i);
            if (hashSet.contains(n2)) continue;
            this.badgeDrawables.delete(n2);
        }
    }

    private void setBadgeIfNeeded(NavigationBarItemView navigationBarItemView) {
        int n = navigationBarItemView.getId();
        if (!this.isValidId(n)) {
            return;
        }
        BadgeDrawable badgeDrawable = (BadgeDrawable)this.badgeDrawables.get(n);
        if (badgeDrawable != null) {
            navigationBarItemView.setBadge(badgeDrawable);
        }
    }

    private void validateMenuItemId(int n) {
        if (this.isValidId(n)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(" is not a valid view id");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void buildMenuView() {
        NavigationBarItemView navigationBarItemView;
        int n;
        int n2;
        this.removeAllViews();
        Drawable drawable2 = this.buttons;
        if (drawable2 != null) {
            n2 = ((NavigationBarItemView[])drawable2).length;
            for (n = 0; n < n2; ++n) {
                navigationBarItemView = drawable2[n];
                if (navigationBarItemView == null) continue;
                this.itemPool.release((Object)navigationBarItemView);
                navigationBarItemView.clear();
            }
        }
        if (this.menu.size() == 0) {
            this.selectedItemId = 0;
            this.selectedItemPosition = 0;
            this.buttons = null;
            return;
        }
        this.removeUnusedBadges();
        this.buttons = new NavigationBarItemView[this.menu.size()];
        boolean bl = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
        for (n = 0; n < this.menu.size(); ++n) {
            this.presenter.setUpdateSuspended(true);
            this.menu.getItem(n).setCheckable(true);
            this.presenter.setUpdateSuspended(false);
            this.buttons[n] = navigationBarItemView = this.getNewItem();
            navigationBarItemView.setIconTintList(this.itemIconTint);
            navigationBarItemView.setIconSize(this.itemIconSize);
            navigationBarItemView.setTextColor(this.itemTextColorDefault);
            navigationBarItemView.setTextAppearanceInactive(this.itemTextAppearanceInactive);
            navigationBarItemView.setTextAppearanceActive(this.itemTextAppearanceActive);
            navigationBarItemView.setTextColor(this.itemTextColorFromUser);
            n2 = this.itemPaddingTop;
            if (n2 != -1) {
                navigationBarItemView.setItemPaddingTop(n2);
            }
            if ((n2 = this.itemPaddingBottom) != -1) {
                navigationBarItemView.setItemPaddingBottom(n2);
            }
            navigationBarItemView.setActiveIndicatorWidth(this.itemActiveIndicatorWidth);
            navigationBarItemView.setActiveIndicatorHeight(this.itemActiveIndicatorHeight);
            navigationBarItemView.setActiveIndicatorMarginHorizontal(this.itemActiveIndicatorMarginHorizontal);
            navigationBarItemView.setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            navigationBarItemView.setActiveIndicatorResizeable(this.itemActiveIndicatorResizeable);
            navigationBarItemView.setActiveIndicatorEnabled(this.itemActiveIndicatorEnabled);
            drawable2 = this.itemBackground;
            if (drawable2 != null) {
                navigationBarItemView.setItemBackground(drawable2);
            } else {
                navigationBarItemView.setItemBackground(this.itemBackgroundRes);
            }
            navigationBarItemView.setShifting(bl);
            navigationBarItemView.setLabelVisibilityMode(this.labelVisibilityMode);
            drawable2 = (MenuItemImpl)this.menu.getItem(n);
            navigationBarItemView.initialize((MenuItemImpl)drawable2, 0);
            navigationBarItemView.setItemPosition(n);
            int n3 = drawable2.getItemId();
            navigationBarItemView.setOnTouchListener((View.OnTouchListener)this.onTouchListeners.get(n3));
            navigationBarItemView.setOnClickListener(this.onClickListener);
            n2 = this.selectedItemId;
            if (n2 != 0 && n3 == n2) {
                this.selectedItemPosition = n;
            }
            this.setBadgeIfNeeded(navigationBarItemView);
            this.addView((View)navigationBarItemView);
        }
        this.selectedItemPosition = n = Math.min(this.menu.size() - 1, this.selectedItemPosition);
        this.menu.getItem(n).setChecked(true);
    }

    public ColorStateList createDefaultColorStateList(int n) {
        Object object = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(n, object, true)) {
            return null;
        }
        ColorStateList colorStateList = AppCompatResources.getColorStateList((Context)this.getContext(), (int)object.resourceId);
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, object, true)) {
            return null;
        }
        int n2 = object.data;
        int n3 = colorStateList.getDefaultColor();
        int[] nArray = DISABLED_STATE_SET;
        object = CHECKED_STATE_SET;
        int[] nArray2 = EMPTY_STATE_SET;
        n = colorStateList.getColorForState(nArray, n3);
        return new ColorStateList((int[][])new int[][]{nArray, (int[])object, nArray2}, new int[]{n, n2, n3});
    }

    protected abstract NavigationBarItemView createNavigationBarItemView(Context var1);

    public NavigationBarItemView findItemView(int n) {
        this.validateMenuItemId(n);
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            for (NavigationBarItemView navigationBarItemView : navigationBarItemViewArray) {
                if (navigationBarItemView.getId() != n) continue;
                return navigationBarItemView;
            }
        }
        return null;
    }

    public BadgeDrawable getBadge(int n) {
        return (BadgeDrawable)this.badgeDrawables.get(n);
    }

    SparseArray<BadgeDrawable> getBadgeDrawables() {
        return this.badgeDrawables;
    }

    public ColorStateList getIconTintList() {
        return this.itemIconTint;
    }

    public ColorStateList getItemActiveIndicatorColor() {
        return this.itemActiveIndicatorColor;
    }

    public boolean getItemActiveIndicatorEnabled() {
        return this.itemActiveIndicatorEnabled;
    }

    public int getItemActiveIndicatorHeight() {
        return this.itemActiveIndicatorHeight;
    }

    public int getItemActiveIndicatorMarginHorizontal() {
        return this.itemActiveIndicatorMarginHorizontal;
    }

    public ShapeAppearanceModel getItemActiveIndicatorShapeAppearance() {
        return this.itemActiveIndicatorShapeAppearance;
    }

    public int getItemActiveIndicatorWidth() {
        return this.itemActiveIndicatorWidth;
    }

    public Drawable getItemBackground() {
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null && navigationBarItemViewArray.length > 0) {
            return navigationBarItemViewArray[0].getBackground();
        }
        return this.itemBackground;
    }

    @Deprecated
    public int getItemBackgroundRes() {
        return this.itemBackgroundRes;
    }

    public int getItemIconSize() {
        return this.itemIconSize;
    }

    public int getItemPaddingBottom() {
        return this.itemPaddingBottom;
    }

    public int getItemPaddingTop() {
        return this.itemPaddingTop;
    }

    public int getItemTextAppearanceActive() {
        return this.itemTextAppearanceActive;
    }

    public int getItemTextAppearanceInactive() {
        return this.itemTextAppearanceInactive;
    }

    public ColorStateList getItemTextColor() {
        return this.itemTextColorFromUser;
    }

    public int getLabelVisibilityMode() {
        return this.labelVisibilityMode;
    }

    protected MenuBuilder getMenu() {
        return this.menu;
    }

    BadgeDrawable getOrCreateBadge(int n) {
        this.validateMenuItemId(n);
        Object object = (BadgeDrawable)this.badgeDrawables.get(n);
        BadgeDrawable badgeDrawable = object;
        if (object == null) {
            badgeDrawable = BadgeDrawable.create(this.getContext());
            this.badgeDrawables.put(n, (Object)badgeDrawable);
        }
        if ((object = this.findItemView(n)) != null) {
            ((NavigationBarItemView)((Object)object)).setBadge(badgeDrawable);
        }
        return badgeDrawable;
    }

    public int getSelectedItemId() {
        return this.selectedItemId;
    }

    protected int getSelectedItemPosition() {
        return this.selectedItemPosition;
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void initialize(MenuBuilder menuBuilder) {
        this.menu = menuBuilder;
    }

    protected boolean isItemActiveIndicatorResizeable() {
        return this.itemActiveIndicatorResizeable;
    }

    protected boolean isShifting(int n, int n2) {
        boolean bl = true;
        if (!(n == -1 ? n2 > 3 : n == 0)) {
            bl = false;
        }
        return bl;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo).setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.menu.getVisibleItems().size(), (boolean)false, (int)1));
    }

    void removeBadge(int n) {
        this.validateMenuItemId(n);
        BadgeDrawable badgeDrawable = (BadgeDrawable)this.badgeDrawables.get(n);
        NavigationBarItemView navigationBarItemView = this.findItemView(n);
        if (navigationBarItemView != null) {
            navigationBarItemView.removeBadge();
        }
        if (badgeDrawable != null) {
            this.badgeDrawables.remove(n);
        }
    }

    void setBadgeDrawables(SparseArray<BadgeDrawable> sparseArray) {
        this.badgeDrawables = sparseArray;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            for (NavigationBarItemView navigationBarItemView : navigationBarItemViewArray) {
                navigationBarItemView.setBadge((BadgeDrawable)sparseArray.get(navigationBarItemView.getId()));
            }
        }
    }

    public void setIconTintList(ColorStateList colorStateList) {
        this.itemIconTint = colorStateList;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setIconTintList(colorStateList);
            }
        }
    }

    public void setItemActiveIndicatorColor(ColorStateList navigationBarItemViewArray) {
        this.itemActiveIndicatorColor = navigationBarItemViewArray;
        navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            }
        }
    }

    public void setItemActiveIndicatorEnabled(boolean bl) {
        this.itemActiveIndicatorEnabled = bl;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorEnabled(bl);
            }
        }
    }

    public void setItemActiveIndicatorHeight(int n) {
        this.itemActiveIndicatorHeight = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorHeight(n);
            }
        }
    }

    public void setItemActiveIndicatorMarginHorizontal(int n) {
        this.itemActiveIndicatorMarginHorizontal = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorMarginHorizontal(n);
            }
        }
    }

    protected void setItemActiveIndicatorResizeable(boolean bl) {
        this.itemActiveIndicatorResizeable = bl;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorResizeable(bl);
            }
        }
    }

    public void setItemActiveIndicatorShapeAppearance(ShapeAppearanceModel navigationBarItemViewArray) {
        this.itemActiveIndicatorShapeAppearance = navigationBarItemViewArray;
        navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorDrawable(this.createItemActiveIndicatorDrawable());
            }
        }
    }

    public void setItemActiveIndicatorWidth(int n) {
        this.itemActiveIndicatorWidth = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setActiveIndicatorWidth(n);
            }
        }
    }

    public void setItemBackground(Drawable drawable2) {
        this.itemBackground = drawable2;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setItemBackground(drawable2);
            }
        }
    }

    public void setItemBackgroundRes(int n) {
        this.itemBackgroundRes = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setItemBackground(n);
            }
        }
    }

    public void setItemIconSize(int n) {
        this.itemIconSize = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setIconSize(n);
            }
        }
    }

    public void setItemOnTouchListener(int n, View.OnTouchListener onTouchListener) {
        if (onTouchListener == null) {
            this.onTouchListeners.remove(n);
        } else {
            this.onTouchListeners.put(n, (Object)onTouchListener);
        }
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            for (NavigationBarItemView navigationBarItemView : navigationBarItemViewArray) {
                if (navigationBarItemView.getItemData().getItemId() != n) continue;
                navigationBarItemView.setOnTouchListener(onTouchListener);
            }
        }
    }

    public void setItemPaddingBottom(int n) {
        this.itemPaddingBottom = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setItemPaddingBottom(n);
            }
        }
    }

    public void setItemPaddingTop(int n) {
        this.itemPaddingTop = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n2 = navigationBarItemViewArray.length;
            for (int i = 0; i < n2; ++i) {
                navigationBarItemViewArray[i].setItemPaddingTop(n);
            }
        }
    }

    public void setItemTextAppearanceActive(int n) {
        this.itemTextAppearanceActive = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            for (NavigationBarItemView navigationBarItemView : navigationBarItemViewArray) {
                navigationBarItemView.setTextAppearanceActive(n);
                ColorStateList colorStateList = this.itemTextColorFromUser;
                if (colorStateList == null) continue;
                navigationBarItemView.setTextColor(colorStateList);
            }
        }
    }

    public void setItemTextAppearanceInactive(int n) {
        this.itemTextAppearanceInactive = n;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            for (NavigationBarItemView navigationBarItemView : navigationBarItemViewArray) {
                navigationBarItemView.setTextAppearanceInactive(n);
                ColorStateList colorStateList = this.itemTextColorFromUser;
                if (colorStateList == null) continue;
                navigationBarItemView.setTextColor(colorStateList);
            }
        }
    }

    public void setItemTextColor(ColorStateList colorStateList) {
        this.itemTextColorFromUser = colorStateList;
        NavigationBarItemView[] navigationBarItemViewArray = this.buttons;
        if (navigationBarItemViewArray != null) {
            int n = navigationBarItemViewArray.length;
            for (int i = 0; i < n; ++i) {
                navigationBarItemViewArray[i].setTextColor(colorStateList);
            }
        }
    }

    public void setLabelVisibilityMode(int n) {
        this.labelVisibilityMode = n;
    }

    public void setPresenter(NavigationBarPresenter navigationBarPresenter) {
        this.presenter = navigationBarPresenter;
    }

    void tryRestoreSelectedItemId(int n) {
        int n2 = this.menu.size();
        for (int i = 0; i < n2; ++i) {
            MenuItem menuItem = this.menu.getItem(i);
            if (n != menuItem.getItemId()) continue;
            this.selectedItemId = n;
            this.selectedItemPosition = i;
            menuItem.setChecked(true);
            break;
        }
    }

    public void updateMenuView() {
        MenuBuilder menuBuilder = this.menu;
        if (menuBuilder != null && this.buttons != null) {
            int n;
            int n2 = menuBuilder.size();
            if (n2 != this.buttons.length) {
                this.buildMenuView();
                return;
            }
            int n3 = this.selectedItemId;
            for (n = 0; n < n2; ++n) {
                menuBuilder = this.menu.getItem(n);
                if (!menuBuilder.isChecked()) continue;
                this.selectedItemId = menuBuilder.getItemId();
                this.selectedItemPosition = n;
            }
            if (n3 != this.selectedItemId) {
                TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.set);
            }
            boolean bl = this.isShifting(this.labelVisibilityMode, this.menu.getVisibleItems().size());
            for (n = 0; n < n2; ++n) {
                this.presenter.setUpdateSuspended(true);
                this.buttons[n].setLabelVisibilityMode(this.labelVisibilityMode);
                this.buttons[n].setShifting(bl);
                this.buttons[n].initialize((MenuItemImpl)this.menu.getItem(n), 0);
                this.presenter.setUpdateSuspended(false);
            }
        }
    }
}

