/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.navigation.NavigationBarMenu;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigation.NavigationBarPresenter;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class NavigationBarView
extends FrameLayout {
    public static final int LABEL_VISIBILITY_AUTO = -1;
    public static final int LABEL_VISIBILITY_LABELED = 1;
    public static final int LABEL_VISIBILITY_SELECTED = 0;
    public static final int LABEL_VISIBILITY_UNLABELED = 2;
    private static final int MENU_PRESENTER_ID = 1;
    private ColorStateList itemRippleColor;
    private final NavigationBarMenu menu;
    private MenuInflater menuInflater;
    private final NavigationBarMenuView menuView;
    private final NavigationBarPresenter presenter;
    private OnItemReselectedListener reselectedListener;
    private OnItemSelectedListener selectedListener;

    public NavigationBarView(Context context, AttributeSet object, int n, int n2) {
        super(MaterialThemeOverlay.wrap(context, object, n, n2), object, n);
        NavigationBarMenuView navigationBarMenuView;
        NavigationBarPresenter navigationBarPresenter;
        this.presenter = navigationBarPresenter = new NavigationBarPresenter();
        context = this.getContext();
        TintTypedArray tintTypedArray = ThemeEnforcement.obtainTintedStyledAttributes(context, object, R.styleable.NavigationBarView, n, n2, new int[]{R.styleable.NavigationBarView_itemTextAppearanceInactive, R.styleable.NavigationBarView_itemTextAppearanceActive});
        object = new NavigationBarMenu(context, ((Object)((Object)this)).getClass(), this.getMaxItemCount());
        this.menu = object;
        this.menuView = navigationBarMenuView = this.createNavigationBarMenuView(context);
        navigationBarPresenter.setMenuView(navigationBarMenuView);
        navigationBarPresenter.setId(1);
        navigationBarMenuView.setPresenter(navigationBarPresenter);
        object.addMenuPresenter((MenuPresenter)navigationBarPresenter);
        navigationBarPresenter.initForMenu(this.getContext(), (MenuBuilder)object);
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemIconTint)) {
            navigationBarMenuView.setIconTintList(tintTypedArray.getColorStateList(R.styleable.NavigationBarView_itemIconTint));
        } else {
            navigationBarMenuView.setIconTintList(navigationBarMenuView.createDefaultColorStateList(16842808));
        }
        this.setItemIconSize(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationBarView_itemIconSize, this.getResources().getDimensionPixelSize(R.dimen.mtrl_navigation_bar_item_default_icon_size)));
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemTextAppearanceInactive)) {
            this.setItemTextAppearanceInactive(tintTypedArray.getResourceId(R.styleable.NavigationBarView_itemTextAppearanceInactive, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemTextAppearanceActive)) {
            this.setItemTextAppearanceActive(tintTypedArray.getResourceId(R.styleable.NavigationBarView_itemTextAppearanceActive, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemTextColor)) {
            this.setItemTextColor(tintTypedArray.getColorStateList(R.styleable.NavigationBarView_itemTextColor));
        }
        if (this.getBackground() == null || this.getBackground() instanceof ColorDrawable) {
            ViewCompat.setBackground((View)this, (Drawable)this.createMaterialShapeDrawableBackground(context));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemPaddingTop)) {
            this.setItemPaddingTop(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationBarView_itemPaddingTop, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_itemPaddingBottom)) {
            this.setItemPaddingBottom(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationBarView_itemPaddingBottom, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_elevation)) {
            this.setElevation(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationBarView_elevation, 0));
        }
        navigationBarPresenter = MaterialResources.getColorStateList(context, tintTypedArray, R.styleable.NavigationBarView_backgroundTint);
        DrawableCompat.setTintList((Drawable)this.getBackground().mutate(), (ColorStateList)navigationBarPresenter);
        this.setLabelVisibilityMode(tintTypedArray.getInteger(R.styleable.NavigationBarView_labelVisibilityMode, -1));
        n = tintTypedArray.getResourceId(R.styleable.NavigationBarView_itemBackground, 0);
        if (n != 0) {
            navigationBarMenuView.setItemBackgroundRes(n);
        } else {
            this.setItemRippleColor(MaterialResources.getColorStateList(context, tintTypedArray, R.styleable.NavigationBarView_itemRippleColor));
        }
        n = tintTypedArray.getResourceId(R.styleable.NavigationBarView_itemActiveIndicatorStyle, 0);
        if (n != 0) {
            this.setItemActiveIndicatorEnabled(true);
            navigationBarPresenter = context.obtainStyledAttributes(n, R.styleable.NavigationBarActiveIndicator);
            this.setItemActiveIndicatorWidth(navigationBarPresenter.getDimensionPixelSize(R.styleable.NavigationBarActiveIndicator_android_width, 0));
            this.setItemActiveIndicatorHeight(navigationBarPresenter.getDimensionPixelSize(R.styleable.NavigationBarActiveIndicator_android_height, 0));
            this.setItemActiveIndicatorMarginHorizontal(navigationBarPresenter.getDimensionPixelOffset(R.styleable.NavigationBarActiveIndicator_marginHorizontal, 0));
            this.setItemActiveIndicatorColor(MaterialResources.getColorStateList(context, (TypedArray)navigationBarPresenter, R.styleable.NavigationBarActiveIndicator_android_color));
            this.setItemActiveIndicatorShapeAppearance(ShapeAppearanceModel.builder(context, navigationBarPresenter.getResourceId(R.styleable.NavigationBarActiveIndicator_shapeAppearance, 0), 0).build());
            navigationBarPresenter.recycle();
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationBarView_menu)) {
            this.inflateMenu(tintTypedArray.getResourceId(R.styleable.NavigationBarView_menu, 0));
        }
        tintTypedArray.recycle();
        this.addView((View)navigationBarMenuView);
        object.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder object, MenuItem menuItem) {
                object = NavigationBarView.this.reselectedListener;
                boolean bl = true;
                if (object != null && menuItem.getItemId() == NavigationBarView.this.getSelectedItemId()) {
                    NavigationBarView.this.reselectedListener.onNavigationItemReselected(menuItem);
                    return true;
                }
                if (NavigationBarView.this.selectedListener == null || NavigationBarView.this.selectedListener.onNavigationItemSelected(menuItem)) {
                    bl = false;
                }
                return bl;
            }

            public void onMenuModeChange(MenuBuilder menuBuilder) {
            }
        });
    }

    private MaterialShapeDrawable createMaterialShapeDrawableBackground(Context context) {
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
        Drawable drawable2 = this.getBackground();
        if (drawable2 instanceof ColorDrawable) {
            materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)((ColorDrawable)drawable2).getColor()));
        }
        materialShapeDrawable.initializeElevationOverlay(context);
        return materialShapeDrawable;
    }

    private MenuInflater getMenuInflater() {
        if (this.menuInflater == null) {
            this.menuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.menuInflater;
    }

    protected abstract NavigationBarMenuView createNavigationBarMenuView(Context var1);

    public BadgeDrawable getBadge(int n) {
        return this.menuView.getBadge(n);
    }

    public ColorStateList getItemActiveIndicatorColor() {
        return this.menuView.getItemActiveIndicatorColor();
    }

    public int getItemActiveIndicatorHeight() {
        return this.menuView.getItemActiveIndicatorHeight();
    }

    public int getItemActiveIndicatorMarginHorizontal() {
        return this.menuView.getItemActiveIndicatorMarginHorizontal();
    }

    public ShapeAppearanceModel getItemActiveIndicatorShapeAppearance() {
        return this.menuView.getItemActiveIndicatorShapeAppearance();
    }

    public int getItemActiveIndicatorWidth() {
        return this.menuView.getItemActiveIndicatorWidth();
    }

    public Drawable getItemBackground() {
        return this.menuView.getItemBackground();
    }

    @Deprecated
    public int getItemBackgroundResource() {
        return this.menuView.getItemBackgroundRes();
    }

    public int getItemIconSize() {
        return this.menuView.getItemIconSize();
    }

    public ColorStateList getItemIconTintList() {
        return this.menuView.getIconTintList();
    }

    public int getItemPaddingBottom() {
        return this.menuView.getItemPaddingBottom();
    }

    public int getItemPaddingTop() {
        return this.menuView.getItemPaddingTop();
    }

    public ColorStateList getItemRippleColor() {
        return this.itemRippleColor;
    }

    public int getItemTextAppearanceActive() {
        return this.menuView.getItemTextAppearanceActive();
    }

    public int getItemTextAppearanceInactive() {
        return this.menuView.getItemTextAppearanceInactive();
    }

    public ColorStateList getItemTextColor() {
        return this.menuView.getItemTextColor();
    }

    public int getLabelVisibilityMode() {
        return this.menuView.getLabelVisibilityMode();
    }

    public abstract int getMaxItemCount();

    public Menu getMenu() {
        return this.menu;
    }

    public MenuView getMenuView() {
        return this.menuView;
    }

    public BadgeDrawable getOrCreateBadge(int n) {
        return this.menuView.getOrCreateBadge(n);
    }

    public NavigationBarPresenter getPresenter() {
        return this.presenter;
    }

    public int getSelectedItemId() {
        return this.menuView.getSelectedItemId();
    }

    public void inflateMenu(int n) {
        this.presenter.setUpdateSuspended(true);
        this.getMenuInflater().inflate(n, (Menu)this.menu);
        this.presenter.setUpdateSuspended(false);
        this.presenter.updateMenuView(true);
    }

    public boolean isItemActiveIndicatorEnabled() {
        return this.menuView.getItemActiveIndicatorEnabled();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.menu.restorePresenterStates(object.menuPresenterState);
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.menuPresenterState = new Bundle();
        this.menu.savePresenterStates(savedState.menuPresenterState);
        return savedState;
    }

    public void removeBadge(int n) {
        this.menuView.removeBadge(n);
    }

    public void setElevation(float f) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.setElevation(f);
        }
        MaterialShapeUtils.setElevation((View)this, f);
    }

    public void setItemActiveIndicatorColor(ColorStateList colorStateList) {
        this.menuView.setItemActiveIndicatorColor(colorStateList);
    }

    public void setItemActiveIndicatorEnabled(boolean bl) {
        this.menuView.setItemActiveIndicatorEnabled(bl);
    }

    public void setItemActiveIndicatorHeight(int n) {
        this.menuView.setItemActiveIndicatorHeight(n);
    }

    public void setItemActiveIndicatorMarginHorizontal(int n) {
        this.menuView.setItemActiveIndicatorMarginHorizontal(n);
    }

    public void setItemActiveIndicatorShapeAppearance(ShapeAppearanceModel shapeAppearanceModel) {
        this.menuView.setItemActiveIndicatorShapeAppearance(shapeAppearanceModel);
    }

    public void setItemActiveIndicatorWidth(int n) {
        this.menuView.setItemActiveIndicatorWidth(n);
    }

    public void setItemBackground(Drawable drawable2) {
        this.menuView.setItemBackground(drawable2);
        this.itemRippleColor = null;
    }

    public void setItemBackgroundResource(int n) {
        this.menuView.setItemBackgroundRes(n);
        this.itemRippleColor = null;
    }

    public void setItemIconSize(int n) {
        this.menuView.setItemIconSize(n);
    }

    public void setItemIconSizeRes(int n) {
        this.setItemIconSize(this.getResources().getDimensionPixelSize(n));
    }

    public void setItemIconTintList(ColorStateList colorStateList) {
        this.menuView.setIconTintList(colorStateList);
    }

    public void setItemOnTouchListener(int n, View.OnTouchListener onTouchListener) {
        this.menuView.setItemOnTouchListener(n, onTouchListener);
    }

    public void setItemPaddingBottom(int n) {
        this.menuView.setItemPaddingBottom(n);
    }

    public void setItemPaddingTop(int n) {
        this.menuView.setItemPaddingTop(n);
    }

    public void setItemRippleColor(ColorStateList colorStateList) {
        if (this.itemRippleColor == colorStateList) {
            if (colorStateList == null && this.menuView.getItemBackground() != null) {
                this.menuView.setItemBackground(null);
            }
            return;
        }
        this.itemRippleColor = colorStateList;
        if (colorStateList == null) {
            this.menuView.setItemBackground(null);
        } else {
            colorStateList = RippleUtils.convertToRippleDrawableColor(colorStateList);
            if (Build.VERSION.SDK_INT >= 21) {
                this.menuView.setItemBackground((Drawable)new RippleDrawable(colorStateList, null, null));
            } else {
                GradientDrawable gradientDrawable = new GradientDrawable();
                gradientDrawable.setCornerRadius(1.0E-5f);
                gradientDrawable = DrawableCompat.wrap((Drawable)gradientDrawable);
                DrawableCompat.setTintList((Drawable)gradientDrawable, (ColorStateList)colorStateList);
                this.menuView.setItemBackground((Drawable)gradientDrawable);
            }
        }
    }

    public void setItemTextAppearanceActive(int n) {
        this.menuView.setItemTextAppearanceActive(n);
    }

    public void setItemTextAppearanceInactive(int n) {
        this.menuView.setItemTextAppearanceInactive(n);
    }

    public void setItemTextColor(ColorStateList colorStateList) {
        this.menuView.setItemTextColor(colorStateList);
    }

    public void setLabelVisibilityMode(int n) {
        if (this.menuView.getLabelVisibilityMode() != n) {
            this.menuView.setLabelVisibilityMode(n);
            this.presenter.updateMenuView(false);
        }
    }

    public void setOnItemReselectedListener(OnItemReselectedListener onItemReselectedListener) {
        this.reselectedListener = onItemReselectedListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.selectedListener = onItemSelectedListener;
    }

    public void setSelectedItemId(int n) {
        MenuItem menuItem = this.menu.findItem(n);
        if (menuItem != null && !this.menu.performItemAction(menuItem, this.presenter, 0)) {
            menuItem.setChecked(true);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LabelVisibility {
    }

    public static interface OnItemReselectedListener {
        public void onNavigationItemReselected(MenuItem var1);
    }

    public static interface OnItemSelectedListener {
        public boolean onNavigationItemSelected(MenuItem var1);
    }

    static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Bundle menuPresenterState;

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            ClassLoader classLoader2 = classLoader;
            if (classLoader == null) {
                classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.readFromParcel(parcel, classLoader2);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private void readFromParcel(Parcel parcel, ClassLoader classLoader) {
            this.menuPresenterState = parcel.readBundle(classLoader);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeBundle(this.menuPresenterState);
        }
    }
}

