/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.navigationrail.NavigationRailMenuView;

public class NavigationRailView
extends NavigationBarView {
    private static final int DEFAULT_HEADER_GRAVITY = 49;
    static final int DEFAULT_MENU_GRAVITY = 49;
    static final int MAX_ITEM_COUNT = 7;
    static final int NO_ITEM_MINIMUM_HEIGHT = -1;
    private View headerView;
    private final int topMargin = this.getResources().getDimensionPixelSize(R.dimen.mtrl_navigation_rail_margin);

    public NavigationRailView(Context context) {
        this(context, null);
    }

    public NavigationRailView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.navigationRailStyle);
    }

    public NavigationRailView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, R.style.Widget_MaterialComponents_NavigationRailView);
    }

    public NavigationRailView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        context = ThemeEnforcement.obtainTintedStyledAttributes(this.getContext(), attributeSet, R.styleable.NavigationRailView, n, n2, new int[0]);
        n = context.getResourceId(R.styleable.NavigationRailView_headerLayout, 0);
        if (n != 0) {
            this.addHeaderView(n);
        }
        this.setMenuGravity(context.getInt(R.styleable.NavigationRailView_menuGravity, 49));
        if (context.hasValue(R.styleable.NavigationRailView_itemMinHeight)) {
            this.setItemMinimumHeight(context.getDimensionPixelSize(R.styleable.NavigationRailView_itemMinHeight, -1));
        }
        context.recycle();
        this.applyWindowInsets();
    }

    private void applyWindowInsets() {
        ViewUtils.doOnApplyWindowInsets((View)this, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat, ViewUtils.RelativePadding relativePadding) {
                relativePadding.top += windowInsetsCompat.getSystemWindowInsetTop();
                relativePadding.bottom += windowInsetsCompat.getSystemWindowInsetBottom();
                int n = ViewCompat.getLayoutDirection((View)view);
                boolean bl = true;
                if (n != 1) {
                    bl = false;
                }
                n = windowInsetsCompat.getSystemWindowInsetLeft();
                int n2 = windowInsetsCompat.getSystemWindowInsetRight();
                int n3 = relativePadding.start;
                if (bl) {
                    n = n2;
                }
                relativePadding.start = n3 + n;
                relativePadding.applyToView(view);
                return windowInsetsCompat;
            }
        });
    }

    private NavigationRailMenuView getNavigationRailMenuView() {
        return (NavigationRailMenuView)this.getMenuView();
    }

    private boolean isHeaderViewVisible() {
        View view = this.headerView;
        boolean bl = view != null && view.getVisibility() != 8;
        return bl;
    }

    private int makeMinWidthSpec(int n) {
        int n2 = this.getSuggestedMinimumWidth();
        int n3 = n;
        if (View.MeasureSpec.getMode((int)n) != 0x40000000) {
            n3 = n;
            if (n2 > 0) {
                int n4 = this.getPaddingLeft();
                n3 = this.getPaddingRight();
                n3 = View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)n), n2 + (n4 + n3)), (int)0x40000000);
            }
        }
        return n3;
    }

    public void addHeaderView(int n) {
        this.addHeaderView(LayoutInflater.from((Context)this.getContext()).inflate(n, (ViewGroup)this, false));
    }

    public void addHeaderView(View view) {
        this.removeHeaderView();
        this.headerView = view;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 49;
        layoutParams.topMargin = this.topMargin;
        this.addView(view, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    protected NavigationRailMenuView createNavigationBarMenuView(Context context) {
        return new NavigationRailMenuView(context);
    }

    public View getHeaderView() {
        return this.headerView;
    }

    public int getItemMinimumHeight() {
        return ((NavigationRailMenuView)this.getMenuView()).getItemMinimumHeight();
    }

    @Override
    public int getMaxItemCount() {
        return 7;
    }

    public int getMenuGravity() {
        return this.getNavigationRailMenuView().getMenuGravity();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        NavigationRailMenuView navigationRailMenuView = this.getNavigationRailMenuView();
        bl = this.isHeaderViewVisible();
        n = 0;
        if (bl) {
            n3 = this.headerView.getBottom() + this.topMargin;
            n2 = navigationRailMenuView.getTop();
            if (n2 < n3) {
                n = n3 - n2;
            }
        } else if (navigationRailMenuView.isTopGravity()) {
            n = this.topMargin;
        }
        if (n > 0) {
            navigationRailMenuView.layout(navigationRailMenuView.getLeft(), navigationRailMenuView.getTop() + n, navigationRailMenuView.getRight(), navigationRailMenuView.getBottom() + n);
        }
    }

    protected void onMeasure(int n, int n2) {
        n = this.makeMinWidthSpec(n);
        super.onMeasure(n, n2);
        if (this.isHeaderViewVisible()) {
            n2 = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.headerView.getMeasuredHeight() - this.topMargin), (int)Integer.MIN_VALUE);
            this.measureChild((View)this.getNavigationRailMenuView(), n, n2);
        }
    }

    public void removeHeaderView() {
        View view = this.headerView;
        if (view != null) {
            this.removeView(view);
            this.headerView = null;
        }
    }

    public void setItemMinimumHeight(int n) {
        ((NavigationRailMenuView)this.getMenuView()).setItemMinimumHeight(n);
    }

    public void setMenuGravity(int n) {
        this.getNavigationRailMenuView().setMenuGravity(n);
    }
}

