/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;

public abstract class BaseProgressIndicatorSpec {
    public int hideAnimationBehavior;
    public int[] indicatorColors = new int[0];
    public int showAnimationBehavior;
    public int trackColor;
    public int trackCornerRadius;
    public int trackThickness;

    protected BaseProgressIndicatorSpec(Context context, AttributeSet attributeSet, int n, int n2) {
        int n3 = context.getResources().getDimensionPixelSize(R.dimen.mtrl_progress_track_thickness);
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.BaseProgressIndicator, n, n2, new int[0]);
        this.trackThickness = MaterialResources.getDimensionPixelSize(context, (TypedArray)attributeSet, R.styleable.BaseProgressIndicator_trackThickness, n3);
        this.trackCornerRadius = Math.min(MaterialResources.getDimensionPixelSize(context, (TypedArray)attributeSet, R.styleable.BaseProgressIndicator_trackCornerRadius, 0), this.trackThickness / 2);
        this.showAnimationBehavior = attributeSet.getInt(R.styleable.BaseProgressIndicator_showAnimationBehavior, 0);
        this.hideAnimationBehavior = attributeSet.getInt(R.styleable.BaseProgressIndicator_hideAnimationBehavior, 0);
        this.loadIndicatorColors(context, (TypedArray)attributeSet);
        this.loadTrackColor(context, (TypedArray)attributeSet);
        attributeSet.recycle();
    }

    private void loadIndicatorColors(Context object, TypedArray typedArray) {
        if (!typedArray.hasValue(R.styleable.BaseProgressIndicator_indicatorColor)) {
            this.indicatorColors = new int[]{MaterialColors.getColor(object, R.attr.colorPrimary, -1)};
            return;
        }
        if (typedArray.peekValue((int)R.styleable.BaseProgressIndicator_indicatorColor).type != 1) {
            this.indicatorColors = new int[]{typedArray.getColor(R.styleable.BaseProgressIndicator_indicatorColor, -1)};
            return;
        }
        object = object.getResources().getIntArray(typedArray.getResourceId(R.styleable.BaseProgressIndicator_indicatorColor, -1));
        this.indicatorColors = (int[])object;
        if (((Context)object).length != 0) {
            return;
        }
        throw new IllegalArgumentException("indicatorColors cannot be empty when indicatorColor is not used.");
    }

    private void loadTrackColor(Context context, TypedArray typedArray) {
        if (typedArray.hasValue(R.styleable.BaseProgressIndicator_trackColor)) {
            this.trackColor = typedArray.getColor(R.styleable.BaseProgressIndicator_trackColor, -1);
            return;
        }
        this.trackColor = this.indicatorColors[0];
        context = context.getTheme().obtainStyledAttributes(new int[]{0x1010033});
        float f = context.getFloat(0, 0.2f);
        context.recycle();
        int n = (int)(f * 255.0f);
        this.trackColor = MaterialColors.compositeARGBWithAlpha(this.trackColor, n);
    }

    public boolean isHideAnimationEnabled() {
        boolean bl = this.hideAnimationBehavior != 0;
        return bl;
    }

    public boolean isShowAnimationEnabled() {
        boolean bl = this.showAnimationBehavior != 0;
        return bl;
    }

    abstract void validateSpec();
}

