/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawingDelegate;

final class CircularDrawingDelegate
extends DrawingDelegate<CircularProgressIndicatorSpec> {
    private float adjustedRadius;
    private int arcDirectionFactor = 1;
    private float displayedCornerRadius;
    private float displayedTrackThickness;

    public CircularDrawingDelegate(CircularProgressIndicatorSpec circularProgressIndicatorSpec) {
        super(circularProgressIndicatorSpec);
    }

    private void drawRoundedEnd(Canvas canvas, Paint paint, float f, float f2, float f3) {
        canvas.save();
        canvas.rotate(f3);
        f3 = this.adjustedRadius;
        canvas.drawRoundRect(new RectF(f3 - (f /= 2.0f), f2, f3 + f, -f2), f2, f2, paint);
        canvas.restore();
    }

    private int getSize() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorSize + ((CircularProgressIndicatorSpec)this.spec).indicatorInset * 2;
    }

    @Override
    public void adjustCanvas(Canvas canvas, float f) {
        float f2 = (float)((CircularProgressIndicatorSpec)this.spec).indicatorSize / 2.0f + (float)((CircularProgressIndicatorSpec)this.spec).indicatorInset;
        canvas.translate(f2, f2);
        canvas.rotate(-90.0f);
        float f3 = -f2;
        canvas.clipRect(f3, f3, f2, f2);
        int n = ((CircularProgressIndicatorSpec)this.spec).indicatorDirection == 0 ? 1 : -1;
        this.arcDirectionFactor = n;
        this.displayedTrackThickness = (float)((CircularProgressIndicatorSpec)this.spec).trackThickness * f;
        this.displayedCornerRadius = (float)((CircularProgressIndicatorSpec)this.spec).trackCornerRadius * f;
        this.adjustedRadius = (float)(((CircularProgressIndicatorSpec)this.spec).indicatorSize - ((CircularProgressIndicatorSpec)this.spec).trackThickness) / 2.0f;
        if (this.drawable.isShowing() && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 2 || this.drawable.isHiding() && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 1) {
            this.adjustedRadius += (1.0f - f) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
        } else if (this.drawable.isShowing() && ((CircularProgressIndicatorSpec)this.spec).showAnimationBehavior == 1 || this.drawable.isHiding() && ((CircularProgressIndicatorSpec)this.spec).hideAnimationBehavior == 2) {
            this.adjustedRadius -= (1.0f - f) * (float)((CircularProgressIndicatorSpec)this.spec).trackThickness / 2.0f;
        }
    }

    @Override
    void fillIndicator(Canvas canvas, Paint paint, float f, float f2, int n) {
        if (f == f2) {
            return;
        }
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setAntiAlias(true);
        paint.setColor(n);
        paint.setStrokeWidth(this.displayedTrackThickness);
        n = this.arcDirectionFactor;
        float f3 = f * 360.0f * (float)n;
        f = f2 >= f ? f2 - f : 1.0f + f2 - f;
        f2 = f * 360.0f * (float)n;
        f = this.adjustedRadius;
        canvas.drawArc(new RectF(-f, -f, f, f), f3, f2, false, paint);
        if (this.displayedCornerRadius > 0.0f && Math.abs(f2) < 360.0f) {
            paint.setStyle(Paint.Style.FILL);
            this.drawRoundedEnd(canvas, paint, this.displayedTrackThickness, this.displayedCornerRadius, f3);
            this.drawRoundedEnd(canvas, paint, this.displayedTrackThickness, this.displayedCornerRadius, f3 + f2);
        }
    }

    @Override
    void fillTrack(Canvas canvas, Paint paint) {
        int n = MaterialColors.compositeARGBWithAlpha(((CircularProgressIndicatorSpec)this.spec).trackColor, this.drawable.getAlpha());
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.BUTT);
        paint.setAntiAlias(true);
        paint.setColor(n);
        paint.setStrokeWidth(this.displayedTrackThickness);
        float f = this.adjustedRadius;
        canvas.drawArc(new RectF(-f, -f, f, f), 0.0f, 360.0f, false, paint);
    }

    @Override
    public int getPreferredHeight() {
        return this.getSize();
    }

    @Override
    public int getPreferredWidth() {
        return this.getSize();
    }
}

