/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.drawable.Drawable;
import android.util.Property;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.animation.ArgbEvaluatorCompat;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;

final class CircularIndeterminateAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final Property<CircularIndeterminateAnimatorDelegate, Float> ANIMATION_FRACTION;
    private static final Property<CircularIndeterminateAnimatorDelegate, Float> COMPLETE_END_FRACTION;
    private static final int CONSTANT_ROTATION_DEGREES = 1520;
    private static final int[] DELAY_TO_COLLAPSE_IN_MS;
    private static final int[] DELAY_TO_EXPAND_IN_MS;
    private static final int[] DELAY_TO_FADE_IN_MS;
    private static final int DURATION_TO_COLLAPSE_IN_MS = 667;
    private static final int DURATION_TO_COMPLETE_END_IN_MS = 333;
    private static final int DURATION_TO_EXPAND_IN_MS = 667;
    private static final int DURATION_TO_FADE_IN_MS = 333;
    private static final int EXTRA_DEGREES_PER_CYCLE = 250;
    private static final int TAIL_DEGREES_OFFSET = -20;
    private static final int TOTAL_CYCLES = 4;
    private static final int TOTAL_DURATION_IN_MS = 5400;
    private float animationFraction;
    private ObjectAnimator animator;
    Animatable2Compat.AnimationCallback animatorCompleteCallback = null;
    private final BaseProgressIndicatorSpec baseSpec;
    private ObjectAnimator completeEndAnimator;
    private float completeEndFraction;
    private int indicatorColorIndexOffset = 0;
    private final FastOutSlowInInterpolator interpolator;

    static {
        DELAY_TO_EXPAND_IN_MS = new int[]{0, 1350, 2700, 4050};
        DELAY_TO_COLLAPSE_IN_MS = new int[]{667, 2017, 3367, 4717};
        DELAY_TO_FADE_IN_MS = new int[]{1000, 2350, 3700, 5050};
        ANIMATION_FRACTION = new Property<CircularIndeterminateAnimatorDelegate, Float>(Float.class, "animationFraction"){

            public Float get(CircularIndeterminateAnimatorDelegate circularIndeterminateAnimatorDelegate) {
                return Float.valueOf(circularIndeterminateAnimatorDelegate.getAnimationFraction());
            }

            public void set(CircularIndeterminateAnimatorDelegate circularIndeterminateAnimatorDelegate, Float f) {
                circularIndeterminateAnimatorDelegate.setAnimationFraction(f.floatValue());
            }
        };
        COMPLETE_END_FRACTION = new Property<CircularIndeterminateAnimatorDelegate, Float>(Float.class, "completeEndFraction"){

            public Float get(CircularIndeterminateAnimatorDelegate circularIndeterminateAnimatorDelegate) {
                return Float.valueOf(circularIndeterminateAnimatorDelegate.getCompleteEndFraction());
            }

            public void set(CircularIndeterminateAnimatorDelegate circularIndeterminateAnimatorDelegate, Float f) {
                circularIndeterminateAnimatorDelegate.setCompleteEndFraction(f.floatValue());
            }
        };
    }

    public CircularIndeterminateAnimatorDelegate(CircularProgressIndicatorSpec circularProgressIndicatorSpec) {
        super(1);
        this.baseSpec = circularProgressIndicatorSpec;
        this.interpolator = new FastOutSlowInInterpolator();
    }

    static /* synthetic */ int access$002(CircularIndeterminateAnimatorDelegate circularIndeterminateAnimatorDelegate, int n) {
        circularIndeterminateAnimatorDelegate.indicatorColorIndexOffset = n;
        return n;
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    private float getCompleteEndFraction() {
        return this.completeEndFraction;
    }

    private void maybeInitializeAnimators() {
        ObjectAnimator objectAnimator;
        if (this.animator == null) {
            this.animator = objectAnimator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setDuration(5400L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator object) {
                    super.onAnimationRepeat(object);
                    object = CircularIndeterminateAnimatorDelegate.this;
                    CircularIndeterminateAnimatorDelegate.access$002((CircularIndeterminateAnimatorDelegate)object, (((CircularIndeterminateAnimatorDelegate)object).indicatorColorIndexOffset + 4) % ((CircularIndeterminateAnimatorDelegate)CircularIndeterminateAnimatorDelegate.this).baseSpec.indicatorColors.length);
                }
            });
        }
        if (this.completeEndAnimator == null) {
            this.completeEndAnimator = objectAnimator = ObjectAnimator.ofFloat((Object)this, COMPLETE_END_FRACTION, (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setDuration(333L);
            this.completeEndAnimator.setInterpolator((TimeInterpolator)this.interpolator);
            this.completeEndAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    super.onAnimationEnd(animator2);
                    CircularIndeterminateAnimatorDelegate.this.cancelAnimatorImmediately();
                    if (CircularIndeterminateAnimatorDelegate.this.animatorCompleteCallback != null) {
                        CircularIndeterminateAnimatorDelegate.this.animatorCompleteCallback.onAnimationEnd((Drawable)CircularIndeterminateAnimatorDelegate.this.drawable);
                    }
                }
            });
        }
    }

    private void maybeUpdateSegmentColors(int n) {
        for (int i = 0; i < 4; ++i) {
            float f = this.getFractionInRange(n, DELAY_TO_FADE_IN_MS[i], 333);
            if (!(f >= 0.0f) || !(f <= 1.0f)) continue;
            int n2 = (i + this.indicatorColorIndexOffset) % this.baseSpec.indicatorColors.length;
            i = this.baseSpec.indicatorColors.length;
            n = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[n2], this.drawable.getAlpha());
            i = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[(n2 + 1) % i], this.drawable.getAlpha());
            f = this.interpolator.getInterpolation(f);
            this.segmentColors[0] = ArgbEvaluatorCompat.getInstance().evaluate(f, n, i);
            break;
        }
    }

    private void setCompleteEndFraction(float f) {
        this.completeEndFraction = f;
    }

    private void updateSegmentPositions(int n) {
        float[] fArray;
        this.segmentPositions[0] = this.animationFraction * 1520.0f - 20.0f;
        this.segmentPositions[1] = this.animationFraction * 1520.0f;
        for (int i = 0; i < 4; ++i) {
            float f = this.getFractionInRange(n, DELAY_TO_EXPAND_IN_MS[i], 667);
            fArray = this.segmentPositions;
            fArray[1] = fArray[1] + this.interpolator.getInterpolation(f) * 250.0f;
            f = this.getFractionInRange(n, DELAY_TO_COLLAPSE_IN_MS[i], 667);
            fArray = this.segmentPositions;
            fArray[0] = fArray[0] + this.interpolator.getInterpolation(f) * 250.0f;
        }
        fArray = this.segmentPositions;
        fArray[0] = fArray[0] + (this.segmentPositions[1] - this.segmentPositions[0]) * this.completeEndFraction;
        fArray = this.segmentPositions;
        fArray[0] = fArray[0] / 360.0f;
        fArray = this.segmentPositions;
        fArray[1] = fArray[1] / 360.0f;
    }

    @Override
    void cancelAnimatorImmediately() {
        ObjectAnimator objectAnimator = this.animator;
        if (objectAnimator != null) {
            objectAnimator.cancel();
        }
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(Animatable2Compat.AnimationCallback animationCallback) {
        this.animatorCompleteCallback = animationCallback;
    }

    @Override
    void requestCancelAnimatorAfterCurrentCycle() {
        ObjectAnimator objectAnimator = this.completeEndAnimator;
        if (objectAnimator != null && !objectAnimator.isRunning()) {
            if (this.drawable.isVisible()) {
                this.completeEndAnimator.start();
            } else {
                this.cancelAnimatorImmediately();
            }
        }
    }

    void resetPropertiesForNewStart() {
        this.indicatorColorIndexOffset = 0;
        this.segmentColors[0] = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha());
        this.completeEndFraction = 0.0f;
    }

    void setAnimationFraction(float f) {
        this.animationFraction = f;
        int n = (int)(f * 5400.0f);
        this.updateSegmentPositions(n);
        this.maybeUpdateSegmentColors(n);
        this.drawable.invalidateSelf();
    }

    @Override
    void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
        this.animatorCompleteCallback = null;
    }
}

