/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.util.AttributeSet;
import com.google.android.material.R;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CircularProgressIndicator
extends BaseProgressIndicator<CircularProgressIndicatorSpec> {
    public static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_CircularProgressIndicator;
    public static final int INDICATOR_DIRECTION_CLOCKWISE = 0;
    public static final int INDICATOR_DIRECTION_COUNTERCLOCKWISE = 1;

    public CircularProgressIndicator(Context context) {
        this(context, null);
    }

    public CircularProgressIndicator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.circularProgressIndicatorStyle);
    }

    public CircularProgressIndicator(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n, DEF_STYLE_RES);
        this.initializeDrawables();
    }

    private void initializeDrawables() {
        this.setIndeterminateDrawable(IndeterminateDrawable.createCircularDrawable(this.getContext(), (CircularProgressIndicatorSpec)this.spec));
        this.setProgressDrawable(DeterminateDrawable.createCircularDrawable(this.getContext(), (CircularProgressIndicatorSpec)this.spec));
    }

    @Override
    CircularProgressIndicatorSpec createSpec(Context context, AttributeSet attributeSet) {
        return new CircularProgressIndicatorSpec(context, attributeSet);
    }

    public int getIndicatorDirection() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorDirection;
    }

    public int getIndicatorInset() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorInset;
    }

    public int getIndicatorSize() {
        return ((CircularProgressIndicatorSpec)this.spec).indicatorSize;
    }

    public void setIndicatorDirection(int n) {
        ((CircularProgressIndicatorSpec)this.spec).indicatorDirection = n;
        this.invalidate();
    }

    public void setIndicatorInset(int n) {
        if (((CircularProgressIndicatorSpec)this.spec).indicatorInset != n) {
            ((CircularProgressIndicatorSpec)this.spec).indicatorInset = n;
            this.invalidate();
        }
    }

    public void setIndicatorSize(int n) {
        if (((CircularProgressIndicatorSpec)this.spec).indicatorSize != (n = Math.max(n, this.getTrackThickness() * 2))) {
            ((CircularProgressIndicatorSpec)this.spec).indicatorSize = n;
            ((CircularProgressIndicatorSpec)this.spec).validateSpec();
            this.invalidate();
        }
    }

    @Override
    public void setTrackThickness(int n) {
        super.setTrackThickness(n);
        ((CircularProgressIndicatorSpec)this.spec).validateSpec();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicatorDirection {
    }
}

