/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularDrawingDelegate;
import com.google.android.material.progressindicator.CircularProgressIndicatorSpec;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearDrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

public final class DeterminateDrawable<S extends BaseProgressIndicatorSpec>
extends DrawableWithAnimatedVisibilityChange {
    private static final FloatPropertyCompat<DeterminateDrawable> INDICATOR_LENGTH_IN_LEVEL = new FloatPropertyCompat<DeterminateDrawable>("indicatorLevel"){

        public float getValue(DeterminateDrawable determinateDrawable) {
            return determinateDrawable.getIndicatorFraction() * 10000.0f;
        }

        public void setValue(DeterminateDrawable determinateDrawable, float f) {
            determinateDrawable.setIndicatorFraction(f / 10000.0f);
        }
    };
    private static final int MAX_DRAWABLE_LEVEL = 10000;
    private static final float SPRING_FORCE_STIFFNESS = 50.0f;
    private DrawingDelegate<S> drawingDelegate;
    private float indicatorFraction;
    private boolean skipAnimationOnLevelChange = false;
    private final SpringAnimation springAnimation;
    private final SpringForce springForce;

    DeterminateDrawable(Context context, BaseProgressIndicatorSpec baseProgressIndicatorSpec, DrawingDelegate<S> drawingDelegate) {
        super(context, baseProgressIndicatorSpec);
        this.setDrawingDelegate(drawingDelegate);
        context = new SpringForce();
        this.springForce = context;
        context.setDampingRatio(1.0f);
        context.setStiffness(50.0f);
        baseProgressIndicatorSpec = new SpringAnimation((Object)this, INDICATOR_LENGTH_IN_LEVEL);
        this.springAnimation = baseProgressIndicatorSpec;
        baseProgressIndicatorSpec.setSpring((SpringForce)context);
        this.setGrowFraction(1.0f);
    }

    public static DeterminateDrawable<CircularProgressIndicatorSpec> createCircularDrawable(Context context, CircularProgressIndicatorSpec circularProgressIndicatorSpec) {
        return new DeterminateDrawable<CircularProgressIndicatorSpec>(context, circularProgressIndicatorSpec, new CircularDrawingDelegate(circularProgressIndicatorSpec));
    }

    public static DeterminateDrawable<LinearProgressIndicatorSpec> createLinearDrawable(Context context, LinearProgressIndicatorSpec linearProgressIndicatorSpec) {
        return new DeterminateDrawable<LinearProgressIndicatorSpec>(context, linearProgressIndicatorSpec, new LinearDrawingDelegate(linearProgressIndicatorSpec));
    }

    private float getIndicatorFraction() {
        return this.indicatorFraction;
    }

    private void setIndicatorFraction(float f) {
        this.indicatorFraction = f;
        this.invalidateSelf();
    }

    public void addSpringAnimationEndListener(DynamicAnimation.OnAnimationEndListener onAnimationEndListener) {
        this.springAnimation.addEndListener(onAnimationEndListener);
    }

    public void draw(Canvas canvas) {
        Rect rect = new Rect();
        if (!this.getBounds().isEmpty() && this.isVisible() && canvas.getClipBounds(rect)) {
            canvas.save();
            this.drawingDelegate.validateSpecAndAdjustCanvas(canvas, this.getGrowFraction());
            this.drawingDelegate.fillTrack(canvas, this.paint);
            int n = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.getAlpha());
            this.drawingDelegate.fillIndicator(canvas, this.paint, 0.0f, this.getIndicatorFraction(), n);
            canvas.restore();
        }
    }

    DrawingDelegate<S> getDrawingDelegate() {
        return this.drawingDelegate;
    }

    public int getIntrinsicHeight() {
        return this.drawingDelegate.getPreferredHeight();
    }

    public int getIntrinsicWidth() {
        return this.drawingDelegate.getPreferredWidth();
    }

    public void jumpToCurrentState() {
        this.springAnimation.skipToEnd();
        this.setIndicatorFraction((float)this.getLevel() / 10000.0f);
    }

    protected boolean onLevelChange(int n) {
        if (this.skipAnimationOnLevelChange) {
            this.springAnimation.skipToEnd();
            this.setIndicatorFraction((float)n / 10000.0f);
        } else {
            this.springAnimation.setStartValue(this.getIndicatorFraction() * 10000.0f);
            this.springAnimation.animateToFinalPosition((float)n);
        }
        return true;
    }

    public void removeSpringAnimationEndListener(DynamicAnimation.OnAnimationEndListener onAnimationEndListener) {
        this.springAnimation.removeEndListener(onAnimationEndListener);
    }

    void setDrawingDelegate(DrawingDelegate<S> drawingDelegate) {
        this.drawingDelegate = drawingDelegate;
        drawingDelegate.registerDrawable(this);
    }

    void setLevelByFraction(float f) {
        this.setLevel((int)(f * 10000.0f));
    }

    @Override
    boolean setVisibleInternal(boolean bl, boolean bl2, boolean bl3) {
        bl = super.setVisibleInternal(bl, bl2, bl3);
        float f = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        if (f == 0.0f) {
            this.skipAnimationOnLevelChange = true;
        } else {
            this.skipAnimationOnLevelChange = false;
            this.springForce.setStiffness(50.0f / f);
        }
        return bl;
    }
}

