/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Property;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.progressindicator.AnimatorDurationScaleProvider;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import java.util.ArrayList;
import java.util.List;

abstract class DrawableWithAnimatedVisibilityChange
extends Drawable
implements Animatable2Compat {
    private static final boolean DEFAULT_DRAWABLE_RESTART = false;
    private static final int GROW_DURATION = 500;
    private static final Property<DrawableWithAnimatedVisibilityChange, Float> GROW_FRACTION = new Property<DrawableWithAnimatedVisibilityChange, Float>(Float.class, "growFraction"){

        public Float get(DrawableWithAnimatedVisibilityChange drawableWithAnimatedVisibilityChange) {
            return Float.valueOf(drawableWithAnimatedVisibilityChange.getGrowFraction());
        }

        public void set(DrawableWithAnimatedVisibilityChange drawableWithAnimatedVisibilityChange, Float f) {
            drawableWithAnimatedVisibilityChange.setGrowFraction(f.floatValue());
        }
    };
    private List<Animatable2Compat.AnimationCallback> animationCallbacks;
    AnimatorDurationScaleProvider animatorDurationScaleProvider;
    final BaseProgressIndicatorSpec baseSpec;
    final Context context;
    private float growFraction;
    private ValueAnimator hideAnimator;
    private boolean ignoreCallbacks;
    private Animatable2Compat.AnimationCallback internalAnimationCallback;
    private float mockGrowFraction;
    private boolean mockHideAnimationRunning;
    private boolean mockShowAnimationRunning;
    final Paint paint = new Paint();
    private ValueAnimator showAnimator;
    private int totalAlpha;

    DrawableWithAnimatedVisibilityChange(Context context, BaseProgressIndicatorSpec baseProgressIndicatorSpec) {
        this.context = context;
        this.baseSpec = baseProgressIndicatorSpec;
        this.animatorDurationScaleProvider = new AnimatorDurationScaleProvider();
        this.setAlpha(255);
    }

    private void dispatchAnimationEnd() {
        Object object = this.internalAnimationCallback;
        if (object != null) {
            object.onAnimationEnd((Drawable)this);
        }
        if ((object = this.animationCallbacks) != null && !this.ignoreCallbacks) {
            object = object.iterator();
            while (object.hasNext()) {
                ((Animatable2Compat.AnimationCallback)object.next()).onAnimationEnd((Drawable)this);
            }
        }
    }

    private void dispatchAnimationStart() {
        Object object = this.internalAnimationCallback;
        if (object != null) {
            object.onAnimationStart((Drawable)this);
        }
        if ((object = this.animationCallbacks) != null && !this.ignoreCallbacks) {
            object = object.iterator();
            while (object.hasNext()) {
                ((Animatable2Compat.AnimationCallback)object.next()).onAnimationStart((Drawable)this);
            }
        }
    }

    private void endAnimatorWithoutCallbacks(ValueAnimator ... valueAnimatorArray) {
        boolean bl = this.ignoreCallbacks;
        this.ignoreCallbacks = true;
        int n = valueAnimatorArray.length;
        for (int i = 0; i < n; ++i) {
            valueAnimatorArray[i].end();
        }
        this.ignoreCallbacks = bl;
    }

    private void maybeInitializeAnimators() {
        ObjectAnimator objectAnimator;
        if (this.showAnimator == null) {
            objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), GROW_FRACTION, (float[])new float[]{0.0f, 1.0f});
            this.showAnimator = objectAnimator;
            objectAnimator.setDuration(500L);
            this.showAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.setShowAnimator(this.showAnimator);
        }
        if (this.hideAnimator == null) {
            objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), GROW_FRACTION, (float[])new float[]{1.0f, 0.0f});
            this.hideAnimator = objectAnimator;
            objectAnimator.setDuration(500L);
            this.hideAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.setHideAnimator(this.hideAnimator);
        }
    }

    private void setHideAnimator(ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = this.hideAnimator;
        if (valueAnimator2 != null && valueAnimator2.isRunning()) {
            throw new IllegalArgumentException("Cannot set hideAnimator while the current hideAnimator is running.");
        }
        this.hideAnimator = valueAnimator;
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                super.onAnimationEnd(animator2);
                DrawableWithAnimatedVisibilityChange.super.setVisible(false, false);
                DrawableWithAnimatedVisibilityChange.this.dispatchAnimationEnd();
            }
        });
    }

    private void setShowAnimator(ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = this.showAnimator;
        if (valueAnimator2 != null && valueAnimator2.isRunning()) {
            throw new IllegalArgumentException("Cannot set showAnimator while the current showAnimator is running.");
        }
        this.showAnimator = valueAnimator;
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                super.onAnimationStart(animator2);
                DrawableWithAnimatedVisibilityChange.this.dispatchAnimationStart();
            }
        });
    }

    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
        this.animationCallbacks = null;
    }

    public int getAlpha() {
        return this.totalAlpha;
    }

    float getGrowFraction() {
        if (!this.baseSpec.isShowAnimationEnabled() && !this.baseSpec.isHideAnimationEnabled()) {
            return 1.0f;
        }
        if (!this.mockHideAnimationRunning && !this.mockShowAnimationRunning) {
            return this.growFraction;
        }
        return this.mockGrowFraction;
    }

    ValueAnimator getHideAnimator() {
        return this.hideAnimator;
    }

    public int getOpacity() {
        return -3;
    }

    public boolean hideNow() {
        return this.setVisible(false, false, false);
    }

    public boolean isHiding() {
        ValueAnimator valueAnimator = this.hideAnimator;
        boolean bl = valueAnimator != null && valueAnimator.isRunning() || this.mockHideAnimationRunning;
        return bl;
    }

    public boolean isRunning() {
        boolean bl = this.isShowing() || this.isHiding();
        return bl;
    }

    public boolean isShowing() {
        ValueAnimator valueAnimator = this.showAnimator;
        boolean bl = valueAnimator != null && valueAnimator.isRunning() || this.mockShowAnimationRunning;
        return bl;
    }

    public void registerAnimationCallback(Animatable2Compat.AnimationCallback animationCallback) {
        if (this.animationCallbacks == null) {
            this.animationCallbacks = new ArrayList<Animatable2Compat.AnimationCallback>();
        }
        if (!this.animationCallbacks.contains(animationCallback)) {
            this.animationCallbacks.add(animationCallback);
        }
    }

    public void setAlpha(int n) {
        this.totalAlpha = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    void setGrowFraction(float f) {
        if (this.growFraction != f) {
            this.growFraction = f;
            this.invalidateSelf();
        }
    }

    void setInternalAnimationCallback(Animatable2Compat.AnimationCallback animationCallback) {
        this.internalAnimationCallback = animationCallback;
    }

    void setMockHideAnimationRunning(boolean bl, float f) {
        this.mockHideAnimationRunning = bl;
        this.mockGrowFraction = f;
    }

    void setMockShowAnimationRunning(boolean bl, float f) {
        this.mockShowAnimationRunning = bl;
        this.mockGrowFraction = f;
    }

    public boolean setVisible(boolean bl, boolean bl2) {
        return this.setVisible(bl, bl2, true);
    }

    public boolean setVisible(boolean bl, boolean bl2, boolean bl3) {
        float f = this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.context.getContentResolver());
        bl3 = bl3 && f > 0.0f;
        return this.setVisibleInternal(bl, bl2, bl3);
    }

    boolean setVisibleInternal(boolean bl, boolean bl2, boolean bl3) {
        this.maybeInitializeAnimators();
        if (!this.isVisible() && !bl) {
            return false;
        }
        ValueAnimator valueAnimator = bl ? this.showAnimator : this.hideAnimator;
        if (!bl3) {
            if (valueAnimator.isRunning()) {
                valueAnimator.end();
            } else {
                this.endAnimatorWithoutCallbacks(valueAnimator);
            }
            return super.setVisible(bl, false);
        }
        if (bl3 && valueAnimator.isRunning()) {
            return false;
        }
        bl3 = !bl || super.setVisible(bl, false);
        bl = bl ? this.baseSpec.isShowAnimationEnabled() : this.baseSpec.isHideAnimationEnabled();
        if (!bl) {
            this.endAnimatorWithoutCallbacks(valueAnimator);
            return bl3;
        }
        if (!bl2 && Build.VERSION.SDK_INT >= 19 && valueAnimator.isPaused()) {
            valueAnimator.resume();
        } else {
            valueAnimator.start();
        }
        return bl3;
    }

    public void start() {
        this.setVisibleInternal(true, true, false);
    }

    public void stop() {
        this.setVisibleInternal(false, true, false);
    }

    public boolean unregisterAnimationCallback(Animatable2Compat.AnimationCallback animationCallback) {
        List<Animatable2Compat.AnimationCallback> list = this.animationCallbacks;
        if (list != null && list.contains(animationCallback)) {
            this.animationCallbacks.remove(animationCallback);
            if (this.animationCallbacks.isEmpty()) {
                this.animationCallbacks = null;
            }
            return true;
        }
        return false;
    }
}

