/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;

final class LinearDrawingDelegate
extends DrawingDelegate<LinearProgressIndicatorSpec> {
    private float displayedCornerRadius;
    private float displayedTrackThickness;
    private float trackLength = 300.0f;

    public LinearDrawingDelegate(LinearProgressIndicatorSpec linearProgressIndicatorSpec) {
        super(linearProgressIndicatorSpec);
    }

    @Override
    public void adjustCanvas(Canvas canvas, float f) {
        Rect rect = canvas.getClipBounds();
        this.trackLength = rect.width();
        float f2 = ((LinearProgressIndicatorSpec)this.spec).trackThickness;
        canvas.translate((float)rect.left + (float)rect.width() / 2.0f, (float)rect.top + (float)rect.height() / 2.0f + Math.max(0.0f, (float)(rect.height() - ((LinearProgressIndicatorSpec)this.spec).trackThickness) / 2.0f));
        if (((LinearProgressIndicatorSpec)this.spec).drawHorizontallyInverse) {
            canvas.scale(-1.0f, 1.0f);
        }
        if (this.drawable.isShowing() && ((LinearProgressIndicatorSpec)this.spec).showAnimationBehavior == 1 || this.drawable.isHiding() && ((LinearProgressIndicatorSpec)this.spec).hideAnimationBehavior == 2) {
            canvas.scale(1.0f, -1.0f);
        }
        if (this.drawable.isShowing() || this.drawable.isHiding()) {
            canvas.translate(0.0f, (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * (f - 1.0f) / 2.0f);
        }
        float f3 = this.trackLength;
        canvas.clipRect(-f3 / 2.0f, -f2 / 2.0f, f3 / 2.0f, f2 / 2.0f);
        this.displayedTrackThickness = (float)((LinearProgressIndicatorSpec)this.spec).trackThickness * f;
        this.displayedCornerRadius = (float)((LinearProgressIndicatorSpec)this.spec).trackCornerRadius * f;
    }

    @Override
    public void fillIndicator(Canvas canvas, Paint paint, float f, float f2, int n) {
        if (f == f2) {
            return;
        }
        float f3 = this.trackLength;
        float f4 = -f3 / 2.0f;
        float f5 = this.displayedCornerRadius;
        float f6 = -f3 / 2.0f;
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setColor(n);
        float f7 = this.displayedTrackThickness;
        RectF rectF = new RectF(f4 + f * (f3 - f5 * 2.0f), -f7 / 2.0f, f6 + f2 * (f3 - f5 * 2.0f) + f5 * 2.0f, f7 / 2.0f);
        f = this.displayedCornerRadius;
        canvas.drawRoundRect(rectF, f, f, paint);
    }

    @Override
    void fillTrack(Canvas canvas, Paint paint) {
        int n = MaterialColors.compositeARGBWithAlpha(((LinearProgressIndicatorSpec)this.spec).trackColor, this.drawable.getAlpha());
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setColor(n);
        float f = this.trackLength;
        float f2 = -f / 2.0f;
        float f3 = this.displayedTrackThickness;
        RectF rectF = new RectF(f2, -f3 / 2.0f, f / 2.0f, f3 / 2.0f);
        f = this.displayedCornerRadius;
        canvas.drawRoundRect(rectF, f, f, paint);
    }

    @Override
    public int getPreferredHeight() {
        return ((LinearProgressIndicatorSpec)this.spec).trackThickness;
    }

    @Override
    public int getPreferredWidth() {
        return -1;
    }
}

