/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.Property;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.util.Arrays;

final class LinearIndeterminateContiguousAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final Property<LinearIndeterminateContiguousAnimatorDelegate, Float> ANIMATION_FRACTION = new Property<LinearIndeterminateContiguousAnimatorDelegate, Float>(Float.class, "animationFraction"){

        public Float get(LinearIndeterminateContiguousAnimatorDelegate linearIndeterminateContiguousAnimatorDelegate) {
            return Float.valueOf(linearIndeterminateContiguousAnimatorDelegate.getAnimationFraction());
        }

        public void set(LinearIndeterminateContiguousAnimatorDelegate linearIndeterminateContiguousAnimatorDelegate, Float f) {
            linearIndeterminateContiguousAnimatorDelegate.setAnimationFraction(f.floatValue());
        }
    };
    private static final int DURATION_PER_CYCLE_IN_MS = 333;
    private static final int TOTAL_DURATION_IN_MS = 667;
    private float animationFraction;
    private ObjectAnimator animator;
    private final BaseProgressIndicatorSpec baseSpec;
    private boolean dirtyColors;
    private FastOutSlowInInterpolator interpolator;
    private int newIndicatorColorIndex = 1;

    public LinearIndeterminateContiguousAnimatorDelegate(LinearProgressIndicatorSpec linearProgressIndicatorSpec) {
        super(3);
        this.baseSpec = linearProgressIndicatorSpec;
        this.interpolator = new FastOutSlowInInterpolator();
    }

    static /* synthetic */ int access$002(LinearIndeterminateContiguousAnimatorDelegate linearIndeterminateContiguousAnimatorDelegate, int n) {
        linearIndeterminateContiguousAnimatorDelegate.newIndicatorColorIndex = n;
        return n;
    }

    static /* synthetic */ boolean access$202(LinearIndeterminateContiguousAnimatorDelegate linearIndeterminateContiguousAnimatorDelegate, boolean bl) {
        linearIndeterminateContiguousAnimatorDelegate.dirtyColors = bl;
        return bl;
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    private void maybeInitializeAnimators() {
        if (this.animator == null) {
            ObjectAnimator objectAnimator;
            this.animator = objectAnimator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setDuration(333L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator object) {
                    super.onAnimationRepeat(object);
                    object = LinearIndeterminateContiguousAnimatorDelegate.this;
                    LinearIndeterminateContiguousAnimatorDelegate.access$002((LinearIndeterminateContiguousAnimatorDelegate)object, (((LinearIndeterminateContiguousAnimatorDelegate)object).newIndicatorColorIndex + 1) % ((LinearIndeterminateContiguousAnimatorDelegate)LinearIndeterminateContiguousAnimatorDelegate.this).baseSpec.indicatorColors.length);
                    LinearIndeterminateContiguousAnimatorDelegate.access$202(LinearIndeterminateContiguousAnimatorDelegate.this, true);
                }
            });
        }
    }

    private void maybeUpdateSegmentColors() {
        if (this.dirtyColors && this.segmentPositions[3] < 1.0f) {
            this.segmentColors[2] = this.segmentColors[1];
            this.segmentColors[1] = this.segmentColors[0];
            this.segmentColors[0] = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[this.newIndicatorColorIndex], this.drawable.getAlpha());
            this.dirtyColors = false;
        }
    }

    private void updateSegmentPositions(int n) {
        float f;
        this.segmentPositions[0] = 0.0f;
        float f2 = this.getFractionInRange(n, 0, 667);
        float[] fArray = this.segmentPositions;
        float[] fArray2 = this.segmentPositions;
        fArray2[2] = f = this.interpolator.getInterpolation(f2);
        fArray[1] = f;
        fArray2 = this.segmentPositions;
        fArray = this.segmentPositions;
        fArray[4] = f = this.interpolator.getInterpolation(f2 + 0.49925038f);
        fArray2[3] = f;
        this.segmentPositions[5] = 1.0f;
    }

    @Override
    public void cancelAnimatorImmediately() {
        ObjectAnimator objectAnimator = this.animator;
        if (objectAnimator != null) {
            objectAnimator.cancel();
        }
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(Animatable2Compat.AnimationCallback animationCallback) {
    }

    @Override
    public void requestCancelAnimatorAfterCurrentCycle() {
    }

    void resetPropertiesForNewStart() {
        this.dirtyColors = true;
        this.newIndicatorColorIndex = 1;
        Arrays.fill(this.segmentColors, MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha()));
    }

    void setAnimationFraction(float f) {
        this.animationFraction = f;
        this.updateSegmentPositions((int)(f * 333.0f));
        this.maybeUpdateSegmentColors();
        this.drawable.invalidateSelf();
    }

    @Override
    public void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
    }
}

