/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import com.google.android.material.progressindicator.LinearIndeterminateContiguousAnimatorDelegate;
import com.google.android.material.progressindicator.LinearIndeterminateDisjointAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class LinearProgressIndicator
extends BaseProgressIndicator<LinearProgressIndicatorSpec> {
    public static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_LinearProgressIndicator;
    public static final int INDETERMINATE_ANIMATION_TYPE_CONTIGUOUS = 0;
    public static final int INDETERMINATE_ANIMATION_TYPE_DISJOINT = 1;
    public static final int INDICATOR_DIRECTION_END_TO_START = 3;
    public static final int INDICATOR_DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int INDICATOR_DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int INDICATOR_DIRECTION_START_TO_END = 2;

    public LinearProgressIndicator(Context context) {
        this(context, null);
    }

    public LinearProgressIndicator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.linearProgressIndicatorStyle);
    }

    public LinearProgressIndicator(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n, DEF_STYLE_RES);
        this.initializeDrawables();
    }

    private void initializeDrawables() {
        this.setIndeterminateDrawable(IndeterminateDrawable.createLinearDrawable(this.getContext(), (LinearProgressIndicatorSpec)this.spec));
        this.setProgressDrawable(DeterminateDrawable.createLinearDrawable(this.getContext(), (LinearProgressIndicatorSpec)this.spec));
    }

    @Override
    LinearProgressIndicatorSpec createSpec(Context context, AttributeSet attributeSet) {
        return new LinearProgressIndicatorSpec(context, attributeSet);
    }

    public int getIndeterminateAnimationType() {
        return ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType;
    }

    public int getIndicatorDirection() {
        return ((LinearProgressIndicatorSpec)this.spec).indicatorDirection;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        block2: {
            boolean bl2;
            block3: {
                super.onLayout(bl, n, n2, n3, n4);
                LinearProgressIndicatorSpec linearProgressIndicatorSpec = (LinearProgressIndicatorSpec)this.spec;
                n = ((LinearProgressIndicatorSpec)this.spec).indicatorDirection;
                bl = bl2 = true;
                if (n == 1) break block2;
                if (ViewCompat.getLayoutDirection((View)this) != 1) break block3;
                bl = bl2;
                if (((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 2) break block2;
            }
            bl = ViewCompat.getLayoutDirection((View)this) == 0 && ((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 3 ? bl2 : false;
        }
        linearProgressIndicatorSpec.drawHorizontallyInverse = bl;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        n -= this.getPaddingLeft() + this.getPaddingRight();
        n2 -= this.getPaddingTop() + this.getPaddingBottom();
        Drawable drawable2 = this.getIndeterminateDrawable();
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, n, n2);
        }
        if ((drawable2 = this.getProgressDrawable()) != null) {
            drawable2.setBounds(0, 0, n, n2);
        }
    }

    public void setIndeterminateAnimationType(int n) {
        if (((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType == n) {
            return;
        }
        if (this.visibleToUser() && this.isIndeterminate()) {
            throw new IllegalStateException("Cannot change indeterminate animation type while the progress indicator is show in indeterminate mode.");
        }
        ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType = n;
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
        if (n == 0) {
            this.getIndeterminateDrawable().setAnimatorDelegate(new LinearIndeterminateContiguousAnimatorDelegate((LinearProgressIndicatorSpec)this.spec));
        } else {
            this.getIndeterminateDrawable().setAnimatorDelegate(new LinearIndeterminateDisjointAnimatorDelegate(this.getContext(), (LinearProgressIndicatorSpec)this.spec));
        }
        this.invalidate();
    }

    @Override
    public void setIndicatorColor(int ... nArray) {
        super.setIndicatorColor(nArray);
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
    }

    public void setIndicatorDirection(int n) {
        boolean bl;
        block2: {
            boolean bl2;
            block3: {
                ((LinearProgressIndicatorSpec)this.spec).indicatorDirection = n;
                LinearProgressIndicatorSpec linearProgressIndicatorSpec = (LinearProgressIndicatorSpec)this.spec;
                bl = bl2 = true;
                if (n == 1) break block2;
                if (ViewCompat.getLayoutDirection((View)this) != 1) break block3;
                bl = bl2;
                if (((LinearProgressIndicatorSpec)this.spec).indicatorDirection == 2) break block2;
            }
            bl = ViewCompat.getLayoutDirection((View)this) == 0 && n == 3 ? bl2 : false;
        }
        linearProgressIndicatorSpec.drawHorizontallyInverse = bl;
        this.invalidate();
    }

    @Override
    public void setProgressCompat(int n, boolean bl) {
        if (this.spec != null && ((LinearProgressIndicatorSpec)this.spec).indeterminateAnimationType == 0 && this.isIndeterminate()) {
            return;
        }
        super.setProgressCompat(n, bl);
    }

    @Override
    public void setTrackCornerRadius(int n) {
        super.setTrackCornerRadius(n);
        ((LinearProgressIndicatorSpec)this.spec).validateSpec();
        this.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndeterminateAnimationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IndicatorDirection {
    }
}

