/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.util.AttributeSet;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.LinearProgressIndicator;

public final class LinearProgressIndicatorSpec
extends BaseProgressIndicatorSpec {
    boolean drawHorizontallyInverse;
    public int indeterminateAnimationType;
    public int indicatorDirection;

    public LinearProgressIndicatorSpec(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.linearProgressIndicatorStyle);
    }

    public LinearProgressIndicatorSpec(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, LinearProgressIndicator.DEF_STYLE_RES);
    }

    public LinearProgressIndicatorSpec(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int[] nArray = R.styleable.LinearProgressIndicator;
        n2 = R.attr.linearProgressIndicatorStyle;
        n = LinearProgressIndicator.DEF_STYLE_RES;
        boolean bl = false;
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, nArray, n2, n, new int[0]);
        this.indeterminateAnimationType = context.getInt(R.styleable.LinearProgressIndicator_indeterminateAnimationType, 1);
        this.indicatorDirection = context.getInt(R.styleable.LinearProgressIndicator_indicatorDirectionLinear, 0);
        context.recycle();
        this.validateSpec();
        if (this.indicatorDirection == 1) {
            bl = true;
        }
        this.drawHorizontallyInverse = bl;
    }

    @Override
    void validateSpec() {
        if (this.indeterminateAnimationType == 0) {
            if (this.trackCornerRadius <= 0) {
                if (this.indicatorColors.length < 3) {
                    throw new IllegalArgumentException("Contiguous indeterminate animation must be used with 3 or more indicator colors.");
                }
            } else {
                throw new IllegalArgumentException("Rounded corners are not supported in contiguous indeterminate animation.");
            }
        }
    }
}

