/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shadow;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import androidx.core.graphics.ColorUtils;

public class ShadowRenderer {
    private static final int COLOR_ALPHA_END = 0;
    private static final int COLOR_ALPHA_MIDDLE = 20;
    private static final int COLOR_ALPHA_START = 68;
    private static final int[] cornerColors;
    private static final float[] cornerPositions;
    private static final int[] edgeColors;
    private static final float[] edgePositions;
    private final Paint cornerShadowPaint;
    private final Paint edgeShadowPaint;
    private final Path scratch = new Path();
    private int shadowEndColor;
    private int shadowMiddleColor;
    private final Paint shadowPaint;
    private int shadowStartColor;
    private Paint transparentPaint = new Paint();

    static {
        edgeColors = new int[3];
        edgePositions = new float[]{0.0f, 0.5f, 1.0f};
        cornerColors = new int[4];
        cornerPositions = new float[]{0.0f, 0.0f, 0.5f, 1.0f};
    }

    public ShadowRenderer() {
        this(-16777216);
    }

    public ShadowRenderer(int n) {
        Paint paint;
        this.shadowPaint = new Paint();
        this.setShadowColor(n);
        this.transparentPaint.setColor(0);
        this.cornerShadowPaint = paint = new Paint(4);
        paint.setStyle(Paint.Style.FILL);
        this.edgeShadowPaint = new Paint(paint);
    }

    public void drawCornerShadow(Canvas canvas, Matrix matrix, RectF rectF, int n, float f, float f2) {
        float f3;
        Object object;
        boolean bl = f2 < 0.0f;
        Path path = this.scratch;
        if (bl) {
            object = cornerColors;
            object[0] = 0;
            object[1] = this.shadowEndColor;
            object[2] = this.shadowMiddleColor;
            object[3] = this.shadowStartColor;
        } else {
            path.rewind();
            path.moveTo(rectF.centerX(), rectF.centerY());
            path.arcTo(rectF, f, f2);
            path.close();
            f3 = -n;
            rectF.inset(f3, f3);
            object = cornerColors;
            object[0] = 0;
            object[1] = this.shadowStartColor;
            object[2] = this.shadowMiddleColor;
            object[3] = this.shadowEndColor;
        }
        float f4 = rectF.width() / 2.0f;
        if (f4 <= 0.0f) {
            return;
        }
        float f5 = 1.0f - (float)n / f4;
        f3 = (1.0f - f5) / 2.0f;
        object = cornerPositions;
        object[1] = (int)f5;
        object[2] = (int)(f3 + f5);
        object = new RadialGradient(rectF.centerX(), rectF.centerY(), f4, cornerColors, (float[])object, Shader.TileMode.CLAMP);
        this.cornerShadowPaint.setShader((Shader)object);
        canvas.save();
        canvas.concat(matrix);
        canvas.scale(1.0f, rectF.height() / rectF.width());
        if (!bl) {
            canvas.clipPath(path, Region.Op.DIFFERENCE);
            canvas.drawPath(path, this.transparentPaint);
        }
        canvas.drawArc(rectF, f, f2, true, this.cornerShadowPaint);
        canvas.restore();
    }

    public void drawEdgeShadow(Canvas canvas, Matrix matrix, RectF rectF, int n) {
        rectF.bottom += (float)n;
        rectF.offset(0.0f, (float)(-n));
        int[] nArray = edgeColors;
        nArray[0] = this.shadowEndColor;
        nArray[1] = this.shadowMiddleColor;
        nArray[2] = this.shadowStartColor;
        this.edgeShadowPaint.setShader((Shader)new LinearGradient(rectF.left, rectF.top, rectF.left, rectF.bottom, nArray, edgePositions, Shader.TileMode.CLAMP));
        canvas.save();
        canvas.concat(matrix);
        canvas.drawRect(rectF, this.edgeShadowPaint);
        canvas.restore();
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowColor(int n) {
        this.shadowStartColor = ColorUtils.setAlphaComponent((int)n, (int)68);
        this.shadowMiddleColor = ColorUtils.setAlphaComponent((int)n, (int)20);
        this.shadowEndColor = ColorUtils.setAlphaComponent((int)n, (int)0);
        this.shadowPaint.setColor(this.shadowStartColor);
    }
}

