/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.RectF;
import com.google.android.material.shape.CornerSize;
import java.util.Arrays;

public final class AdjustedCornerSize
implements CornerSize {
    private final float adjustment;
    private final CornerSize other;

    public AdjustedCornerSize(float f, CornerSize cornerSize) {
        while (cornerSize instanceof AdjustedCornerSize) {
            cornerSize = ((AdjustedCornerSize)cornerSize).other;
            f += ((AdjustedCornerSize)cornerSize).adjustment;
        }
        this.other = cornerSize;
        this.adjustment = f;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdjustedCornerSize)) {
            return false;
        }
        object = (AdjustedCornerSize)object;
        if (!this.other.equals(((AdjustedCornerSize)object).other) || this.adjustment != ((AdjustedCornerSize)object).adjustment) {
            bl = false;
        }
        return bl;
    }

    @Override
    public float getCornerSize(RectF rectF) {
        return Math.max(0.0f, this.other.getCornerSize(rectF) + this.adjustment);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.other, Float.valueOf(this.adjustment)});
    }
}

