/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapePath;

public class ShapeAppearancePathProvider {
    private final Path boundsPath;
    private final Path cornerPath;
    private final ShapePath[] cornerPaths = new ShapePath[4];
    private final Matrix[] cornerTransforms = new Matrix[4];
    private boolean edgeIntersectionCheckEnabled = true;
    private final Path edgePath;
    private final Matrix[] edgeTransforms = new Matrix[4];
    private final Path overlappedEdgePath;
    private final PointF pointF = new PointF();
    private final float[] scratch;
    private final float[] scratch2;
    private final ShapePath shapePath;

    public ShapeAppearancePathProvider() {
        this.overlappedEdgePath = new Path();
        this.boundsPath = new Path();
        this.shapePath = new ShapePath();
        this.scratch = new float[2];
        this.scratch2 = new float[2];
        this.edgePath = new Path();
        this.cornerPath = new Path();
        for (int i = 0; i < 4; ++i) {
            this.cornerPaths[i] = new ShapePath();
            this.cornerTransforms[i] = new Matrix();
            this.edgeTransforms[i] = new Matrix();
        }
    }

    private float angleOfEdge(int n) {
        return (n + 1) * 90;
    }

    private void appendCornerPath(ShapeAppearancePathSpec shapeAppearancePathSpec, int n) {
        this.scratch[0] = this.cornerPaths[n].getStartX();
        this.scratch[1] = this.cornerPaths[n].getStartY();
        this.cornerTransforms[n].mapPoints(this.scratch);
        if (n == 0) {
            Path path = shapeAppearancePathSpec.path;
            float[] fArray = this.scratch;
            path.moveTo(fArray[0], fArray[1]);
        } else {
            Path path = shapeAppearancePathSpec.path;
            float[] fArray = this.scratch;
            path.lineTo(fArray[0], fArray[1]);
        }
        this.cornerPaths[n].applyToPath(this.cornerTransforms[n], shapeAppearancePathSpec.path);
        if (shapeAppearancePathSpec.pathListener != null) {
            shapeAppearancePathSpec.pathListener.onCornerPathCreated(this.cornerPaths[n], this.cornerTransforms[n], n);
        }
    }

    private void appendEdgePath(ShapeAppearancePathSpec shapeAppearancePathSpec, int n) {
        int n2 = (n + 1) % 4;
        this.scratch[0] = this.cornerPaths[n].getEndX();
        this.scratch[1] = this.cornerPaths[n].getEndY();
        this.cornerTransforms[n].mapPoints(this.scratch);
        this.scratch2[0] = this.cornerPaths[n2].getStartX();
        this.scratch2[1] = this.cornerPaths[n2].getStartY();
        this.cornerTransforms[n2].mapPoints(this.scratch2);
        Object object = this.scratch;
        float f = object[0];
        Object object2 = this.scratch2;
        f = Math.max((float)Math.hypot(f - object2[0], object[1] - object2[1]) - 0.001f, 0.0f);
        float f2 = this.getEdgeCenterForIndex(shapeAppearancePathSpec.bounds, n);
        this.shapePath.reset(0.0f, 0.0f);
        object = this.getEdgeTreatmentForIndex(n, shapeAppearancePathSpec.shapeAppearanceModel);
        object.getEdgePath(f, f2, shapeAppearancePathSpec.interpolation, this.shapePath);
        this.edgePath.reset();
        this.shapePath.applyToPath(this.edgeTransforms[n], this.edgePath);
        if (this.edgeIntersectionCheckEnabled && Build.VERSION.SDK_INT >= 19 && (object.forceIntersection() || this.pathOverlapsCorner(this.edgePath, n) || this.pathOverlapsCorner(this.edgePath, n2))) {
            object = this.edgePath;
            object.op((Path)object, this.boundsPath, Path.Op.DIFFERENCE);
            this.scratch[0] = this.shapePath.getStartX();
            this.scratch[1] = this.shapePath.getStartY();
            this.edgeTransforms[n].mapPoints(this.scratch);
            object2 = this.overlappedEdgePath;
            object = this.scratch;
            object2.moveTo(object[0], object[1]);
            this.shapePath.applyToPath(this.edgeTransforms[n], this.overlappedEdgePath);
        } else {
            this.shapePath.applyToPath(this.edgeTransforms[n], shapeAppearancePathSpec.path);
        }
        if (shapeAppearancePathSpec.pathListener != null) {
            shapeAppearancePathSpec.pathListener.onEdgePathCreated(this.shapePath, this.edgeTransforms[n], n);
        }
    }

    private void getCoordinatesOfCorner(int n, RectF rectF, PointF pointF) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    pointF.set(rectF.right, rectF.top);
                } else {
                    pointF.set(rectF.left, rectF.top);
                }
            } else {
                pointF.set(rectF.left, rectF.bottom);
            }
        } else {
            pointF.set(rectF.right, rectF.bottom);
        }
    }

    private CornerSize getCornerSizeForIndex(int n, ShapeAppearanceModel shapeAppearanceModel) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return shapeAppearanceModel.getTopRightCornerSize();
                }
                return shapeAppearanceModel.getTopLeftCornerSize();
            }
            return shapeAppearanceModel.getBottomLeftCornerSize();
        }
        return shapeAppearanceModel.getBottomRightCornerSize();
    }

    private CornerTreatment getCornerTreatmentForIndex(int n, ShapeAppearanceModel shapeAppearanceModel) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return shapeAppearanceModel.getTopRightCorner();
                }
                return shapeAppearanceModel.getTopLeftCorner();
            }
            return shapeAppearanceModel.getBottomLeftCorner();
        }
        return shapeAppearanceModel.getBottomRightCorner();
    }

    private float getEdgeCenterForIndex(RectF rectF, int n) {
        this.scratch[0] = this.cornerPaths[n].endX;
        this.scratch[1] = this.cornerPaths[n].endY;
        this.cornerTransforms[n].mapPoints(this.scratch);
        if (n != 1 && n != 3) {
            return Math.abs(rectF.centerY() - this.scratch[1]);
        }
        return Math.abs(rectF.centerX() - this.scratch[0]);
    }

    private EdgeTreatment getEdgeTreatmentForIndex(int n, ShapeAppearanceModel shapeAppearanceModel) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return shapeAppearanceModel.getRightEdge();
                }
                return shapeAppearanceModel.getTopEdge();
            }
            return shapeAppearanceModel.getLeftEdge();
        }
        return shapeAppearanceModel.getBottomEdge();
    }

    public static ShapeAppearancePathProvider getInstance() {
        return Lazy.INSTANCE;
    }

    private boolean pathOverlapsCorner(Path path, int n) {
        this.cornerPath.reset();
        this.cornerPaths[n].applyToPath(this.cornerTransforms[n], this.cornerPath);
        RectF rectF = new RectF();
        boolean bl = true;
        path.computeBounds(rectF, true);
        this.cornerPath.computeBounds(rectF, true);
        path.op(this.cornerPath, Path.Op.INTERSECT);
        path.computeBounds(rectF, true);
        boolean bl2 = bl;
        if (rectF.isEmpty()) {
            bl2 = rectF.width() > 1.0f && rectF.height() > 1.0f ? bl : false;
        }
        return bl2;
    }

    private void setCornerPathAndTransform(ShapeAppearancePathSpec shapeAppearancePathSpec, int n) {
        CornerSize cornerSize = this.getCornerSizeForIndex(n, shapeAppearancePathSpec.shapeAppearanceModel);
        this.getCornerTreatmentForIndex(n, shapeAppearancePathSpec.shapeAppearanceModel).getCornerPath(this.cornerPaths[n], 90.0f, shapeAppearancePathSpec.interpolation, shapeAppearancePathSpec.bounds, cornerSize);
        float f = this.angleOfEdge(n);
        this.cornerTransforms[n].reset();
        this.getCoordinatesOfCorner(n, shapeAppearancePathSpec.bounds, this.pointF);
        this.cornerTransforms[n].setTranslate(this.pointF.x, this.pointF.y);
        this.cornerTransforms[n].preRotate(f);
    }

    private void setEdgePathAndTransform(int n) {
        this.scratch[0] = this.cornerPaths[n].getEndX();
        this.scratch[1] = this.cornerPaths[n].getEndY();
        this.cornerTransforms[n].mapPoints(this.scratch);
        float f = this.angleOfEdge(n);
        this.edgeTransforms[n].reset();
        Matrix matrix = this.edgeTransforms[n];
        float[] fArray = this.scratch;
        matrix.setTranslate(fArray[0], fArray[1]);
        this.edgeTransforms[n].preRotate(f);
    }

    public void calculatePath(ShapeAppearanceModel shapeAppearanceModel, float f, RectF rectF, Path path) {
        this.calculatePath(shapeAppearanceModel, f, rectF, null, path);
    }

    public void calculatePath(ShapeAppearanceModel object, float f, RectF rectF, PathListener pathListener, Path path) {
        path.rewind();
        this.overlappedEdgePath.rewind();
        this.boundsPath.rewind();
        this.boundsPath.addRect(rectF, Path.Direction.CW);
        object = new ShapeAppearancePathSpec((ShapeAppearanceModel)object, f, rectF, pathListener, path);
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 >= 4) break;
            this.setCornerPathAndTransform((ShapeAppearancePathSpec)object, n2);
            this.setEdgePathAndTransform(n2);
            ++n2;
        }
        for (int i = n; i < 4; ++i) {
            this.appendCornerPath((ShapeAppearancePathSpec)object, i);
            this.appendEdgePath((ShapeAppearancePathSpec)object, i);
        }
        path.close();
        this.overlappedEdgePath.close();
        if (Build.VERSION.SDK_INT >= 19 && !this.overlappedEdgePath.isEmpty()) {
            path.op(this.overlappedEdgePath, Path.Op.UNION);
        }
    }

    void setEdgeIntersectionCheckEnable(boolean bl) {
        this.edgeIntersectionCheckEnabled = bl;
    }

    private static class Lazy {
        static final ShapeAppearancePathProvider INSTANCE = new ShapeAppearancePathProvider();

        private Lazy() {
        }
    }

    public static interface PathListener {
        public void onCornerPathCreated(ShapePath var1, Matrix var2, int var3);

        public void onEdgePathCreated(ShapePath var1, Matrix var2, int var3);
    }

    static final class ShapeAppearancePathSpec {
        public final RectF bounds;
        public final float interpolation;
        public final Path path;
        public final PathListener pathListener;
        public final ShapeAppearanceModel shapeAppearanceModel;

        ShapeAppearancePathSpec(ShapeAppearanceModel shapeAppearanceModel, float f, RectF rectF, PathListener pathListener, Path path) {
            this.pathListener = pathListener;
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.interpolation = f;
            this.bounds = rectF;
            this.path = path;
        }
    }
}

