/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.SeekBar;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewOverlayImpl;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.LabelFormatter;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import com.google.android.material.tooltip.TooltipDrawable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class BaseSlider<S extends BaseSlider<S, L, T>, L extends BaseOnChangeListener<S>, T extends BaseOnSliderTouchListener<S>>
extends View {
    static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_Slider;
    private static final String EXCEPTION_ILLEGAL_DISCRETE_VALUE = "Value(%s) must be equal to valueFrom(%s) plus a multiple of stepSize(%s) when using stepSize(%s)";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION = "minSeparation(%s) must be greater or equal to 0";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE = "minSeparation(%s) must be greater or equal and a multiple of stepSize(%s) when using stepSize(%s)";
    private static final String EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE_UNIT = "minSeparation(%s) cannot be set as a dimension when using stepSize(%s)";
    private static final String EXCEPTION_ILLEGAL_STEP_SIZE = "The stepSize(%s) must be 0, or a factor of the valueFrom(%s)-valueTo(%s) range";
    private static final String EXCEPTION_ILLEGAL_VALUE = "Slider value(%s) must be greater or equal to valueFrom(%s), and lower or equal to valueTo(%s)";
    private static final String EXCEPTION_ILLEGAL_VALUE_FROM = "valueFrom(%s) must be smaller than valueTo(%s)";
    private static final String EXCEPTION_ILLEGAL_VALUE_TO = "valueTo(%s) must be greater than valueFrom(%s)";
    private static final int HALO_ALPHA = 63;
    private static final long LABEL_ANIMATION_ENTER_DURATION = 83L;
    private static final long LABEL_ANIMATION_EXIT_DURATION = 117L;
    private static final String TAG = "BaseSlider";
    private static final double THRESHOLD = 1.0E-4;
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    static final int UNIT_PX = 0;
    static final int UNIT_VALUE = 1;
    private static final String WARNING_FLOATING_POINT_ERROR = "Floating point value used for %s(%s). Using floats can have rounding errors which may result in incorrect values. Instead, consider using integers with a custom LabelFormatter to display the value correctly.";
    private AccessibilityEventSender accessibilityEventSender;
    private final AccessibilityHelper accessibilityHelper;
    private final AccessibilityManager accessibilityManager;
    private int activeThumbIdx = -1;
    private final Paint activeTicksPaint;
    private final Paint activeTrackPaint;
    private final List<L> changeListeners;
    private int defaultThumbRadius;
    private boolean dirtyConfig;
    private int focusedThumbIdx = -1;
    private boolean forceDrawCompatHalo;
    private LabelFormatter formatter;
    private ColorStateList haloColor;
    private final Paint haloPaint;
    private int haloRadius;
    private final Paint inactiveTicksPaint;
    private final Paint inactiveTrackPaint;
    private boolean isLongPress = false;
    private int labelBehavior;
    private final TooltipDrawableFactory labelMaker;
    private int labelPadding;
    private final List<TooltipDrawable> labels = new ArrayList<TooltipDrawable>();
    private boolean labelsAreAnimatedIn = false;
    private ValueAnimator labelsInAnimator;
    private ValueAnimator labelsOutAnimator;
    private MotionEvent lastEvent;
    private int minTrackSidePadding;
    private final int scaledTouchSlop;
    private int separationUnit;
    private float stepSize = 0.0f;
    private final MaterialShapeDrawable thumbDrawable;
    private boolean thumbIsPressed = false;
    private final Paint thumbPaint;
    private int thumbRadius;
    private ColorStateList tickColorActive;
    private ColorStateList tickColorInactive;
    private boolean tickVisible = true;
    private float[] ticksCoordinates;
    private float touchDownX;
    private final List<T> touchListeners;
    private float touchPosition;
    private ColorStateList trackColorActive;
    private ColorStateList trackColorInactive;
    private int trackHeight;
    private int trackSidePadding;
    private int trackTop;
    private int trackWidth;
    private float valueFrom;
    private float valueTo;
    private ArrayList<Float> values;
    private int widgetHeight;

    public BaseSlider(Context context) {
        this(context, null);
    }

    public BaseSlider(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.sliderStyle);
    }

    public BaseSlider(Context object, final AttributeSet attributeSet, final int n) {
        super(MaterialThemeOverlay.wrap(object, attributeSet, n, DEF_STYLE_RES), attributeSet, n);
        Paint paint;
        this.changeListeners = new ArrayList<L>();
        this.touchListeners = new ArrayList<T>();
        this.values = new ArrayList();
        object = new MaterialShapeDrawable();
        this.thumbDrawable = object;
        this.separationUnit = 0;
        Context context = this.getContext();
        this.inactiveTrackPaint = paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        this.activeTrackPaint = paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        this.thumbPaint = paint = new Paint(1);
        paint.setStyle(Paint.Style.FILL);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.haloPaint = paint = new Paint(1);
        paint.setStyle(Paint.Style.FILL);
        this.inactiveTicksPaint = paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        this.activeTicksPaint = paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        this.loadResources(context.getResources());
        this.labelMaker = new TooltipDrawableFactory(){

            @Override
            public TooltipDrawable createTooltipDrawable() {
                TypedArray typedArray = ThemeEnforcement.obtainStyledAttributes(BaseSlider.this.getContext(), attributeSet, R.styleable.Slider, n, DEF_STYLE_RES, new int[0]);
                TooltipDrawable tooltipDrawable = BaseSlider.parseLabelDrawable(BaseSlider.this.getContext(), typedArray);
                typedArray.recycle();
                return tooltipDrawable;
            }
        };
        this.processAttributes(context, attributeSet, n);
        this.setFocusable(true);
        this.setClickable(true);
        object.setShadowCompatibilityMode(2);
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        object = new AccessibilityHelper(this);
        this.accessibilityHelper = object;
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)object);
        this.accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
    }

    private void attachLabelToContentView(TooltipDrawable tooltipDrawable) {
        tooltipDrawable.setRelativeToView((View)ViewUtils.getContentView(this));
    }

    private Float calculateIncrementForKey(int n) {
        float f = this.isLongPress ? this.calculateStepIncrement(20) : this.calculateStepIncrement();
        if (n != 21) {
            if (n != 22) {
                if (n != 69) {
                    if (n != 70 && n != 81) {
                        return null;
                    }
                    return Float.valueOf(f);
                }
                return Float.valueOf(-f);
            }
            float f2 = f;
            if (this.isRtl()) {
                f2 = -f;
            }
            return Float.valueOf(f2);
        }
        if (!this.isRtl()) {
            f = -f;
        }
        return Float.valueOf(f);
    }

    private float calculateStepIncrement() {
        float f;
        float f2 = f = this.stepSize;
        if (f == 0.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    private float calculateStepIncrement(int n) {
        float f;
        float f2 = this.calculateStepIncrement();
        float f3 = (this.valueTo - this.valueFrom) / f2;
        if (f3 <= (f = (float)n)) {
            return f2;
        }
        return (float)Math.round(f3 / f) * f2;
    }

    private int calculateTop() {
        int n = this.trackTop;
        int n2 = this.labelBehavior;
        int n3 = 0;
        if (n2 == 1) {
            n3 = this.labels.get(0).getIntrinsicHeight();
        }
        return n + n3;
    }

    private ValueAnimator createLabelAnimator(boolean bl) {
        float f = 0.0f;
        float f2 = bl ? 0.0f : 1.0f;
        ValueAnimator valueAnimator = bl ? this.labelsOutAnimator : this.labelsInAnimator;
        float f3 = BaseSlider.getAnimatorCurrentValueOrDefault(valueAnimator, f2);
        f2 = f;
        if (bl) {
            f2 = 1.0f;
        }
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f3, f2});
        long l = bl ? 83L : 117L;
        valueAnimator2.setDuration(l);
        valueAnimator = bl ? AnimationUtils.DECELERATE_INTERPOLATOR : AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR;
        valueAnimator2.setInterpolator((TimeInterpolator)valueAnimator);
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator object) {
                float f = ((Float)object.getAnimatedValue()).floatValue();
                object = BaseSlider.this.labels.iterator();
                while (object.hasNext()) {
                    ((TooltipDrawable)object.next()).setRevealFraction(f);
                }
                ViewCompat.postInvalidateOnAnimation((View)BaseSlider.this);
            }
        });
        return valueAnimator2;
    }

    private void createLabelPool() {
        Iterator<TooltipDrawable> iterator2;
        if (this.labels.size() > this.values.size()) {
            List<TooltipDrawable> list = this.labels.subList(this.values.size(), this.labels.size());
            for (TooltipDrawable tooltipDrawable : list) {
                if (!ViewCompat.isAttachedToWindow((View)this)) continue;
                this.detachLabelFromContentView(tooltipDrawable);
            }
            list.clear();
        }
        while (this.labels.size() < this.values.size()) {
            iterator2 = this.labelMaker.createTooltipDrawable();
            this.labels.add((TooltipDrawable)((Object)iterator2));
            if (!ViewCompat.isAttachedToWindow((View)this)) continue;
            this.attachLabelToContentView((TooltipDrawable)((Object)iterator2));
        }
        int n = this.labels.size();
        boolean bl = true;
        if (n == 1) {
            bl = false;
        }
        iterator2 = this.labels.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setStrokeWidth((float)bl);
        }
    }

    private void detachLabelFromContentView(TooltipDrawable tooltipDrawable) {
        ViewOverlayImpl viewOverlayImpl = ViewUtils.getContentViewOverlay(this);
        if (viewOverlayImpl != null) {
            viewOverlayImpl.remove(tooltipDrawable);
            tooltipDrawable.detachView((View)ViewUtils.getContentView(this));
        }
    }

    private float dimenToValue(float f) {
        if (f == 0.0f) {
            return 0.0f;
        }
        f = (f - (float)this.trackSidePadding) / (float)this.trackWidth;
        float f2 = this.valueFrom;
        return f * (f2 - this.valueTo) + f2;
    }

    private void dispatchOnChangedFromUser(int n) {
        AccessibilityManager accessibilityManager = this.changeListeners.iterator();
        while (accessibilityManager.hasNext()) {
            ((BaseOnChangeListener)accessibilityManager.next()).onValueChange(this, this.values.get(n).floatValue(), true);
        }
        accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null && accessibilityManager.isEnabled()) {
            this.scheduleAccessibilityEventSender(n);
        }
    }

    private void dispatchOnChangedProgrammatically() {
        for (BaseOnChangeListener baseOnChangeListener : this.changeListeners) {
            Iterator<Float> iterator2 = this.values.iterator();
            while (iterator2.hasNext()) {
                baseOnChangeListener.onValueChange(this, iterator2.next().floatValue(), false);
            }
        }
    }

    private void drawActiveTrack(Canvas canvas, int n, int n2) {
        float[] fArray = this.getActiveRange();
        int n3 = this.trackSidePadding;
        float f = n3;
        float f2 = fArray[1];
        float f3 = n;
        float f4 = n3;
        float f5 = fArray[0];
        float f6 = n2;
        canvas.drawLine(f4 + f5 * f3, f6, f + f2 * f3, f6, this.activeTrackPaint);
    }

    private void drawInactiveTrack(Canvas canvas, int n, int n2) {
        float[] fArray = this.getActiveRange();
        int n3 = this.trackSidePadding;
        float f = n3;
        float f2 = fArray[1];
        float f3 = n;
        if ((f += f2 * f3) < (float)(n3 + n)) {
            f2 = n2;
            canvas.drawLine(f, f2, (float)(n3 + n), f2, this.inactiveTrackPaint);
        }
        if ((f2 = (float)(n = this.trackSidePadding) + fArray[0] * f3) > (float)n) {
            f3 = n;
            f = n2;
            canvas.drawLine(f3, f, f2, f, this.inactiveTrackPaint);
        }
    }

    private void drawThumbs(Canvas canvas, int n, int n2) {
        if (!this.isEnabled()) {
            for (Float f : this.values) {
                canvas.drawCircle((float)this.trackSidePadding + this.normalizeValue(f.floatValue()) * (float)n, (float)n2, (float)this.thumbRadius, this.thumbPaint);
            }
        }
        for (Float f : this.values) {
            canvas.save();
            int n3 = this.trackSidePadding;
            int n4 = (int)(this.normalizeValue(f.floatValue()) * (float)n);
            int n5 = this.thumbRadius;
            canvas.translate((float)(n3 + n4 - n5), (float)(n2 - n5));
            this.thumbDrawable.draw(canvas);
            canvas.restore();
        }
    }

    private void ensureLabelsAdded() {
        ValueAnimator valueAnimator;
        if (this.labelBehavior == 2) {
            return;
        }
        if (!this.labelsAreAnimatedIn) {
            this.labelsAreAnimatedIn = true;
            this.labelsInAnimator = valueAnimator = this.createLabelAnimator(true);
            this.labelsOutAnimator = null;
            valueAnimator.start();
        }
        valueAnimator = this.labels.iterator();
        for (int i = 0; i < this.values.size() && valueAnimator.hasNext(); ++i) {
            if (i == this.focusedThumbIdx) continue;
            this.setValueForLabel((TooltipDrawable)valueAnimator.next(), this.values.get(i).floatValue());
        }
        if (valueAnimator.hasNext()) {
            this.setValueForLabel((TooltipDrawable)valueAnimator.next(), this.values.get(this.focusedThumbIdx).floatValue());
            return;
        }
        throw new IllegalStateException(String.format("Not enough labels(%d) to display all the values(%d)", this.labels.size(), this.values.size()));
    }

    private void ensureLabelsRemoved() {
        if (this.labelsAreAnimatedIn) {
            ValueAnimator valueAnimator;
            this.labelsAreAnimatedIn = false;
            this.labelsOutAnimator = valueAnimator = this.createLabelAnimator(false);
            this.labelsInAnimator = null;
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator object) {
                    super.onAnimationEnd((Animator)object);
                    for (TooltipDrawable tooltipDrawable : BaseSlider.this.labels) {
                        ViewUtils.getContentViewOverlay(BaseSlider.this).remove(tooltipDrawable);
                    }
                }
            });
            this.labelsOutAnimator.start();
        }
    }

    private void focusThumbOnFocusGained(int n) {
        if (n != 1) {
            if (n != 2) {
                if (n != 17) {
                    if (n == 66) {
                        this.moveFocusInAbsoluteDirection(Integer.MIN_VALUE);
                    }
                } else {
                    this.moveFocusInAbsoluteDirection(Integer.MAX_VALUE);
                }
            } else {
                this.moveFocus(Integer.MIN_VALUE);
            }
        } else {
            this.moveFocus(Integer.MAX_VALUE);
        }
    }

    private String formatValue(float f) {
        if (this.hasLabelFormatter()) {
            return this.formatter.getFormattedValue(f);
        }
        String string2 = (float)((int)f) == f ? "%.0f" : "%.2f";
        return String.format(string2, Float.valueOf(f));
    }

    private float[] getActiveRange() {
        float f = Collections.max(this.getValues()).floatValue();
        float f2 = Collections.min(this.getValues()).floatValue();
        if (this.values.size() == 1) {
            f2 = this.valueFrom;
        }
        f2 = this.normalizeValue(f2);
        f = this.normalizeValue(f);
        float[] fArray = this.isRtl() ? new float[]{f, f2} : new float[]{f2, f};
        return fArray;
    }

    private static float getAnimatorCurrentValueOrDefault(ValueAnimator valueAnimator, float f) {
        float f2 = f;
        if (valueAnimator != null) {
            f2 = f;
            if (valueAnimator.isRunning()) {
                f2 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                valueAnimator.cancel();
            }
        }
        return f2;
    }

    private float getClampedValue(int n, float f) {
        int n2;
        float f2;
        float f3 = f2 = this.getMinSeparation();
        if (this.separationUnit == 0) {
            f3 = this.dimenToValue(f2);
        }
        f2 = f3;
        if (this.isRtl()) {
            f2 = -f3;
        }
        f3 = (n2 = n + 1) >= this.values.size() ? this.valueTo : this.values.get(n2).floatValue() - f2;
        f2 = --n < 0 ? this.valueFrom : this.values.get(n).floatValue() + f2;
        return MathUtils.clamp((float)f, (float)f2, (float)f3);
    }

    private int getColorForState(ColorStateList colorStateList) {
        return colorStateList.getColorForState(this.getDrawableState(), colorStateList.getDefaultColor());
    }

    private float getValueOfTouchPosition() {
        double d;
        double d2 = d = this.snapPosition(this.touchPosition);
        if (this.isRtl()) {
            d2 = 1.0 - d;
        }
        float f = this.valueTo;
        float f2 = this.valueFrom;
        return (float)(d2 * (double)(f - f2) + (double)f2);
    }

    private float getValueOfTouchPositionAbsolute() {
        float f;
        float f2 = f = this.touchPosition;
        if (this.isRtl()) {
            f2 = 1.0f - f;
        }
        f = this.valueTo;
        float f3 = this.valueFrom;
        return f2 * (f - f3) + f3;
    }

    private void invalidateTrack() {
        this.inactiveTrackPaint.setStrokeWidth((float)this.trackHeight);
        this.activeTrackPaint.setStrokeWidth((float)this.trackHeight);
        this.inactiveTicksPaint.setStrokeWidth((float)this.trackHeight / 2.0f);
        this.activeTicksPaint.setStrokeWidth((float)this.trackHeight / 2.0f);
    }

    private boolean isInVerticalScrollingContainer() {
        ViewParent viewParent = this.getParent();
        while (true) {
            boolean bl = viewParent instanceof ViewGroup;
            boolean bl2 = false;
            if (!bl) break;
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup.canScrollVertically(1) || viewGroup.canScrollVertically(-1)) {
                bl2 = true;
            }
            if (bl2 && viewGroup.shouldDelayChildPressedState()) {
                return true;
            }
            viewParent = viewParent.getParent();
        }
        return false;
    }

    private boolean isMultipleOfStepSize(float f) {
        double d = new BigDecimal(Float.toString(f)).divide(new BigDecimal(Float.toString(this.stepSize)), MathContext.DECIMAL64).doubleValue();
        boolean bl = Math.abs((double)Math.round(d) - d) < 1.0E-4;
        return bl;
    }

    private void loadResources(Resources resources) {
        int n;
        this.widgetHeight = resources.getDimensionPixelSize(R.dimen.mtrl_slider_widget_height);
        this.minTrackSidePadding = n = resources.getDimensionPixelOffset(R.dimen.mtrl_slider_track_side_padding);
        this.trackSidePadding = n;
        this.defaultThumbRadius = resources.getDimensionPixelSize(R.dimen.mtrl_slider_thumb_radius);
        this.trackTop = resources.getDimensionPixelOffset(R.dimen.mtrl_slider_track_top);
        this.labelPadding = resources.getDimensionPixelSize(R.dimen.mtrl_slider_label_padding);
    }

    private void maybeCalculateTicksCoordinates() {
        if (this.stepSize <= 0.0f) {
            return;
        }
        this.validateConfigurationIfDirty();
        int n = Math.min((int)((this.valueTo - this.valueFrom) / this.stepSize + 1.0f), this.trackWidth / (this.trackHeight * 2) + 1);
        float[] fArray = this.ticksCoordinates;
        if (fArray == null || fArray.length != n * 2) {
            this.ticksCoordinates = new float[n * 2];
        }
        float f = (float)this.trackWidth / (float)(n - 1);
        for (int i = 0; i < n * 2; i += 2) {
            fArray = this.ticksCoordinates;
            fArray[i] = (float)this.trackSidePadding + (float)(i / 2) * f;
            fArray[i + 1] = this.calculateTop();
        }
    }

    private void maybeDrawHalo(Canvas canvas, int n, int n2) {
        if (this.shouldDrawCompatHalo()) {
            n = (int)((float)this.trackSidePadding + this.normalizeValue(this.values.get(this.focusedThumbIdx).floatValue()) * (float)n);
            if (Build.VERSION.SDK_INT < 28) {
                int n3 = this.haloRadius;
                canvas.clipRect((float)(n - n3), (float)(n2 - n3), (float)(n + n3), (float)(n3 + n2), Region.Op.UNION);
            }
            canvas.drawCircle((float)n, (float)n2, (float)this.haloRadius, this.haloPaint);
        }
    }

    private void maybeDrawTicks(Canvas canvas) {
        if (this.tickVisible && !(this.stepSize <= 0.0f)) {
            float[] fArray = this.getActiveRange();
            int n = BaseSlider.pivotIndex(this.ticksCoordinates, fArray[0]);
            int n2 = BaseSlider.pivotIndex(this.ticksCoordinates, fArray[1]);
            fArray = this.ticksCoordinates;
            canvas.drawPoints(fArray, 0, n *= 2, this.inactiveTicksPaint);
            fArray = this.ticksCoordinates;
            canvas.drawPoints(fArray, n, (n2 *= 2) - n, this.activeTicksPaint);
            fArray = this.ticksCoordinates;
            canvas.drawPoints(fArray, n2, fArray.length - n2, this.inactiveTicksPaint);
        }
    }

    private void maybeIncreaseTrackSidePadding() {
        int n = Math.max(this.thumbRadius - this.defaultThumbRadius, 0);
        this.trackSidePadding = this.minTrackSidePadding + n;
        if (ViewCompat.isLaidOut((View)this)) {
            this.updateTrackWidth(this.getWidth());
        }
    }

    private boolean moveFocus(int n) {
        int n2 = this.focusedThumbIdx;
        this.focusedThumbIdx = n = (int)MathUtils.clamp((long)((long)n2 + (long)n), (long)0L, (long)(this.values.size() - 1));
        if (n == n2) {
            return false;
        }
        if (this.activeThumbIdx != -1) {
            this.activeThumbIdx = n;
        }
        this.updateHaloHotspot();
        this.postInvalidate();
        return true;
    }

    private boolean moveFocusInAbsoluteDirection(int n) {
        int n2 = n;
        if (this.isRtl()) {
            n2 = n == Integer.MIN_VALUE ? Integer.MAX_VALUE : -n;
        }
        return this.moveFocus(n2);
    }

    private float normalizeValue(float f) {
        float f2 = this.valueFrom;
        f = (f - f2) / (this.valueTo - f2);
        if (this.isRtl()) {
            return 1.0f - f;
        }
        return f;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private Boolean onKeyDownNoActiveThumb(int var1_1, KeyEvent var2_2) {
        block8: {
            block9: {
                if (var1_1 == 61) break block8;
                if (var1_1 == 66) break block9;
                if (var1_1 == 81) ** GOTO lbl20
                if (var1_1 == 69) {
                    this.moveFocus(-1);
                    return true;
                }
                if (var1_1 == 70) ** GOTO lbl20
                switch (var1_1) {
                    default: {
                        return null;
                    }
                    case 22: {
                        this.moveFocusInAbsoluteDirection(1);
                        return true;
                    }
                    case 21: {
                        this.moveFocusInAbsoluteDirection(-1);
                        return true;
                    }
lbl20:
                    // 2 sources

                    this.moveFocus(1);
                    return true;
                    case 23: 
                }
            }
            this.activeThumbIdx = this.focusedThumbIdx;
            this.postInvalidate();
            return true;
        }
        if (var2_2.hasNoModifiers()) {
            return this.moveFocus(1);
        }
        if (var2_2.isShiftPressed()) {
            return this.moveFocus(-1);
        }
        return false;
    }

    private void onStartTrackingTouch() {
        Iterator<T> iterator2 = this.touchListeners.iterator();
        while (iterator2.hasNext()) {
            ((BaseOnSliderTouchListener)iterator2.next()).onStartTrackingTouch(this);
        }
    }

    private void onStopTrackingTouch() {
        Iterator<T> iterator2 = this.touchListeners.iterator();
        while (iterator2.hasNext()) {
            ((BaseOnSliderTouchListener)iterator2.next()).onStopTrackingTouch(this);
        }
    }

    private static TooltipDrawable parseLabelDrawable(Context context, TypedArray typedArray) {
        return TooltipDrawable.createFromAttributes(context, null, 0, typedArray.getResourceId(R.styleable.Slider_labelStyle, R.style.Widget_MaterialComponents_Tooltip));
    }

    private static int pivotIndex(float[] fArray, float f) {
        return Math.round(f * (float)(fArray.length / 2 - 1));
    }

    private void processAttributes(Context object, AttributeSet attributeSet, int n) {
        TypedArray typedArray = ThemeEnforcement.obtainStyledAttributes(object, attributeSet, R.styleable.Slider, n, DEF_STYLE_RES, new int[0]);
        this.valueFrom = typedArray.getFloat(R.styleable.Slider_android_valueFrom, 0.0f);
        this.valueTo = typedArray.getFloat(R.styleable.Slider_android_valueTo, 1.0f);
        this.setValues(Float.valueOf(this.valueFrom));
        this.stepSize = typedArray.getFloat(R.styleable.Slider_android_stepSize, 0.0f);
        boolean bl = typedArray.hasValue(R.styleable.Slider_trackColor);
        n = bl ? R.styleable.Slider_trackColor : R.styleable.Slider_trackColorInactive;
        int n2 = bl ? R.styleable.Slider_trackColor : R.styleable.Slider_trackColorActive;
        attributeSet = MaterialResources.getColorStateList(object, typedArray, n);
        if (attributeSet == null) {
            attributeSet = AppCompatResources.getColorStateList((Context)object, (int)R.color.material_slider_inactive_track_color);
        }
        this.setTrackInactiveTintList((ColorStateList)attributeSet);
        attributeSet = MaterialResources.getColorStateList(object, typedArray, n2);
        if (attributeSet == null) {
            attributeSet = AppCompatResources.getColorStateList((Context)object, (int)R.color.material_slider_active_track_color);
        }
        this.setTrackActiveTintList((ColorStateList)attributeSet);
        attributeSet = MaterialResources.getColorStateList(object, typedArray, R.styleable.Slider_thumbColor);
        this.thumbDrawable.setFillColor((ColorStateList)attributeSet);
        if (typedArray.hasValue(R.styleable.Slider_thumbStrokeColor)) {
            this.setThumbStrokeColor(MaterialResources.getColorStateList(object, typedArray, R.styleable.Slider_thumbStrokeColor));
        }
        this.setThumbStrokeWidth(typedArray.getDimension(R.styleable.Slider_thumbStrokeWidth, 0.0f));
        attributeSet = MaterialResources.getColorStateList(object, typedArray, R.styleable.Slider_haloColor);
        if (attributeSet == null) {
            attributeSet = AppCompatResources.getColorStateList((Context)object, (int)R.color.material_slider_halo_color);
        }
        this.setHaloTintList((ColorStateList)attributeSet);
        this.tickVisible = typedArray.getBoolean(R.styleable.Slider_tickVisible, true);
        bl = typedArray.hasValue(R.styleable.Slider_tickColor);
        n = bl ? R.styleable.Slider_tickColor : R.styleable.Slider_tickColorInactive;
        n2 = bl ? R.styleable.Slider_tickColor : R.styleable.Slider_tickColorActive;
        attributeSet = MaterialResources.getColorStateList(object, typedArray, n);
        if (attributeSet == null) {
            attributeSet = AppCompatResources.getColorStateList((Context)object, (int)R.color.material_slider_inactive_tick_marks_color);
        }
        this.setTickInactiveTintList((ColorStateList)attributeSet);
        attributeSet = MaterialResources.getColorStateList(object, typedArray, n2);
        object = attributeSet != null ? attributeSet : AppCompatResources.getColorStateList((Context)object, (int)R.color.material_slider_active_tick_marks_color);
        this.setTickActiveTintList((ColorStateList)object);
        this.setThumbRadius(typedArray.getDimensionPixelSize(R.styleable.Slider_thumbRadius, 0));
        this.setHaloRadius(typedArray.getDimensionPixelSize(R.styleable.Slider_haloRadius, 0));
        this.setThumbElevation(typedArray.getDimension(R.styleable.Slider_thumbElevation, 0.0f));
        this.setTrackHeight(typedArray.getDimensionPixelSize(R.styleable.Slider_trackHeight, 0));
        this.labelBehavior = typedArray.getInt(R.styleable.Slider_labelBehavior, 0);
        if (!typedArray.getBoolean(R.styleable.Slider_android_enabled, true)) {
            this.setEnabled(false);
        }
        typedArray.recycle();
    }

    private void scheduleAccessibilityEventSender(int n) {
        AccessibilityEventSender accessibilityEventSender = this.accessibilityEventSender;
        if (accessibilityEventSender == null) {
            this.accessibilityEventSender = new AccessibilityEventSender();
        } else {
            this.removeCallbacks(accessibilityEventSender);
        }
        this.accessibilityEventSender.setVirtualViewId(n);
        this.postDelayed(this.accessibilityEventSender, 200L);
    }

    private void setValueForLabel(TooltipDrawable tooltipDrawable, float f) {
        tooltipDrawable.setText(this.formatValue(f));
        int n = this.trackSidePadding + (int)(this.normalizeValue(f) * (float)this.trackWidth) - tooltipDrawable.getIntrinsicWidth() / 2;
        int n2 = this.calculateTop() - (this.labelPadding + this.thumbRadius);
        tooltipDrawable.setBounds(n, n2 - tooltipDrawable.getIntrinsicHeight(), tooltipDrawable.getIntrinsicWidth() + n, n2);
        Rect rect = new Rect(tooltipDrawable.getBounds());
        DescendantOffsetUtils.offsetDescendantRect(ViewUtils.getContentView(this), this, rect);
        tooltipDrawable.setBounds(rect);
        ViewUtils.getContentViewOverlay(this).add(tooltipDrawable);
    }

    private void setValuesInternal(ArrayList<Float> arrayList) {
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            if (this.values.size() == arrayList.size() && this.values.equals(arrayList)) {
                return;
            }
            this.values = arrayList;
            this.dirtyConfig = true;
            this.focusedThumbIdx = 0;
            this.updateHaloHotspot();
            this.createLabelPool();
            this.dispatchOnChangedProgrammatically();
            this.postInvalidate();
            return;
        }
        throw new IllegalArgumentException("At least one value must be set");
    }

    private boolean shouldDrawCompatHalo() {
        boolean bl = this.forceDrawCompatHalo || Build.VERSION.SDK_INT < 21 || !(this.getBackground() instanceof RippleDrawable);
        return bl;
    }

    private boolean snapActiveThumbToValue(float f) {
        return this.snapThumbToValue(this.activeThumbIdx, f);
    }

    private double snapPosition(float f) {
        float f2 = this.stepSize;
        if (f2 > 0.0f) {
            int n = (int)((this.valueTo - this.valueFrom) / f2);
            return (double)Math.round(f * (float)n) / (double)n;
        }
        return f;
    }

    private boolean snapThumbToValue(int n, float f) {
        this.focusedThumbIdx = n;
        if ((double)Math.abs(f - this.values.get(n).floatValue()) < 1.0E-4) {
            return false;
        }
        f = this.getClampedValue(n, f);
        this.values.set(n, Float.valueOf(f));
        this.dispatchOnChangedFromUser(n);
        return true;
    }

    private boolean snapTouchPosition() {
        return this.snapActiveThumbToValue(this.getValueOfTouchPosition());
    }

    private void updateHaloHotspot() {
        Drawable drawable2;
        if (!this.shouldDrawCompatHalo() && this.getMeasuredWidth() > 0 && (drawable2 = this.getBackground()) instanceof RippleDrawable) {
            int n = (int)(this.normalizeValue(this.values.get(this.focusedThumbIdx).floatValue()) * (float)this.trackWidth + (float)this.trackSidePadding);
            int n2 = this.calculateTop();
            int n3 = this.haloRadius;
            DrawableCompat.setHotspotBounds((Drawable)drawable2, (int)(n - n3), (int)(n2 - n3), (int)(n + n3), (int)(n2 + n3));
        }
    }

    private void updateTrackWidth(int n) {
        this.trackWidth = Math.max(n - this.trackSidePadding * 2, 0);
        this.maybeCalculateTicksCoordinates();
    }

    private void validateConfigurationIfDirty() {
        if (this.dirtyConfig) {
            this.validateValueFrom();
            this.validateValueTo();
            this.validateStepSize();
            this.validateValues();
            this.validateMinSeparation();
            this.warnAboutFloatingPointError();
            this.dirtyConfig = false;
        }
    }

    private void validateMinSeparation() {
        float f = this.getMinSeparation();
        if (!(f < 0.0f)) {
            float f2 = this.stepSize;
            if (f2 > 0.0f && f > 0.0f) {
                if (this.separationUnit == 1) {
                    if (f < f2 || !this.isMultipleOfStepSize(f)) {
                        throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE, Float.valueOf(f), Float.valueOf(this.stepSize), Float.valueOf(this.stepSize)));
                    }
                } else {
                    throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION_STEP_SIZE_UNIT, Float.valueOf(f), Float.valueOf(this.stepSize)));
                }
            }
            return;
        }
        throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_MIN_SEPARATION, Float.valueOf(f)));
    }

    private void validateStepSize() {
        if (this.stepSize > 0.0f && !this.valueLandsOnTick(this.valueTo)) {
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_STEP_SIZE, Float.valueOf(this.stepSize), Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
        }
    }

    private void validateValueFrom() {
        if (!(this.valueFrom >= this.valueTo)) {
            return;
        }
        throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE_FROM, Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
    }

    private void validateValueTo() {
        if (!(this.valueTo <= this.valueFrom)) {
            return;
        }
        throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE_TO, Float.valueOf(this.valueTo), Float.valueOf(this.valueFrom)));
    }

    private void validateValues() {
        for (Float f : this.values) {
            if (!(f.floatValue() < this.valueFrom) && !(f.floatValue() > this.valueTo)) {
                if (!(this.stepSize > 0.0f) || this.valueLandsOnTick(f.floatValue())) continue;
                throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_DISCRETE_VALUE, f, Float.valueOf(this.valueFrom), Float.valueOf(this.stepSize), Float.valueOf(this.stepSize)));
            }
            throw new IllegalStateException(String.format(EXCEPTION_ILLEGAL_VALUE, f, Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
        }
    }

    private boolean valueLandsOnTick(float f) {
        return this.isMultipleOfStepSize(f - this.valueFrom);
    }

    private float valueToX(float f) {
        return this.normalizeValue(f) * (float)this.trackWidth + (float)this.trackSidePadding;
    }

    private void warnAboutFloatingPointError() {
        float f = this.stepSize;
        if (f == 0.0f) {
            return;
        }
        if ((float)((int)f) != f) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "stepSize", Float.valueOf(f)));
        }
        if ((float)((int)(f = this.valueFrom)) != f) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "valueFrom", Float.valueOf(f)));
        }
        if ((float)((int)(f = this.valueTo)) != f) {
            Log.w((String)TAG, (String)String.format(WARNING_FLOATING_POINT_ERROR, "valueTo", Float.valueOf(f)));
        }
    }

    public void addOnChangeListener(L l) {
        this.changeListeners.add(l);
    }

    public void addOnSliderTouchListener(T t) {
        this.touchListeners.add(t);
    }

    public void clearOnChangeListeners() {
        this.changeListeners.clear();
    }

    public void clearOnSliderTouchListeners() {
        this.touchListeners.clear();
    }

    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        boolean bl = this.accessibilityHelper.dispatchHoverEvent(motionEvent) || super.dispatchHoverEvent(motionEvent);
        return bl;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.inactiveTrackPaint.setColor(this.getColorForState(this.trackColorInactive));
        this.activeTrackPaint.setColor(this.getColorForState(this.trackColorActive));
        this.inactiveTicksPaint.setColor(this.getColorForState(this.tickColorInactive));
        this.activeTicksPaint.setColor(this.getColorForState(this.tickColorActive));
        for (TooltipDrawable tooltipDrawable : this.labels) {
            if (!tooltipDrawable.isStateful()) continue;
            tooltipDrawable.setState(this.getDrawableState());
        }
        if (this.thumbDrawable.isStateful()) {
            this.thumbDrawable.setState(this.getDrawableState());
        }
        this.haloPaint.setColor(this.getColorForState(this.haloColor));
        this.haloPaint.setAlpha(63);
    }

    void forceDrawCompatHalo(boolean bl) {
        this.forceDrawCompatHalo = bl;
    }

    public CharSequence getAccessibilityClassName() {
        return SeekBar.class.getName();
    }

    final int getAccessibilityFocusedVirtualViewId() {
        return this.accessibilityHelper.getAccessibilityFocusedVirtualViewId();
    }

    public int getActiveThumbIndex() {
        return this.activeThumbIdx;
    }

    public int getFocusedThumbIndex() {
        return this.focusedThumbIdx;
    }

    public int getHaloRadius() {
        return this.haloRadius;
    }

    public ColorStateList getHaloTintList() {
        return this.haloColor;
    }

    public int getLabelBehavior() {
        return this.labelBehavior;
    }

    protected float getMinSeparation() {
        return 0.0f;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public float getThumbElevation() {
        return this.thumbDrawable.getElevation();
    }

    public int getThumbRadius() {
        return this.thumbRadius;
    }

    public ColorStateList getThumbStrokeColor() {
        return this.thumbDrawable.getStrokeColor();
    }

    public float getThumbStrokeWidth() {
        return this.thumbDrawable.getStrokeWidth();
    }

    public ColorStateList getThumbTintList() {
        return this.thumbDrawable.getFillColor();
    }

    public ColorStateList getTickActiveTintList() {
        return this.tickColorActive;
    }

    public ColorStateList getTickInactiveTintList() {
        return this.tickColorInactive;
    }

    public ColorStateList getTickTintList() {
        if (this.tickColorInactive.equals(this.tickColorActive)) {
            return this.tickColorActive;
        }
        throw new IllegalStateException("The inactive and active ticks are different colors. Use the getTickColorInactive() and getTickColorActive() methods instead.");
    }

    public ColorStateList getTrackActiveTintList() {
        return this.trackColorActive;
    }

    public int getTrackHeight() {
        return this.trackHeight;
    }

    public ColorStateList getTrackInactiveTintList() {
        return this.trackColorInactive;
    }

    public int getTrackSidePadding() {
        return this.trackSidePadding;
    }

    public ColorStateList getTrackTintList() {
        if (this.trackColorInactive.equals(this.trackColorActive)) {
            return this.trackColorActive;
        }
        throw new IllegalStateException("The inactive and active parts of the track are different colors. Use the getInactiveTrackColor() and getActiveTrackColor() methods instead.");
    }

    public int getTrackWidth() {
        return this.trackWidth;
    }

    public float getValueFrom() {
        return this.valueFrom;
    }

    public float getValueTo() {
        return this.valueTo;
    }

    List<Float> getValues() {
        return new ArrayList<Float>(this.values);
    }

    public boolean hasLabelFormatter() {
        boolean bl = this.formatter != null;
        return bl;
    }

    final boolean isRtl() {
        int n = ViewCompat.getLayoutDirection((View)this);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isTickVisible() {
        return this.tickVisible;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Iterator<TooltipDrawable> iterator2 = this.labels.iterator();
        while (iterator2.hasNext()) {
            this.attachLabelToContentView(iterator2.next());
        }
    }

    protected void onDetachedFromWindow() {
        Object object = this.accessibilityEventSender;
        if (object != null) {
            this.removeCallbacks((Runnable)object);
        }
        this.labelsAreAnimatedIn = false;
        object = this.labels.iterator();
        while (object.hasNext()) {
            this.detachLabelFromContentView((TooltipDrawable)object.next());
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        if (this.dirtyConfig) {
            this.validateConfigurationIfDirty();
            this.maybeCalculateTicksCoordinates();
        }
        super.onDraw(canvas);
        int n = this.calculateTop();
        this.drawInactiveTrack(canvas, this.trackWidth, n);
        if (Collections.max(this.getValues()).floatValue() > this.valueFrom) {
            this.drawActiveTrack(canvas, this.trackWidth, n);
        }
        this.maybeDrawTicks(canvas);
        if ((this.thumbIsPressed || this.isFocused()) && this.isEnabled()) {
            this.maybeDrawHalo(canvas, this.trackWidth, n);
            if (this.activeThumbIdx != -1) {
                this.ensureLabelsAdded();
            }
        }
        this.drawThumbs(canvas, this.trackWidth, n);
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (!bl) {
            this.activeThumbIdx = -1;
            this.ensureLabelsRemoved();
            this.accessibilityHelper.clearKeyboardFocusForVirtualView(this.focusedThumbIdx);
        } else {
            this.focusThumbOnFocusGained(n);
            this.accessibilityHelper.requestKeyboardFocusForVirtualView(this.focusedThumbIdx);
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return super.onKeyDown(n, keyEvent);
        }
        if (this.values.size() == 1) {
            this.activeThumbIdx = 0;
        }
        if (this.activeThumbIdx == -1) {
            Boolean bl = this.onKeyDownNoActiveThumb(n, keyEvent);
            boolean bl2 = bl != null ? bl.booleanValue() : super.onKeyDown(n, keyEvent);
            return bl2;
        }
        this.isLongPress |= keyEvent.isLongPress();
        Float f = this.calculateIncrementForKey(n);
        if (f != null) {
            if (this.snapActiveThumbToValue(this.values.get(this.activeThumbIdx).floatValue() + f.floatValue())) {
                this.updateHaloHotspot();
                this.postInvalidate();
            }
            return true;
        }
        if (n != 23) {
            if (n != 61) {
                if (n != 66) {
                    return super.onKeyDown(n, keyEvent);
                }
            } else {
                if (keyEvent.hasNoModifiers()) {
                    return this.moveFocus(1);
                }
                if (keyEvent.isShiftPressed()) {
                    return this.moveFocus(-1);
                }
                return false;
            }
        }
        this.activeThumbIdx = -1;
        this.ensureLabelsRemoved();
        this.postInvalidate();
        return true;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        this.isLongPress = false;
        return super.onKeyUp(n, keyEvent);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = this.widgetHeight;
        int n4 = this.labelBehavior;
        n2 = 0;
        if (n4 == 1) {
            n2 = this.labels.get(0).getIntrinsicHeight();
        }
        super.onMeasure(n, View.MeasureSpec.makeMeasureSpec((int)(n3 + n2), (int)0x40000000));
    }

    protected void onRestoreInstanceState(Parcelable object) {
        object = (SliderState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.valueFrom = object.valueFrom;
        this.valueTo = object.valueTo;
        this.setValuesInternal(object.values);
        this.stepSize = object.stepSize;
        if (object.hasFocus) {
            this.requestFocus();
        }
    }

    protected Parcelable onSaveInstanceState() {
        SliderState sliderState = new SliderState(super.onSaveInstanceState());
        sliderState.valueFrom = this.valueFrom;
        sliderState.valueTo = this.valueTo;
        sliderState.values = new ArrayList<Float>(this.values);
        sliderState.stepSize = this.stepSize;
        sliderState.hasFocus = this.hasFocus();
        return sliderState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.updateTrackWidth(n);
        this.updateHaloHotspot();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        float f;
        if (!this.isEnabled()) {
            return false;
        }
        float f2 = motionEvent.getX();
        this.touchPosition = f = (f2 - (float)this.trackSidePadding) / (float)this.trackWidth;
        this.touchPosition = f = Math.max(0.0f, f);
        this.touchPosition = Math.min(1.0f, f);
        int n = motionEvent.getActionMasked();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    if (!this.thumbIsPressed) {
                        if (this.isInVerticalScrollingContainer() && Math.abs(f2 - this.touchDownX) < (float)this.scaledTouchSlop) {
                            return false;
                        }
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.onStartTrackingTouch();
                    }
                    if (this.pickActiveThumb()) {
                        this.thumbIsPressed = true;
                        this.snapTouchPosition();
                        this.updateHaloHotspot();
                        this.invalidate();
                    }
                }
            } else {
                this.thumbIsPressed = false;
                MotionEvent motionEvent2 = this.lastEvent;
                if (motionEvent2 != null && motionEvent2.getActionMasked() == 0 && Math.abs(this.lastEvent.getX() - motionEvent.getX()) <= (float)this.scaledTouchSlop && Math.abs(this.lastEvent.getY() - motionEvent.getY()) <= (float)this.scaledTouchSlop && this.pickActiveThumb()) {
                    this.onStartTrackingTouch();
                }
                if (this.activeThumbIdx != -1) {
                    this.snapTouchPosition();
                    this.activeThumbIdx = -1;
                    this.onStopTrackingTouch();
                }
                this.ensureLabelsRemoved();
                this.invalidate();
            }
        } else {
            this.touchDownX = f2;
            if (!this.isInVerticalScrollingContainer()) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (this.pickActiveThumb()) {
                    this.requestFocus();
                    this.thumbIsPressed = true;
                    this.snapTouchPosition();
                    this.updateHaloHotspot();
                    this.invalidate();
                    this.onStartTrackingTouch();
                }
            }
        }
        this.setPressed(this.thumbIsPressed);
        this.lastEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        return true;
    }

    protected boolean pickActiveThumb() {
        int n = this.activeThumbIdx;
        boolean bl = true;
        if (n != -1) {
            return true;
        }
        float f = this.getValueOfTouchPositionAbsolute();
        float f2 = this.valueToX(f);
        this.activeThumbIdx = 0;
        float f3 = Math.abs(this.values.get(0).floatValue() - f);
        for (n = 1; n < this.values.size(); ++n) {
            float f4;
            block9: {
                float f5;
                block8: {
                    boolean bl2;
                    float f6;
                    block7: {
                        f5 = Math.abs(this.values.get(n).floatValue() - f);
                        f6 = this.valueToX(this.values.get(n).floatValue());
                        if (Float.compare(f5, f3) > 1) break;
                        bl2 = this.isRtl() ? f6 - f2 > 0.0f : f6 - f2 < 0.0f;
                        if (Float.compare(f5, f3) >= 0) break block7;
                        this.activeThumbIdx = n;
                        break block8;
                    }
                    f4 = f3;
                    if (Float.compare(f5, f3) != 0) break block9;
                    if (Math.abs(f6 - f2) < (float)this.scaledTouchSlop) {
                        this.activeThumbIdx = -1;
                        return false;
                    }
                    f4 = f3;
                    if (!bl2) break block9;
                    this.activeThumbIdx = n;
                }
                f4 = f5;
            }
            f3 = f4;
        }
        if (this.activeThumbIdx == -1) {
            bl = false;
        }
        return bl;
    }

    public void removeOnChangeListener(L l) {
        this.changeListeners.remove(l);
    }

    public void removeOnSliderTouchListener(T t) {
        this.touchListeners.remove(t);
    }

    protected void setActiveThumbIndex(int n) {
        this.activeThumbIdx = n;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = bl ? 0 : 2;
        this.setLayerType(n, null);
    }

    public void setFocusedThumbIndex(int n) {
        if (n >= 0 && n < this.values.size()) {
            this.focusedThumbIdx = n;
            this.accessibilityHelper.requestKeyboardFocusForVirtualView(n);
            this.postInvalidate();
            return;
        }
        throw new IllegalArgumentException("index out of range");
    }

    public void setHaloRadius(int n) {
        if (n == this.haloRadius) {
            return;
        }
        this.haloRadius = n;
        Drawable drawable2 = this.getBackground();
        if (!this.shouldDrawCompatHalo() && drawable2 instanceof RippleDrawable) {
            DrawableUtils.setRippleDrawableRadius((RippleDrawable)drawable2, this.haloRadius);
            return;
        }
        this.postInvalidate();
    }

    public void setHaloRadiusResource(int n) {
        this.setHaloRadius(this.getResources().getDimensionPixelSize(n));
    }

    public void setHaloTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.haloColor)) {
            return;
        }
        this.haloColor = colorStateList;
        Drawable drawable2 = this.getBackground();
        if (!this.shouldDrawCompatHalo() && drawable2 instanceof RippleDrawable) {
            ((RippleDrawable)drawable2).setColor(colorStateList);
            return;
        }
        this.haloPaint.setColor(this.getColorForState(colorStateList));
        this.haloPaint.setAlpha(63);
        this.invalidate();
    }

    public void setLabelBehavior(int n) {
        if (this.labelBehavior != n) {
            this.labelBehavior = n;
            this.requestLayout();
        }
    }

    public void setLabelFormatter(LabelFormatter labelFormatter) {
        this.formatter = labelFormatter;
    }

    protected void setSeparationUnit(int n) {
        this.separationUnit = n;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    public void setStepSize(float f) {
        if (!(f < 0.0f)) {
            if (this.stepSize != f) {
                this.stepSize = f;
                this.dirtyConfig = true;
                this.postInvalidate();
            }
            return;
        }
        throw new IllegalArgumentException(String.format(EXCEPTION_ILLEGAL_STEP_SIZE, Float.valueOf(f), Float.valueOf(this.valueFrom), Float.valueOf(this.valueTo)));
    }

    public void setThumbElevation(float f) {
        this.thumbDrawable.setElevation(f);
    }

    public void setThumbElevationResource(int n) {
        this.setThumbElevation(this.getResources().getDimension(n));
    }

    public void setThumbRadius(int n) {
        if (n == this.thumbRadius) {
            return;
        }
        this.thumbRadius = n;
        this.maybeIncreaseTrackSidePadding();
        this.thumbDrawable.setShapeAppearanceModel(ShapeAppearanceModel.builder().setAllCorners(0, this.thumbRadius).build());
        MaterialShapeDrawable materialShapeDrawable = this.thumbDrawable;
        n = this.thumbRadius;
        materialShapeDrawable.setBounds(0, 0, n * 2, n * 2);
        this.postInvalidate();
    }

    public void setThumbRadiusResource(int n) {
        this.setThumbRadius(this.getResources().getDimensionPixelSize(n));
    }

    public void setThumbStrokeColor(ColorStateList colorStateList) {
        this.thumbDrawable.setStrokeColor(colorStateList);
        this.postInvalidate();
    }

    public void setThumbStrokeColorResource(int n) {
        if (n != 0) {
            this.setThumbStrokeColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
        }
    }

    public void setThumbStrokeWidth(float f) {
        this.thumbDrawable.setStrokeWidth(f);
        this.postInvalidate();
    }

    public void setThumbStrokeWidthResource(int n) {
        if (n != 0) {
            this.setThumbStrokeWidth(this.getResources().getDimension(n));
        }
    }

    public void setThumbTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.thumbDrawable.getFillColor())) {
            return;
        }
        this.thumbDrawable.setFillColor(colorStateList);
        this.invalidate();
    }

    public void setTickActiveTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.tickColorActive)) {
            return;
        }
        this.tickColorActive = colorStateList;
        this.activeTicksPaint.setColor(this.getColorForState(colorStateList));
        this.invalidate();
    }

    public void setTickInactiveTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.tickColorInactive)) {
            return;
        }
        this.tickColorInactive = colorStateList;
        this.inactiveTicksPaint.setColor(this.getColorForState(colorStateList));
        this.invalidate();
    }

    public void setTickTintList(ColorStateList colorStateList) {
        this.setTickInactiveTintList(colorStateList);
        this.setTickActiveTintList(colorStateList);
    }

    public void setTickVisible(boolean bl) {
        if (this.tickVisible != bl) {
            this.tickVisible = bl;
            this.postInvalidate();
        }
    }

    public void setTrackActiveTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.trackColorActive)) {
            return;
        }
        this.trackColorActive = colorStateList;
        this.activeTrackPaint.setColor(this.getColorForState(colorStateList));
        this.invalidate();
    }

    public void setTrackHeight(int n) {
        if (this.trackHeight != n) {
            this.trackHeight = n;
            this.invalidateTrack();
            this.postInvalidate();
        }
    }

    public void setTrackInactiveTintList(ColorStateList colorStateList) {
        if (colorStateList.equals(this.trackColorInactive)) {
            return;
        }
        this.trackColorInactive = colorStateList;
        this.inactiveTrackPaint.setColor(this.getColorForState(colorStateList));
        this.invalidate();
    }

    public void setTrackTintList(ColorStateList colorStateList) {
        this.setTrackInactiveTintList(colorStateList);
        this.setTrackActiveTintList(colorStateList);
    }

    public void setValueFrom(float f) {
        this.valueFrom = f;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    public void setValueTo(float f) {
        this.valueTo = f;
        this.dirtyConfig = true;
        this.postInvalidate();
    }

    void setValues(List<Float> list) {
        this.setValuesInternal(new ArrayList<Float>(list));
    }

    void setValues(Float ... floatArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        Collections.addAll(arrayList, floatArray);
        this.setValuesInternal(arrayList);
    }

    void updateBoundsForVirturalViewId(int n, Rect rect) {
        n = this.trackSidePadding + (int)(this.normalizeValue(this.getValues().get(n).floatValue()) * (float)this.trackWidth);
        int n2 = this.calculateTop();
        int n3 = this.thumbRadius;
        rect.set(n - n3, n2 - n3, n + n3, n2 + n3);
    }

    private class AccessibilityEventSender
    implements Runnable {
        int virtualViewId = -1;

        private AccessibilityEventSender() {
        }

        @Override
        public void run() {
            BaseSlider.this.accessibilityHelper.sendEventForVirtualView(this.virtualViewId, 4);
        }

        void setVirtualViewId(int n) {
            this.virtualViewId = n;
        }
    }

    private static class AccessibilityHelper
    extends ExploreByTouchHelper {
        private final BaseSlider<?, ?, ?> slider;
        Rect virtualViewBounds = new Rect();

        AccessibilityHelper(BaseSlider<?, ?, ?> baseSlider) {
            super(baseSlider);
            this.slider = baseSlider;
        }

        private String startOrEndDescription(int n) {
            if (n == this.slider.getValues().size() - 1) {
                return this.slider.getContext().getString(R.string.material_slider_range_end);
            }
            if (n == 0) {
                return this.slider.getContext().getString(R.string.material_slider_range_start);
            }
            return "";
        }

        protected int getVirtualViewAt(float f, float f2) {
            for (int i = 0; i < this.slider.getValues().size(); ++i) {
                this.slider.updateBoundsForVirturalViewId(i, this.virtualViewBounds);
                if (!this.virtualViewBounds.contains((int)f, (int)f2)) continue;
                return i;
            }
            return -1;
        }

        protected void getVisibleVirtualViews(List<Integer> list) {
            for (int i = 0; i < this.slider.getValues().size(); ++i) {
                list.add(i);
            }
        }

        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            float f;
            if (!this.slider.isEnabled()) {
                return false;
            }
            if (n2 != 4096 && n2 != 8192) {
                float f2;
                if (n2 != 16908349) {
                    return false;
                }
                if (bundle != null && bundle.containsKey("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE") && ((BaseSlider)this.slider).snapThumbToValue(n, f2 = bundle.getFloat("android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE"))) {
                    ((BaseSlider)this.slider).updateHaloHotspot();
                    this.slider.postInvalidate();
                    this.invalidateVirtualView(n);
                    return true;
                }
                return false;
            }
            float f3 = f = ((BaseSlider)this.slider).calculateStepIncrement(20);
            if (n2 == 8192) {
                f3 = -f;
            }
            f = f3;
            if (this.slider.isRtl()) {
                f = -f3;
            }
            if (((BaseSlider)this.slider).snapThumbToValue(n, f3 = MathUtils.clamp((float)(this.slider.getValues().get(n).floatValue() + f), (float)this.slider.getValueFrom(), (float)this.slider.getValueTo()))) {
                ((BaseSlider)this.slider).updateHaloHotspot();
                this.slider.postInvalidate();
                this.invalidateVirtualView(n);
                return true;
            }
            return false;
        }

        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            accessibilityNodeInfoCompat.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SET_PROGRESS);
            List<Float> list = this.slider.getValues();
            float f = list.get(n).floatValue();
            float f2 = this.slider.getValueFrom();
            float f3 = this.slider.getValueTo();
            if (this.slider.isEnabled()) {
                if (f > f2) {
                    accessibilityNodeInfoCompat.addAction(8192);
                }
                if (f < f3) {
                    accessibilityNodeInfoCompat.addAction(4096);
                }
            }
            accessibilityNodeInfoCompat.setRangeInfo(AccessibilityNodeInfoCompat.RangeInfoCompat.obtain((int)1, (float)f2, (float)f3, (float)f));
            accessibilityNodeInfoCompat.setClassName((CharSequence)SeekBar.class.getName());
            StringBuilder stringBuilder = new StringBuilder();
            if (this.slider.getContentDescription() != null) {
                stringBuilder.append(this.slider.getContentDescription());
                stringBuilder.append(",");
            }
            if (list.size() > 1) {
                stringBuilder.append(this.startOrEndDescription(n));
                stringBuilder.append(((BaseSlider)this.slider).formatValue(f));
            }
            accessibilityNodeInfoCompat.setContentDescription((CharSequence)stringBuilder.toString());
            this.slider.updateBoundsForVirturalViewId(n, this.virtualViewBounds);
            accessibilityNodeInfoCompat.setBoundsInParent(this.virtualViewBounds);
        }
    }

    static class SliderState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SliderState> CREATOR = new Parcelable.Creator<SliderState>(){

            public SliderState createFromParcel(Parcel parcel) {
                return new SliderState(parcel);
            }

            public SliderState[] newArray(int n) {
                return new SliderState[n];
            }
        };
        boolean hasFocus;
        float stepSize;
        float valueFrom;
        float valueTo;
        ArrayList<Float> values;

        private SliderState(Parcel parcel) {
            super(parcel);
            this.valueFrom = parcel.readFloat();
            this.valueTo = parcel.readFloat();
            ArrayList arrayList = new ArrayList();
            this.values = arrayList;
            parcel.readList(arrayList, Float.class.getClassLoader());
            this.stepSize = parcel.readFloat();
            this.hasFocus = parcel.createBooleanArray()[0];
        }

        SliderState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeFloat(this.valueFrom);
            parcel.writeFloat(this.valueTo);
            parcel.writeList(this.values);
            parcel.writeFloat(this.stepSize);
            parcel.writeBooleanArray(new boolean[]{this.hasFocus});
        }
    }

    private static interface TooltipDrawableFactory {
        public TooltipDrawable createTooltipDrawable();
    }
}

