/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.snackbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.snackbar.ContentViewCallback;

public class SnackbarContentLayout
extends LinearLayout
implements ContentViewCallback {
    private Button actionView;
    private int maxInlineActionWidth;
    private TextView messageView;

    public SnackbarContentLayout(Context context) {
        this(context, null);
    }

    public SnackbarContentLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private static void updateTopBottomPadding(View view, int n, int n2) {
        if (ViewCompat.isPaddingRelative((View)view)) {
            ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)n, (int)ViewCompat.getPaddingEnd((View)view), (int)n2);
        } else {
            view.setPadding(view.getPaddingLeft(), n, view.getPaddingRight(), n2);
        }
    }

    private boolean updateViewsWithinLayout(int n, int n2, int n3) {
        boolean bl;
        int n4 = this.getOrientation();
        boolean bl2 = true;
        if (n != n4) {
            this.setOrientation(n);
            bl = true;
        } else {
            bl = false;
        }
        if (this.messageView.getPaddingTop() != n2 || this.messageView.getPaddingBottom() != n3) {
            SnackbarContentLayout.updateTopBottomPadding((View)this.messageView, n2, n3);
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void animateContentIn(int n, int n2) {
        this.messageView.setAlpha(0.0f);
        ViewPropertyAnimator viewPropertyAnimator = this.messageView.animate().alpha(1.0f);
        long l = n2;
        viewPropertyAnimator = viewPropertyAnimator.setDuration(l);
        long l2 = n;
        viewPropertyAnimator.setStartDelay(l2).start();
        if (this.actionView.getVisibility() == 0) {
            this.actionView.setAlpha(0.0f);
            this.actionView.animate().alpha(1.0f).setDuration(l).setStartDelay(l2).start();
        }
    }

    @Override
    public void animateContentOut(int n, int n2) {
        this.messageView.setAlpha(1.0f);
        ViewPropertyAnimator viewPropertyAnimator = this.messageView.animate().alpha(0.0f);
        long l = n2;
        viewPropertyAnimator = viewPropertyAnimator.setDuration(l);
        long l2 = n;
        viewPropertyAnimator.setStartDelay(l2).start();
        if (this.actionView.getVisibility() == 0) {
            this.actionView.setAlpha(1.0f);
            this.actionView.animate().alpha(0.0f).setDuration(l).setStartDelay(l2).start();
        }
    }

    public Button getActionView() {
        return this.actionView;
    }

    public TextView getMessageView() {
        return this.messageView;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.messageView = (TextView)this.findViewById(R.id.snackbar_text);
        this.actionView = (Button)this.findViewById(R.id.snackbar_action);
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        block6: {
            block7: {
                int n4;
                int n5;
                int n6;
                block5: {
                    super.onMeasure(n, n2);
                    n6 = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
                    n5 = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
                    n3 = this.messageView.getLayout().getLineCount();
                    n4 = 0;
                    n3 = n3 > 1 ? 1 : 0;
                    if (n3 == 0 || this.maxInlineActionWidth <= 0 || this.actionView.getMeasuredWidth() <= this.maxInlineActionWidth) break block5;
                    n3 = n4;
                    if (!this.updateViewsWithinLayout(1, n6, n6 - n5)) break block6;
                    break block7;
                }
                if (n3 != 0) {
                    n5 = n6;
                }
                n3 = n4;
                if (!this.updateViewsWithinLayout(0, n5, n5)) break block6;
            }
            n3 = 1;
        }
        if (n3 != 0) {
            super.onMeasure(n, n2);
        }
    }

    public void setMaxInlineActionWidth(int n) {
        this.maxInlineActionWidth = n;
    }

    void updateActionTextColorAlphaIfNeeded(float f) {
        if (f != 1.0f) {
            int n = this.actionView.getCurrentTextColor();
            n = MaterialColors.layer(MaterialColors.getColor((View)this, R.attr.colorSurface), n, f);
            this.actionView.setTextColor(n);
        }
    }
}

