/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.text.BidiFormatter;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.customview.view.AbsSavedState;
import androidx.transition.Fade;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.internal.CollapsingTextHelper;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.ClearTextEndIconDelegate;
import com.google.android.material.textfield.CustomEndIconDelegate;
import com.google.android.material.textfield.CutoutDrawable;
import com.google.android.material.textfield.DropdownMenuEndIconDelegate;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.IndicatorViewController;
import com.google.android.material.textfield.NoEndIconDelegate;
import com.google.android.material.textfield.PasswordToggleEndIconDelegate;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class TextInputLayout
extends LinearLayout {
    public static final int BOX_BACKGROUND_FILLED = 1;
    public static final int BOX_BACKGROUND_NONE = 0;
    public static final int BOX_BACKGROUND_OUTLINE = 2;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_TextInputLayout;
    public static final int END_ICON_CLEAR_TEXT = 2;
    public static final int END_ICON_CUSTOM = -1;
    public static final int END_ICON_DROPDOWN_MENU = 3;
    public static final int END_ICON_NONE = 0;
    public static final int END_ICON_PASSWORD_TOGGLE = 1;
    private static final int INVALID_MAX_LENGTH = -1;
    private static final int LABEL_SCALE_ANIMATION_DURATION = 167;
    private static final String LOG_TAG = "TextInputLayout";
    private static final int NO_WIDTH = -1;
    private static final long PLACEHOLDER_FADE_DURATION = 87L;
    private static final long PLACEHOLDER_START_DELAY = 67L;
    private ValueAnimator animator;
    private MaterialShapeDrawable boxBackground;
    private int boxBackgroundColor;
    private int boxBackgroundMode;
    private int boxCollapsedPaddingTopPx;
    private final int boxLabelCutoutPaddingPx;
    private int boxStrokeColor;
    private int boxStrokeWidthDefaultPx;
    private int boxStrokeWidthFocusedPx;
    private int boxStrokeWidthPx;
    private MaterialShapeDrawable boxUnderline;
    final CollapsingTextHelper collapsingTextHelper;
    boolean counterEnabled;
    private int counterMaxLength;
    private int counterOverflowTextAppearance;
    private ColorStateList counterOverflowTextColor;
    private boolean counterOverflowed;
    private int counterTextAppearance;
    private ColorStateList counterTextColor;
    private TextView counterView;
    private int defaultFilledBackgroundColor;
    private ColorStateList defaultHintTextColor;
    private int defaultStrokeColor;
    private int disabledColor;
    private int disabledFilledBackgroundColor;
    EditText editText;
    private final LinkedHashSet<OnEditTextAttachedListener> editTextAttachedListeners;
    private Drawable endDummyDrawable;
    private int endDummyDrawableWidth;
    private final LinkedHashSet<OnEndIconChangedListener> endIconChangedListeners;
    private final SparseArray<EndIconDelegate> endIconDelegates;
    private final FrameLayout endIconFrame;
    private int endIconMode;
    private View.OnLongClickListener endIconOnLongClickListener;
    private ColorStateList endIconTintList;
    private PorterDuff.Mode endIconTintMode;
    private final CheckableImageButton endIconView;
    private final LinearLayout endLayout;
    private View.OnLongClickListener errorIconOnLongClickListener;
    private ColorStateList errorIconTintList;
    private final CheckableImageButton errorIconView;
    private boolean expandedHintEnabled;
    private int focusedFilledBackgroundColor;
    private int focusedStrokeColor;
    private ColorStateList focusedTextColor;
    private boolean hasEndIconTintList;
    private boolean hasEndIconTintMode;
    private boolean hasStartIconTintList;
    private boolean hasStartIconTintMode;
    private CharSequence hint;
    private boolean hintAnimationEnabled;
    private boolean hintEnabled;
    private boolean hintExpanded;
    private int hoveredFilledBackgroundColor;
    private int hoveredStrokeColor;
    private boolean inDrawableStateChanged;
    private final IndicatorViewController indicatorViewController;
    private final FrameLayout inputFrame;
    private boolean isProvidingHint;
    private int maxWidth;
    private int minWidth;
    private Drawable originalEditTextEndDrawable;
    private CharSequence originalHint;
    private boolean placeholderEnabled;
    private Fade placeholderFadeIn;
    private Fade placeholderFadeOut;
    private CharSequence placeholderText;
    private int placeholderTextAppearance;
    private ColorStateList placeholderTextColor;
    private TextView placeholderTextView;
    private CharSequence prefixText;
    private final TextView prefixTextView;
    private boolean restoringSavedState;
    private ShapeAppearanceModel shapeAppearanceModel;
    private Drawable startDummyDrawable;
    private int startDummyDrawableWidth;
    private View.OnLongClickListener startIconOnLongClickListener;
    private ColorStateList startIconTintList;
    private PorterDuff.Mode startIconTintMode;
    private final CheckableImageButton startIconView;
    private final LinearLayout startLayout;
    private ColorStateList strokeErrorColor;
    private CharSequence suffixText;
    private final TextView suffixTextView;
    private final Rect tmpBoundsRect;
    private final Rect tmpRect;
    private final RectF tmpRectF;
    private Typeface typeface;

    public TextInputLayout(Context context) {
        this(context, null);
    }

    public TextInputLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.textInputStyle);
    }

    public TextInputLayout(Context context, AttributeSet object, int n) {
        CheckableImageButton checkableImageButton;
        CheckableImageButton checkableImageButton2;
        CheckableImageButton checkableImageButton3;
        LinearLayout linearLayout;
        FrameLayout frameLayout;
        CollapsingTextHelper collapsingTextHelper;
        SparseArray sparseArray;
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, (AttributeSet)object, n, n2), (AttributeSet)object, n);
        this.minWidth = -1;
        this.maxWidth = -1;
        this.indicatorViewController = new IndicatorViewController(this);
        this.tmpRect = new Rect();
        this.tmpBoundsRect = new Rect();
        this.tmpRectF = new RectF();
        this.editTextAttachedListeners = new LinkedHashSet();
        this.endIconMode = 0;
        this.endIconDelegates = sparseArray = new SparseArray();
        this.endIconChangedListeners = new LinkedHashSet();
        this.collapsingTextHelper = collapsingTextHelper = new CollapsingTextHelper((View)this);
        Context context2 = this.getContext();
        this.setOrientation(1);
        this.setWillNotDraw(false);
        this.setAddStatesFromChildren(true);
        this.inputFrame = frameLayout = new FrameLayout(context2);
        frameLayout.setAddStatesFromChildren(true);
        this.addView((View)frameLayout);
        this.startLayout = linearLayout = new LinearLayout(context2);
        linearLayout.setOrientation(0);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        frameLayout.addView((View)linearLayout);
        context = new LinearLayout(context2);
        this.endLayout = context;
        context.setOrientation(0);
        context.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        frameLayout.addView((View)context);
        this.endIconFrame = frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        collapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        collapsingTextHelper.setPositionInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        collapsingTextHelper.setCollapsedTextGravity(0x800033);
        collapsingTextHelper = ThemeEnforcement.obtainTintedStyledAttributes(context2, (AttributeSet)object, R.styleable.TextInputLayout, n, n2, R.styleable.TextInputLayout_counterTextAppearance, R.styleable.TextInputLayout_counterOverflowTextAppearance, R.styleable.TextInputLayout_errorTextAppearance, R.styleable.TextInputLayout_helperTextTextAppearance, R.styleable.TextInputLayout_hintTextAppearance);
        this.hintEnabled = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_hintEnabled, true);
        this.setHint(collapsingTextHelper.getText(R.styleable.TextInputLayout_android_hint));
        this.hintAnimationEnabled = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_hintAnimationEnabled, true);
        this.expandedHintEnabled = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_expandedHintEnabled, true);
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_android_minWidth)) {
            this.setMinWidth(collapsingTextHelper.getDimensionPixelSize(R.styleable.TextInputLayout_android_minWidth, -1));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_android_maxWidth)) {
            this.setMaxWidth(collapsingTextHelper.getDimensionPixelSize(R.styleable.TextInputLayout_android_maxWidth, -1));
        }
        this.shapeAppearanceModel = ShapeAppearanceModel.builder(context2, (AttributeSet)object, n, n2).build();
        this.boxLabelCutoutPaddingPx = context2.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_box_label_cutout_padding);
        this.boxCollapsedPaddingTopPx = collapsingTextHelper.getDimensionPixelOffset(R.styleable.TextInputLayout_boxCollapsedPaddingTop, 0);
        this.boxStrokeWidthDefaultPx = collapsingTextHelper.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidth, context2.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_default));
        this.boxStrokeWidthFocusedPx = collapsingTextHelper.getDimensionPixelSize(R.styleable.TextInputLayout_boxStrokeWidthFocused, context2.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_focused));
        this.boxStrokeWidthPx = this.boxStrokeWidthDefaultPx;
        float f = collapsingTextHelper.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopStart, -1.0f);
        float f2 = collapsingTextHelper.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopEnd, -1.0f);
        float f3 = collapsingTextHelper.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomEnd, -1.0f);
        float f4 = collapsingTextHelper.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomStart, -1.0f);
        object = this.shapeAppearanceModel.toBuilder();
        if (f >= 0.0f) {
            ((ShapeAppearanceModel.Builder)object).setTopLeftCornerSize(f);
        }
        if (f2 >= 0.0f) {
            ((ShapeAppearanceModel.Builder)object).setTopRightCornerSize(f2);
        }
        if (f3 >= 0.0f) {
            ((ShapeAppearanceModel.Builder)object).setBottomRightCornerSize(f3);
        }
        if (f4 >= 0.0f) {
            ((ShapeAppearanceModel.Builder)object).setBottomLeftCornerSize(f4);
        }
        this.shapeAppearanceModel = ((ShapeAppearanceModel.Builder)object).build();
        object = MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_boxBackgroundColor);
        if (object != null) {
            this.defaultFilledBackgroundColor = n = object.getDefaultColor();
            this.boxBackgroundColor = n;
            if (object.isStateful()) {
                this.disabledFilledBackgroundColor = object.getColorForState(new int[]{-16842910}, -1);
                this.focusedFilledBackgroundColor = object.getColorForState(new int[]{16842908, 16842910}, -1);
                this.hoveredFilledBackgroundColor = object.getColorForState(new int[]{16843623, 16842910}, -1);
            } else {
                this.focusedFilledBackgroundColor = this.defaultFilledBackgroundColor;
                object = AppCompatResources.getColorStateList((Context)context2, (int)R.color.mtrl_filled_background_color);
                this.disabledFilledBackgroundColor = object.getColorForState(new int[]{-16842910}, -1);
                this.hoveredFilledBackgroundColor = object.getColorForState(new int[]{16843623}, -1);
            }
        } else {
            this.boxBackgroundColor = 0;
            this.defaultFilledBackgroundColor = 0;
            this.disabledFilledBackgroundColor = 0;
            this.focusedFilledBackgroundColor = 0;
            this.hoveredFilledBackgroundColor = 0;
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_android_textColorHint)) {
            object = collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_android_textColorHint);
            this.focusedTextColor = object;
            this.defaultHintTextColor = object;
        }
        object = MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_boxStrokeColor);
        this.focusedStrokeColor = collapsingTextHelper.getColor(R.styleable.TextInputLayout_boxStrokeColor, 0);
        this.defaultStrokeColor = ContextCompat.getColor((Context)context2, (int)R.color.mtrl_textinput_default_box_stroke_color);
        this.disabledColor = ContextCompat.getColor((Context)context2, (int)R.color.mtrl_textinput_disabled_color);
        this.hoveredStrokeColor = ContextCompat.getColor((Context)context2, (int)R.color.mtrl_textinput_hovered_box_stroke_color);
        if (object != null) {
            this.setBoxStrokeColorStateList((ColorStateList)object);
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_boxStrokeErrorColor)) {
            this.setBoxStrokeErrorColor(MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_boxStrokeErrorColor));
        }
        if (collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, -1) != -1) {
            this.setHintTextAppearance(collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, 0));
        }
        int n3 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_errorTextAppearance, 0);
        CharSequence charSequence = collapsingTextHelper.getText(R.styleable.TextInputLayout_errorContentDescription);
        boolean bl = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_errorEnabled, false);
        this.errorIconView = checkableImageButton3 = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_end_icon, (ViewGroup)context, false);
        checkableImageButton3.setId(R.id.text_input_error_icon);
        checkableImageButton3.setVisibility(8);
        if (MaterialResources.isFontScaleAtLeast1_3(context2)) {
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)checkableImageButton3.getLayoutParams()), (int)0);
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_errorIconDrawable)) {
            this.setErrorIconDrawable(collapsingTextHelper.getDrawable(R.styleable.TextInputLayout_errorIconDrawable));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_errorIconTint)) {
            this.setErrorIconTintList(MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_errorIconTint));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_errorIconTintMode)) {
            this.setErrorIconTintMode(ViewUtils.parseTintMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_errorIconTintMode, -1), null));
        }
        checkableImageButton3.setContentDescription(this.getResources().getText(R.string.error_icon_content_description));
        ViewCompat.setImportantForAccessibility((View)checkableImageButton3, (int)2);
        checkableImageButton3.setClickable(false);
        checkableImageButton3.setPressable(false);
        checkableImageButton3.setFocusable(false);
        int n4 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_helperTextTextAppearance, 0);
        boolean bl2 = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_helperTextEnabled, false);
        CharSequence charSequence2 = collapsingTextHelper.getText(R.styleable.TextInputLayout_helperText);
        int n5 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_placeholderTextAppearance, 0);
        object = collapsingTextHelper.getText(R.styleable.TextInputLayout_placeholderText);
        int n6 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_prefixTextAppearance, 0);
        CharSequence charSequence3 = collapsingTextHelper.getText(R.styleable.TextInputLayout_prefixText);
        int n7 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_suffixTextAppearance, 0);
        CharSequence charSequence4 = collapsingTextHelper.getText(R.styleable.TextInputLayout_suffixText);
        boolean bl3 = collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_counterEnabled, false);
        this.setCounterMaxLength(collapsingTextHelper.getInt(R.styleable.TextInputLayout_counterMaxLength, -1));
        this.counterTextAppearance = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_counterTextAppearance, 0);
        this.counterOverflowTextAppearance = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_counterOverflowTextAppearance, 0);
        this.startIconView = checkableImageButton2 = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_start_icon, (ViewGroup)linearLayout, false);
        checkableImageButton2.setVisibility(8);
        if (MaterialResources.isFontScaleAtLeast1_3(context2)) {
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)checkableImageButton2.getLayoutParams()), (int)0);
        }
        this.setStartIconOnClickListener(null);
        this.setStartIconOnLongClickListener(null);
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_startIconDrawable)) {
            this.setStartIconDrawable(collapsingTextHelper.getDrawable(R.styleable.TextInputLayout_startIconDrawable));
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_startIconContentDescription)) {
                this.setStartIconContentDescription(collapsingTextHelper.getText(R.styleable.TextInputLayout_startIconContentDescription));
            }
            this.setStartIconCheckable(collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_startIconCheckable, true));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_startIconTint)) {
            this.setStartIconTintList(MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_startIconTint));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_startIconTintMode)) {
            this.setStartIconTintMode(ViewUtils.parseTintMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_startIconTintMode, -1), null));
        }
        this.setBoxBackgroundMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_boxBackgroundMode, 0));
        this.endIconView = checkableImageButton = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_end_icon, (ViewGroup)frameLayout, false);
        frameLayout.addView((View)checkableImageButton);
        checkableImageButton.setVisibility(8);
        if (MaterialResources.isFontScaleAtLeast1_3(context2)) {
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)checkableImageButton.getLayoutParams()), (int)0);
        }
        n2 = collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_endIconDrawable, 0);
        sparseArray.append(-1, (Object)new CustomEndIconDelegate(this, n2));
        sparseArray.append(0, (Object)new NoEndIconDelegate(this));
        n = n2 == 0 ? collapsingTextHelper.getResourceId(R.styleable.TextInputLayout_passwordToggleDrawable, 0) : n2;
        sparseArray.append(1, (Object)new PasswordToggleEndIconDelegate(this, n));
        sparseArray.append(2, (Object)new ClearTextEndIconDelegate(this, n2));
        sparseArray.append(3, (Object)new DropdownMenuEndIconDelegate(this, n2));
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_endIconMode)) {
            this.setEndIconMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_endIconMode, 0));
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_endIconContentDescription)) {
                this.setEndIconContentDescription(collapsingTextHelper.getText(R.styleable.TextInputLayout_endIconContentDescription));
            }
            this.setEndIconCheckable(collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_endIconCheckable, true));
        } else if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            this.setEndIconMode(collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_passwordToggleEnabled, false) ? 1 : 0);
            this.setEndIconContentDescription(collapsingTextHelper.getText(R.styleable.TextInputLayout_passwordToggleContentDescription));
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_passwordToggleTint)) {
                this.setEndIconTintList(MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_passwordToggleTint));
            }
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_passwordToggleTintMode)) {
                this.setEndIconTintMode(ViewUtils.parseTintMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_passwordToggleTintMode, -1), null));
            }
        }
        if (!collapsingTextHelper.hasValue(R.styleable.TextInputLayout_passwordToggleEnabled)) {
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_endIconTint)) {
                this.setEndIconTintList(MaterialResources.getColorStateList(context2, (TintTypedArray)collapsingTextHelper, R.styleable.TextInputLayout_endIconTint));
            }
            if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_endIconTintMode)) {
                this.setEndIconTintMode(ViewUtils.parseTintMode(collapsingTextHelper.getInt(R.styleable.TextInputLayout_endIconTintMode, -1), null));
            }
        }
        sparseArray = new AppCompatTextView(context2);
        this.prefixTextView = sparseArray;
        sparseArray.setId(R.id.textinput_prefix_text);
        sparseArray.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        ViewCompat.setAccessibilityLiveRegion((View)sparseArray, (int)1);
        linearLayout.addView((View)checkableImageButton2);
        linearLayout.addView((View)sparseArray);
        linearLayout = new AppCompatTextView(context2);
        this.suffixTextView = linearLayout;
        linearLayout.setId(R.id.textinput_suffix_text);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 80));
        ViewCompat.setAccessibilityLiveRegion((View)linearLayout, (int)1);
        context.addView((View)linearLayout);
        context.addView((View)checkableImageButton3);
        context.addView((View)frameLayout);
        this.setHelperTextEnabled(bl2);
        this.setHelperText(charSequence2);
        this.setHelperTextTextAppearance(n4);
        this.setErrorEnabled(bl);
        this.setErrorTextAppearance(n3);
        this.setErrorContentDescription(charSequence);
        this.setCounterTextAppearance(this.counterTextAppearance);
        this.setCounterOverflowTextAppearance(this.counterOverflowTextAppearance);
        this.setPlaceholderText((CharSequence)object);
        this.setPlaceholderTextAppearance(n5);
        this.setPrefixText(charSequence3);
        this.setPrefixTextAppearance(n6);
        this.setSuffixText(charSequence4);
        this.setSuffixTextAppearance(n7);
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_errorTextColor)) {
            this.setErrorTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_errorTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_helperTextTextColor)) {
            this.setHelperTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_helperTextTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_hintTextColor)) {
            this.setHintTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_hintTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_counterTextColor)) {
            this.setCounterTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_counterTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_counterOverflowTextColor)) {
            this.setCounterOverflowTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_counterOverflowTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_placeholderTextColor)) {
            this.setPlaceholderTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_placeholderTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_prefixTextColor)) {
            this.setPrefixTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_prefixTextColor));
        }
        if (collapsingTextHelper.hasValue(R.styleable.TextInputLayout_suffixTextColor)) {
            this.setSuffixTextColor(collapsingTextHelper.getColorStateList(R.styleable.TextInputLayout_suffixTextColor));
        }
        this.setCounterEnabled(bl3);
        this.setEnabled(collapsingTextHelper.getBoolean(R.styleable.TextInputLayout_android_enabled, true));
        collapsingTextHelper.recycle();
        ViewCompat.setImportantForAccessibility((View)this, (int)2);
        if (Build.VERSION.SDK_INT >= 26) {
            ViewCompat.setImportantForAutofill((View)this, (int)1);
        }
    }

    private void addPlaceholderTextView() {
        TextView textView = this.placeholderTextView;
        if (textView != null) {
            this.inputFrame.addView((View)textView);
            this.placeholderTextView.setVisibility(0);
        }
    }

    private void adjustFilledEditTextPaddingForLargeFont() {
        if (this.editText != null && this.boxBackgroundMode == 1) {
            if (MaterialResources.isFontScaleAtLeast2_0(this.getContext())) {
                EditText editText = this.editText;
                ViewCompat.setPaddingRelative((View)editText, (int)ViewCompat.getPaddingStart((View)editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_2_0_padding_top), (int)ViewCompat.getPaddingEnd((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_2_0_padding_bottom));
            } else if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
                EditText editText = this.editText;
                ViewCompat.setPaddingRelative((View)editText, (int)ViewCompat.getPaddingStart((View)editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_1_3_padding_top), (int)ViewCompat.getPaddingEnd((View)this.editText), (int)this.getResources().getDimensionPixelSize(R.dimen.material_filled_edittext_font_1_3_padding_bottom));
            }
        }
    }

    private void applyBoxAttributes() {
        int n;
        MaterialShapeDrawable materialShapeDrawable = this.boxBackground;
        if (materialShapeDrawable == null) {
            return;
        }
        materialShapeDrawable.setShapeAppearanceModel(this.shapeAppearanceModel);
        if (this.canDrawOutlineStroke()) {
            this.boxBackground.setStroke((float)this.boxStrokeWidthPx, this.boxStrokeColor);
        }
        this.boxBackgroundColor = n = this.calculateBoxBackgroundColor();
        this.boxBackground.setFillColor(ColorStateList.valueOf((int)n));
        if (this.endIconMode == 3) {
            this.editText.getBackground().invalidateSelf();
        }
        this.applyBoxUnderlineAttributes();
        this.invalidate();
    }

    private void applyBoxUnderlineAttributes() {
        if (this.boxUnderline == null) {
            return;
        }
        if (this.canDrawStroke()) {
            this.boxUnderline.setFillColor(ColorStateList.valueOf((int)this.boxStrokeColor));
        }
        this.invalidate();
    }

    private void applyCutoutPadding(RectF rectF) {
        rectF.left -= (float)this.boxLabelCutoutPaddingPx;
        rectF.right += (float)this.boxLabelCutoutPaddingPx;
    }

    private void applyEndIconTint() {
        this.applyIconTint(this.endIconView, this.hasEndIconTintList, this.endIconTintList, this.hasEndIconTintMode, this.endIconTintMode);
    }

    private void applyIconTint(CheckableImageButton checkableImageButton, boolean bl, ColorStateList colorStateList, boolean bl2, PorterDuff.Mode mode) {
        Drawable drawable2;
        block6: {
            Drawable drawable3;
            block7: {
                drawable2 = drawable3 = checkableImageButton.getDrawable();
                if (drawable3 == null) break block6;
                if (bl) break block7;
                drawable2 = drawable3;
                if (!bl2) break block6;
            }
            drawable3 = DrawableCompat.wrap((Drawable)drawable3).mutate();
            if (bl) {
                DrawableCompat.setTintList((Drawable)drawable3, (ColorStateList)colorStateList);
            }
            drawable2 = drawable3;
            if (bl2) {
                DrawableCompat.setTintMode((Drawable)drawable3, (PorterDuff.Mode)mode);
                drawable2 = drawable3;
            }
        }
        if (checkableImageButton.getDrawable() != drawable2) {
            checkableImageButton.setImageDrawable(drawable2);
        }
    }

    private void applyStartIconTint() {
        this.applyIconTint(this.startIconView, this.hasStartIconTintList, this.startIconTintList, this.hasStartIconTintMode, this.startIconTintMode);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void assignBoxBackgroundByMode() {
        int n = this.boxBackgroundMode;
        if (n == 0) {
            this.boxBackground = null;
            this.boxUnderline = null;
            return;
        }
        if (n == 1) {
            this.boxBackground = new MaterialShapeDrawable(this.shapeAppearanceModel);
            this.boxUnderline = new MaterialShapeDrawable();
            return;
        }
        if (n != 2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.boxBackgroundMode);
            stringBuilder.append(" is illegal; only @BoxBackgroundMode constants are supported.");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.boxBackground = this.hintEnabled && !(this.boxBackground instanceof CutoutDrawable) ? new CutoutDrawable(this.shapeAppearanceModel) : new MaterialShapeDrawable(this.shapeAppearanceModel);
        this.boxUnderline = null;
    }

    private int calculateBoxBackgroundColor() {
        int n = this.boxBackgroundColor;
        if (this.boxBackgroundMode == 1) {
            n = MaterialColors.layer(MaterialColors.getColor((View)this, R.attr.colorSurface, 0), this.boxBackgroundColor);
        }
        return n;
    }

    private Rect calculateCollapsedTextBounds(Rect rect) {
        if (this.editText != null) {
            Rect rect2 = this.tmpBoundsRect;
            boolean bl = ViewCompat.getLayoutDirection((View)this) == 1;
            rect2.bottom = rect.bottom;
            int n = this.boxBackgroundMode;
            if (n != 1) {
                if (n != 2) {
                    rect2.left = this.getLabelLeftBoundAlightWithPrefix(rect.left, bl);
                    rect2.top = this.getPaddingTop();
                    rect2.right = this.getLabelRightBoundAlignedWithSuffix(rect.right, bl);
                    return rect2;
                }
                rect2.left = rect.left + this.editText.getPaddingLeft();
                rect2.top = rect.top - this.calculateLabelMarginTop();
                rect2.right = rect.right - this.editText.getPaddingRight();
                return rect2;
            }
            rect2.left = this.getLabelLeftBoundAlightWithPrefix(rect.left, bl);
            rect2.top = rect.top + this.boxCollapsedPaddingTopPx;
            rect2.right = this.getLabelRightBoundAlignedWithSuffix(rect.right, bl);
            return rect2;
        }
        throw new IllegalStateException();
    }

    private int calculateExpandedLabelBottom(Rect rect, Rect rect2, float f) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)rect2.top + f);
        }
        return rect.bottom - this.editText.getCompoundPaddingBottom();
    }

    private int calculateExpandedLabelTop(Rect rect, float f) {
        if (this.isSingleLineFilledTextField()) {
            return (int)((float)rect.centerY() - f / 2.0f);
        }
        return rect.top + this.editText.getCompoundPaddingTop();
    }

    private Rect calculateExpandedTextBounds(Rect rect) {
        if (this.editText != null) {
            Rect rect2 = this.tmpBoundsRect;
            float f = this.collapsingTextHelper.getExpandedTextHeight();
            rect2.left = rect.left + this.editText.getCompoundPaddingLeft();
            rect2.top = this.calculateExpandedLabelTop(rect, f);
            rect2.right = rect.right - this.editText.getCompoundPaddingRight();
            rect2.bottom = this.calculateExpandedLabelBottom(rect, rect2, f);
            return rect2;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int calculateLabelMarginTop() {
        float f;
        if (!this.hintEnabled) {
            return 0;
        }
        int n = this.boxBackgroundMode;
        if (n != 0 && n != 1) {
            if (n != 2) {
                return 0;
            }
            f = this.collapsingTextHelper.getCollapsedTextHeight() / 2.0f;
            return (int)f;
        }
        f = this.collapsingTextHelper.getCollapsedTextHeight();
        return (int)f;
    }

    private boolean canDrawOutlineStroke() {
        boolean bl = this.boxBackgroundMode == 2 && this.canDrawStroke();
        return bl;
    }

    private boolean canDrawStroke() {
        boolean bl = this.boxStrokeWidthPx > -1 && this.boxStrokeColor != 0;
        return bl;
    }

    private void closeCutout() {
        if (this.cutoutEnabled()) {
            ((CutoutDrawable)this.boxBackground).removeCutout();
        }
    }

    private void collapseHint(boolean bl) {
        ValueAnimator valueAnimator = this.animator;
        if (valueAnimator != null && valueAnimator.isRunning()) {
            this.animator.cancel();
        }
        if (bl && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(1.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(1.0f);
        }
        this.hintExpanded = false;
        if (this.cutoutEnabled()) {
            this.openCutout();
        }
        this.updatePlaceholderText();
        this.updatePrefixTextVisibility();
        this.updateSuffixTextVisibility();
    }

    private Fade createPlaceholderFadeTransition() {
        Fade fade = new Fade();
        fade.setDuration(87L);
        fade.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        return fade;
    }

    private boolean cutoutEnabled() {
        boolean bl = this.hintEnabled && !TextUtils.isEmpty((CharSequence)this.hint) && this.boxBackground instanceof CutoutDrawable;
        return bl;
    }

    private void dispatchOnEditTextAttached() {
        Iterator iterator2 = this.editTextAttachedListeners.iterator();
        while (iterator2.hasNext()) {
            ((OnEditTextAttachedListener)iterator2.next()).onEditTextAttached(this);
        }
    }

    private void dispatchOnEndIconChanged(int n) {
        Iterator iterator2 = this.endIconChangedListeners.iterator();
        while (iterator2.hasNext()) {
            ((OnEndIconChangedListener)iterator2.next()).onEndIconChanged(this, n);
        }
    }

    private void drawBoxUnderline(Canvas canvas) {
        MaterialShapeDrawable materialShapeDrawable = this.boxUnderline;
        if (materialShapeDrawable != null) {
            materialShapeDrawable = materialShapeDrawable.getBounds();
            ((Rect)materialShapeDrawable).top = ((Rect)materialShapeDrawable).bottom - this.boxStrokeWidthPx;
            this.boxUnderline.draw(canvas);
        }
    }

    private void drawHint(Canvas canvas) {
        if (this.hintEnabled) {
            this.collapsingTextHelper.draw(canvas);
        }
    }

    private void expandHint(boolean bl) {
        ValueAnimator valueAnimator = this.animator;
        if (valueAnimator != null && valueAnimator.isRunning()) {
            this.animator.cancel();
        }
        if (bl && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(0.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(0.0f);
        }
        if (this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout()) {
            this.closeCutout();
        }
        this.hintExpanded = true;
        this.hidePlaceholderText();
        this.updatePrefixTextVisibility();
        this.updateSuffixTextVisibility();
    }

    private EndIconDelegate getEndIconDelegate() {
        EndIconDelegate endIconDelegate = (EndIconDelegate)this.endIconDelegates.get(this.endIconMode);
        if (endIconDelegate == null) {
            endIconDelegate = (EndIconDelegate)this.endIconDelegates.get(0);
        }
        return endIconDelegate;
    }

    private CheckableImageButton getEndIconToUpdateDummyDrawable() {
        if (this.errorIconView.getVisibility() == 0) {
            return this.errorIconView;
        }
        if (this.hasEndIcon() && this.isEndIconVisible()) {
            return this.endIconView;
        }
        return null;
    }

    private int getLabelLeftBoundAlightWithPrefix(int n, boolean bl) {
        int n2;
        n = n2 = n + this.editText.getCompoundPaddingLeft();
        if (this.prefixText != null) {
            n = n2;
            if (!bl) {
                n = n2 - this.prefixTextView.getMeasuredWidth() + this.prefixTextView.getPaddingLeft();
            }
        }
        return n;
    }

    private int getLabelRightBoundAlignedWithSuffix(int n, boolean bl) {
        int n2;
        n = n2 = n - this.editText.getCompoundPaddingRight();
        if (this.prefixText != null) {
            n = n2;
            if (bl) {
                n = n2 + (this.prefixTextView.getMeasuredWidth() - this.prefixTextView.getPaddingRight());
            }
        }
        return n;
    }

    private boolean hasEndIcon() {
        boolean bl = this.endIconMode != 0;
        return bl;
    }

    private void hidePlaceholderText() {
        TextView textView = this.placeholderTextView;
        if (textView != null && this.placeholderEnabled) {
            textView.setText(null);
            TransitionManager.beginDelayedTransition((ViewGroup)this.inputFrame, (Transition)this.placeholderFadeOut);
            this.placeholderTextView.setVisibility(4);
        }
    }

    private boolean isErrorIconVisible() {
        boolean bl = this.errorIconView.getVisibility() == 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSingleLineFilledTextField() {
        int n = this.boxBackgroundMode;
        boolean bl = true;
        if (n != 1) return false;
        boolean bl2 = bl;
        if (Build.VERSION.SDK_INT < 16) return bl2;
        if (this.editText.getMinLines() > 1) return false;
        return bl;
    }

    private int[] mergeIconState(CheckableImageButton object) {
        int[] nArray = this.getDrawableState();
        object = object.getDrawableState();
        int n = nArray.length;
        nArray = Arrays.copyOf(nArray, nArray.length + ((CheckableImageButton)object).length);
        System.arraycopy(object, 0, nArray, n, ((CheckableImageButton)object).length);
        return nArray;
    }

    private void onApplyBoxBackgroundMode() {
        this.assignBoxBackgroundByMode();
        this.setEditTextBoxBackground();
        this.updateTextInputBoxState();
        this.updateBoxCollapsedPaddingTop();
        this.adjustFilledEditTextPaddingForLargeFont();
        if (this.boxBackgroundMode != 0) {
            this.updateInputLayoutMargins();
        }
    }

    private void openCutout() {
        if (!this.cutoutEnabled()) {
            return;
        }
        RectF rectF = this.tmpRectF;
        this.collapsingTextHelper.getCollapsedTextActualBounds(rectF, this.editText.getWidth(), this.editText.getGravity());
        this.applyCutoutPadding(rectF);
        rectF.offset((float)(-this.getPaddingLeft()), (float)(-this.getPaddingTop()) - rectF.height() / 2.0f + (float)this.boxStrokeWidthPx);
        ((CutoutDrawable)this.boxBackground).setCutout(rectF);
    }

    private void recalculateCutout() {
        if (this.cutoutEnabled() && !this.hintExpanded) {
            this.closeCutout();
            this.openCutout();
        }
    }

    private static void recursiveSetEnabled(ViewGroup viewGroup, boolean bl) {
        int n = viewGroup.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = viewGroup.getChildAt(i);
            view.setEnabled(bl);
            if (!(view instanceof ViewGroup)) continue;
            TextInputLayout.recursiveSetEnabled((ViewGroup)view, bl);
        }
    }

    private void refreshIconDrawableState(CheckableImageButton checkableImageButton, ColorStateList colorStateList) {
        Drawable drawable2 = checkableImageButton.getDrawable();
        if (checkableImageButton.getDrawable() != null && colorStateList != null && colorStateList.isStateful()) {
            int n = colorStateList.getColorForState(this.mergeIconState(checkableImageButton), colorStateList.getDefaultColor());
            colorStateList = DrawableCompat.wrap((Drawable)drawable2).mutate();
            DrawableCompat.setTintList((Drawable)colorStateList, (ColorStateList)ColorStateList.valueOf((int)n));
            checkableImageButton.setImageDrawable((Drawable)colorStateList);
        }
    }

    private void removePlaceholderTextView() {
        TextView textView = this.placeholderTextView;
        if (textView != null) {
            textView.setVisibility(8);
        }
    }

    private void setEditText(EditText editText) {
        if (this.editText == null) {
            if (this.endIconMode != 3 && !(editText instanceof TextInputEditText)) {
                Log.i((String)LOG_TAG, (String)"EditText added is not a TextInputEditText. Please switch to using that class instead.");
            }
            this.editText = editText;
            this.setMinWidth(this.minWidth);
            this.setMaxWidth(this.maxWidth);
            this.onApplyBoxBackgroundMode();
            this.setTextInputAccessibilityDelegate(new AccessibilityDelegate(this));
            this.collapsingTextHelper.setTypefaces(this.editText.getTypeface());
            this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
            int n = this.editText.getGravity();
            this.collapsingTextHelper.setCollapsedTextGravity(n & 0xFFFFFF8F | 0x30);
            this.collapsingTextHelper.setExpandedTextGravity(n);
            this.editText.addTextChangedListener(new TextWatcher(){

                public void afterTextChanged(Editable editable) {
                    TextInputLayout textInputLayout = TextInputLayout.this;
                    textInputLayout.updateLabelState(textInputLayout.restoringSavedState ^ true);
                    if (TextInputLayout.this.counterEnabled) {
                        TextInputLayout.this.updateCounter(editable.length());
                    }
                    if (TextInputLayout.this.placeholderEnabled) {
                        TextInputLayout.this.updatePlaceholderText(editable.length());
                    }
                }

                public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                }

                public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                }
            });
            if (this.defaultHintTextColor == null) {
                this.defaultHintTextColor = this.editText.getHintTextColors();
            }
            if (this.hintEnabled) {
                if (TextUtils.isEmpty((CharSequence)this.hint)) {
                    CharSequence charSequence;
                    this.originalHint = charSequence = this.editText.getHint();
                    this.setHint(charSequence);
                    this.editText.setHint(null);
                }
                this.isProvidingHint = true;
            }
            if (this.counterView != null) {
                this.updateCounter(this.editText.getText().length());
            }
            this.updateEditTextBackground();
            this.indicatorViewController.adjustIndicatorPadding();
            this.startLayout.bringToFront();
            this.endLayout.bringToFront();
            this.endIconFrame.bringToFront();
            this.errorIconView.bringToFront();
            this.dispatchOnEditTextAttached();
            this.updatePrefixTextViewPadding();
            this.updateSuffixTextViewPadding();
            if (!this.isEnabled()) {
                editText.setEnabled(false);
            }
            this.updateLabelState(false, true);
            return;
        }
        throw new IllegalArgumentException("We already have an EditText, can only have one");
    }

    private void setEditTextBoxBackground() {
        if (this.shouldUseEditTextBackgroundForBoxBackground()) {
            ViewCompat.setBackground((View)this.editText, (Drawable)this.boxBackground);
        }
    }

    private void setErrorIconVisible(boolean bl) {
        CheckableImageButton checkableImageButton = this.errorIconView;
        int n = 0;
        int n2 = bl ? 0 : 8;
        checkableImageButton.setVisibility(n2);
        checkableImageButton = this.endIconFrame;
        n2 = n;
        if (bl) {
            n2 = 8;
        }
        checkableImageButton.setVisibility(n2);
        this.updateSuffixTextViewPadding();
        if (!this.hasEndIcon()) {
            this.updateDummyDrawables();
        }
    }

    private void setHintInternal(CharSequence charSequence) {
        if (!TextUtils.equals((CharSequence)charSequence, (CharSequence)this.hint)) {
            this.hint = charSequence;
            this.collapsingTextHelper.setText(charSequence);
            if (!this.hintExpanded) {
                this.openCutout();
            }
        }
    }

    private static void setIconClickable(CheckableImageButton checkableImageButton, View.OnLongClickListener onLongClickListener) {
        boolean bl = ViewCompat.hasOnClickListeners((View)checkableImageButton);
        boolean bl2 = false;
        int n = 1;
        boolean bl3 = onLongClickListener != null;
        if (bl || bl3) {
            bl2 = true;
        }
        checkableImageButton.setFocusable(bl2);
        checkableImageButton.setClickable(bl);
        checkableImageButton.setPressable(bl);
        checkableImageButton.setLongClickable(bl3);
        if (!bl2) {
            n = 2;
        }
        ViewCompat.setImportantForAccessibility((View)checkableImageButton, (int)n);
    }

    private static void setIconOnClickListener(CheckableImageButton checkableImageButton, View.OnClickListener onClickListener, View.OnLongClickListener onLongClickListener) {
        checkableImageButton.setOnClickListener(onClickListener);
        TextInputLayout.setIconClickable(checkableImageButton, onLongClickListener);
    }

    private static void setIconOnLongClickListener(CheckableImageButton checkableImageButton, View.OnLongClickListener onLongClickListener) {
        checkableImageButton.setOnLongClickListener(onLongClickListener);
        TextInputLayout.setIconClickable(checkableImageButton, onLongClickListener);
    }

    private void setPlaceholderTextEnabled(boolean bl) {
        if (this.placeholderEnabled == bl) {
            return;
        }
        if (bl) {
            AppCompatTextView appCompatTextView = new AppCompatTextView(this.getContext());
            this.placeholderTextView = appCompatTextView;
            appCompatTextView.setId(R.id.textinput_placeholder);
            appCompatTextView = this.createPlaceholderFadeTransition();
            this.placeholderFadeIn = appCompatTextView;
            appCompatTextView.setStartDelay(67L);
            this.placeholderFadeOut = this.createPlaceholderFadeTransition();
            ViewCompat.setAccessibilityLiveRegion((View)this.placeholderTextView, (int)1);
            this.setPlaceholderTextAppearance(this.placeholderTextAppearance);
            this.setPlaceholderTextColor(this.placeholderTextColor);
            this.addPlaceholderTextView();
        } else {
            this.removePlaceholderTextView();
            this.placeholderTextView = null;
        }
        this.placeholderEnabled = bl;
    }

    private boolean shouldUpdateEndDummyDrawable() {
        boolean bl = (this.errorIconView.getVisibility() == 0 || this.hasEndIcon() && this.isEndIconVisible() || this.suffixText != null) && this.endLayout.getMeasuredWidth() > 0;
        return bl;
    }

    private boolean shouldUpdateStartDummyDrawable() {
        boolean bl = (this.getStartIconDrawable() != null || this.prefixText != null) && this.startLayout.getMeasuredWidth() > 0;
        return bl;
    }

    private boolean shouldUseEditTextBackgroundForBoxBackground() {
        EditText editText = this.editText;
        boolean bl = editText != null && this.boxBackground != null && editText.getBackground() == null && this.boxBackgroundMode != 0;
        return bl;
    }

    private void showPlaceholderText() {
        TextView textView = this.placeholderTextView;
        if (textView != null && this.placeholderEnabled) {
            textView.setText(this.placeholderText);
            TransitionManager.beginDelayedTransition((ViewGroup)this.inputFrame, (Transition)this.placeholderFadeIn);
            this.placeholderTextView.setVisibility(0);
            this.placeholderTextView.bringToFront();
        }
    }

    private void tintEndIconOnError(boolean bl) {
        if (bl && this.getEndIconDrawable() != null) {
            Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getEndIconDrawable()).mutate();
            DrawableCompat.setTint((Drawable)drawable2, (int)this.indicatorViewController.getErrorViewCurrentTextColor());
            this.endIconView.setImageDrawable(drawable2);
        } else {
            this.applyEndIconTint();
        }
    }

    private void updateBoxCollapsedPaddingTop() {
        if (this.boxBackgroundMode == 1) {
            if (MaterialResources.isFontScaleAtLeast2_0(this.getContext())) {
                this.boxCollapsedPaddingTopPx = this.getResources().getDimensionPixelSize(R.dimen.material_font_2_0_box_collapsed_padding_top);
            } else if (MaterialResources.isFontScaleAtLeast1_3(this.getContext())) {
                this.boxCollapsedPaddingTopPx = this.getResources().getDimensionPixelSize(R.dimen.material_font_1_3_box_collapsed_padding_top);
            }
        }
    }

    private void updateBoxUnderlineBounds(Rect rect) {
        if (this.boxUnderline != null) {
            int n = rect.bottom;
            int n2 = this.boxStrokeWidthFocusedPx;
            this.boxUnderline.setBounds(rect.left, n - n2, rect.right, rect.bottom);
        }
    }

    private void updateCounter() {
        if (this.counterView != null) {
            EditText editText = this.editText;
            int n = editText == null ? 0 : editText.getText().length();
            this.updateCounter(n);
        }
    }

    private static void updateCounterContentDescription(Context context, TextView textView, int n, int n2, boolean bl) {
        int n3 = bl ? R.string.character_counter_overflowed_content_description : R.string.character_counter_content_description;
        textView.setContentDescription((CharSequence)context.getString(n3, new Object[]{n, n2}));
    }

    private void updateCounterTextAppearanceAndColor() {
        TextView textView = this.counterView;
        if (textView != null) {
            int n = this.counterOverflowed ? this.counterOverflowTextAppearance : this.counterTextAppearance;
            this.setTextAppearanceCompatWithErrorFallback(textView, n);
            if (!this.counterOverflowed && (textView = this.counterTextColor) != null) {
                this.counterView.setTextColor((ColorStateList)textView);
            }
            if (this.counterOverflowed && (textView = this.counterOverflowTextColor) != null) {
                this.counterView.setTextColor((ColorStateList)textView);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean updateDummyDrawables() {
        block17: {
            block16: {
                block15: {
                    block14: {
                        if (this.editText == null) {
                            return false;
                        }
                        var1_1 = this.shouldUpdateStartDummyDrawable();
                        var2_2 = true;
                        var3_3 = true;
                        if (!var1_1) break block14;
                        var4_4 = this.startLayout.getMeasuredWidth() - this.editText.getPaddingLeft();
                        if (this.startDummyDrawable == null || this.startDummyDrawableWidth != var4_4) {
                            this.startDummyDrawable = var5_5 /* !! */  = new ColorDrawable();
                            this.startDummyDrawableWidth = var4_4;
                            var5_5 /* !! */ .setBounds(0, 0, var4_4, 1);
                        }
                        if ((var6_6 = (var5_5 /* !! */  = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText))[0]) == (var7_7 = this.startDummyDrawable)) ** GOTO lbl-1000
                        TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)var7_7, (Drawable)var5_5 /* !! */ [1], (Drawable)var5_5 /* !! */ [2], (Drawable)var5_5 /* !! */ [3]);
                        ** GOTO lbl20
                    }
                    if (this.startDummyDrawable != null) {
                        var5_5 /* !! */  = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
                        TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, null, (Drawable)var5_5 /* !! */ [1], (Drawable)var5_5 /* !! */ [2], (Drawable)var5_5 /* !! */ [3]);
                        this.startDummyDrawable = null;
lbl20:
                        // 2 sources

                        var1_1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_1 = false;
                    }
                    if (!this.shouldUpdateEndDummyDrawable()) break block15;
                    var8_8 = this.suffixTextView.getMeasuredWidth() - this.editText.getPaddingRight();
                    var5_5 /* !! */  = this.getEndIconToUpdateDummyDrawable();
                    var4_4 = var8_8;
                    if (var5_5 /* !! */  != null) {
                        var4_4 = var8_8 + var5_5 /* !! */ .getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)var5_5 /* !! */ .getLayoutParams()));
                    }
                    var5_5 /* !! */  = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
                    var7_7 = this.endDummyDrawable;
                    if (var7_7 != null && this.endDummyDrawableWidth != var4_4) {
                        this.endDummyDrawableWidth = var4_4;
                        var7_7.setBounds(0, 0, var4_4, 1);
                        TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)var5_5 /* !! */ [0], (Drawable)var5_5 /* !! */ [1], (Drawable)this.endDummyDrawable, (Drawable)var5_5 /* !! */ [3]);
                        var1_1 = var2_2;
                    } else {
                        if (var7_7 == null) {
                            this.endDummyDrawable = var7_7 = new ColorDrawable();
                            this.endDummyDrawableWidth = var4_4;
                            var7_7.setBounds(0, 0, var4_4, 1);
                        }
                        if ((var7_7 = var5_5 /* !! */ [2]) != (var6_6 = this.endDummyDrawable)) {
                            this.originalEditTextEndDrawable = var5_5 /* !! */ [2];
                            TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)var5_5 /* !! */ [0], (Drawable)var5_5 /* !! */ [1], (Drawable)var6_6, (Drawable)var5_5 /* !! */ [3]);
                            var1_1 = var2_2;
                        }
                    }
                    break block16;
                }
                var2_2 = var1_1;
                if (this.endDummyDrawable == null) break block17;
                var5_5 /* !! */  = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
                if (var5_5 /* !! */ [2] == this.endDummyDrawable) {
                    TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)var5_5 /* !! */ [0], (Drawable)var5_5 /* !! */ [1], (Drawable)this.originalEditTextEndDrawable, (Drawable)var5_5 /* !! */ [3]);
                    var1_1 = var3_3;
                }
                this.endDummyDrawable = null;
            }
            var2_2 = var1_1;
        }
        return var2_2;
    }

    private boolean updateEditTextHeightBasedOnIcon() {
        if (this.editText == null) {
            return false;
        }
        int n = Math.max(this.endLayout.getMeasuredHeight(), this.startLayout.getMeasuredHeight());
        if (this.editText.getMeasuredHeight() < n) {
            this.editText.setMinimumHeight(n);
            return true;
        }
        return false;
    }

    private void updateInputLayoutMargins() {
        if (this.boxBackgroundMode != 1) {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.inputFrame.getLayoutParams();
            int n = this.calculateLabelMarginTop();
            if (n != layoutParams.topMargin) {
                layoutParams.topMargin = n;
                this.inputFrame.requestLayout();
            }
        }
    }

    private void updateLabelState(boolean bl, boolean bl2) {
        boolean bl3 = this.isEnabled();
        EditText editText = this.editText;
        boolean bl4 = editText != null && !TextUtils.isEmpty((CharSequence)editText.getText());
        editText = this.editText;
        boolean bl5 = editText != null && editText.hasFocus();
        boolean bl6 = this.indicatorViewController.errorShouldBeShown();
        editText = this.defaultHintTextColor;
        if (editText != null) {
            this.collapsingTextHelper.setCollapsedTextColor((ColorStateList)editText);
            this.collapsingTextHelper.setExpandedTextColor(this.defaultHintTextColor);
        }
        if (!bl3) {
            int n;
            editText = this.defaultHintTextColor;
            if (editText != null) {
                n = this.disabledColor;
                n = editText.getColorForState(new int[]{-16842910}, n);
            } else {
                n = this.disabledColor;
            }
            this.collapsingTextHelper.setCollapsedTextColor(ColorStateList.valueOf((int)n));
            this.collapsingTextHelper.setExpandedTextColor(ColorStateList.valueOf((int)n));
        } else if (bl6) {
            this.collapsingTextHelper.setCollapsedTextColor(this.indicatorViewController.getErrorViewTextColors());
        } else if (this.counterOverflowed && (editText = this.counterView) != null) {
            this.collapsingTextHelper.setCollapsedTextColor(editText.getTextColors());
        } else if (bl5 && (editText = this.focusedTextColor) != null) {
            this.collapsingTextHelper.setCollapsedTextColor((ColorStateList)editText);
        }
        if (!(bl4 || !this.expandedHintEnabled || this.isEnabled() && bl5)) {
            if (bl2 || !this.hintExpanded) {
                this.expandHint(bl);
            }
        } else if (bl2 || this.hintExpanded) {
            this.collapseHint(bl);
        }
    }

    private void updatePlaceholderMeasurementsBasedOnEditText() {
        EditText editText;
        if (this.placeholderTextView != null && (editText = this.editText) != null) {
            int n = editText.getGravity();
            this.placeholderTextView.setGravity(n);
            this.placeholderTextView.setPadding(this.editText.getCompoundPaddingLeft(), this.editText.getCompoundPaddingTop(), this.editText.getCompoundPaddingRight(), this.editText.getCompoundPaddingBottom());
        }
    }

    private void updatePlaceholderText() {
        EditText editText = this.editText;
        int n = editText == null ? 0 : editText.getText().length();
        this.updatePlaceholderText(n);
    }

    private void updatePlaceholderText(int n) {
        if (n == 0 && !this.hintExpanded) {
            this.showPlaceholderText();
        } else {
            this.hidePlaceholderText();
        }
    }

    private void updatePrefixTextViewPadding() {
        if (this.editText == null) {
            return;
        }
        int n = this.isStartIconVisible() ? 0 : ViewCompat.getPaddingStart((View)this.editText);
        ViewCompat.setPaddingRelative((View)this.prefixTextView, (int)n, (int)this.editText.getCompoundPaddingTop(), (int)this.getContext().getResources().getDimensionPixelSize(R.dimen.material_input_text_to_prefix_suffix_padding), (int)this.editText.getCompoundPaddingBottom());
    }

    private void updatePrefixTextVisibility() {
        TextView textView = this.prefixTextView;
        int n = this.prefixText != null && !this.isHintExpanded() ? 0 : 8;
        textView.setVisibility(n);
        this.updateDummyDrawables();
    }

    private void updateStrokeErrorColor(boolean bl, boolean bl2) {
        int n = this.strokeErrorColor.getDefaultColor();
        int n2 = this.strokeErrorColor.getColorForState(new int[]{16843623, 16842910}, n);
        int n3 = this.strokeErrorColor.getColorForState(new int[]{16843518, 16842910}, n);
        this.boxStrokeColor = bl ? n3 : (bl2 ? n2 : n);
    }

    private void updateSuffixTextViewPadding() {
        if (this.editText == null) {
            return;
        }
        int n = !this.isEndIconVisible() && !this.isErrorIconVisible() ? ViewCompat.getPaddingEnd((View)this.editText) : 0;
        ViewCompat.setPaddingRelative((View)this.suffixTextView, (int)this.getContext().getResources().getDimensionPixelSize(R.dimen.material_input_text_to_prefix_suffix_padding), (int)this.editText.getPaddingTop(), (int)n, (int)this.editText.getPaddingBottom());
    }

    private void updateSuffixTextVisibility() {
        int n = this.suffixTextView.getVisibility();
        CharSequence charSequence = this.suffixText;
        int n2 = 0;
        boolean bl = charSequence != null && !this.isHintExpanded();
        charSequence = this.suffixTextView;
        if (!bl) {
            n2 = 8;
        }
        charSequence.setVisibility(n2);
        if (n != this.suffixTextView.getVisibility()) {
            this.getEndIconDelegate().onSuffixVisibilityChanged(bl);
        }
        this.updateDummyDrawables();
    }

    public void addOnEditTextAttachedListener(OnEditTextAttachedListener onEditTextAttachedListener) {
        this.editTextAttachedListeners.add(onEditTextAttachedListener);
        if (this.editText != null) {
            onEditTextAttachedListener.onEditTextAttached(this);
        }
    }

    public void addOnEndIconChangedListener(OnEndIconChangedListener onEndIconChangedListener) {
        this.endIconChangedListeners.add(onEndIconChangedListener);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof EditText) {
            FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(layoutParams);
            layoutParams2.gravity = layoutParams2.gravity & 0xFFFFFF8F | 0x10;
            this.inputFrame.addView(view, (ViewGroup.LayoutParams)layoutParams2);
            this.inputFrame.setLayoutParams(layoutParams);
            this.updateInputLayoutMargins();
            this.setEditText((EditText)view);
        } else {
            super.addView(view, n, layoutParams);
        }
    }

    void animateToExpansionFraction(float f) {
        if (this.collapsingTextHelper.getExpansionFraction() == f) {
            return;
        }
        if (this.animator == null) {
            ValueAnimator valueAnimator;
            this.animator = valueAnimator = new ValueAnimator();
            valueAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.animator.setDuration(167L);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    TextInputLayout.this.collapsingTextHelper.setExpansionFraction(((Float)valueAnimator.getAnimatedValue()).floatValue());
                }
            });
        }
        this.animator.setFloatValues(new float[]{this.collapsingTextHelper.getExpansionFraction(), f});
        this.animator.start();
    }

    public void clearOnEditTextAttachedListeners() {
        this.editTextAttachedListeners.clear();
    }

    public void clearOnEndIconChangedListeners() {
        this.endIconChangedListeners.clear();
    }

    boolean cutoutIsOpen() {
        boolean bl = this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout();
        return bl;
    }

    public void dispatchProvideAutofillStructure(ViewStructure viewStructure, int n) {
        EditText editText = this.editText;
        if (editText == null) {
            super.dispatchProvideAutofillStructure(viewStructure, n);
            return;
        }
        CharSequence charSequence = this.originalHint;
        if (charSequence != null) {
            boolean bl = this.isProvidingHint;
            this.isProvidingHint = false;
            charSequence = editText.getHint();
            this.editText.setHint(this.originalHint);
            try {
                super.dispatchProvideAutofillStructure(viewStructure, n);
            }
            finally {
                this.editText.setHint(charSequence);
                this.isProvidingHint = bl;
            }
        } else {
            viewStructure.setAutofillId(this.getAutofillId());
            this.onProvideAutofillStructure(viewStructure, n);
            this.onProvideAutofillVirtualStructure(viewStructure, n);
            viewStructure.setChildCount(this.inputFrame.getChildCount());
            for (int i = 0; i < this.inputFrame.getChildCount(); ++i) {
                charSequence = this.inputFrame.getChildAt(i);
                editText = viewStructure.newChild(i);
                charSequence.dispatchProvideAutofillStructure((ViewStructure)editText, n);
                if (charSequence != this.editText) continue;
                editText.setHint(this.getHint());
            }
        }
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        this.restoringSavedState = true;
        super.dispatchRestoreInstanceState(sparseArray);
        this.restoringSavedState = false;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.drawHint(canvas);
        this.drawBoxUnderline(canvas);
    }

    protected void drawableStateChanged() {
        if (this.inDrawableStateChanged) {
            return;
        }
        boolean bl = true;
        this.inDrawableStateChanged = true;
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        CollapsingTextHelper collapsingTextHelper = this.collapsingTextHelper;
        boolean bl2 = collapsingTextHelper != null ? collapsingTextHelper.setState(nArray) | false : false;
        if (this.editText != null) {
            if (!ViewCompat.isLaidOut((View)this) || !this.isEnabled()) {
                bl = false;
            }
            this.updateLabelState(bl);
        }
        this.updateEditTextBackground();
        this.updateTextInputBoxState();
        if (bl2) {
            this.invalidate();
        }
        this.inDrawableStateChanged = false;
    }

    public int getBaseline() {
        EditText editText = this.editText;
        if (editText != null) {
            return editText.getBaseline() + this.getPaddingTop() + this.calculateLabelMarginTop();
        }
        return super.getBaseline();
    }

    MaterialShapeDrawable getBoxBackground() {
        int n = this.boxBackgroundMode;
        if (n != 1 && n != 2) {
            throw new IllegalStateException();
        }
        return this.boxBackground;
    }

    public int getBoxBackgroundColor() {
        return this.boxBackgroundColor;
    }

    public int getBoxBackgroundMode() {
        return this.boxBackgroundMode;
    }

    public int getBoxCollapsedPaddingTop() {
        return this.boxCollapsedPaddingTopPx;
    }

    public float getBoxCornerRadiusBottomEnd() {
        return this.boxBackground.getBottomLeftCornerResolvedSize();
    }

    public float getBoxCornerRadiusBottomStart() {
        return this.boxBackground.getBottomRightCornerResolvedSize();
    }

    public float getBoxCornerRadiusTopEnd() {
        return this.boxBackground.getTopRightCornerResolvedSize();
    }

    public float getBoxCornerRadiusTopStart() {
        return this.boxBackground.getTopLeftCornerResolvedSize();
    }

    public int getBoxStrokeColor() {
        return this.focusedStrokeColor;
    }

    public ColorStateList getBoxStrokeErrorColor() {
        return this.strokeErrorColor;
    }

    public int getBoxStrokeWidth() {
        return this.boxStrokeWidthDefaultPx;
    }

    public int getBoxStrokeWidthFocused() {
        return this.boxStrokeWidthFocusedPx;
    }

    public int getCounterMaxLength() {
        return this.counterMaxLength;
    }

    CharSequence getCounterOverflowDescription() {
        TextView textView;
        if (this.counterEnabled && this.counterOverflowed && (textView = this.counterView) != null) {
            return textView.getContentDescription();
        }
        return null;
    }

    public ColorStateList getCounterOverflowTextColor() {
        return this.counterTextColor;
    }

    public ColorStateList getCounterTextColor() {
        return this.counterTextColor;
    }

    public ColorStateList getDefaultHintTextColor() {
        return this.defaultHintTextColor;
    }

    public EditText getEditText() {
        return this.editText;
    }

    public CharSequence getEndIconContentDescription() {
        return this.endIconView.getContentDescription();
    }

    public Drawable getEndIconDrawable() {
        return this.endIconView.getDrawable();
    }

    public int getEndIconMode() {
        return this.endIconMode;
    }

    CheckableImageButton getEndIconView() {
        return this.endIconView;
    }

    public CharSequence getError() {
        CharSequence charSequence = this.indicatorViewController.isErrorEnabled() ? this.indicatorViewController.getErrorText() : null;
        return charSequence;
    }

    public CharSequence getErrorContentDescription() {
        return this.indicatorViewController.getErrorContentDescription();
    }

    public int getErrorCurrentTextColors() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    public Drawable getErrorIconDrawable() {
        return this.errorIconView.getDrawable();
    }

    final int getErrorTextCurrentColor() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    public CharSequence getHelperText() {
        CharSequence charSequence = this.indicatorViewController.isHelperTextEnabled() ? this.indicatorViewController.getHelperText() : null;
        return charSequence;
    }

    public int getHelperTextCurrentTextColor() {
        return this.indicatorViewController.getHelperTextViewCurrentTextColor();
    }

    public CharSequence getHint() {
        CharSequence charSequence = this.hintEnabled ? this.hint : null;
        return charSequence;
    }

    final float getHintCollapsedTextHeight() {
        return this.collapsingTextHelper.getCollapsedTextHeight();
    }

    final int getHintCurrentCollapsedTextColor() {
        return this.collapsingTextHelper.getCurrentCollapsedTextColor();
    }

    public ColorStateList getHintTextColor() {
        return this.focusedTextColor;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    @Deprecated
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.endIconView.getContentDescription();
    }

    @Deprecated
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.endIconView.getDrawable();
    }

    public CharSequence getPlaceholderText() {
        CharSequence charSequence = this.placeholderEnabled ? this.placeholderText : null;
        return charSequence;
    }

    public int getPlaceholderTextAppearance() {
        return this.placeholderTextAppearance;
    }

    public ColorStateList getPlaceholderTextColor() {
        return this.placeholderTextColor;
    }

    public CharSequence getPrefixText() {
        return this.prefixText;
    }

    public ColorStateList getPrefixTextColor() {
        return this.prefixTextView.getTextColors();
    }

    public TextView getPrefixTextView() {
        return this.prefixTextView;
    }

    public CharSequence getStartIconContentDescription() {
        return this.startIconView.getContentDescription();
    }

    public Drawable getStartIconDrawable() {
        return this.startIconView.getDrawable();
    }

    public CharSequence getSuffixText() {
        return this.suffixText;
    }

    public ColorStateList getSuffixTextColor() {
        return this.suffixTextView.getTextColors();
    }

    public TextView getSuffixTextView() {
        return this.suffixTextView;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public boolean isCounterEnabled() {
        return this.counterEnabled;
    }

    public boolean isEndIconCheckable() {
        return this.endIconView.isCheckable();
    }

    public boolean isEndIconVisible() {
        boolean bl = this.endIconFrame.getVisibility() == 0 && this.endIconView.getVisibility() == 0;
        return bl;
    }

    public boolean isErrorEnabled() {
        return this.indicatorViewController.isErrorEnabled();
    }

    public boolean isExpandedHintEnabled() {
        return this.expandedHintEnabled;
    }

    final boolean isHelperTextDisplayed() {
        return this.indicatorViewController.helperTextIsDisplayed();
    }

    public boolean isHelperTextEnabled() {
        return this.indicatorViewController.isHelperTextEnabled();
    }

    public boolean isHintAnimationEnabled() {
        return this.hintAnimationEnabled;
    }

    public boolean isHintEnabled() {
        return this.hintEnabled;
    }

    final boolean isHintExpanded() {
        return this.hintExpanded;
    }

    @Deprecated
    public boolean isPasswordVisibilityToggleEnabled() {
        int n = this.endIconMode;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    public boolean isProvidingHint() {
        return this.isProvidingHint;
    }

    public boolean isStartIconCheckable() {
        return this.startIconView.isCheckable();
    }

    public boolean isStartIconVisible() {
        boolean bl = this.startIconView.getVisibility() == 0;
        return bl;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        EditText editText = this.editText;
        if (editText != null) {
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)this, (View)editText, rect);
            this.updateBoxUnderlineBounds(rect);
            if (this.hintEnabled) {
                this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
                n = this.editText.getGravity();
                this.collapsingTextHelper.setCollapsedTextGravity(n & 0xFFFFFF8F | 0x30);
                this.collapsingTextHelper.setExpandedTextGravity(n);
                this.collapsingTextHelper.setCollapsedBounds(this.calculateCollapsedTextBounds(rect));
                this.collapsingTextHelper.setExpandedBounds(this.calculateExpandedTextBounds(rect));
                this.collapsingTextHelper.recalculate();
                if (this.cutoutEnabled() && !this.hintExpanded) {
                    this.openCutout();
                }
            }
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        boolean bl = this.updateEditTextHeightBasedOnIcon();
        boolean bl2 = this.updateDummyDrawables();
        if (bl || bl2) {
            this.editText.post(new Runnable(){

                @Override
                public void run() {
                    TextInputLayout.this.editText.requestLayout();
                }
            });
        }
        this.updatePlaceholderMeasurementsBasedOnEditText();
        this.updatePrefixTextViewPadding();
        this.updateSuffixTextViewPadding();
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.setError(object.error);
        if (object.isEndIconChecked) {
            this.endIconView.post(new Runnable(){

                @Override
                public void run() {
                    TextInputLayout.this.endIconView.performClick();
                    TextInputLayout.this.endIconView.jumpDrawablesToCurrentState();
                }
            });
        }
        this.setHint(object.hintText);
        this.setHelperText(object.helperText);
        this.setPlaceholderText(object.placeholderText);
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.indicatorViewController.errorShouldBeShown()) {
            savedState.error = this.getError();
        }
        boolean bl = this.hasEndIcon() && this.endIconView.isChecked();
        savedState.isEndIconChecked = bl;
        savedState.hintText = this.getHint();
        savedState.helperText = this.getHelperText();
        savedState.placeholderText = this.getPlaceholderText();
        return savedState;
    }

    @Deprecated
    public void passwordVisibilityToggleRequested(boolean bl) {
        if (this.endIconMode == 1) {
            this.endIconView.performClick();
            if (bl) {
                this.endIconView.jumpDrawablesToCurrentState();
            }
        }
    }

    public void refreshEndIconDrawableState() {
        this.refreshIconDrawableState(this.endIconView, this.endIconTintList);
    }

    public void refreshErrorIconDrawableState() {
        this.refreshIconDrawableState(this.errorIconView, this.errorIconTintList);
    }

    public void refreshStartIconDrawableState() {
        this.refreshIconDrawableState(this.startIconView, this.startIconTintList);
    }

    public void removeOnEditTextAttachedListener(OnEditTextAttachedListener onEditTextAttachedListener) {
        this.editTextAttachedListeners.remove(onEditTextAttachedListener);
    }

    public void removeOnEndIconChangedListener(OnEndIconChangedListener onEndIconChangedListener) {
        this.endIconChangedListeners.remove(onEndIconChangedListener);
    }

    public void setBoxBackgroundColor(int n) {
        if (this.boxBackgroundColor != n) {
            this.boxBackgroundColor = n;
            this.defaultFilledBackgroundColor = n;
            this.focusedFilledBackgroundColor = n;
            this.hoveredFilledBackgroundColor = n;
            this.applyBoxAttributes();
        }
    }

    public void setBoxBackgroundColorResource(int n) {
        this.setBoxBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public void setBoxBackgroundColorStateList(ColorStateList colorStateList) {
        int n;
        this.defaultFilledBackgroundColor = n = colorStateList.getDefaultColor();
        this.boxBackgroundColor = n;
        this.disabledFilledBackgroundColor = colorStateList.getColorForState(new int[]{-16842910}, -1);
        this.focusedFilledBackgroundColor = colorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        this.hoveredFilledBackgroundColor = colorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
        this.applyBoxAttributes();
    }

    public void setBoxBackgroundMode(int n) {
        if (n == this.boxBackgroundMode) {
            return;
        }
        this.boxBackgroundMode = n;
        if (this.editText != null) {
            this.onApplyBoxBackgroundMode();
        }
    }

    public void setBoxCollapsedPaddingTop(int n) {
        this.boxCollapsedPaddingTopPx = n;
    }

    public void setBoxCornerRadii(float f, float f2, float f3, float f4) {
        MaterialShapeDrawable materialShapeDrawable = this.boxBackground;
        if (materialShapeDrawable == null || materialShapeDrawable.getTopLeftCornerResolvedSize() != f || this.boxBackground.getTopRightCornerResolvedSize() != f2 || this.boxBackground.getBottomRightCornerResolvedSize() != f4 || this.boxBackground.getBottomLeftCornerResolvedSize() != f3) {
            this.shapeAppearanceModel = this.shapeAppearanceModel.toBuilder().setTopLeftCornerSize(f).setTopRightCornerSize(f2).setBottomRightCornerSize(f4).setBottomLeftCornerSize(f3).build();
            this.applyBoxAttributes();
        }
    }

    public void setBoxCornerRadiiResources(int n, int n2, int n3, int n4) {
        this.setBoxCornerRadii(this.getContext().getResources().getDimension(n), this.getContext().getResources().getDimension(n2), this.getContext().getResources().getDimension(n4), this.getContext().getResources().getDimension(n3));
    }

    public void setBoxStrokeColor(int n) {
        if (this.focusedStrokeColor != n) {
            this.focusedStrokeColor = n;
            this.updateTextInputBoxState();
        }
    }

    public void setBoxStrokeColorStateList(ColorStateList colorStateList) {
        if (colorStateList.isStateful()) {
            this.defaultStrokeColor = colorStateList.getDefaultColor();
            this.disabledColor = colorStateList.getColorForState(new int[]{-16842910}, -1);
            this.hoveredStrokeColor = colorStateList.getColorForState(new int[]{16843623, 16842910}, -1);
            this.focusedStrokeColor = colorStateList.getColorForState(new int[]{16842908, 16842910}, -1);
        } else if (this.focusedStrokeColor != colorStateList.getDefaultColor()) {
            this.focusedStrokeColor = colorStateList.getDefaultColor();
        }
        this.updateTextInputBoxState();
    }

    public void setBoxStrokeErrorColor(ColorStateList colorStateList) {
        if (this.strokeErrorColor != colorStateList) {
            this.strokeErrorColor = colorStateList;
            this.updateTextInputBoxState();
        }
    }

    public void setBoxStrokeWidth(int n) {
        this.boxStrokeWidthDefaultPx = n;
        this.updateTextInputBoxState();
    }

    public void setBoxStrokeWidthFocused(int n) {
        this.boxStrokeWidthFocusedPx = n;
        this.updateTextInputBoxState();
    }

    public void setBoxStrokeWidthFocusedResource(int n) {
        this.setBoxStrokeWidthFocused(this.getResources().getDimensionPixelSize(n));
    }

    public void setBoxStrokeWidthResource(int n) {
        this.setBoxStrokeWidth(this.getResources().getDimensionPixelSize(n));
    }

    public void setCounterEnabled(boolean bl) {
        if (this.counterEnabled != bl) {
            if (bl) {
                AppCompatTextView appCompatTextView = new AppCompatTextView(this.getContext());
                this.counterView = appCompatTextView;
                appCompatTextView.setId(R.id.textinput_counter);
                appCompatTextView = this.typeface;
                if (appCompatTextView != null) {
                    this.counterView.setTypeface((Typeface)appCompatTextView);
                }
                this.counterView.setMaxLines(1);
                this.indicatorViewController.addIndicator(this.counterView, 2);
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)this.counterView.getLayoutParams()), (int)this.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_counter_margin_start));
                this.updateCounterTextAppearanceAndColor();
                this.updateCounter();
            } else {
                this.indicatorViewController.removeIndicator(this.counterView, 2);
                this.counterView = null;
            }
            this.counterEnabled = bl;
        }
    }

    public void setCounterMaxLength(int n) {
        if (this.counterMaxLength != n) {
            this.counterMaxLength = n > 0 ? n : -1;
            if (this.counterEnabled) {
                this.updateCounter();
            }
        }
    }

    public void setCounterOverflowTextAppearance(int n) {
        if (this.counterOverflowTextAppearance != n) {
            this.counterOverflowTextAppearance = n;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterOverflowTextColor(ColorStateList colorStateList) {
        if (this.counterOverflowTextColor != colorStateList) {
            this.counterOverflowTextColor = colorStateList;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterTextAppearance(int n) {
        if (this.counterTextAppearance != n) {
            this.counterTextAppearance = n;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setCounterTextColor(ColorStateList colorStateList) {
        if (this.counterTextColor != colorStateList) {
            this.counterTextColor = colorStateList;
            this.updateCounterTextAppearanceAndColor();
        }
    }

    public void setDefaultHintTextColor(ColorStateList colorStateList) {
        this.defaultHintTextColor = colorStateList;
        this.focusedTextColor = colorStateList;
        if (this.editText != null) {
            this.updateLabelState(false);
        }
    }

    public void setEnabled(boolean bl) {
        TextInputLayout.recursiveSetEnabled((ViewGroup)this, bl);
        super.setEnabled(bl);
    }

    public void setEndIconActivated(boolean bl) {
        this.endIconView.setActivated(bl);
    }

    public void setEndIconCheckable(boolean bl) {
        this.endIconView.setCheckable(bl);
    }

    public void setEndIconContentDescription(int n) {
        CharSequence charSequence = n != 0 ? this.getResources().getText(n) : null;
        this.setEndIconContentDescription(charSequence);
    }

    public void setEndIconContentDescription(CharSequence charSequence) {
        if (this.getEndIconContentDescription() != charSequence) {
            this.endIconView.setContentDescription(charSequence);
        }
    }

    public void setEndIconDrawable(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setEndIconDrawable(drawable2);
    }

    public void setEndIconDrawable(Drawable drawable2) {
        this.endIconView.setImageDrawable(drawable2);
        if (drawable2 != null) {
            this.applyEndIconTint();
            this.refreshEndIconDrawableState();
        }
    }

    public void setEndIconMode(int n) {
        int n2 = this.endIconMode;
        this.endIconMode = n;
        this.dispatchOnEndIconChanged(n2);
        boolean bl = n != 0;
        this.setEndIconVisible(bl);
        if (this.getEndIconDelegate().isBoxBackgroundModeSupported(this.boxBackgroundMode)) {
            this.getEndIconDelegate().initialize();
            this.applyEndIconTint();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The current box background mode ");
        stringBuilder.append(this.boxBackgroundMode);
        stringBuilder.append(" is not supported by the end icon mode ");
        stringBuilder.append(n);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void setEndIconOnClickListener(View.OnClickListener onClickListener) {
        TextInputLayout.setIconOnClickListener(this.endIconView, onClickListener, this.endIconOnLongClickListener);
    }

    public void setEndIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.endIconOnLongClickListener = onLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.endIconView, onLongClickListener);
    }

    public void setEndIconTintList(ColorStateList colorStateList) {
        if (this.endIconTintList != colorStateList) {
            this.endIconTintList = colorStateList;
            this.hasEndIconTintList = true;
            this.applyEndIconTint();
        }
    }

    public void setEndIconTintMode(PorterDuff.Mode mode) {
        if (this.endIconTintMode != mode) {
            this.endIconTintMode = mode;
            this.hasEndIconTintMode = true;
            this.applyEndIconTint();
        }
    }

    public void setEndIconVisible(boolean bl) {
        if (this.isEndIconVisible() != bl) {
            CheckableImageButton checkableImageButton = this.endIconView;
            int n = bl ? 0 : 8;
            checkableImageButton.setVisibility(n);
            this.updateSuffixTextViewPadding();
            this.updateDummyDrawables();
        }
    }

    public void setError(CharSequence charSequence) {
        if (!this.indicatorViewController.isErrorEnabled()) {
            if (TextUtils.isEmpty((CharSequence)charSequence)) {
                return;
            }
            this.setErrorEnabled(true);
        }
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            this.indicatorViewController.showError(charSequence);
        } else {
            this.indicatorViewController.hideError();
        }
    }

    public void setErrorContentDescription(CharSequence charSequence) {
        this.indicatorViewController.setErrorContentDescription(charSequence);
    }

    public void setErrorEnabled(boolean bl) {
        this.indicatorViewController.setErrorEnabled(bl);
    }

    public void setErrorIconDrawable(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setErrorIconDrawable(drawable2);
        this.refreshErrorIconDrawableState();
    }

    public void setErrorIconDrawable(Drawable drawable2) {
        this.errorIconView.setImageDrawable(drawable2);
        boolean bl = drawable2 != null && this.indicatorViewController.isErrorEnabled();
        this.setErrorIconVisible(bl);
    }

    public void setErrorIconOnClickListener(View.OnClickListener onClickListener) {
        TextInputLayout.setIconOnClickListener(this.errorIconView, onClickListener, this.errorIconOnLongClickListener);
    }

    public void setErrorIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.errorIconOnLongClickListener = onLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.errorIconView, onLongClickListener);
    }

    public void setErrorIconTintList(ColorStateList colorStateList) {
        Drawable drawable2;
        this.errorIconTintList = colorStateList;
        Drawable drawable3 = drawable2 = this.errorIconView.getDrawable();
        if (drawable2 != null) {
            drawable3 = DrawableCompat.wrap((Drawable)drawable2).mutate();
            DrawableCompat.setTintList((Drawable)drawable3, (ColorStateList)colorStateList);
        }
        if (this.errorIconView.getDrawable() != drawable3) {
            this.errorIconView.setImageDrawable(drawable3);
        }
    }

    public void setErrorIconTintMode(PorterDuff.Mode mode) {
        Drawable drawable2;
        Drawable drawable3 = drawable2 = this.errorIconView.getDrawable();
        if (drawable2 != null) {
            drawable3 = DrawableCompat.wrap((Drawable)drawable2).mutate();
            DrawableCompat.setTintMode((Drawable)drawable3, (PorterDuff.Mode)mode);
        }
        if (this.errorIconView.getDrawable() != drawable3) {
            this.errorIconView.setImageDrawable(drawable3);
        }
    }

    public void setErrorTextAppearance(int n) {
        this.indicatorViewController.setErrorTextAppearance(n);
    }

    public void setErrorTextColor(ColorStateList colorStateList) {
        this.indicatorViewController.setErrorViewTextColor(colorStateList);
    }

    public void setExpandedHintEnabled(boolean bl) {
        if (this.expandedHintEnabled != bl) {
            this.expandedHintEnabled = bl;
            this.updateLabelState(false);
        }
    }

    public void setHelperText(CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            if (this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(false);
            }
        } else {
            if (!this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(true);
            }
            this.indicatorViewController.showHelper(charSequence);
        }
    }

    public void setHelperTextColor(ColorStateList colorStateList) {
        this.indicatorViewController.setHelperTextViewTextColor(colorStateList);
    }

    public void setHelperTextEnabled(boolean bl) {
        this.indicatorViewController.setHelperTextEnabled(bl);
    }

    public void setHelperTextTextAppearance(int n) {
        this.indicatorViewController.setHelperTextAppearance(n);
    }

    public void setHint(int n) {
        CharSequence charSequence = n != 0 ? this.getResources().getText(n) : null;
        this.setHint(charSequence);
    }

    public void setHint(CharSequence charSequence) {
        if (this.hintEnabled) {
            this.setHintInternal(charSequence);
            this.sendAccessibilityEvent(2048);
        }
    }

    public void setHintAnimationEnabled(boolean bl) {
        this.hintAnimationEnabled = bl;
    }

    public void setHintEnabled(boolean bl) {
        if (bl != this.hintEnabled) {
            this.hintEnabled = bl;
            if (!bl) {
                this.isProvidingHint = false;
                if (!TextUtils.isEmpty((CharSequence)this.hint) && TextUtils.isEmpty((CharSequence)this.editText.getHint())) {
                    this.editText.setHint(this.hint);
                }
                this.setHintInternal(null);
            } else {
                CharSequence charSequence = this.editText.getHint();
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    if (TextUtils.isEmpty((CharSequence)this.hint)) {
                        this.setHint(charSequence);
                    }
                    this.editText.setHint(null);
                }
                this.isProvidingHint = true;
            }
            if (this.editText != null) {
                this.updateInputLayoutMargins();
            }
        }
    }

    public void setHintTextAppearance(int n) {
        this.collapsingTextHelper.setCollapsedTextAppearance(n);
        this.focusedTextColor = this.collapsingTextHelper.getCollapsedTextColor();
        if (this.editText != null) {
            this.updateLabelState(false);
            this.updateInputLayoutMargins();
        }
    }

    public void setHintTextColor(ColorStateList colorStateList) {
        if (this.focusedTextColor != colorStateList) {
            if (this.defaultHintTextColor == null) {
                this.collapsingTextHelper.setCollapsedTextColor(colorStateList);
            }
            this.focusedTextColor = colorStateList;
            if (this.editText != null) {
                this.updateLabelState(false);
            }
        }
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
        EditText editText = this.editText;
        if (editText != null && n != -1) {
            editText.setMaxWidth(n);
        }
    }

    public void setMaxWidthResource(int n) {
        this.setMaxWidth(this.getContext().getResources().getDimensionPixelSize(n));
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
        EditText editText = this.editText;
        if (editText != null && n != -1) {
            editText.setMinWidth(n);
        }
    }

    public void setMinWidthResource(int n) {
        this.setMinWidth(this.getContext().getResources().getDimensionPixelSize(n));
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(int n) {
        CharSequence charSequence = n != 0 ? this.getResources().getText(n) : null;
        this.setPasswordVisibilityToggleContentDescription(charSequence);
    }

    @Deprecated
    public void setPasswordVisibilityToggleContentDescription(CharSequence charSequence) {
        this.endIconView.setContentDescription(charSequence);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setPasswordVisibilityToggleDrawable(drawable2);
    }

    @Deprecated
    public void setPasswordVisibilityToggleDrawable(Drawable drawable2) {
        this.endIconView.setImageDrawable(drawable2);
    }

    @Deprecated
    public void setPasswordVisibilityToggleEnabled(boolean bl) {
        if (bl && this.endIconMode != 1) {
            this.setEndIconMode(1);
        } else if (!bl) {
            this.setEndIconMode(0);
        }
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintList(ColorStateList colorStateList) {
        this.endIconTintList = colorStateList;
        this.hasEndIconTintList = true;
        this.applyEndIconTint();
    }

    @Deprecated
    public void setPasswordVisibilityToggleTintMode(PorterDuff.Mode mode) {
        this.endIconTintMode = mode;
        this.hasEndIconTintMode = true;
        this.applyEndIconTint();
    }

    public void setPlaceholderText(CharSequence charSequence) {
        if (this.placeholderEnabled && TextUtils.isEmpty((CharSequence)charSequence)) {
            this.setPlaceholderTextEnabled(false);
        } else {
            if (!this.placeholderEnabled) {
                this.setPlaceholderTextEnabled(true);
            }
            this.placeholderText = charSequence;
        }
        this.updatePlaceholderText();
    }

    public void setPlaceholderTextAppearance(int n) {
        this.placeholderTextAppearance = n;
        TextView textView = this.placeholderTextView;
        if (textView != null) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)n);
        }
    }

    public void setPlaceholderTextColor(ColorStateList colorStateList) {
        if (this.placeholderTextColor != colorStateList) {
            this.placeholderTextColor = colorStateList;
            TextView textView = this.placeholderTextView;
            if (textView != null && colorStateList != null) {
                textView.setTextColor(colorStateList);
            }
        }
    }

    public void setPrefixText(CharSequence charSequence) {
        CharSequence charSequence2 = TextUtils.isEmpty((CharSequence)charSequence) ? null : charSequence;
        this.prefixText = charSequence2;
        this.prefixTextView.setText(charSequence);
        this.updatePrefixTextVisibility();
    }

    public void setPrefixTextAppearance(int n) {
        TextViewCompat.setTextAppearance((TextView)this.prefixTextView, (int)n);
    }

    public void setPrefixTextColor(ColorStateList colorStateList) {
        this.prefixTextView.setTextColor(colorStateList);
    }

    public void setStartIconCheckable(boolean bl) {
        this.startIconView.setCheckable(bl);
    }

    public void setStartIconContentDescription(int n) {
        CharSequence charSequence = n != 0 ? this.getResources().getText(n) : null;
        this.setStartIconContentDescription(charSequence);
    }

    public void setStartIconContentDescription(CharSequence charSequence) {
        if (this.getStartIconContentDescription() != charSequence) {
            this.startIconView.setContentDescription(charSequence);
        }
    }

    public void setStartIconDrawable(int n) {
        Drawable drawable2 = n != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)n) : null;
        this.setStartIconDrawable(drawable2);
    }

    public void setStartIconDrawable(Drawable drawable2) {
        this.startIconView.setImageDrawable(drawable2);
        if (drawable2 != null) {
            this.applyStartIconTint();
            this.setStartIconVisible(true);
            this.refreshStartIconDrawableState();
        } else {
            this.setStartIconVisible(false);
            this.setStartIconOnClickListener(null);
            this.setStartIconOnLongClickListener(null);
            this.setStartIconContentDescription(null);
        }
    }

    public void setStartIconOnClickListener(View.OnClickListener onClickListener) {
        TextInputLayout.setIconOnClickListener(this.startIconView, onClickListener, this.startIconOnLongClickListener);
    }

    public void setStartIconOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.startIconOnLongClickListener = onLongClickListener;
        TextInputLayout.setIconOnLongClickListener(this.startIconView, onLongClickListener);
    }

    public void setStartIconTintList(ColorStateList colorStateList) {
        if (this.startIconTintList != colorStateList) {
            this.startIconTintList = colorStateList;
            this.hasStartIconTintList = true;
            this.applyStartIconTint();
        }
    }

    public void setStartIconTintMode(PorterDuff.Mode mode) {
        if (this.startIconTintMode != mode) {
            this.startIconTintMode = mode;
            this.hasStartIconTintMode = true;
            this.applyStartIconTint();
        }
    }

    public void setStartIconVisible(boolean bl) {
        if (this.isStartIconVisible() != bl) {
            CheckableImageButton checkableImageButton = this.startIconView;
            int n = bl ? 0 : 8;
            checkableImageButton.setVisibility(n);
            this.updatePrefixTextViewPadding();
            this.updateDummyDrawables();
        }
    }

    public void setSuffixText(CharSequence charSequence) {
        CharSequence charSequence2 = TextUtils.isEmpty((CharSequence)charSequence) ? null : charSequence;
        this.suffixText = charSequence2;
        this.suffixTextView.setText(charSequence);
        this.updateSuffixTextVisibility();
    }

    public void setSuffixTextAppearance(int n) {
        TextViewCompat.setTextAppearance((TextView)this.suffixTextView, (int)n);
    }

    public void setSuffixTextColor(ColorStateList colorStateList) {
        this.suffixTextView.setTextColor(colorStateList);
    }

    void setTextAppearanceCompatWithErrorFallback(TextView textView, int n) {
        int n2 = 1;
        try {
            TextViewCompat.setTextAppearance((TextView)textView, (int)n);
            n = Build.VERSION.SDK_INT >= 23 && (n = textView.getTextColors().getDefaultColor()) == -65281 ? n2 : 0;
        }
        catch (Exception exception) {
            n = n2;
        }
        if (n != 0) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.TextAppearance_AppCompat_Caption);
            textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.design_error));
        }
    }

    public void setTextInputAccessibilityDelegate(AccessibilityDelegate accessibilityDelegate) {
        EditText editText = this.editText;
        if (editText != null) {
            ViewCompat.setAccessibilityDelegate((View)editText, (AccessibilityDelegateCompat)accessibilityDelegate);
        }
    }

    public void setTypeface(Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.collapsingTextHelper.setTypefaces(typeface);
            this.indicatorViewController.setTypefaces(typeface);
            TextView textView = this.counterView;
            if (textView != null) {
                textView.setTypeface(typeface);
            }
        }
    }

    void updateCounter(int n) {
        boolean bl = this.counterOverflowed;
        int n2 = this.counterMaxLength;
        if (n2 == -1) {
            this.counterView.setText((CharSequence)String.valueOf(n));
            this.counterView.setContentDescription(null);
            this.counterOverflowed = false;
        } else {
            boolean bl2 = n > n2;
            this.counterOverflowed = bl2;
            TextInputLayout.updateCounterContentDescription(this.getContext(), this.counterView, n, this.counterMaxLength, this.counterOverflowed);
            if (bl != this.counterOverflowed) {
                this.updateCounterTextAppearanceAndColor();
            }
            BidiFormatter bidiFormatter = BidiFormatter.getInstance();
            this.counterView.setText((CharSequence)bidiFormatter.unicodeWrap(this.getContext().getString(R.string.character_counter_pattern, new Object[]{n, this.counterMaxLength})));
        }
        if (this.editText != null && bl != this.counterOverflowed) {
            this.updateLabelState(false);
            this.updateTextInputBoxState();
            this.updateEditTextBackground();
        }
    }

    void updateEditTextBackground() {
        EditText editText = this.editText;
        if (editText != null && this.boxBackgroundMode == 0) {
            Drawable drawable2 = editText.getBackground();
            if (drawable2 == null) {
                return;
            }
            editText = drawable2;
            if (DrawableUtils.canSafelyMutateDrawable((Drawable)drawable2)) {
                editText = drawable2.mutate();
            }
            if (this.indicatorViewController.errorShouldBeShown()) {
                editText.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.indicatorViewController.getErrorViewCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
            } else if (this.counterOverflowed && (drawable2 = this.counterView) != null) {
                editText.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)drawable2.getCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
            } else {
                DrawableCompat.clearColorFilter((Drawable)editText);
                this.editText.refreshDrawableState();
            }
        }
    }

    void updateLabelState(boolean bl) {
        this.updateLabelState(bl, false);
    }

    void updateTextInputBoxState() {
        if (this.boxBackground != null && this.boxBackgroundMode != 0) {
            EditText editText;
            boolean bl = this.isFocused();
            boolean bl2 = false;
            bl = bl || (editText = this.editText) != null && editText.hasFocus();
            boolean bl3 = this.isHovered() || (editText = this.editText) != null && editText.isHovered();
            if (!this.isEnabled()) {
                this.boxStrokeColor = this.disabledColor;
            } else if (this.indicatorViewController.errorShouldBeShown()) {
                if (this.strokeErrorColor != null) {
                    this.updateStrokeErrorColor(bl, bl3);
                } else {
                    this.boxStrokeColor = this.indicatorViewController.getErrorViewCurrentTextColor();
                }
            } else if (this.counterOverflowed && (editText = this.counterView) != null) {
                if (this.strokeErrorColor != null) {
                    this.updateStrokeErrorColor(bl, bl3);
                } else {
                    this.boxStrokeColor = editText.getCurrentTextColor();
                }
            } else {
                this.boxStrokeColor = bl ? this.focusedStrokeColor : (bl3 ? this.hoveredStrokeColor : this.defaultStrokeColor);
            }
            boolean bl4 = bl2;
            if (this.getErrorIconDrawable() != null) {
                bl4 = bl2;
                if (this.indicatorViewController.isErrorEnabled()) {
                    bl4 = bl2;
                    if (this.indicatorViewController.errorShouldBeShown()) {
                        bl4 = true;
                    }
                }
            }
            this.setErrorIconVisible(bl4);
            this.refreshErrorIconDrawableState();
            this.refreshStartIconDrawableState();
            this.refreshEndIconDrawableState();
            if (this.getEndIconDelegate().shouldTintIconOnError()) {
                this.tintEndIconOnError(this.indicatorViewController.errorShouldBeShown());
            }
            int n = this.boxStrokeWidthPx;
            this.boxStrokeWidthPx = bl && this.isEnabled() ? this.boxStrokeWidthFocusedPx : this.boxStrokeWidthDefaultPx;
            if (this.boxStrokeWidthPx != n && this.boxBackgroundMode == 2) {
                this.recalculateCutout();
            }
            if (this.boxBackgroundMode == 1) {
                this.boxBackgroundColor = !this.isEnabled() ? this.disabledFilledBackgroundColor : (bl3 && !bl ? this.hoveredFilledBackgroundColor : (bl ? this.focusedFilledBackgroundColor : this.defaultFilledBackgroundColor));
            }
            this.applyBoxAttributes();
        }
    }

    public static class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final TextInputLayout layout;

        public AccessibilityDelegate(TextInputLayout textInputLayout) {
            this.layout = textInputLayout;
        }

        public void onInitializeAccessibilityNodeInfo(View object, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo((View)object, accessibilityNodeInfoCompat);
            EditText editText = this.layout.getEditText();
            Editable editable = editText != null ? editText.getText() : null;
            object = this.layout.getHint();
            CharSequence charSequence = this.layout.getError();
            Object object2 = this.layout.getPlaceholderText();
            int n = this.layout.getCounterMaxLength();
            CharSequence charSequence2 = this.layout.getCounterOverflowDescription();
            boolean bl = TextUtils.isEmpty((CharSequence)editable) ^ true;
            boolean bl2 = TextUtils.isEmpty((CharSequence)object);
            boolean bl3 = this.layout.isHintExpanded();
            boolean bl4 = TextUtils.isEmpty((CharSequence)charSequence) ^ true;
            boolean bl5 = bl4 || !TextUtils.isEmpty((CharSequence)charSequence2);
            object = bl2 ^ true ? object.toString() : "";
            if (bl) {
                accessibilityNodeInfoCompat.setText((CharSequence)editable);
            } else if (!TextUtils.isEmpty((CharSequence)object)) {
                accessibilityNodeInfoCompat.setText((CharSequence)object);
                if (bl3 ^ true && object2 != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object);
                    stringBuilder.append(", ");
                    stringBuilder.append(object2);
                    accessibilityNodeInfoCompat.setText((CharSequence)stringBuilder.toString());
                }
            } else if (object2 != null) {
                accessibilityNodeInfoCompat.setText((CharSequence)object2);
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                if (Build.VERSION.SDK_INT >= 26) {
                    accessibilityNodeInfoCompat.setHintText((CharSequence)object);
                } else {
                    object2 = object;
                    if (bl) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append(editable);
                        ((StringBuilder)object2).append(", ");
                        ((StringBuilder)object2).append((String)object);
                        object2 = ((StringBuilder)object2).toString();
                    }
                    accessibilityNodeInfoCompat.setText((CharSequence)object2);
                }
                accessibilityNodeInfoCompat.setShowingHintText(bl ^ true);
            }
            if (editable == null || editable.length() != n) {
                n = -1;
            }
            accessibilityNodeInfoCompat.setMaxTextLength(n);
            if (bl5) {
                object = bl4 ? charSequence : charSequence2;
                accessibilityNodeInfoCompat.setError((CharSequence)object);
            }
            if (Build.VERSION.SDK_INT >= 17 && editText != null) {
                editText.setLabelFor(R.id.textinput_helper_text);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoxBackgroundMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EndIconMode {
    }

    public static interface OnEditTextAttachedListener {
        public void onEditTextAttached(TextInputLayout var1);
    }

    public static interface OnEndIconChangedListener {
        public void onEndIconChanged(TextInputLayout var1, int var2);
    }

    static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        CharSequence error;
        CharSequence helperText;
        CharSequence hintText;
        boolean isEndIconChecked;
        CharSequence placeholderText;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.error = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            int n = parcel.readInt();
            boolean bl = true;
            if (n != 1) {
                bl = false;
            }
            this.isEndIconChecked = bl;
            this.hintText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.helperText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.placeholderText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TextInputLayout.SavedState{");
            stringBuilder.append(Integer.toHexString(System.identityHashCode((Object)this)));
            stringBuilder.append(" error=");
            stringBuilder.append((Object)this.error);
            stringBuilder.append(" hint=");
            stringBuilder.append((Object)this.hintText);
            stringBuilder.append(" helperText=");
            stringBuilder.append((Object)this.helperText);
            stringBuilder.append(" placeholderText=");
            stringBuilder.append((Object)this.placeholderText);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            TextUtils.writeToParcel((CharSequence)this.error, (Parcel)parcel, (int)n);
            parcel.writeInt(this.isEndIconChecked ? 1 : 0);
            TextUtils.writeToParcel((CharSequence)this.hintText, (Parcel)parcel, (int)n);
            TextUtils.writeToParcel((CharSequence)this.helperText, (Parcel)parcel, (int)n);
            TextUtils.writeToParcel((CharSequence)this.placeholderText, (Parcel)parcel, (int)n);
        }
    }
}

