/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RelativeCornerSize;

class RadialViewGroup
extends ConstraintLayout {
    private static final String SKIP_TAG = "skip";
    private MaterialShapeDrawable background;
    private int radius;
    private final Runnable updateLayoutParametersRunnable;

    public RadialViewGroup(Context context) {
        this(context, null);
    }

    public RadialViewGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RadialViewGroup(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        LayoutInflater.from((Context)context).inflate(R.layout.material_radial_view_group, (ViewGroup)this);
        ViewCompat.setBackground((View)this, (Drawable)this.createBackground());
        context = context.obtainStyledAttributes(attributeSet, R.styleable.RadialViewGroup, n, 0);
        this.radius = context.getDimensionPixelSize(R.styleable.RadialViewGroup_materialCircleRadius, 0);
        this.updateLayoutParametersRunnable = new Runnable(){

            @Override
            public void run() {
                RadialViewGroup.this.updateLayoutParams();
            }
        };
        context.recycle();
    }

    private Drawable createBackground() {
        MaterialShapeDrawable materialShapeDrawable;
        this.background = materialShapeDrawable = new MaterialShapeDrawable();
        materialShapeDrawable.setCornerSize(new RelativeCornerSize(0.5f));
        this.background.setFillColor(ColorStateList.valueOf((int)-1));
        return this.background;
    }

    private static boolean shouldSkipView(View view) {
        return SKIP_TAG.equals(view.getTag());
    }

    private void updateLayoutParamsAsync() {
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.removeCallbacks(this.updateLayoutParametersRunnable);
            handler.post(this.updateLayoutParametersRunnable);
        }
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        if (view.getId() == -1) {
            view.setId(ViewCompat.generateViewId());
        }
        this.updateLayoutParamsAsync();
    }

    public int getRadius() {
        return this.radius;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateLayoutParams();
    }

    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.updateLayoutParamsAsync();
    }

    public void setBackgroundColor(int n) {
        this.background.setFillColor(ColorStateList.valueOf((int)n));
    }

    public void setRadius(int n) {
        this.radius = n;
        this.updateLayoutParams();
    }

    protected void updateLayoutParams() {
        int n;
        int n2 = this.getChildCount();
        int n3 = 0;
        int n4 = 1;
        for (n = 0; n < n2; ++n) {
            int n5 = n4;
            if (RadialViewGroup.shouldSkipView(this.getChildAt(n))) {
                n5 = n4 + 1;
            }
            n4 = n5;
        }
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        float f = 0.0f;
        for (n = n3; n < n2; ++n) {
            View view = this.getChildAt(n);
            float f2 = f;
            if (view.getId() != R.id.circle_center) {
                if (RadialViewGroup.shouldSkipView(view)) {
                    f2 = f;
                } else {
                    constraintSet.constrainCircle(view.getId(), R.id.circle_center, this.radius, f);
                    f2 = f + 360.0f / (float)(n2 - n4);
                }
            }
            f = f2;
        }
        constraintSet.applyTo((ConstraintLayout)this);
    }
}

