/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.material.timepicker.MaxInputValidator;
import java.util.Arrays;

class TimeModel
implements Parcelable {
    public static final Parcelable.Creator<TimeModel> CREATOR = new Parcelable.Creator<TimeModel>(){

        public TimeModel createFromParcel(Parcel parcel) {
            return new TimeModel(parcel);
        }

        public TimeModel[] newArray(int n) {
            return new TimeModel[n];
        }
    };
    public static final String NUMBER_FORMAT = "%d";
    public static final String ZERO_LEADING_NUMBER_FORMAT = "%02d";
    final int format;
    int hour;
    private final MaxInputValidator hourInputValidator;
    int minute;
    private final MaxInputValidator minuteInputValidator;
    int period;
    int selection;

    public TimeModel() {
        this(0);
    }

    public TimeModel(int n) {
        this(0, 0, 10, n);
    }

    public TimeModel(int n, int n2, int n3, int n4) {
        this.hour = n;
        this.minute = n2;
        this.selection = n3;
        this.format = n4;
        this.period = TimeModel.getPeriod(n);
        this.minuteInputValidator = new MaxInputValidator(59);
        n = n4 == 1 ? 24 : 12;
        this.hourInputValidator = new MaxInputValidator(n);
    }

    protected TimeModel(Parcel parcel) {
        this(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
    }

    public static String formatText(Resources resources, CharSequence charSequence) {
        return TimeModel.formatText(resources, charSequence, ZERO_LEADING_NUMBER_FORMAT);
    }

    public static String formatText(Resources resources, CharSequence charSequence, String string2) {
        return String.format(resources.getConfiguration().locale, string2, Integer.parseInt(String.valueOf(charSequence)));
    }

    private static int getPeriod(int n) {
        n = n >= 12 ? 1 : 0;
        return n;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof TimeModel)) {
            return false;
        }
        object = (TimeModel)object;
        if (this.hour != ((TimeModel)object).hour || this.minute != ((TimeModel)object).minute || this.format != ((TimeModel)object).format || this.selection != ((TimeModel)object).selection) {
            bl = false;
        }
        return bl;
    }

    public int getHourForDisplay() {
        if (this.format == 1) {
            return this.hour % 24;
        }
        int n = this.hour;
        if (n % 12 == 0) {
            return 12;
        }
        int n2 = n;
        if (this.period == 1) {
            n2 = n - 12;
        }
        return n2;
    }

    public MaxInputValidator getHourInputValidator() {
        return this.hourInputValidator;
    }

    public MaxInputValidator getMinuteInputValidator() {
        return this.minuteInputValidator;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.format, this.hour, this.minute, this.selection});
    }

    public void setHour(int n) {
        if (this.format == 1) {
            this.hour = n;
            return;
        }
        int n2 = 12;
        if (this.period != 1) {
            n2 = 0;
        }
        this.hour = n % 12 + n2;
    }

    public void setHourOfDay(int n) {
        this.period = TimeModel.getPeriod(n);
        this.hour = n;
    }

    public void setMinute(int n) {
        this.minute = n % 60;
    }

    public void setPeriod(int n) {
        if (n != this.period) {
            this.period = n;
            int n2 = this.hour;
            if (n2 < 12 && n == 1) {
                this.hour = n2 + 12;
            } else if (n2 >= 12 && n == 0) {
                this.hour = n2 - 12;
            }
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.hour);
        parcel.writeInt(this.minute);
        parcel.writeInt(this.selection);
        parcel.writeInt(this.format);
    }
}

