/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.chip.Chip;
import com.google.android.material.timepicker.ClockFaceView;
import com.google.android.material.timepicker.ClockHandView;
import com.google.android.material.timepicker.TimePickerControls;
import java.util.Locale;

class TimePickerView
extends ConstraintLayout
implements TimePickerControls {
    private final ClockFaceView clockFace;
    private final ClockHandView clockHandView;
    private final Chip hourView;
    private final Chip minuteView;
    private OnDoubleTapListener onDoubleTapListener;
    private OnPeriodChangeListener onPeriodChangeListener;
    private OnSelectionChange onSelectionChangeListener;
    private final View.OnClickListener selectionListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (TimePickerView.this.onSelectionChangeListener != null) {
                TimePickerView.this.onSelectionChangeListener.onSelectionChanged((Integer)view.getTag(R.id.selection_type));
            }
        }
    };
    private final MaterialButtonToggleGroup toggle;

    public TimePickerView(Context context) {
        this(context, null);
    }

    public TimePickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TimePickerView(Context object, AttributeSet object2, int n) {
        super((Context)object, object2, n);
        LayoutInflater.from((Context)object).inflate(R.layout.material_timepicker, (ViewGroup)this);
        this.clockFace = (ClockFaceView)this.findViewById(R.id.material_clock_face);
        object = (MaterialButtonToggleGroup)this.findViewById(R.id.material_clock_period_toggle);
        this.toggle = object;
        ((MaterialButtonToggleGroup)((Object)object)).addOnButtonCheckedListener(new MaterialButtonToggleGroup.OnButtonCheckedListener(){

            @Override
            public void onButtonChecked(MaterialButtonToggleGroup materialButtonToggleGroup, int n, boolean bl) {
                n = n == R.id.material_clock_period_pm_button ? 1 : 0;
                if (TimePickerView.this.onPeriodChangeListener != null && bl) {
                    TimePickerView.this.onPeriodChangeListener.onPeriodChange(n);
                }
            }
        });
        object2 = (Chip)this.findViewById(R.id.material_minute_tv);
        this.minuteView = object2;
        this.hourView = object = (Chip)this.findViewById(R.id.material_hour_tv);
        this.clockHandView = (ClockHandView)this.findViewById(R.id.material_clock_hand);
        ViewCompat.setAccessibilityLiveRegion((View)object2, (int)2);
        ViewCompat.setAccessibilityLiveRegion((View)object, (int)2);
        this.setupDoubleTap();
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        this.minuteView.setTag(R.id.selection_type, 12);
        this.hourView.setTag(R.id.selection_type, 10);
        this.minuteView.setOnClickListener(this.selectionListener);
        this.hourView.setOnClickListener(this.selectionListener);
    }

    private void setupDoubleTap() {
        View.OnTouchListener onTouchListener = new View.OnTouchListener(new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent object) {
                object = TimePickerView.this.onDoubleTapListener;
                if (object != null) {
                    object.onDoubleTap();
                    return true;
                }
                return false;
            }
        })){
            final /* synthetic */ GestureDetector val$gestureDetector;
            {
                this.val$gestureDetector = gestureDetector;
            }

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (((Checkable)view).isChecked()) {
                    return this.val$gestureDetector.onTouchEvent(motionEvent);
                }
                return false;
            }
        };
        this.minuteView.setOnTouchListener(onTouchListener);
        this.hourView.setOnTouchListener(onTouchListener);
    }

    private void updateToggleConstraints() {
        if (this.toggle.getVisibility() == 0) {
            ConstraintSet constraintSet = new ConstraintSet();
            constraintSet.clone((ConstraintLayout)this);
            int n = ViewCompat.getLayoutDirection((View)this);
            int n2 = 1;
            n = n == 0 ? 1 : 0;
            if (n != 0) {
                n2 = 2;
            }
            constraintSet.clear(R.id.material_clock_display, n2);
            constraintSet.applyTo((ConstraintLayout)this);
        }
    }

    public void addOnRotateListener(ClockHandView.OnRotateListener onRotateListener) {
        this.clockHandView.addOnRotateListener(onRotateListener);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateToggleConstraints();
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (view == this && n == 0) {
            this.updateToggleConstraints();
        }
    }

    @Override
    public void setActiveSelection(int n) {
        Chip chip = this.minuteView;
        boolean bl = true;
        boolean bl2 = n == 12;
        chip.setChecked(bl2);
        chip = this.hourView;
        bl2 = n == 10 ? bl : false;
        chip.setChecked(bl2);
    }

    public void setAnimateOnTouchUp(boolean bl) {
        this.clockHandView.setAnimateOnTouchUp(bl);
    }

    @Override
    public void setHandRotation(float f) {
        this.clockHandView.setHandRotation(f);
    }

    public void setHandRotation(float f, boolean bl) {
        this.clockHandView.setHandRotation(f, bl);
    }

    public void setHourClickDelegate(AccessibilityDelegateCompat accessibilityDelegateCompat) {
        ViewCompat.setAccessibilityDelegate((View)this.minuteView, (AccessibilityDelegateCompat)accessibilityDelegateCompat);
    }

    public void setMinuteHourDelegate(AccessibilityDelegateCompat accessibilityDelegateCompat) {
        ViewCompat.setAccessibilityDelegate((View)this.hourView, (AccessibilityDelegateCompat)accessibilityDelegateCompat);
    }

    public void setOnActionUpListener(ClockHandView.OnActionUpListener onActionUpListener) {
        this.clockHandView.setOnActionUpListener(onActionUpListener);
    }

    void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.onDoubleTapListener = onDoubleTapListener;
    }

    void setOnPeriodChangeListener(OnPeriodChangeListener onPeriodChangeListener) {
        this.onPeriodChangeListener = onPeriodChangeListener;
    }

    void setOnSelectionChangeListener(OnSelectionChange onSelectionChange) {
        this.onSelectionChangeListener = onSelectionChange;
    }

    @Override
    public void setValues(String[] stringArray, int n) {
        this.clockFace.setValues(stringArray, n);
    }

    public void showToggle() {
        this.toggle.setVisibility(0);
    }

    @Override
    public void updateTime(int n, int n2, int n3) {
        n = n == 1 ? R.id.material_clock_period_pm_button : R.id.material_clock_period_am_button;
        this.toggle.check(n);
        Object object = this.getResources().getConfiguration().locale;
        String string2 = String.format((Locale)object, "%02d", n3);
        object = String.format((Locale)object, "%02d", n2);
        this.minuteView.setText(string2);
        this.hourView.setText((CharSequence)object);
    }

    static interface OnDoubleTapListener {
        public void onDoubleTap();
    }

    static interface OnPeriodChangeListener {
        public void onPeriodChange(int var1);
    }

    static interface OnSelectionChange {
        public void onSelectionChanged(int var1);
    }
}

