/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tooltip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.MarkerEdgeTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.OffsetEdgeTreatment;

public class TooltipDrawable
extends MaterialShapeDrawable
implements TextDrawableHelper.TextDrawableDelegate {
    private static final int DEFAULT_STYLE = R.style.Widget_MaterialComponents_Tooltip;
    private static final int DEFAULT_THEME_ATTR = R.attr.tooltipStyle;
    private int arrowSize;
    private final View.OnLayoutChangeListener attachedViewLayoutChangeListener;
    private final Context context;
    private final Rect displayFrame;
    private final Paint.FontMetrics fontMetrics = new Paint.FontMetrics();
    private float labelOpacity;
    private int layoutMargin;
    private int locationOnScreenX;
    private int minHeight;
    private int minWidth;
    private int padding;
    private CharSequence text;
    private final TextDrawableHelper textDrawableHelper;
    private final float tooltipPivotX;
    private float tooltipPivotY;
    private float tooltipScaleX;
    private float tooltipScaleY;

    private TooltipDrawable(Context context, AttributeSet object, int n, int n2) {
        super(context, (AttributeSet)object, n, n2);
        object = new TextDrawableHelper(this);
        this.textDrawableHelper = object;
        this.attachedViewLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                TooltipDrawable.this.updateLocationOnScreen(view);
            }
        };
        this.displayFrame = new Rect();
        this.tooltipScaleX = 1.0f;
        this.tooltipScaleY = 1.0f;
        this.tooltipPivotX = 0.5f;
        this.tooltipPivotY = 0.5f;
        this.labelOpacity = 1.0f;
        this.context = context;
        ((TextDrawableHelper)object).getTextPaint().density = context.getResources().getDisplayMetrics().density;
        ((TextDrawableHelper)object).getTextPaint().setTextAlign(Paint.Align.CENTER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private float calculatePointerOffset() {
        int n;
        if (this.displayFrame.right - this.getBounds().right - this.locationOnScreenX - this.layoutMargin < 0) {
            n = this.displayFrame.right - this.getBounds().right - this.locationOnScreenX - this.layoutMargin;
            return n;
        }
        if (this.displayFrame.left - this.getBounds().left - this.locationOnScreenX + this.layoutMargin <= 0) return 0.0f;
        n = this.displayFrame.left - this.getBounds().left - this.locationOnScreenX + this.layoutMargin;
        return n;
    }

    private float calculateTextCenterFromBaseline() {
        this.textDrawableHelper.getTextPaint().getFontMetrics(this.fontMetrics);
        return (this.fontMetrics.descent + this.fontMetrics.ascent) / 2.0f;
    }

    private float calculateTextOriginAndAlignment(Rect rect) {
        return (float)rect.centerY() - this.calculateTextCenterFromBaseline();
    }

    public static TooltipDrawable create(Context context) {
        return TooltipDrawable.createFromAttributes(context, null, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    public static TooltipDrawable createFromAttributes(Context context, AttributeSet attributeSet) {
        return TooltipDrawable.createFromAttributes(context, attributeSet, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    public static TooltipDrawable createFromAttributes(Context object, AttributeSet attributeSet, int n, int n2) {
        object = new TooltipDrawable((Context)object, attributeSet, n, n2);
        super.loadFromAttributes(attributeSet, n, n2);
        return object;
    }

    private EdgeTreatment createMarkerEdge() {
        float f = -this.calculatePointerOffset();
        float f2 = (float)((double)this.getBounds().width() - (double)this.arrowSize * Math.sqrt(2.0)) / 2.0f;
        f2 = Math.min(Math.max(f, -f2), f2);
        return new OffsetEdgeTreatment(new MarkerEdgeTreatment(this.arrowSize), f2);
    }

    private void drawText(Canvas canvas) {
        if (this.text == null) {
            return;
        }
        Rect rect = this.getBounds();
        int n = (int)this.calculateTextOriginAndAlignment(rect);
        if (this.textDrawableHelper.getTextAppearance() != null) {
            this.textDrawableHelper.getTextPaint().drawableState = this.getState();
            this.textDrawableHelper.updateTextPaintDrawState(this.context);
            this.textDrawableHelper.getTextPaint().setAlpha((int)(this.labelOpacity * 255.0f));
        }
        CharSequence charSequence = this.text;
        canvas.drawText(charSequence, 0, charSequence.length(), (float)rect.centerX(), (float)n, (Paint)this.textDrawableHelper.getTextPaint());
    }

    private float getTextWidth() {
        CharSequence charSequence = this.text;
        if (charSequence == null) {
            return 0.0f;
        }
        return this.textDrawableHelper.getTextWidth(charSequence.toString());
    }

    private void loadFromAttributes(AttributeSet attributeSet, int n, int n2) {
        attributeSet = ThemeEnforcement.obtainStyledAttributes(this.context, attributeSet, R.styleable.Tooltip, n, n2, new int[0]);
        this.arrowSize = this.context.getResources().getDimensionPixelSize(R.dimen.mtrl_tooltip_arrowSize);
        this.setShapeAppearanceModel(this.getShapeAppearanceModel().toBuilder().setBottomEdge(this.createMarkerEdge()).build());
        this.setText(attributeSet.getText(R.styleable.Tooltip_android_text));
        TextAppearance textAppearance = MaterialResources.getTextAppearance(this.context, (TypedArray)attributeSet, R.styleable.Tooltip_android_textAppearance);
        if (textAppearance != null && attributeSet.hasValue(R.styleable.Tooltip_android_textColor)) {
            textAppearance.setTextColor(MaterialResources.getColorStateList(this.context, (TypedArray)attributeSet, R.styleable.Tooltip_android_textColor));
        }
        this.setTextAppearance(textAppearance);
        n = MaterialColors.getColor(this.context, R.attr.colorOnBackground, TooltipDrawable.class.getCanonicalName());
        n = MaterialColors.layer(ColorUtils.setAlphaComponent((int)MaterialColors.getColor(this.context, 0x1010031, TooltipDrawable.class.getCanonicalName()), (int)229), ColorUtils.setAlphaComponent((int)n, (int)153));
        this.setFillColor(ColorStateList.valueOf((int)attributeSet.getColor(R.styleable.Tooltip_backgroundTint, n)));
        this.setStrokeColor(ColorStateList.valueOf((int)MaterialColors.getColor(this.context, R.attr.colorSurface, TooltipDrawable.class.getCanonicalName())));
        this.padding = attributeSet.getDimensionPixelSize(R.styleable.Tooltip_android_padding, 0);
        this.minWidth = attributeSet.getDimensionPixelSize(R.styleable.Tooltip_android_minWidth, 0);
        this.minHeight = attributeSet.getDimensionPixelSize(R.styleable.Tooltip_android_minHeight, 0);
        this.layoutMargin = attributeSet.getDimensionPixelSize(R.styleable.Tooltip_android_layout_margin, 0);
        attributeSet.recycle();
    }

    private void updateLocationOnScreen(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        this.locationOnScreenX = nArray[0];
        view.getWindowVisibleDisplayFrame(this.displayFrame);
    }

    public void detachView(View view) {
        if (view == null) {
            return;
        }
        view.removeOnLayoutChangeListener(this.attachedViewLayoutChangeListener);
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.save();
        float f = this.calculatePointerOffset();
        float f2 = (float)(-((double)this.arrowSize * Math.sqrt(2.0) - (double)this.arrowSize));
        canvas.scale(this.tooltipScaleX, this.tooltipScaleY, (float)this.getBounds().left + (float)this.getBounds().width() * 0.5f, (float)this.getBounds().top + (float)this.getBounds().height() * this.tooltipPivotY);
        canvas.translate(f, f2);
        super.draw(canvas);
        this.drawText(canvas);
        canvas.restore();
    }

    public int getIntrinsicHeight() {
        return (int)Math.max(this.textDrawableHelper.getTextPaint().getTextSize(), (float)this.minHeight);
    }

    public int getIntrinsicWidth() {
        return (int)Math.max((float)(this.padding * 2) + this.getTextWidth(), (float)this.minWidth);
    }

    public int getLayoutMargin() {
        return this.layoutMargin;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public CharSequence getText() {
        return this.text;
    }

    public TextAppearance getTextAppearance() {
        return this.textDrawableHelper.getTextAppearance();
    }

    public int getTextPadding() {
        return this.padding;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.setShapeAppearanceModel(this.getShapeAppearanceModel().toBuilder().setBottomEdge(this.createMarkerEdge()).build());
    }

    @Override
    public boolean onStateChange(int[] nArray) {
        return super.onStateChange(nArray);
    }

    @Override
    public void onTextSizeChange() {
        this.invalidateSelf();
    }

    public void setLayoutMargin(int n) {
        this.layoutMargin = n;
        this.invalidateSelf();
    }

    public void setMinHeight(int n) {
        this.minHeight = n;
        this.invalidateSelf();
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
        this.invalidateSelf();
    }

    public void setRelativeToView(View view) {
        if (view == null) {
            return;
        }
        this.updateLocationOnScreen(view);
        view.addOnLayoutChangeListener(this.attachedViewLayoutChangeListener);
    }

    public void setRevealFraction(float f) {
        this.tooltipPivotY = 1.2f;
        this.tooltipScaleX = f;
        this.tooltipScaleY = f;
        this.labelOpacity = AnimationUtils.lerp(0.0f, 1.0f, 0.19f, 1.0f, f);
        this.invalidateSelf();
    }

    public void setText(CharSequence charSequence) {
        if (!TextUtils.equals((CharSequence)this.text, (CharSequence)charSequence)) {
            this.text = charSequence;
            this.textDrawableHelper.setTextWidthDirty(true);
            this.invalidateSelf();
        }
    }

    public void setTextAppearance(TextAppearance textAppearance) {
        this.textDrawableHelper.setTextAppearance(textAppearance, this.context);
    }

    public void setTextAppearanceResource(int n) {
        this.setTextAppearance(new TextAppearance(this.context, n));
    }

    public void setTextPadding(int n) {
        this.padding = n;
        this.invalidateSelf();
    }

    public void setTextResource(int n) {
        this.setText(this.context.getResources().getString(n));
    }
}

