/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.transition.Transition;
import androidx.transition.TransitionValues;
import androidx.transition.Visibility;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.transition.TransitionUtils;
import com.google.android.material.transition.VisibilityAnimatorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class MaterialVisibility<P extends VisibilityAnimatorProvider>
extends Visibility {
    private final List<VisibilityAnimatorProvider> additionalAnimatorProviders = new ArrayList<VisibilityAnimatorProvider>();
    private final P primaryAnimatorProvider;
    private VisibilityAnimatorProvider secondaryAnimatorProvider;

    protected MaterialVisibility(P p, VisibilityAnimatorProvider visibilityAnimatorProvider) {
        this.primaryAnimatorProvider = p;
        this.secondaryAnimatorProvider = visibilityAnimatorProvider;
    }

    private static void addAnimatorIfNeeded(List<Animator> list, VisibilityAnimatorProvider visibilityAnimatorProvider, ViewGroup viewGroup, View view, boolean bl) {
        if (visibilityAnimatorProvider == null) {
            return;
        }
        visibilityAnimatorProvider = bl ? visibilityAnimatorProvider.createAppear(viewGroup, view) : visibilityAnimatorProvider.createDisappear(viewGroup, view);
        if (visibilityAnimatorProvider != null) {
            list.add((Animator)visibilityAnimatorProvider);
        }
    }

    private Animator createAnimator(ViewGroup viewGroup, View view, boolean bl) {
        AnimatorSet animatorSet = new AnimatorSet();
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        MaterialVisibility.addAnimatorIfNeeded(arrayList, this.primaryAnimatorProvider, viewGroup, view, bl);
        MaterialVisibility.addAnimatorIfNeeded(arrayList, this.secondaryAnimatorProvider, viewGroup, view, bl);
        Iterator<VisibilityAnimatorProvider> iterator2 = this.additionalAnimatorProviders.iterator();
        while (iterator2.hasNext()) {
            MaterialVisibility.addAnimatorIfNeeded(arrayList, iterator2.next(), viewGroup, view, bl);
        }
        this.maybeApplyThemeValues(viewGroup.getContext(), bl);
        AnimatorSetCompat.playTogether(animatorSet, arrayList);
        return animatorSet;
    }

    private void maybeApplyThemeValues(Context context, boolean bl) {
        TransitionUtils.maybeApplyThemeDuration((Transition)this, context, this.getDurationThemeAttrResId(bl));
        TransitionUtils.maybeApplyThemeInterpolator((Transition)this, context, this.getEasingThemeAttrResId(bl), this.getDefaultEasingInterpolator(bl));
    }

    public void addAdditionalAnimatorProvider(VisibilityAnimatorProvider visibilityAnimatorProvider) {
        this.additionalAnimatorProviders.add(visibilityAnimatorProvider);
    }

    public void clearAdditionalAnimatorProvider() {
        this.additionalAnimatorProviders.clear();
    }

    TimeInterpolator getDefaultEasingInterpolator(boolean bl) {
        return AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR;
    }

    int getDurationThemeAttrResId(boolean bl) {
        return 0;
    }

    int getEasingThemeAttrResId(boolean bl) {
        return 0;
    }

    public P getPrimaryAnimatorProvider() {
        return this.primaryAnimatorProvider;
    }

    public VisibilityAnimatorProvider getSecondaryAnimatorProvider() {
        return this.secondaryAnimatorProvider;
    }

    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return this.createAnimator(viewGroup, view, true);
    }

    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return this.createAnimator(viewGroup, view, false);
    }

    public boolean removeAdditionalAnimatorProvider(VisibilityAnimatorProvider visibilityAnimatorProvider) {
        return this.additionalAnimatorProviders.remove(visibilityAnimatorProvider);
    }

    public void setSecondaryAnimatorProvider(VisibilityAnimatorProvider visibilityAnimatorProvider) {
        this.secondaryAnimatorProvider = visibilityAnimatorProvider;
    }
}

