/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.transition.VisibilityAnimatorProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SlideDistanceProvider
implements VisibilityAnimatorProvider {
    private static final int DEFAULT_DISTANCE = -1;
    private int slideDistance = -1;
    private int slideEdge;

    public SlideDistanceProvider(int n) {
        this.slideEdge = n;
    }

    private static Animator createTranslationAppearAnimator(View object, View view, int n, int n2) {
        float f = view.getTranslationX();
        float f2 = view.getTranslationY();
        if (n != 3) {
            if (n != 5) {
                if (n != 48) {
                    if (n != 80) {
                        if (n != 0x800003) {
                            if (n == 0x800005) {
                                f2 = SlideDistanceProvider.isRtl((View)object) ? f - (float)n2 : (float)n2 + f;
                                return SlideDistanceProvider.createTranslationXAnimator(view, f2, f, f);
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Invalid slide direction: ");
                            ((StringBuilder)object).append(n);
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                        f2 = SlideDistanceProvider.isRtl((View)object) ? (float)n2 + f : f - (float)n2;
                        return SlideDistanceProvider.createTranslationXAnimator(view, f2, f, f);
                    }
                    return SlideDistanceProvider.createTranslationYAnimator(view, (float)n2 + f2, f2, f2);
                }
                return SlideDistanceProvider.createTranslationYAnimator(view, f2 - (float)n2, f2, f2);
            }
            return SlideDistanceProvider.createTranslationXAnimator(view, f - (float)n2, f, f);
        }
        return SlideDistanceProvider.createTranslationXAnimator(view, (float)n2 + f, f, f);
    }

    private static Animator createTranslationDisappearAnimator(View object, View view, int n, int n2) {
        float f = view.getTranslationX();
        float f2 = view.getTranslationY();
        if (n != 3) {
            if (n != 5) {
                if (n != 48) {
                    if (n != 80) {
                        if (n != 0x800003) {
                            if (n == 0x800005) {
                                f2 = SlideDistanceProvider.isRtl((View)object) ? (float)n2 + f : f - (float)n2;
                                return SlideDistanceProvider.createTranslationXAnimator(view, f, f2, f);
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Invalid slide direction: ");
                            ((StringBuilder)object).append(n);
                            throw new IllegalArgumentException(((StringBuilder)object).toString());
                        }
                        f2 = SlideDistanceProvider.isRtl((View)object) ? f - (float)n2 : (float)n2 + f;
                        return SlideDistanceProvider.createTranslationXAnimator(view, f, f2, f);
                    }
                    return SlideDistanceProvider.createTranslationYAnimator(view, f2, f2 - (float)n2, f2);
                }
                return SlideDistanceProvider.createTranslationYAnimator(view, f2, (float)n2 + f2, f2);
            }
            return SlideDistanceProvider.createTranslationXAnimator(view, f, (float)n2 + f, f);
        }
        return SlideDistanceProvider.createTranslationXAnimator(view, f, f - (float)n2, f);
    }

    private static Animator createTranslationXAnimator(final View view, float f, float f2, final float f3) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{f, f2})});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                view.setTranslationX(f3);
            }
        });
        return objectAnimator;
    }

    private static Animator createTranslationYAnimator(final View view, float f, float f2, final float f3) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{f, f2})});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                view.setTranslationY(f3);
            }
        });
        return objectAnimator;
    }

    private int getSlideDistanceOrDefault(Context context) {
        int n = this.slideDistance;
        if (n != -1) {
            return n;
        }
        return context.getResources().getDimensionPixelSize(R.dimen.mtrl_transition_shared_axis_slide_distance);
    }

    private static boolean isRtl(View view) {
        int n = ViewCompat.getLayoutDirection((View)view);
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Animator createAppear(ViewGroup viewGroup, View view) {
        return SlideDistanceProvider.createTranslationAppearAnimator((View)viewGroup, view, this.slideEdge, this.getSlideDistanceOrDefault(view.getContext()));
    }

    @Override
    public Animator createDisappear(ViewGroup viewGroup, View view) {
        return SlideDistanceProvider.createTranslationDisappearAnimator((View)viewGroup, view, this.slideEdge, this.getSlideDistanceOrDefault(view.getContext()));
    }

    public int getSlideDistance() {
        return this.slideDistance;
    }

    public int getSlideEdge() {
        return this.slideEdge;
    }

    public void setSlideDistance(int n) {
        if (n >= 0) {
            this.slideDistance = n;
            return;
        }
        throw new IllegalArgumentException("Slide distance must be positive. If attempting to reverse the direction of the slide, use setSlideEdge(int) instead.");
    }

    public void setSlideEdge(int n) {
        this.slideEdge = n;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GravityFlag {
    }
}

