/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.transition.PathMotion;
import android.transition.PatternPathMotion;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.util.TypedValue;
import android.view.View;
import androidx.core.graphics.PathParser;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.RelativeCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.transition.platform.MaterialArcMotion;

class TransitionUtils {
    static final int NO_ATTR_RES_ID = 0;
    static final int NO_DURATION = -1;
    private static final int PATH_TYPE_ARC = 1;
    private static final int PATH_TYPE_LINEAR = 0;
    private static final RectF transformAlphaRectF = new RectF();

    private TransitionUtils() {
    }

    static float calculateArea(RectF rectF) {
        return rectF.width() * rectF.height();
    }

    static ShapeAppearanceModel convertToRelativeCornerSizes(ShapeAppearanceModel shapeAppearanceModel, final RectF rectF) {
        return shapeAppearanceModel.withTransformedCornerSizes(new ShapeAppearanceModel.CornerSizeUnaryOperator(){

            @Override
            public CornerSize apply(CornerSize cornerSize) {
                if (!(cornerSize instanceof RelativeCornerSize)) {
                    cornerSize = new RelativeCornerSize(cornerSize.getCornerSize(rectF) / rectF.height());
                }
                return cornerSize;
            }
        });
    }

    static Shader createColorShader(int n) {
        return new LinearGradient(0.0f, 0.0f, 0.0f, 0.0f, n, n, Shader.TileMode.CLAMP);
    }

    static <T> T defaultIfNull(T t, T t2) {
        if (t == null) {
            t = t2;
        }
        return t;
    }

    static View findAncestorById(View object, int n) {
        String string2 = object.getResources().getResourceName(n);
        while (object != null) {
            if (object.getId() == n) {
                return object;
            }
            if (!((object = object.getParent()) instanceof View)) break;
            object = (View)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" is not a valid ancestor");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    static View findDescendantOrAncestorById(View view, int n) {
        View view2 = view.findViewById(n);
        if (view2 != null) {
            return view2;
        }
        return TransitionUtils.findAncestorById(view, n);
    }

    static RectF getLocationOnScreen(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = view.getWidth();
        int n4 = view.getHeight();
        return new RectF((float)n, (float)n2, (float)(n3 + n), (float)(n4 + n2));
    }

    static RectF getRelativeBounds(View view) {
        return new RectF((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
    }

    static Rect getRelativeBoundsRect(View view) {
        return new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    private static boolean isShapeAppearanceSignificant(ShapeAppearanceModel shapeAppearanceModel, RectF rectF) {
        boolean bl = shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(rectF) != 0.0f || shapeAppearanceModel.getTopRightCornerSize().getCornerSize(rectF) != 0.0f || shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(rectF) != 0.0f || shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(rectF) != 0.0f;
        return bl;
    }

    static float lerp(float f, float f2, float f3) {
        return f + f3 * (f2 - f);
    }

    static float lerp(float f, float f2, float f3, float f4, float f5) {
        return TransitionUtils.lerp(f, f2, f3, f4, f5, false);
    }

    static float lerp(float f, float f2, float f3, float f4, float f5, boolean bl) {
        if (bl && (f5 < 0.0f || f5 > 1.0f)) {
            return TransitionUtils.lerp(f, f2, f5);
        }
        if (f5 < f3) {
            return f;
        }
        if (f5 > f4) {
            return f2;
        }
        return TransitionUtils.lerp(f, f2, (f5 - f3) / (f4 - f3));
    }

    static int lerp(int n, int n2, float f, float f2, float f3) {
        if (f3 < f) {
            return n;
        }
        if (f3 > f2) {
            return n2;
        }
        return (int)TransitionUtils.lerp(n, n2, (f3 - f) / (f2 - f));
    }

    static ShapeAppearanceModel lerp(ShapeAppearanceModel shapeAppearanceModel, ShapeAppearanceModel shapeAppearanceModel2, final RectF rectF, final RectF rectF2, final float f, final float f2, final float f3) {
        if (f3 < f) {
            return shapeAppearanceModel;
        }
        if (f3 > f2) {
            return shapeAppearanceModel2;
        }
        return TransitionUtils.transformCornerSizes(shapeAppearanceModel, shapeAppearanceModel2, rectF, new CornerSizeBinaryOperator(){

            @Override
            public CornerSize apply(CornerSize cornerSize, CornerSize cornerSize2) {
                return new AbsoluteCornerSize(TransitionUtils.lerp(cornerSize.getCornerSize(rectF), cornerSize2.getCornerSize(rectF2), f, f2, f3));
            }
        });
    }

    static void maybeAddTransition(TransitionSet transitionSet, Transition transition) {
        if (transition != null) {
            transitionSet.addTransition(transition);
        }
    }

    static boolean maybeApplyThemeDuration(Transition transition, Context context, int n) {
        if (n != 0 && transition.getDuration() == -1L && (n = MotionUtils.resolveThemeDuration(context, n, -1)) != -1) {
            transition.setDuration((long)n);
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemeInterpolator(Transition transition, Context context, int n, TimeInterpolator timeInterpolator) {
        if (n != 0 && transition.getInterpolator() == null) {
            transition.setInterpolator(MotionUtils.resolveThemeInterpolator(context, n, timeInterpolator));
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemePath(Transition transition, Context context, int n) {
        if (n != 0 && (context = TransitionUtils.resolveThemePath(context, n)) != null) {
            transition.setPathMotion((PathMotion)context);
            return true;
        }
        return false;
    }

    static void maybeRemoveTransition(TransitionSet transitionSet, Transition transition) {
        if (transition != null) {
            transitionSet.removeTransition(transition);
        }
    }

    static PathMotion resolveThemePath(Context object, int n) {
        TypedValue typedValue = new TypedValue();
        if (object.getTheme().resolveAttribute(n, typedValue, true)) {
            if (typedValue.type == 16) {
                n = typedValue.data;
                if (n == 0) {
                    return null;
                }
                if (n == 1) {
                    return new MaterialArcMotion();
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid motion path type: ");
                ((StringBuilder)object).append(n);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            if (typedValue.type == 3) {
                return new PatternPathMotion(PathParser.createPathFromPathData((String)String.valueOf(typedValue.string)));
            }
            throw new IllegalArgumentException("Motion path theme attribute must either be an enum value or path data string");
        }
        return null;
    }

    private static int saveLayerAlphaCompat(Canvas canvas, Rect rect, int n) {
        RectF rectF = transformAlphaRectF;
        rectF.set(rect);
        if (Build.VERSION.SDK_INT >= 21) {
            return canvas.saveLayerAlpha(rectF, n);
        }
        return canvas.saveLayerAlpha(rectF.left, rectF.top, rectF.right, rectF.bottom, n, 31);
    }

    static void transform(Canvas canvas, Rect rect, float f, float f2, float f3, int n, CanvasOperation canvasOperation) {
        if (n <= 0) {
            return;
        }
        int n2 = canvas.save();
        canvas.translate(f, f2);
        canvas.scale(f3, f3);
        if (n < 255) {
            TransitionUtils.saveLayerAlphaCompat(canvas, rect, n);
        }
        canvasOperation.run(canvas);
        canvas.restoreToCount(n2);
    }

    static ShapeAppearanceModel transformCornerSizes(ShapeAppearanceModel shapeAppearanceModel, ShapeAppearanceModel shapeAppearanceModel2, RectF object, CornerSizeBinaryOperator cornerSizeBinaryOperator) {
        object = TransitionUtils.isShapeAppearanceSignificant(shapeAppearanceModel, (RectF)object) ? shapeAppearanceModel : shapeAppearanceModel2;
        return ((ShapeAppearanceModel)object).toBuilder().setTopLeftCornerSize(cornerSizeBinaryOperator.apply(shapeAppearanceModel.getTopLeftCornerSize(), shapeAppearanceModel2.getTopLeftCornerSize())).setTopRightCornerSize(cornerSizeBinaryOperator.apply(shapeAppearanceModel.getTopRightCornerSize(), shapeAppearanceModel2.getTopRightCornerSize())).setBottomLeftCornerSize(cornerSizeBinaryOperator.apply(shapeAppearanceModel.getBottomLeftCornerSize(), shapeAppearanceModel2.getBottomLeftCornerSize())).setBottomRightCornerSize(cornerSizeBinaryOperator.apply(shapeAppearanceModel.getBottomRightCornerSize(), shapeAppearanceModel2.getBottomRightCornerSize())).build();
    }

    static interface CanvasOperation {
        public void run(Canvas var1);
    }

    static interface CornerSizeBinaryOperator {
        public CornerSize apply(CornerSize var1, CornerSize var2);
    }
}

