/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.zza;
import com.google.firebase.analytics.zzc;
import com.google.firebase.installations.FirebaseInstallations;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FirebaseAnalytics {
    private static volatile FirebaseAnalytics zza;
    private final zzee zzb;
    private ExecutorService zzc;

    public FirebaseAnalytics(zzee zzee2) {
        Preconditions.checkNotNull(zzee2);
        this.zzb = zzee2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FirebaseAnalytics getInstance(Context object) {
        if (zza != null) return zza;
        synchronized (FirebaseAnalytics.class) {
            if (zza != null) return zza;
            zzee zzee2 = zzee.zzg(object, null, null, null, null);
            object = new FirebaseAnalytics(zzee2);
            zza = object;
            return zza;
        }
    }

    public static zziq getScionFrontendApiImplementation(Context object, Bundle bundle) {
        if ((object = zzee.zzg(object, null, null, null, bundle)) == null) {
            return null;
        }
        return new zzc((zzee)object);
    }

    static /* bridge */ /* synthetic */ zzee zza(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzb;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task<String> getAppInstanceId() {
        Task<String> task;
        Object object;
        try {
            synchronized (FirebaseAnalytics.class) {
                if (this.zzc != null) break block7;
                object = TimeUnit.SECONDS;
            }
        }
        catch (RuntimeException runtimeException) {
            this.zzb.zzA(5, "Failed to schedule task for getAppInstanceId", null, null, null);
            return Tasks.forException(runtimeException);
        }
        {
            block7: {
                task = new Task<String>(100);
                zza zza2 = new zza(this, 0, 1, 30L, (TimeUnit)((Object)object), (BlockingQueue)((Object)task));
                this.zzc = zza2;
            }
            object = this.zzc;
        }
        {
            task = new Task<String>(this);
            return Tasks.call(object, task);
        }
    }

    public String getFirebaseInstanceId() {
        try {
            String string2 = Tasks.await(FirebaseInstallations.getInstance().getId(), 30000L, TimeUnit.MILLISECONDS);
            return string2;
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException.getCause());
        }
    }

    public void logEvent(String string2, Bundle bundle) {
        this.zzb.zzx(string2, bundle);
    }

    public void resetAnalyticsData() {
        this.zzb.zzC();
    }

    public void setAnalyticsCollectionEnabled(boolean bl) {
        this.zzb.zzK(bl);
    }

    public void setConsent(Map<ConsentType, ConsentStatus> object) {
        int n;
        Bundle bundle = new Bundle();
        ConsentStatus consentStatus = object.get((Object)ConsentType.AD_STORAGE);
        if (consentStatus != null) {
            n = consentStatus.ordinal();
            if (n != 0) {
                if (n == 1) {
                    bundle.putString("ad_storage", "denied");
                }
            } else {
                bundle.putString("ad_storage", "granted");
            }
        }
        if ((object = object.get((Object)ConsentType.ANALYTICS_STORAGE)) != null) {
            n = ((Enum)object).ordinal();
            if (n != 0) {
                if (n == 1) {
                    bundle.putString("analytics_storage", "denied");
                }
            } else {
                bundle.putString("analytics_storage", "granted");
            }
        }
        this.zzb.zzF(bundle);
    }

    @Deprecated
    public void setCurrentScreen(Activity activity, String string2, String string3) {
        this.zzb.zzG(activity, string2, string3);
    }

    public void setDefaultEventParameters(Bundle bundle) {
        this.zzb.zzI(bundle);
    }

    public void setSessionTimeoutDuration(long l) {
        this.zzb.zzL(l);
    }

    public void setUserId(String string2) {
        this.zzb.zzM(string2);
    }

    public void setUserProperty(String string2, String string3) {
        this.zzb.zzN(null, string2, string3, false);
    }

    public static final class ConsentStatus
    extends Enum<ConsentStatus> {
        public static final /* enum */ ConsentStatus DENIED;
        public static final /* enum */ ConsentStatus GRANTED;
        private static final /* synthetic */ ConsentStatus[] zza;

        static {
            ConsentStatus consentStatus;
            ConsentStatus consentStatus2;
            GRANTED = consentStatus2 = new ConsentStatus();
            DENIED = consentStatus = new ConsentStatus();
            zza = new ConsentStatus[]{consentStatus2, consentStatus};
        }

        public static ConsentStatus valueOf(String string2) {
            return Enum.valueOf(ConsentStatus.class, string2);
        }

        public static ConsentStatus[] values() {
            return (ConsentStatus[])zza.clone();
        }
    }

    public static final class ConsentType
    extends Enum<ConsentType> {
        public static final /* enum */ ConsentType AD_STORAGE;
        public static final /* enum */ ConsentType ANALYTICS_STORAGE;
        private static final /* synthetic */ ConsentType[] zza;

        static {
            ConsentType consentType;
            ConsentType consentType2;
            AD_STORAGE = consentType2 = new ConsentType();
            ANALYTICS_STORAGE = consentType = new ConsentType();
            zza = new ConsentType[]{consentType2, consentType};
        }

        public static ConsentType valueOf(String string2) {
            return Enum.valueOf(ConsentType.class, string2);
        }

        public static ConsentType[] values() {
            return (ConsentType[])zza.clone();
        }
    }

    public static class Event {
        public static final String ADD_PAYMENT_INFO = "add_payment_info";
        public static final String ADD_SHIPPING_INFO = "add_shipping_info";
        public static final String ADD_TO_CART = "add_to_cart";
        public static final String ADD_TO_WISHLIST = "add_to_wishlist";
        public static final String AD_IMPRESSION = "ad_impression";
        public static final String APP_OPEN = "app_open";
        public static final String BEGIN_CHECKOUT = "begin_checkout";
        public static final String CAMPAIGN_DETAILS = "campaign_details";
        public static final String EARN_VIRTUAL_CURRENCY = "earn_virtual_currency";
        public static final String GENERATE_LEAD = "generate_lead";
        public static final String JOIN_GROUP = "join_group";
        public static final String LEVEL_END = "level_end";
        public static final String LEVEL_START = "level_start";
        public static final String LEVEL_UP = "level_up";
        public static final String LOGIN = "login";
        public static final String POST_SCORE = "post_score";
        public static final String PURCHASE = "purchase";
        public static final String REFUND = "refund";
        public static final String REMOVE_FROM_CART = "remove_from_cart";
        public static final String SCREEN_VIEW = "screen_view";
        public static final String SEARCH = "search";
        public static final String SELECT_CONTENT = "select_content";
        public static final String SELECT_ITEM = "select_item";
        public static final String SELECT_PROMOTION = "select_promotion";
        public static final String SHARE = "share";
        public static final String SIGN_UP = "sign_up";
        public static final String SPEND_VIRTUAL_CURRENCY = "spend_virtual_currency";
        public static final String TUTORIAL_BEGIN = "tutorial_begin";
        public static final String TUTORIAL_COMPLETE = "tutorial_complete";
        public static final String UNLOCK_ACHIEVEMENT = "unlock_achievement";
        public static final String VIEW_CART = "view_cart";
        public static final String VIEW_ITEM = "view_item";
        public static final String VIEW_ITEM_LIST = "view_item_list";
        public static final String VIEW_PROMOTION = "view_promotion";
        public static final String VIEW_SEARCH_RESULTS = "view_search_results";

        protected Event() {
        }
    }

    public static class Param {
        public static final String ACHIEVEMENT_ID = "achievement_id";
        public static final String ACLID = "aclid";
        public static final String AD_FORMAT = "ad_format";
        public static final String AD_PLATFORM = "ad_platform";
        public static final String AD_SOURCE = "ad_source";
        public static final String AD_UNIT_NAME = "ad_unit_name";
        public static final String AFFILIATION = "affiliation";
        public static final String CAMPAIGN = "campaign";
        public static final String CHARACTER = "character";
        public static final String CONTENT = "content";
        public static final String CONTENT_TYPE = "content_type";
        public static final String COUPON = "coupon";
        public static final String CP1 = "cp1";
        public static final String CREATIVE_NAME = "creative_name";
        public static final String CREATIVE_SLOT = "creative_slot";
        public static final String CURRENCY = "currency";
        public static final String DESTINATION = "destination";
        public static final String DISCOUNT = "discount";
        public static final String END_DATE = "end_date";
        public static final String EXTEND_SESSION = "extend_session";
        public static final String FLIGHT_NUMBER = "flight_number";
        public static final String GROUP_ID = "group_id";
        public static final String INDEX = "index";
        public static final String ITEMS = "items";
        public static final String ITEM_BRAND = "item_brand";
        public static final String ITEM_CATEGORY = "item_category";
        public static final String ITEM_CATEGORY2 = "item_category2";
        public static final String ITEM_CATEGORY3 = "item_category3";
        public static final String ITEM_CATEGORY4 = "item_category4";
        public static final String ITEM_CATEGORY5 = "item_category5";
        public static final String ITEM_ID = "item_id";
        public static final String ITEM_LIST_ID = "item_list_id";
        public static final String ITEM_LIST_NAME = "item_list_name";
        public static final String ITEM_NAME = "item_name";
        public static final String ITEM_VARIANT = "item_variant";
        public static final String LEVEL = "level";
        public static final String LEVEL_NAME = "level_name";
        public static final String LOCATION = "location";
        public static final String LOCATION_ID = "location_id";
        public static final String MEDIUM = "medium";
        public static final String METHOD = "method";
        public static final String NUMBER_OF_NIGHTS = "number_of_nights";
        public static final String NUMBER_OF_PASSENGERS = "number_of_passengers";
        public static final String NUMBER_OF_ROOMS = "number_of_rooms";
        public static final String ORIGIN = "origin";
        public static final String PAYMENT_TYPE = "payment_type";
        public static final String PRICE = "price";
        public static final String PROMOTION_ID = "promotion_id";
        public static final String PROMOTION_NAME = "promotion_name";
        public static final String QUANTITY = "quantity";
        public static final String SCORE = "score";
        public static final String SCREEN_CLASS = "screen_class";
        public static final String SCREEN_NAME = "screen_name";
        public static final String SEARCH_TERM = "search_term";
        public static final String SHIPPING = "shipping";
        public static final String SHIPPING_TIER = "shipping_tier";
        public static final String SOURCE = "source";
        public static final String START_DATE = "start_date";
        public static final String SUCCESS = "success";
        public static final String TAX = "tax";
        public static final String TERM = "term";
        public static final String TRANSACTION_ID = "transaction_id";
        public static final String TRAVEL_CLASS = "travel_class";
        public static final String VALUE = "value";
        public static final String VIRTUAL_CURRENCY_NAME = "virtual_currency_name";

        protected Param() {
        }
    }

    public static class UserProperty {
        public static final String ALLOW_AD_PERSONALIZATION_SIGNALS = "allow_personalized_ads";
        public static final String SIGN_UP_METHOD = "sign_up_method";

        protected UserProperty() {
        }
    }
}

