/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Component;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.DependencyCycleException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class CycleDetector {
    CycleDetector() {
    }

    static void detect(List<Component<?>> list) {
        Object object;
        Object object2 = CycleDetector.toGraph(list);
        Set<ComponentNode> set = CycleDetector.getRoots(object2);
        int n = 0;
        block0: while (!set.isEmpty()) {
            ComponentNode componentNode = set.iterator().next();
            set.remove(componentNode);
            int n2 = n + 1;
            Iterator<ComponentNode> iterator2 = componentNode.getDependencies().iterator();
            while (true) {
                n = n2;
                if (!iterator2.hasNext()) continue block0;
                object = iterator2.next();
                ((ComponentNode)object).removeDependent(componentNode);
                if (!((ComponentNode)object).isRoot()) continue;
                set.add((ComponentNode)object);
            }
        }
        if (n == list.size()) {
            return;
        }
        list = new ArrayList();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            if (((ComponentNode)object2).isRoot() || ((ComponentNode)object2).isLeaf()) continue;
            list.add(((ComponentNode)object2).getComponent());
        }
        throw new DependencyCycleException(list);
    }

    private static Set<ComponentNode> getRoots(Set<ComponentNode> object) {
        HashSet<ComponentNode> hashSet = new HashSet<ComponentNode>();
        Iterator<ComponentNode> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (!((ComponentNode)object).isRoot()) continue;
            hashSet.add((ComponentNode)object);
        }
        return hashSet;
    }

    private static Set<ComponentNode> toGraph(List<Component<?>> iterator2) {
        Object object;
        Object object3 = new HashMap(iterator2.size());
        Object object422 = iterator2.iterator();
        while (object422.hasNext()) {
            Object object2 = (Component)object422.next();
            ComponentNode componentNode = new ComponentNode((Component<?>)object2);
            for (Class clazz : ((Component)object2).getProvidedInterfaces()) {
                Dep object5 = new Dep(clazz, ((Component)object2).isValue() ^ true);
                if (!object3.containsKey(object5)) {
                    object3.put(object5, new HashSet());
                }
                if (!(object = (Set)object3.get(object5)).isEmpty() && !object5.set) {
                    throw new IllegalArgumentException(String.format("Multiple components provide %s.", clazz));
                }
                object.add(componentNode);
            }
        }
        object = object3.values().iterator();
        while (object.hasNext()) {
            for (Object object422 : (Set)object.next()) {
                for (Dependency dependency : ((ComponentNode)object422).getComponent().getDependencies()) {
                    Set set;
                    if (!dependency.isDirectInjection() || (set = (Set)object3.get(new Dep(dependency.getInterface(), dependency.isSet()))) == null) continue;
                    for (Object object2 : set) {
                        ((ComponentNode)object422).addDependency((ComponentNode)object2);
                        ((ComponentNode)object2).addDependent((ComponentNode)object422);
                    }
                }
            }
        }
        iterator2 = new HashSet();
        object3 = object3.values().iterator();
        while (object3.hasNext()) {
            ((AbstractCollection)((Object)iterator2)).addAll((Set)object3.next());
        }
        return iterator2;
    }

    private static class ComponentNode {
        private final Component<?> component;
        private final Set<ComponentNode> dependencies = new HashSet<ComponentNode>();
        private final Set<ComponentNode> dependents = new HashSet<ComponentNode>();

        ComponentNode(Component<?> component) {
            this.component = component;
        }

        void addDependency(ComponentNode componentNode) {
            this.dependencies.add(componentNode);
        }

        void addDependent(ComponentNode componentNode) {
            this.dependents.add(componentNode);
        }

        Component<?> getComponent() {
            return this.component;
        }

        Set<ComponentNode> getDependencies() {
            return this.dependencies;
        }

        boolean isLeaf() {
            return this.dependencies.isEmpty();
        }

        boolean isRoot() {
            return this.dependents.isEmpty();
        }

        void removeDependent(ComponentNode componentNode) {
            this.dependents.remove(componentNode);
        }
    }

    private static class Dep {
        private final Class<?> anInterface;
        private final boolean set;

        private Dep(Class<?> clazz, boolean bl) {
            this.anInterface = clazz;
            this.set = bl;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = object instanceof Dep;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (Dep)object;
                bl3 = bl;
                if (((Dep)object).anInterface.equals(this.anInterface)) {
                    bl3 = bl;
                    if (((Dep)object).set == this.set) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return (this.anInterface.hashCode() ^ 0xF4243) * 1000003 ^ Boolean.valueOf(this.set).hashCode();
        }
    }
}

