/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.os.Bundle;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.AnalyticsDeferredProxy$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.AnalyticsDeferredProxy$$ExternalSyntheticLambda1;
import com.google.firebase.crashlytics.AnalyticsDeferredProxy$$ExternalSyntheticLambda2;
import com.google.firebase.crashlytics.CrashlyticsAnalyticsListener;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.BlockingAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.BreadcrumbAnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.UnavailableAnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbHandler;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.breadcrumbs.DisabledBreadcrumbSource;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AnalyticsDeferredProxy {
    private final Deferred<AnalyticsConnector> analyticsConnectorDeferred;
    private volatile AnalyticsEventLogger analyticsEventLogger;
    private final List<BreadcrumbHandler> breadcrumbHandlerList;
    private volatile BreadcrumbSource breadcrumbSource;

    public AnalyticsDeferredProxy(Deferred<AnalyticsConnector> deferred) {
        this(deferred, new DisabledBreadcrumbSource(), new UnavailableAnalyticsEventLogger());
    }

    public AnalyticsDeferredProxy(Deferred<AnalyticsConnector> deferred, BreadcrumbSource breadcrumbSource, AnalyticsEventLogger analyticsEventLogger) {
        this.analyticsConnectorDeferred = deferred;
        this.breadcrumbSource = breadcrumbSource;
        this.breadcrumbHandlerList = new ArrayList<BreadcrumbHandler>();
        this.analyticsEventLogger = analyticsEventLogger;
        this.init();
    }

    private void init() {
        this.analyticsConnectorDeferred.whenAvailable(new AnalyticsDeferredProxy$$ExternalSyntheticLambda2(this));
    }

    private static AnalyticsConnector.AnalyticsConnectorHandle subscribeToAnalyticsEvents(AnalyticsConnector object, CrashlyticsAnalyticsListener crashlyticsAnalyticsListener) {
        AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle = object.registerAnalyticsConnectorListener("clx", crashlyticsAnalyticsListener);
        Object object2 = analyticsConnectorHandle;
        if (analyticsConnectorHandle == null) {
            Logger.getLogger().d("Could not register AnalyticsConnectorListener with Crashlytics origin.");
            object2 = object = object.registerAnalyticsConnectorListener("crash", crashlyticsAnalyticsListener);
            if (object != null) {
                Logger.getLogger().w("A new version of the Google Analytics for Firebase SDK is now available. For improved performance and compatibility with Crashlytics, please update to the latest version.");
                object2 = object;
            }
        }
        return object2;
    }

    public AnalyticsEventLogger getAnalyticsEventLogger() {
        return new AnalyticsDeferredProxy$$ExternalSyntheticLambda0(this);
    }

    public BreadcrumbSource getDeferredBreadcrumbSource() {
        return new AnalyticsDeferredProxy$$ExternalSyntheticLambda1(this);
    }

    public /* synthetic */ void lambda$getAnalyticsEventLogger$1$com-google-firebase-crashlytics-AnalyticsDeferredProxy(String string2, Bundle bundle) {
        this.analyticsEventLogger.logEvent(string2, bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public /* synthetic */ void lambda$getDeferredBreadcrumbSource$0$com-google-firebase-crashlytics-AnalyticsDeferredProxy(BreadcrumbHandler breadcrumbHandler) {
        synchronized (this) {
            if (this.breadcrumbSource instanceof DisabledBreadcrumbSource) {
                this.breadcrumbHandlerList.add(breadcrumbHandler);
            }
            this.breadcrumbSource.registerBreadcrumbHandler(breadcrumbHandler);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public /* synthetic */ void lambda$init$2$com-google-firebase-crashlytics-AnalyticsDeferredProxy(Provider object) {
        Logger.getLogger().d("AnalyticsConnector now available.");
        Object object2 = (AnalyticsConnector)object.get();
        AnalyticsEventLogger analyticsEventLogger = new CrashlyticsOriginAnalyticsEventLogger((AnalyticsConnector)object2);
        object = new CrashlyticsAnalyticsListener();
        if (AnalyticsDeferredProxy.subscribeToAnalyticsEvents((AnalyticsConnector)object2, (CrashlyticsAnalyticsListener)object) == null) {
            Logger.getLogger().w("Could not register Firebase Analytics listener; a listener is already registered.");
            return;
        }
        Logger.getLogger().d("Registered Firebase Analytics listener.");
        object2 = new BreadcrumbAnalyticsEventReceiver();
        analyticsEventLogger = new BlockingAnalyticsEventLogger((CrashlyticsOriginAnalyticsEventLogger)analyticsEventLogger, 500, TimeUnit.MILLISECONDS);
        synchronized (this) {
            Iterator<BreadcrumbHandler> iterator2 = this.breadcrumbHandlerList.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    ((CrashlyticsAnalyticsListener)object).setBreadcrumbEventReceiver((AnalyticsEventReceiver)object2);
                    ((CrashlyticsAnalyticsListener)object).setCrashlyticsOriginEventReceiver((AnalyticsEventReceiver)((Object)analyticsEventLogger));
                    this.breadcrumbSource = object2;
                    this.analyticsEventLogger = analyticsEventLogger;
                    return;
                }
                ((BreadcrumbAnalyticsEventReceiver)object2).registerBreadcrumbHandler(iterator2.next());
            }
        }
    }
}

