/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.content.Context;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import java.io.IOException;
import java.io.InputStream;

public class DevelopmentPlatformProvider {
    private static final String FLUTTER_ASSET_FILE = "flutter_assets/NOTICES.Z";
    private static final String FLUTTER_PLATFORM = "Flutter";
    private static final String UNITY_PLATFORM = "Unity";
    private static final String UNITY_VERSION_FIELD = "com.google.firebase.crashlytics.unity_version";
    private final Context context;
    private DevelopmentPlatform developmentPlatform;

    public DevelopmentPlatformProvider(Context context) {
        this.context = context;
        this.developmentPlatform = null;
    }

    private boolean assetFileExists(String object) {
        block4: {
            if (this.context.getAssets() == null) {
                return false;
            }
            try {
                object = this.context.getAssets().open((String)object);
                if (object == null) break block4;
            }
            catch (IOException iOException) {
                return false;
            }
            ((InputStream)object).close();
        }
        return true;
    }

    private DevelopmentPlatform initDevelopmentPlatform() {
        if (this.developmentPlatform == null) {
            this.developmentPlatform = new DevelopmentPlatform();
        }
        return this.developmentPlatform;
    }

    public static boolean isUnity(Context context) {
        boolean bl = CommonUtils.getResourcesIdentifier(context, UNITY_VERSION_FIELD, "string") != 0;
        return bl;
    }

    public String getDevelopmentPlatform() {
        return this.initDevelopmentPlatform().developmentPlatform;
    }

    public String getDevelopmentPlatformVersion() {
        return this.initDevelopmentPlatform().developmentPlatformVersion;
    }

    private class DevelopmentPlatform {
        private final String developmentPlatform;
        private final String developmentPlatformVersion;

        private DevelopmentPlatform() {
            int n = CommonUtils.getResourcesIdentifier(((DevelopmentPlatformProvider)DevelopmentPlatformProvider.this).context, DevelopmentPlatformProvider.UNITY_VERSION_FIELD, "string");
            if (n != 0) {
                String string2;
                this.developmentPlatform = DevelopmentPlatformProvider.UNITY_PLATFORM;
                this.developmentPlatformVersion = string2 = ((DevelopmentPlatformProvider)DevelopmentPlatformProvider.this).context.getResources().getString(n);
                Logger logger = Logger.getLogger();
                DevelopmentPlatformProvider.this = new StringBuilder();
                ((StringBuilder)DevelopmentPlatformProvider.this).append("Unity Editor version is: ");
                ((StringBuilder)DevelopmentPlatformProvider.this).append(string2);
                logger.v(((StringBuilder)DevelopmentPlatformProvider.this).toString());
                return;
            }
            if (((DevelopmentPlatformProvider)DevelopmentPlatformProvider.this).assetFileExists(DevelopmentPlatformProvider.FLUTTER_ASSET_FILE)) {
                this.developmentPlatform = DevelopmentPlatformProvider.FLUTTER_PLATFORM;
                this.developmentPlatformVersion = null;
                Logger.getLogger().v("Development platform is: Flutter");
                return;
            }
            this.developmentPlatform = null;
            this.developmentPlatformVersion = null;
        }
    }
}

