/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.util.Log;

public class Logger {
    static final Logger DEFAULT_LOGGER = new Logger("FirebaseCrashlytics");
    public static final String TAG = "FirebaseCrashlytics";
    private int logLevel;
    private final String tag;

    public Logger(String string2) {
        this.tag = string2;
        this.logLevel = 4;
    }

    private boolean canLog(int n) {
        boolean bl = this.logLevel <= n || Log.isLoggable((String)this.tag, (int)n);
        return bl;
    }

    public static Logger getLogger() {
        return DEFAULT_LOGGER;
    }

    public void d(String string2) {
        this.d(string2, null);
    }

    public void d(String string2, Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)this.tag, (String)string2, (Throwable)throwable);
        }
    }

    public void e(String string2) {
        this.e(string2, null);
    }

    public void e(String string2, Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)this.tag, (String)string2, (Throwable)throwable);
        }
    }

    public void i(String string2) {
        this.i(string2, null);
    }

    public void i(String string2, Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)this.tag, (String)string2, (Throwable)throwable);
        }
    }

    public void log(int n, String string2) {
        this.log(n, string2, false);
    }

    public void log(int n, String string2, boolean bl) {
        if (bl || this.canLog(n)) {
            Log.println((int)n, (String)this.tag, (String)string2);
        }
    }

    public void v(String string2) {
        this.v(string2, null);
    }

    public void v(String string2, Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)this.tag, (String)string2, (Throwable)throwable);
        }
    }

    public void w(String string2) {
        this.w(string2, null);
    }

    public void w(String string2, Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)this.tag, (String)string2, (Throwable)throwable);
        }
    }
}

