/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbHandler;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import org.json.JSONException;
import org.json.JSONObject;

public class BreadcrumbAnalyticsEventReceiver
implements AnalyticsEventReceiver,
BreadcrumbSource {
    private static final String BREADCRUMB_NAME_KEY = "name";
    private static final String BREADCRUMB_PARAMS_KEY = "parameters";
    private static final String BREADCRUMB_PREFIX = "$A$:";
    private BreadcrumbHandler breadcrumbHandler;

    private static String serializeEvent(String string2, Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        for (String string3 : bundle.keySet()) {
            jSONObject2.put(string3, bundle.get(string3));
        }
        jSONObject.put(BREADCRUMB_NAME_KEY, (Object)string2);
        jSONObject.put(BREADCRUMB_PARAMS_KEY, (Object)jSONObject2);
        return jSONObject.toString();
    }

    @Override
    public void onEvent(String string2, Bundle bundle) {
        BreadcrumbHandler breadcrumbHandler = this.breadcrumbHandler;
        if (breadcrumbHandler != null) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(BREADCRUMB_PREFIX);
                stringBuilder.append(BreadcrumbAnalyticsEventReceiver.serializeEvent(string2, bundle));
                breadcrumbHandler.handleBreadcrumb(stringBuilder.toString());
            }
            catch (JSONException jSONException) {
                Logger.getLogger().w("Unable to serialize Firebase Analytics event to breadcrumb.");
            }
        }
    }

    @Override
    public void registerBreadcrumbHandler(BreadcrumbHandler breadcrumbHandler) {
        this.breadcrumbHandler = breadcrumbHandler;
        Logger.getLogger().d("Registered Firebase Analytics event receiver for breadcrumbs");
    }
}

