/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class CrashlyticsBackgroundWorker {
    private final Executor executor;
    private final ThreadLocal<Boolean> isExecutorThread;
    private Task<Void> tail = Tasks.forResult(null);
    private final Object tailLock = new Object();

    public CrashlyticsBackgroundWorker(Executor executor) {
        this.isExecutorThread = new ThreadLocal();
        this.executor = executor;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                CrashlyticsBackgroundWorker.this.isExecutorThread.set(true);
            }
        });
    }

    private <T> Task<Void> ignoreResult(Task<T> task) {
        return task.continueWith(this.executor, new Continuation<T, Void>(){

            @Override
            public Void then(Task<T> task) throws Exception {
                return null;
            }
        });
    }

    private boolean isRunningOnThread() {
        return Boolean.TRUE.equals(this.isExecutorThread.get());
    }

    private <T> Continuation<Void, T> newContinuation(final Callable<T> callable) {
        return new Continuation<Void, T>(){

            @Override
            public T then(Task<Void> task) throws Exception {
                return callable.call();
            }
        };
    }

    public void checkRunningOnThread() {
        if (this.isRunningOnThread()) {
            return;
        }
        throw new IllegalStateException("Not running on background worker thread as intended.");
    }

    public Executor getExecutor() {
        return this.executor;
    }

    Task<Void> submit(final Runnable runnable) {
        return this.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Task<T> submit(Callable<T> object) {
        Object object2 = this.tailLock;
        synchronized (object2) {
            object = this.tail.continueWith(this.executor, this.newContinuation((Callable<T>)object));
            this.tail = this.ignoreResult((Task<T>)object);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Task<T> submitTask(Callable<Task<T>> object) {
        Object object2 = this.tailLock;
        synchronized (object2) {
            object = this.tail.continueWithTask(this.executor, this.newContinuation((Callable<T>)object));
            this.tail = this.ignoreResult((Task<T>)object);
            return object;
        }
    }
}

