/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.BatteryState;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.TrimmedThrowableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CrashlyticsReportDataCapture {
    private static final Map<String, Integer> ARCHITECTURES_BY_NAME;
    static final String GENERATOR;
    static final int GENERATOR_TYPE = 3;
    static final int REPORT_ANDROID_PLATFORM = 4;
    static final int SESSION_ANDROID_PLATFORM = 3;
    static final String SIGNAL_DEFAULT = "0";
    private final AppData appData;
    private final Context context;
    private final IdManager idManager;
    private final StackTraceTrimmingStrategy stackTraceTrimmingStrategy;

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ARCHITECTURES_BY_NAME = hashMap;
        hashMap.put("armeabi", 5);
        hashMap.put("armeabi-v7a", 6);
        hashMap.put("arm64-v8a", 9);
        hashMap.put("x86", 0);
        hashMap.put("x86_64", 1);
        GENERATOR = String.format(Locale.US, "Crashlytics Android SDK/%s", "18.2.11");
    }

    public CrashlyticsReportDataCapture(Context context, IdManager idManager, AppData appData, StackTraceTrimmingStrategy stackTraceTrimmingStrategy) {
        this.context = context;
        this.idManager = idManager;
        this.appData = appData;
        this.stackTraceTrimmingStrategy = stackTraceTrimmingStrategy;
    }

    private CrashlyticsReport.Builder buildReportData() {
        return CrashlyticsReport.builder().setSdkVersion("18.2.11").setGmpAppId(this.appData.googleAppId).setInstallationUuid(this.idManager.getCrashlyticsInstallId()).setBuildVersion(this.appData.versionCode).setDisplayVersion(this.appData.versionName).setPlatform(4);
    }

    private static int getDeviceArchitecture() {
        Object object = Build.CPU_ABI;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return 7;
        }
        if ((object = ARCHITECTURES_BY_NAME.get(((String)object).toLowerCase(Locale.US))) == null) {
            return 7;
        }
        return (Integer)object;
    }

    private CrashlyticsReport.Session.Event.Application.Execution.BinaryImage populateBinaryImageData() {
        return CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.builder().setBaseAddress(0L).setSize(0L).setName(this.appData.packageName).setUuid(this.appData.buildId).build();
    }

    private ImmutableList<CrashlyticsReport.Session.Event.Application.Execution.BinaryImage> populateBinaryImagesList() {
        return ImmutableList.from(this.populateBinaryImageData());
    }

    private CrashlyticsReport.Session.Event.Application populateEventApplicationData(int n, CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        boolean bl = applicationExitInfo.getImportance() != 100;
        return CrashlyticsReport.Session.Event.Application.builder().setBackground(bl).setUiOrientation(n).setExecution(this.populateExecutionData(applicationExitInfo)).build();
    }

    private CrashlyticsReport.Session.Event.Application populateEventApplicationData(int n, TrimmedThrowableData trimmedThrowableData, Thread thread2, int n2, int n3, boolean bl) {
        Object object = CommonUtils.getAppProcessInfo(this.appData.packageName, this.context);
        if (object != null) {
            boolean bl2 = object.importance != 100;
            object = bl2;
        } else {
            object = null;
        }
        return CrashlyticsReport.Session.Event.Application.builder().setBackground((Boolean)object).setUiOrientation(n).setExecution(this.populateExecutionData(trimmedThrowableData, thread2, n2, n3, bl)).build();
    }

    private CrashlyticsReport.Session.Event.Device populateEventDeviceData(int n) {
        BatteryState batteryState = BatteryState.get(this.context);
        Number number = batteryState.getBatteryLevel();
        number = number != null ? Double.valueOf(number.doubleValue()) : null;
        int n2 = batteryState.getBatteryVelocity();
        boolean bl = CommonUtils.getProximitySensorEnabled(this.context);
        long l = CommonUtils.getTotalRamInBytes();
        long l2 = CommonUtils.calculateFreeRamInBytes(this.context);
        long l3 = CommonUtils.calculateUsedDiskSpaceInBytes(Environment.getDataDirectory().getPath());
        return CrashlyticsReport.Session.Event.Device.builder().setBatteryLevel((Double)number).setBatteryVelocity(n2).setProximityOn(bl).setOrientation(n).setRamUsed(l - l2).setDiskUsed(l3).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Exception populateExceptionData(TrimmedThrowableData trimmedThrowableData, int n, int n2) {
        return this.populateExceptionData(trimmedThrowableData, n, n2, 0);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Exception populateExceptionData(TrimmedThrowableData object, int n, int n2, int n3) {
        String string2 = ((TrimmedThrowableData)object).className;
        String string3 = ((TrimmedThrowableData)object).localizedMessage;
        StackTraceElement[] stackTraceElementArray = ((TrimmedThrowableData)object).stacktrace;
        int n4 = 0;
        int n5 = 0;
        stackTraceElementArray = stackTraceElementArray != null ? ((TrimmedThrowableData)object).stacktrace : new StackTraceElement[]{};
        TrimmedThrowableData trimmedThrowableData = ((TrimmedThrowableData)object).cause;
        if (n3 >= n2) {
            object = trimmedThrowableData;
            while (true) {
                n4 = n5++;
                if (object == null) break;
                object = ((TrimmedThrowableData)object).cause;
            }
        }
        object = CrashlyticsReport.Session.Event.Application.Execution.Exception.builder().setType(string2).setReason(string3).setFrames(ImmutableList.from(this.populateFramesList(stackTraceElementArray, n))).setOverflowCount(n4);
        if (trimmedThrowableData != null && n4 == 0) {
            ((CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder)object).setCausedBy(this.populateExceptionData(trimmedThrowableData, n, n2, n3 + 1));
        }
        return ((CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder)object).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution populateExecutionData(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        return CrashlyticsReport.Session.Event.Application.Execution.builder().setAppExitInfo(applicationExitInfo).setSignal(this.populateSignalData()).setBinaries(this.populateBinaryImagesList()).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution populateExecutionData(TrimmedThrowableData trimmedThrowableData, Thread thread2, int n, int n2, boolean bl) {
        return CrashlyticsReport.Session.Event.Application.Execution.builder().setThreads(this.populateThreadsList(trimmedThrowableData, thread2, n, bl)).setException(this.populateExceptionData(trimmedThrowableData, n, n2)).setSignal(this.populateSignalData()).setBinaries(this.populateBinaryImagesList()).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame populateFrameData(StackTraceElement stackTraceElement, CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.Builder builder) {
        boolean bl = stackTraceElement.isNativeMethod();
        long l = 0L;
        long l2 = bl ? Math.max((long)stackTraceElement.getLineNumber(), 0L) : 0L;
        CharSequence charSequence = new StringBuilder();
        charSequence.append(stackTraceElement.getClassName());
        charSequence.append(".");
        charSequence.append(stackTraceElement.getMethodName());
        String string2 = charSequence.toString();
        charSequence = stackTraceElement.getFileName();
        long l3 = l;
        if (!stackTraceElement.isNativeMethod()) {
            l3 = l;
            if (stackTraceElement.getLineNumber() > 0) {
                l3 = stackTraceElement.getLineNumber();
            }
        }
        return builder.setPc(l2).setSymbol(string2).setFile((String)charSequence).setOffset(l3).build();
    }

    private ImmutableList<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame> populateFramesList(StackTraceElement[] stackTraceElementArray, int n) {
        ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame> arrayList = new ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame>();
        int n2 = stackTraceElementArray.length;
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.populateFrameData(stackTraceElementArray[i], CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.builder().setImportance(n)));
        }
        return ImmutableList.from(arrayList);
    }

    private CrashlyticsReport.Session.Application populateSessionApplicationData() {
        return CrashlyticsReport.Session.Application.builder().setIdentifier(this.idManager.getAppIdentifier()).setVersion(this.appData.versionCode).setDisplayVersion(this.appData.versionName).setInstallationUuid(this.idManager.getCrashlyticsInstallId()).setDevelopmentPlatform(this.appData.developmentPlatformProvider.getDevelopmentPlatform()).setDevelopmentPlatformVersion(this.appData.developmentPlatformProvider.getDevelopmentPlatformVersion()).build();
    }

    private CrashlyticsReport.Session populateSessionData(String string2, long l) {
        return CrashlyticsReport.Session.builder().setStartedAt(l).setIdentifier(string2).setGenerator(GENERATOR).setApp(this.populateSessionApplicationData()).setOs(this.populateSessionOperatingSystemData()).setDevice(this.populateSessionDeviceData()).setGeneratorType(3).build();
    }

    private CrashlyticsReport.Session.Device populateSessionDeviceData() {
        Object object = new StatFs(Environment.getDataDirectory().getPath());
        int n = CrashlyticsReportDataCapture.getDeviceArchitecture();
        int n2 = Runtime.getRuntime().availableProcessors();
        long l = CommonUtils.getTotalRamInBytes();
        long l2 = object.getBlockCount();
        long l3 = object.getBlockSize();
        boolean bl = CommonUtils.isEmulator(this.context);
        int n3 = CommonUtils.getDeviceState(this.context);
        object = Build.MANUFACTURER;
        String string2 = Build.PRODUCT;
        return CrashlyticsReport.Session.Device.builder().setArch(n).setModel(Build.MODEL).setCores(n2).setRam(l).setDiskSpace(l2 * l3).setSimulator(bl).setState(n3).setManufacturer((String)object).setModelClass(string2).build();
    }

    private CrashlyticsReport.Session.OperatingSystem populateSessionOperatingSystemData() {
        return CrashlyticsReport.Session.OperatingSystem.builder().setPlatform(3).setVersion(Build.VERSION.RELEASE).setBuildVersion(Build.VERSION.CODENAME).setJailbroken(CommonUtils.isRooted(this.context)).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Signal populateSignalData() {
        return CrashlyticsReport.Session.Event.Application.Execution.Signal.builder().setName(SIGNAL_DEFAULT).setCode(SIGNAL_DEFAULT).setAddress(0L).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread populateThreadData(Thread thread2, StackTraceElement[] stackTraceElementArray) {
        return this.populateThreadData(thread2, stackTraceElementArray, 0);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread populateThreadData(Thread thread2, StackTraceElement[] stackTraceElementArray, int n) {
        return CrashlyticsReport.Session.Event.Application.Execution.Thread.builder().setName(thread2.getName()).setImportance(n).setFrames(ImmutableList.from(this.populateFramesList(stackTraceElementArray, n))).build();
    }

    private ImmutableList<CrashlyticsReport.Session.Event.Application.Execution.Thread> populateThreadsList(TrimmedThrowableData object, Thread thread2, int n, boolean bl) {
        ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread> arrayList = new ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread>();
        arrayList.add(this.populateThreadData(thread2, ((TrimmedThrowableData)((Object)object)).stacktrace, n));
        if (bl) {
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                Thread thread3 = entry.getKey();
                if (thread3.equals(thread2)) continue;
                arrayList.add(this.populateThreadData(thread3, this.stackTraceTrimmingStrategy.getTrimmedStackTrace(entry.getValue())));
            }
        }
        return ImmutableList.from(arrayList);
    }

    public CrashlyticsReport.Session.Event captureAnrEventData(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        int n = this.context.getResources().getConfiguration().orientation;
        return CrashlyticsReport.Session.Event.builder().setType("anr").setTimestamp(applicationExitInfo.getTimestamp()).setApp(this.populateEventApplicationData(n, applicationExitInfo)).setDevice(this.populateEventDeviceData(n)).build();
    }

    public CrashlyticsReport.Session.Event captureEventData(Throwable object, Thread thread2, String string2, long l, int n, int n2, boolean bl) {
        int n3 = this.context.getResources().getConfiguration().orientation;
        object = new TrimmedThrowableData((Throwable)object, this.stackTraceTrimmingStrategy);
        return CrashlyticsReport.Session.Event.builder().setType(string2).setTimestamp(l).setApp(this.populateEventApplicationData(n3, (TrimmedThrowableData)object, thread2, n, n2, bl)).setDevice(this.populateEventDeviceData(n3)).build();
    }

    public CrashlyticsReport captureReportData(String string2, long l) {
        return this.buildReportData().setSession(this.populateSessionData(string2, l)).build();
    }
}

